/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.internal;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import blended.updater.LocalProfile;
import blended.updater.ProfileId;
import blended.updater.Updater;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.OverlayRef;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.internal.UpdateEnv;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001\u0002\n\u0014\u0001iA\u0001B\u0006\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tS\u0001\u0011\t\u0011)A\u0005U!A\u0011\u0007\u0001BC\u0002\u0013\r!\u0007\u0003\u00057\u0001\t\u0005\t\u0015!\u00034\u0011\u00159\u0004\u0001\"\u00019\u0011\u0019q\u0004\u0001)A\u0005\u007f!9q\t\u0001b\u0001\n\u0003A\u0005B\u0002.\u0001A\u0003%\u0011\nC\u0003\\\u0001\u0011\u0005A\fC\u0003^\u0001\u0011\u0005A\fC\u0003_\u0001\u0011\u0005A\fC\u0003`\u0001\u0011\u0005\u0001\rC\u0003j\u0001\u0011\u0005!\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003p\u0001\u0011\u0005\u0001\u000fC\u0004\u0002\u001e\u0001!\t!a\b\t\u000f\u0005}\u0002\u0001\"\u0001\u0002B\tA1i\\7nC:$7O\u0003\u0002\u0015+\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u0017/\u00059Q\u000f\u001d3bi\u0016\u0014(\"\u0001\r\u0002\u000f\tdWM\u001c3fI\u000e\u00011C\u0001\u0001\u001c!\tar$D\u0001\u001e\u0015\u0005q\u0012!B:dC2\f\u0017B\u0001\u0011\u001e\u0005\u0019\te.\u001f*fMB\u0011!eJ\u0007\u0002G)\u0011A%J\u0001\u0006C\u000e$xN\u001d\u0006\u0002M\u0005!\u0011m[6b\u0013\tA3E\u0001\u0005BGR|'OU3g\u0003\r)gN\u001e\t\u00049-j\u0013B\u0001\u0017\u001e\u0005\u0019y\u0005\u000f^5p]B\u0011afL\u0007\u0002'%\u0011\u0001g\u0005\u0002\n+B$\u0017\r^3F]Z\f1\"Y2u_J\u001c\u0016p\u001d;f[V\t1\u0007\u0005\u0002#i%\u0011Qg\t\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007bGR|'oU=ti\u0016l\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004sqjDC\u0001\u001e<!\tq\u0003\u0001C\u00032\u000b\u0001\u000f1\u0007C\u0003\u0017\u000b\u0001\u0007\u0011\u0005C\u0003*\u000b\u0001\u0007!&A\u0002m_\u001e\u0004\"\u0001Q#\u000e\u0003\u0005S!AQ\"\u0002\u000f1|wmZ5oO*\u0011AiF\u0001\u0005kRLG.\u0003\u0002G\u0003\n1Aj\\4hKJ\fqcY8n[\u0006tGm],ji\"$Um]2sSB$\u0018n\u001c8\u0016\u0003%\u00032AS'P\u001b\u0005Y%B\u0001'\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003\u001d.\u00131aU3r!\u0011a\u0002K\u0015*\n\u0005Ek\"A\u0002+va2,'\u0007\u0005\u0002T16\tAK\u0003\u0002V-\u0006!A.\u00198h\u0015\u00059\u0016\u0001\u00026bm\u0006L!!\u0017+\u0003\rM#(/\u001b8h\u0003a\u0019w.\\7b]\u0012\u001cx+\u001b;i\t\u0016\u001c8M]5qi&|g\u000eI\u0001\rg\"|w\u000f\u0015:pM&dWm\u001d\u000b\u00027\u0005\u00112\u000f[8x%VtG/[7f\u0007>tg-[4t\u00031\u0019\bn\\<Pm\u0016\u0014H.Y=t\u0003=\u0011XmZ5ti\u0016\u0014\bK]8gS2,GCA\u000eb\u0011\u0015\u0011G\u00021\u0001d\u0003\u00111\u0017\u000e\\3\u0011\u0005\u0011<W\"A3\u000b\u0005\u00194\u0016AA5p\u0013\tAWM\u0001\u0003GS2,\u0017!\u0006:fO&\u001cH/\u001a:Sk:$\u0018.\\3D_:4\u0017n\u001a\u000b\u00037-DQAY\u0007A\u0002\r\fqB]3hSN$XM](wKJd\u0017-\u001f\u000b\u000379DQA\u0019\bA\u0002\r\fQ\u0002]1sg\u0016|e/\u001a:mCf\u001cHcA9\u0002\bA\u0019!O_?\u000f\u0005MDhB\u0001;x\u001b\u0005)(B\u0001<\u001a\u0003\u0019a$o\\8u}%\ta$\u0003\u0002z;\u00059\u0001/Y2lC\u001e,\u0017BA>}\u0005\u0011a\u0015n\u001d;\u000b\u0005el\u0002c\u0001@\u0002\u00045\tqPC\u0002\u0002\u0002U\taaY8oM&<\u0017bAA\u0003\u007f\nQqJ^3sY\u0006L(+\u001a4\t\u000f\u0005%q\u00021\u0001\u0002\f\u0005\u0011rN^3sY\u0006Lh*Y7f-\u0016\u00148/[8o!\u0015\u0011\u0018QBA\b\u0013\tqE\u0010\u0005\u0003\u0002\u0012\u0005ea\u0002BA\n\u0003+\u0001\"\u0001^\u000f\n\u0007\u0005]Q$\u0001\u0004Qe\u0016$WMZ\u0005\u00043\u0006m!bAA\f;\u0005a1\u000f^1hKB\u0013xNZ5mKR91$!\t\u0002&\u0005%\u0002bBA\u0012!\u0001\u0007\u0011qB\u0001\u0007e\u000et\u0015-\\3\t\u000f\u0005\u001d\u0002\u00031\u0001\u0002\u0010\u0005I!o\u0019,feNLwN\u001c\u0005\b\u0003\u0013\u0001\u0002\u0019AA\u0016!\u0015a\u0012QFA\b\u0013\r\ty#\b\u0002\u000byI,\u0007/Z1uK\u0012t\u0004f\u0001\t\u00024A!\u0011QGA\u001e\u001b\t\t9DC\u0002\u0002:u\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti$a\u000e\u0003\u000fY\f'/\u0019:hg\u0006y\u0011m\u0019;jm\u0006$X\r\u0015:pM&dW\rF\u0004\u001c\u0003\u0007\n9%a\u0013\t\u000f\u0005\u0015\u0013\u00031\u0001\u0002\u0010\u0005!a.Y7f\u0011\u001d\tI%\u0005a\u0001\u0003\u001f\tqA^3sg&|g\u000eC\u0004\u0002\nE\u0001\r!a\u000b)\u0007E\t\u0019\u0004")
public class Commands {
    private final ActorRef updater;
    private final Option<UpdateEnv> env;
    private final ActorSystem actorSystem;
    private final Logger log;
    private final Seq<Tuple2<String, String>> commandsWithDescription;

    public Object stageProfile(String rcName, String rcVersion, String ... overlayNameVersion) {
        return this.stageProfile(rcName, rcVersion, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public Object activateProfile(String name, String version, String ... overlayNameVersion) {
        return this.activateProfile(name, version, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Seq<Tuple2<String, String>> commandsWithDescription() {
        return this.commandsWithDescription;
    }

    public Object showProfiles() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Option activeProfile = this.env.map((Function1 & Serializable & scala.Serializable)env -> new ProfileId(env.launchedProfileName(), env.launchedProfileVersion(), (Set<OverlayRef>)((TraversableOnce)env.overlays().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).toSet()));
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("acitive profile: ").append(activeProfile).toString());
        Set profiles = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetProfiles(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(11).append(profiles.size()).append(" profiles:\n").append(((TraversableOnce)profiles.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof LocalProfile)) {
                throw new MatchError(object);
            }
            LocalProfile localProfile = (LocalProfile)object;
            String activePart = activeProfile.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Commands.$anonfun$showProfiles$5(localProfile, x$1))) ? " (active)" : "";
            String string = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)localProfile.profileId()), ": ")).append(localProfile.state()).append(activePart).toString();
            return string;
        }, Set$.MODULE$.canBuildFrom())).mkString("\n")).toString();
    }

    public Object showRuntimeConfigs() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetRuntimeConfigs(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" runtime configs:\n").append(((TraversableOnce)((SeqLike)configs.toList().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof LocalRuntimeConfig)) {
                throw new MatchError(object);
            }
            LocalRuntimeConfig localRuntimeConfig = (LocalRuntimeConfig)object;
            ResolvedRuntimeConfig c = localRuntimeConfig.resolvedRuntimeConfig();
            String string = new StringBuilder(1).append(c.runtimeConfig().name()).append("-").append(c.runtimeConfig().version()).toString();
            return string;
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).toString();
    }

    public Object showOverlays() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetOverlays(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" overlay configs:\n").append(configs.mkString("\n")).toString();
    }

    public Object registerProfile(File file) {
        return this.registerRuntimeConfig(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerRuntimeConfig(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        RuntimeConfig runtimeConfig = (RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(runtimeConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddRuntimeConfig(reqId, runtimeConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerOverlay(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        OverlayConfig overlayConfig = (OverlayConfig)OverlayConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(overlayConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddOverlayConfig(reqId, overlayConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    public List<OverlayRef> parseOverlays(Seq<String> overlayNameVersion) {
        if (overlayNameVersion.size() % 2 != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(28).append("Missing version for overlay ").append(overlayNameVersion.last()).toString());
        }
        return overlayNameVersion.sliding(2, 2).map((Function1 & Serializable & scala.Serializable)o -> new OverlayRef((String)o.apply(0), (String)o.apply(1))).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object stageProfile(String rcName, String rcVersion, Seq<String> overlayNameVersion) {
        List<OverlayRef> overlays = this.parseOverlays(overlayNameVersion);
        String overlaysAsString = overlays.isEmpty() ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)o -> new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
        String asString = new StringBuilder(1).append(rcName).append("-").append(rcVersion).append(overlaysAsString).toString();
        Timeout timeout = Timeout$.MODULE$.apply(1L, TimeUnit.HOURS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.StageProfile(reqId, rcName, rcVersion, (Set<OverlayRef>)overlays.toSet()), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(8).append("Staged: ").append(asString).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(8).append("Staged: ").append(asString).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String reason = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
            return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        }
        if (string5 == null) return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object activateProfile(String name, String version, Seq<String> overlayNameVersion) {
        block4: {
            block2: {
                block3: {
                    overlays = this.parseOverlays(overlayNameVersion);
                    overlaysAsString = overlays.isEmpty() != false ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$activateProfile$1(blended.updater.config.OverlayRef ), (Lblended/updater/config/OverlayRef;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
                    asString = new StringBuilder(1).append(name).append("-").append(version).append(overlaysAsString).toString();
                    var9_7 = this.env;
                    if (!(var9_7 instanceof Some) || (var11_9 = (UpdateEnv)(var10_8 = (Some)var9_7).value()) == null || !((var12_10 = var11_9.launchProfileLookupFile()) instanceof Some)) break block2;
                    timeout = Timeout$.MODULE$.apply(5L, TimeUnit.MINUTES);
                    reqId = UUID.randomUUID().toString();
                    var15_13 = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.ActivateProfile(reqId, name, version, (Set<OverlayRef>)overlays.toSet()), timeout), (Duration)timeout.duration());
                    if (!(var15_13 instanceof Updater.OperationSucceeded)) break block3;
                    var16_14 = (Updater.OperationSucceeded)var15_13;
                    var17_15 = var16_14.requestId();
                    v0 = reqId;
                    var18_16 = var17_15;
                    if (v0 != null ? v0.equals(var18_16) == false : var18_16 != null) break block3;
                    var5_17 = new StringBuilder(11).append("Activated: ").append(asString).toString();
                    break block4;
                }
                if (!(var15_13 instanceof Updater.OperationFailed)) ** GOTO lbl-1000
                var19_18 = (Updater.OperationFailed)var15_13;
                var20_19 = var19_18.requestId();
                reason = var19_18.reason();
                v1 = reqId;
                var22_21 = var20_19;
                if (!(v1 != null ? v1.equals(var22_21) == false : var22_21 != null)) {
                    var5_17 = new StringBuilder(28).append("Activation failed: ").append(asString).append("\nReason: ").append(reason).toString();
                } else lbl-1000:
                // 2 sources

                {
                    var5_17 = new StringBuilder(27).append("Activation failed: ").append(asString).append("\nError: ").append(var15_13).toString();
                }
                break block4;
            }
            throw scala.sys.package$.MODULE$.error("No updateable environment detected. No profile lookup file defined.");
        }
        var4_22 = var5_17;
        return var4_22;
    }

    public static final /* synthetic */ boolean $anonfun$showProfiles$5(LocalProfile x2$1, ProfileId x$1) {
        ProfileId profileId = x$1;
        ProfileId profileId2 = x2$1.profileId();
        return !(profileId != null ? !((Object)profileId).equals(profileId2) : profileId2 != null);
    }

    public static final /* synthetic */ String $anonfun$activateProfile$1(OverlayRef o) {
        return new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString();
    }

    public Commands(ActorRef updater, Option<UpdateEnv> env, ActorSystem actorSystem) {
        this.updater = updater;
        this.env = env;
        this.actorSystem = actorSystem;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Commands.class));
        this.commandsWithDescription = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showProfiles"), (Object)"Show all (staged) profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showRuntimeConfigs"), (Object)"Show all known runtime configs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showOverlays"), (Object)"Show all known overlays"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerRuntimeConfig"), (Object)"Add a new runtime config"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Add a new profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Add a new overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageProfile"), (Object)"Stage a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activateProfile"), (Object)"Activate a profile")}));
    }
}

