/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.internal;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import blended.updater.LocalProfile;
import blended.updater.ProfileId;
import blended.updater.Updater;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.OverlayRef;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.internal.UpdateEnv;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001%\u0011\u0001bQ8n[\u0006tGm\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I!\u0005\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tQ!Y2u_JT\u0011AF\u0001\u0005C.\\\u0017-\u0003\u0002\u0019'\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\r)gN\u001e\t\u0004\u0017qq\u0012BA\u000f\r\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\n+B$\u0017\r^3F]ZD\u0001b\t\u0001\u0003\u0006\u0004%\u0019\u0001J\u0001\fC\u000e$xN]*zgR,W.F\u0001&!\t\u0011b%\u0003\u0002('\tY\u0011i\u0019;peNK8\u000f^3n\u0011!I\u0003A!A!\u0002\u0013)\u0013\u0001D1di>\u00148+_:uK6\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002.aE\"\"AL\u0018\u0011\u0005}\u0001\u0001\"B\u0012+\u0001\b)\u0003\"B\u0003+\u0001\u0004\t\u0002\"\u0002\u000e+\u0001\u0004Y\u0002BB\u001a\u0001A\u0003%A'A\u0002m_\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000f1|wmZ5oO*\u0011\u0011HB\u0001\u0005kRLG.\u0003\u0002<m\t1Aj\\4hKJDq!\u0010\u0001C\u0002\u0013\u0005a(A\fd_6l\u0017M\u001c3t/&$\b\u000eR3tGJL\u0007\u000f^5p]V\tq\bE\u0002A\u0007\u0016k\u0011!\u0011\u0006\u0003\u00052\t!bY8mY\u0016\u001cG/[8o\u0013\t!\u0015IA\u0002TKF\u0004Ba\u0003$I\u0011&\u0011q\t\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005%sU\"\u0001&\u000b\u0005-c\u0015\u0001\u00027b]\u001eT\u0011!T\u0001\u0005U\u00064\u0018-\u0003\u0002P\u0015\n11\u000b\u001e:j]\u001eDa!\u0015\u0001!\u0002\u0013y\u0014\u0001G2p[6\fg\u000eZ:XSRDG)Z:de&\u0004H/[8oA!)1\u000b\u0001C\u0001)\u0006a1\u000f[8x!J|g-\u001b7fgR\t!\u0002C\u0003W\u0001\u0011\u0005A+\u0001\ntQ><(+\u001e8uS6,7i\u001c8gS\u001e\u001c\b\"\u0002-\u0001\t\u0003!\u0016\u0001D:i_^|e/\u001a:mCf\u001c\b\"\u0002.\u0001\t\u0003Y\u0016a\u0004:fO&\u001cH/\u001a:Qe>4\u0017\u000e\\3\u0015\u0005)a\u0006\"B/Z\u0001\u0004q\u0016\u0001\u00024jY\u0016\u0004\"a\u00182\u000e\u0003\u0001T!!\u0019'\u0002\u0005%|\u0017BA2a\u0005\u00111\u0015\u000e\\3\t\u000b\u0015\u0004A\u0011\u00014\u0002+I,w-[:uKJ\u0014VO\u001c;j[\u0016\u001cuN\u001c4jOR\u0011!b\u001a\u0005\u0006;\u0012\u0004\rA\u0018\u0005\u0006S\u0002!\tA[\u0001\u0010e\u0016<\u0017n\u001d;fe>3XM\u001d7bsR\u0011!b\u001b\u0005\u0006;\"\u0004\rA\u0018\u0005\u0006[\u0002!\tA\\\u0001\u000ea\u0006\u00148/Z(wKJd\u0017-_:\u0015\u0007=\f\u0019\u0001E\u0002qqnt!!\u001d<\u000f\u0005I,X\"A:\u000b\u0005QD\u0011A\u0002\u001fs_>$h(C\u0001\u000e\u0013\t9H\"A\u0004qC\u000e\\\u0017mZ3\n\u0005eT(\u0001\u0002'jgRT!a\u001e\u0007\u0011\u0005q|X\"A?\u000b\u0005y$\u0011AB2p]\u001aLw-C\u0002\u0002\u0002u\u0014!b\u0014<fe2\f\u0017PU3g\u0011\u001d\t)\u0001\u001ca\u0001\u0003\u000f\t!c\u001c<fe2\f\u0017PT1nKZ+'o]5p]B)\u0001/!\u0003\u0002\f%\u0011AI\u001f\t\u0005\u0003\u001b\t)B\u0004\u0003\u0002\u0010\u0005E\u0001C\u0001:\r\u0013\r\t\u0019\u0002D\u0001\u0007!J,G-\u001a4\n\u0007=\u000b9BC\u0002\u0002\u00141Aq!a\u0007\u0001\t\u0003\ti\"\u0001\u0007ti\u0006<W\r\u0015:pM&dW\rF\u0004\u000b\u0003?\t\u0019#a\n\t\u0011\u0005\u0005\u0012\u0011\u0004a\u0001\u0003\u0017\taA]2OC6,\u0007\u0002CA\u0013\u00033\u0001\r!a\u0003\u0002\u0013I\u001cg+\u001a:tS>t\u0007\u0002CA\u0003\u00033\u0001\r!!\u000b\u0011\u000b-\tY#a\u0003\n\u0007\u00055BB\u0001\u0006=e\u0016\u0004X-\u0019;fIzBC!!\u0007\u00022A!\u00111GA\u001d\u001b\t\t)DC\u0002\u000281\t!\"\u00198o_R\fG/[8o\u0013\u0011\tY$!\u000e\u0003\u000fY\f'/\u0019:hg\"9\u0011q\b\u0001\u0005\u0002\u0005\u0005\u0013aD1di&4\u0018\r^3Qe>4\u0017\u000e\\3\u0015\u000f)\t\u0019%a\u0012\u0002L!A\u0011QIA\u001f\u0001\u0004\tY!\u0001\u0003oC6,\u0007\u0002CA%\u0003{\u0001\r!a\u0003\u0002\u000fY,'o]5p]\"A\u0011QAA\u001f\u0001\u0004\tI\u0003\u000b\u0003\u0002>\u0005E\u0002")
public class Commands {
    private final ActorRef updater;
    private final Option<UpdateEnv> env;
    private final ActorSystem actorSystem;
    private final Logger log;
    private final Seq<Tuple2<String, String>> commandsWithDescription;

    public Object stageProfile(String rcName, String rcVersion, String ... overlayNameVersion) {
        return this.stageProfile(rcName, rcVersion, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public Object activateProfile(String name, String version, String ... overlayNameVersion) {
        return this.activateProfile(name, version, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Seq<Tuple2<String, String>> commandsWithDescription() {
        return this.commandsWithDescription;
    }

    public Object showProfiles() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Option activeProfile = this.env.map((Function1 & Serializable & scala.Serializable)env -> new ProfileId(env.launchedProfileName(), env.launchedProfileVersion(), (Set<OverlayRef>)((TraversableOnce)env.overlays().getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Set().empty())).toSet()));
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(17).append("acitive profile: ").append(activeProfile).toString());
        Set profiles = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetProfiles(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(11).append(profiles.size()).append(" profiles:\n").append(((TraversableOnce)profiles.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof LocalProfile)) {
                throw new MatchError(object);
            }
            LocalProfile localProfile = (LocalProfile)object;
            String activePart = activeProfile.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Commands.$anonfun$showProfiles$5(localProfile, x$1))) ? " (active)" : "";
            String string = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)localProfile.profileId()), ": ")).append(localProfile.state()).append(activePart).toString();
            return string;
        }, Set$.MODULE$.canBuildFrom())).mkString("\n")).toString();
    }

    public Object showRuntimeConfigs() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetRuntimeConfigs(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" runtime configs:\n").append(((TraversableOnce)((SeqLike)configs.toList().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object = x0$2;
            if (!(object instanceof LocalRuntimeConfig)) {
                throw new MatchError(object);
            }
            LocalRuntimeConfig localRuntimeConfig = (LocalRuntimeConfig)object;
            ResolvedRuntimeConfig c = localRuntimeConfig.resolvedRuntimeConfig();
            String string = new StringBuilder(1).append(c.runtimeConfig().name()).append("-").append(c.runtimeConfig().version()).toString();
            return string;
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).toString();
    }

    public Object showOverlays() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetOverlays(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" overlay configs:\n").append(configs.mkString("\n")).toString();
    }

    public Object registerProfile(File file) {
        return this.registerRuntimeConfig(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerRuntimeConfig(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        RuntimeConfig runtimeConfig = (RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(runtimeConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddRuntimeConfig(reqId, runtimeConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerOverlay(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        OverlayConfig overlayConfig = (OverlayConfig)OverlayConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(overlayConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddOverlayConfig(reqId, overlayConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    public List<OverlayRef> parseOverlays(Seq<String> overlayNameVersion) {
        if (overlayNameVersion.size() % 2 != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(28).append("Missing version for overlay ").append(overlayNameVersion.last()).toString());
        }
        return overlayNameVersion.sliding(2, 2).map((Function1 & Serializable & scala.Serializable)o -> new OverlayRef((String)o.apply(0), (String)o.apply(1))).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object stageProfile(String rcName, String rcVersion, Seq<String> overlayNameVersion) {
        List<OverlayRef> overlays = this.parseOverlays(overlayNameVersion);
        String overlaysAsString = overlays.isEmpty() ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)o -> new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
        String asString = new StringBuilder(1).append(rcName).append("-").append(rcVersion).append(overlaysAsString).toString();
        Timeout timeout = Timeout$.MODULE$.apply(1L, TimeUnit.HOURS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.StageProfile(reqId, rcName, rcVersion, (Set<OverlayRef>)overlays.toSet()), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(8).append("Staged: ").append(asString).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(8).append("Staged: ").append(asString).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String reason = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
            return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        }
        if (string5 == null) return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object activateProfile(String name, String version, Seq<String> overlayNameVersion) {
        block4: {
            block2: {
                block3: {
                    overlays = this.parseOverlays(overlayNameVersion);
                    overlaysAsString = overlays.isEmpty() != false ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$activateProfile$1(blended.updater.config.OverlayRef ), (Lblended/updater/config/OverlayRef;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
                    asString = new StringBuilder(1).append(name).append("-").append(version).append(overlaysAsString).toString();
                    var9_7 = this.env;
                    if (!(var9_7 instanceof Some) || (var11_9 = (UpdateEnv)(var10_8 = (Some)var9_7).value()) == null || !((var12_10 = var11_9.launchProfileLookupFile()) instanceof Some)) break block2;
                    timeout = Timeout$.MODULE$.apply(5L, TimeUnit.MINUTES);
                    reqId = UUID.randomUUID().toString();
                    var15_13 = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.ActivateProfile(reqId, name, version, (Set<OverlayRef>)overlays.toSet()), timeout), (Duration)timeout.duration());
                    if (!(var15_13 instanceof Updater.OperationSucceeded)) break block3;
                    var16_14 = (Updater.OperationSucceeded)var15_13;
                    var17_15 = var16_14.requestId();
                    v0 = reqId;
                    var18_16 = var17_15;
                    if (v0 != null ? v0.equals(var18_16) == false : var18_16 != null) break block3;
                    var5_17 = new StringBuilder(11).append("Activated: ").append(asString).toString();
                    break block4;
                }
                if (!(var15_13 instanceof Updater.OperationFailed)) ** GOTO lbl-1000
                var19_18 = (Updater.OperationFailed)var15_13;
                var20_19 = var19_18.requestId();
                reason = var19_18.reason();
                v1 = reqId;
                var22_21 = var20_19;
                if (!(v1 != null ? v1.equals(var22_21) == false : var22_21 != null)) {
                    var5_17 = new StringBuilder(28).append("Activation failed: ").append(asString).append("\nReason: ").append(reason).toString();
                } else lbl-1000:
                // 2 sources

                {
                    var5_17 = new StringBuilder(27).append("Activation failed: ").append(asString).append("\nError: ").append(var15_13).toString();
                }
                break block4;
            }
            throw scala.sys.package$.MODULE$.error("No updateable environment detected. No profile lookup file defined.");
        }
        var4_22 = var5_17;
        return var4_22;
    }

    public static final /* synthetic */ boolean $anonfun$showProfiles$5(LocalProfile x2$1, ProfileId x$1) {
        ProfileId profileId = x$1;
        ProfileId profileId2 = x2$1.profileId();
        return !(profileId != null ? !((Object)profileId).equals(profileId2) : profileId2 != null);
    }

    public static final /* synthetic */ String $anonfun$activateProfile$1(OverlayRef o) {
        return new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString();
    }

    public Commands(ActorRef updater, Option<UpdateEnv> env, ActorSystem actorSystem) {
        this.updater = updater;
        this.env = env;
        this.actorSystem = actorSystem;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Commands.class));
        this.commandsWithDescription = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showProfiles"), (Object)"Show all (staged) profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showRuntimeConfigs"), (Object)"Show all known runtime configs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showOverlays"), (Object)"Show all known overlays"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerRuntimeConfig"), (Object)"Add a new runtime config"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Add a new profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Add a new overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageProfile"), (Object)"Stage a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activateProfile"), (Object)"Activate a profile")}));
    }
}

