/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.internal;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import blended.updater.LocalProfile;
import blended.updater.ProfileId;
import blended.updater.Updater;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.OverlayRef;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.internal.UpdateEnv;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=c\u0001B\u0001\u0003\u0001%\u0011\u0001bQ8n[\u0006tGm\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I!\u0005\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tQ!Y2u_JT\u0011AF\u0001\u0005C.\\\u0017-\u0003\u0002\u0019'\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\r)gN\u001e\t\u0004\u0017qq\u0012BA\u000f\r\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\n+B$\u0017\r^3F]ZD\u0001b\t\u0001\u0003\u0006\u0004%\u0019\u0001J\u0001\fC\u000e$xN]*zgR,W.F\u0001&!\t\u0011b%\u0003\u0002('\tY\u0011i\u0019;peNK8\u000f^3n\u0011!I\u0003A!A!\u0002\u0013)\u0013\u0001D1di>\u00148+_:uK6\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002.aE\"\"AL\u0018\u0011\u0005}\u0001\u0001\"B\u0012+\u0001\b)\u0003\"B\u0003+\u0001\u0004\t\u0002\"\u0002\u000e+\u0001\u0004Y\u0002BB\u001a\u0001A\u0003%A'A\u0002m_\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000bMdg\r\u000e6\u000b\u0003e\n1a\u001c:h\u0013\tYdG\u0001\u0004M_\u001e<WM\u001d\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003]\u0019w.\\7b]\u0012\u001cx+\u001b;i\t\u0016\u001c8M]5qi&|g.F\u0001@!\r\u00015)R\u0007\u0002\u0003*\u0011!\tD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\r\u0019V-\u001d\t\u0005\u0017\u0019C\u0005*\u0003\u0002H\u0019\t1A+\u001e9mKJ\u0002\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0004TiJLgn\u001a\u0005\u0007#\u0002\u0001\u000b\u0011B \u00021\r|W.\\1oIN<\u0016\u000e\u001e5EKN\u001c'/\u001b9uS>t\u0007\u0005C\u0003T\u0001\u0011\u0005A+\u0001\u0007tQ><\bK]8gS2,7\u000fF\u0001\u000b\u0011\u00151\u0006\u0001\"\u0001U\u0003I\u0019\bn\\<Sk:$\u0018.\\3D_:4\u0017nZ:\t\u000ba\u0003A\u0011\u0001+\u0002\u0019MDwn^(wKJd\u0017-_:\t\u000bi\u0003A\u0011A.\u0002\u001fI,w-[:uKJ\u0004&o\u001c4jY\u0016$\"A\u0003/\t\u000buK\u0006\u0019\u00010\u0002\t\u0019LG.\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C2\u000b!![8\n\u0005\r\u0004'\u0001\u0002$jY\u0016DQ!\u001a\u0001\u0005\u0002\u0019\fQC]3hSN$XM\u001d*v]RLW.Z\"p]\u001aLw\r\u0006\u0002\u000bO\")Q\f\u001aa\u0001=\")\u0011\u000e\u0001C\u0001U\u0006y!/Z4jgR,'o\u0014<fe2\f\u0017\u0010\u0006\u0002\u000bW\")Q\f\u001ba\u0001=\")Q\u000e\u0001C\u0001]\u0006i\u0001/\u0019:tK>3XM\u001d7bsN$2a\\A\u0002!\r\u0001\bp\u001f\b\u0003cZt!A];\u000e\u0003MT!\u0001\u001e\u0005\u0002\rq\u0012xn\u001c;?\u0013\u0005i\u0011BA<\r\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001f>\u0003\t1K7\u000f\u001e\u0006\u0003o2\u0001\"\u0001`@\u000e\u0003uT!A \u0003\u0002\r\r|gNZ5h\u0013\r\t\t! \u0002\u000b\u001fZ,'\u000f\\1z%\u00164\u0007bBA\u0003Y\u0002\u0007\u0011qA\u0001\u0013_Z,'\u000f\\1z\u001d\u0006lWMV3sg&|g\u000eE\u0003q\u0003\u0013\tY!\u0003\u0002EuB!\u0011QBA\u000b\u001d\u0011\ty!!\u0005\u0011\u0005Id\u0011bAA\n\u0019\u00051\u0001K]3eK\u001aL1aTA\f\u0015\r\t\u0019\u0002\u0004\u0005\b\u00037\u0001A\u0011AA\u000f\u00031\u0019H/Y4f!J|g-\u001b7f)\u001dQ\u0011qDA\u0012\u0003OA\u0001\"!\t\u0002\u001a\u0001\u0007\u00111B\u0001\u0007e\u000et\u0015-\\3\t\u0011\u0005\u0015\u0012\u0011\u0004a\u0001\u0003\u0017\t\u0011B]2WKJ\u001c\u0018n\u001c8\t\u0011\u0005\u0015\u0011\u0011\u0004a\u0001\u0003S\u0001RaCA\u0016\u0003\u0017I1!!\f\r\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0005\u00033\t\t\u0004\u0005\u0003\u00024\u0005eRBAA\u001b\u0015\r\t9\u0004D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001e\u0003k\u0011qA^1sCJ<7\u000fC\u0004\u0002@\u0001!\t!!\u0011\u0002\u001f\u0005\u001cG/\u001b<bi\u0016\u0004&o\u001c4jY\u0016$rACA\"\u0003\u000f\nY\u0005\u0003\u0005\u0002F\u0005u\u0002\u0019AA\u0006\u0003\u0011q\u0017-\\3\t\u0011\u0005%\u0013Q\ba\u0001\u0003\u0017\tqA^3sg&|g\u000e\u0003\u0005\u0002\u0006\u0005u\u0002\u0019AA\u0015Q\u0011\ti$!\r")
public class Commands {
    private final ActorRef updater;
    private final Option<UpdateEnv> env;
    private final ActorSystem actorSystem;
    private final Logger log;
    private final Seq<Tuple2<String, String>> commandsWithDescription;

    public Object stageProfile(String rcName, String rcVersion, String ... overlayNameVersion) {
        return this.stageProfile(rcName, rcVersion, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public Object activateProfile(String name, String version, String ... overlayNameVersion) {
        return this.activateProfile(name, version, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Seq<Tuple2<String, String>> commandsWithDescription() {
        return this.commandsWithDescription;
    }

    public Object showProfiles() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Option activeProfile = this.env.map((Function1 & Serializable & scala.Serializable)env -> new ProfileId(env.launchedProfileName(), env.launchedProfileVersion(), (List<OverlayRef>)((List)env.overlays().getOrElse((Function0 & Serializable & scala.Serializable)() -> List$.MODULE$.empty()))));
        this.log.debug("acitive profile: {}", new Object[]{activeProfile});
        Set profiles = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetProfiles(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(11).append(profiles.size()).append(" profiles:\n").append(((TraversableOnce)profiles.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object = x0$1;
            if (!(object instanceof LocalProfile)) {
                throw new MatchError(object);
            }
            LocalProfile localProfile = (LocalProfile)object;
            String activePart = activeProfile.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Commands.$anonfun$showProfiles$4(localProfile, x$1))) ? " (active)" : "";
            String string = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)localProfile.profileId()), ": ")).append(localProfile.state()).append(activePart).toString();
            return string;
        }, Set$.MODULE$.canBuildFrom())).mkString("\n")).toString();
    }

    public Object showRuntimeConfigs() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetRuntimeConfigs(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" runtime configs:\n").append(((TraversableOnce)((SeqLike)configs.toList().map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Object object = x0$2;
            if (!(object instanceof LocalRuntimeConfig)) {
                throw new MatchError(object);
            }
            LocalRuntimeConfig localRuntimeConfig = (LocalRuntimeConfig)object;
            ResolvedRuntimeConfig c = localRuntimeConfig.resolvedRuntimeConfig();
            String string = new StringBuilder(1).append(c.runtimeConfig().name()).append("-").append(c.runtimeConfig().version()).toString();
            return string;
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")).toString();
    }

    public Object showOverlays() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetOverlays(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringBuilder(18).append(configs.size()).append(" overlay configs:\n").append(configs.mkString("\n")).toString();
    }

    public Object registerProfile(File file) {
        return this.registerRuntimeConfig(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerRuntimeConfig(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        RuntimeConfig runtimeConfig = (RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(runtimeConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddRuntimeConfig(reqId, runtimeConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(runtimeConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerOverlay(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        OverlayConfig overlayConfig = (OverlayConfig)OverlayConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("About to add: ").append(overlayConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddOverlayConfig(reqId, overlayConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(7).append("Added: ").append(overlayConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(7).append("Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(7).append("Error: ").append(object).toString();
            return new StringBuilder(8).append("Failed: ").append(error).toString();
        }
        if (string5 == null) return new StringBuilder(8).append("Failed: ").append(error).toString();
        return new StringBuilder(7).append("Error: ").append(object).toString();
    }

    public List<OverlayRef> parseOverlays(Seq<String> overlayNameVersion) {
        if (overlayNameVersion.size() % 2 != 0) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(28).append("Missing version for overlay ").append(overlayNameVersion.last()).toString());
        }
        return overlayNameVersion.sliding(2, 2).map((Function1 & Serializable & scala.Serializable)o -> new OverlayRef((String)o.apply(0), (String)o.apply(1))).toList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object stageProfile(String rcName, String rcVersion, Seq<String> overlayNameVersion) {
        List<OverlayRef> overlays = this.parseOverlays(overlayNameVersion);
        String overlaysAsString = overlays.isEmpty() ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1 & Serializable & scala.Serializable)o -> new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
        String asString = new StringBuilder(1).append(rcName).append("-").append(rcVersion).append(overlaysAsString).toString();
        Timeout timeout = Timeout$.MODULE$.apply(1L, TimeUnit.HOURS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.StageProfile(reqId, rcName, rcVersion, overlays), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder(8).append("Staged: ").append(asString).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder(8).append("Staged: ").append(asString).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String reason = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
            return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        }
        if (string5 == null) return new StringBuilder(23).append("Stage failed: ").append(asString).append("\nReason: ").append(reason).toString();
        return new StringBuilder(22).append("Stage failed: ").append(asString).append("\nError: ").append(object).toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object activateProfile(String name, String version, Seq<String> overlayNameVersion) {
        block4: {
            block2: {
                block3: {
                    overlays = this.parseOverlays(overlayNameVersion);
                    overlaysAsString = overlays.isEmpty() != false ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$activateProfile$1(blended.updater.config.OverlayRef ), (Lblended/updater/config/OverlayRef;)Ljava/lang/String;)(), List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
                    asString = new StringBuilder(1).append(name).append("-").append(version).append(overlaysAsString).toString();
                    var9_7 = this.env;
                    if (!(var9_7 instanceof Some) || (var11_9 = (UpdateEnv)(var10_8 = (Some)var9_7).value()) == null || !((var12_10 = var11_9.launchProfileLookupFile()) instanceof Some)) break block2;
                    timeout = Timeout$.MODULE$.apply(5L, TimeUnit.MINUTES);
                    reqId = UUID.randomUUID().toString();
                    var15_13 = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.ActivateProfile(reqId, name, version, overlays), timeout), (Duration)timeout.duration());
                    if (!(var15_13 instanceof Updater.OperationSucceeded)) break block3;
                    var16_14 = (Updater.OperationSucceeded)var15_13;
                    var17_15 = var16_14.requestId();
                    v0 = reqId;
                    var18_16 = var17_15;
                    if (v0 != null ? v0.equals(var18_16) == false : var18_16 != null) break block3;
                    var5_17 = new StringBuilder(11).append("Activated: ").append(asString).toString();
                    break block4;
                }
                if (!(var15_13 instanceof Updater.OperationFailed)) ** GOTO lbl-1000
                var19_18 = (Updater.OperationFailed)var15_13;
                var20_19 = var19_18.requestId();
                reason = var19_18.reason();
                v1 = reqId;
                var22_21 = var20_19;
                if (!(v1 != null ? v1.equals(var22_21) == false : var22_21 != null)) {
                    var5_17 = new StringBuilder(28).append("Activation failed: ").append(asString).append("\nReason: ").append(reason).toString();
                } else lbl-1000:
                // 2 sources

                {
                    var5_17 = new StringBuilder(27).append("Activation failed: ").append(asString).append("\nError: ").append(var15_13).toString();
                }
                break block4;
            }
            throw scala.sys.package$.MODULE$.error("No updateable environment detected. No profile lookup file defined.");
        }
        var4_22 = var5_17;
        return var4_22;
    }

    public static final /* synthetic */ boolean $anonfun$showProfiles$4(LocalProfile x2$1, ProfileId x$1) {
        ProfileId profileId = x$1;
        ProfileId profileId2 = x2$1.profileId();
        return !(profileId != null ? !((Object)profileId).equals(profileId2) : profileId2 != null);
    }

    public static final /* synthetic */ String $anonfun$activateProfile$1(OverlayRef o) {
        return new StringBuilder(1).append(o.name()).append("-").append(o.version()).toString();
    }

    public Commands(ActorRef updater, Option<UpdateEnv> env, ActorSystem actorSystem) {
        this.updater = updater;
        this.env = env;
        this.actorSystem = actorSystem;
        this.log = LoggerFactory.getLogger(Commands.class);
        this.commandsWithDescription = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showProfiles"), (Object)"Show all (staged) profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showRuntimeConfigs"), (Object)"Show all known runtime configs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showOverlays"), (Object)"Show all known overlays"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerRuntimeConfig"), (Object)"Add a new runtime config"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Add a new profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Add a new overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageProfile"), (Object)"Stage a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activateProfile"), (Object)"Activate a profile")}));
    }
}

