/*
 * Decompiled with CFR 0.152.
 */
package blended.updater;

import blended.updater.LocalProfile;
import blended.updater.LocalProfile$Staged$;
import blended.updater.config.LocalOverlays;
import blended.updater.config.LocalOverlays$;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u000f\ty\u0001K]8gS2,gi\u001d%fYB,'O\u0003\u0002\u0004\t\u00059Q\u000f\u001d3bi\u0016\u0014(\"A\u0003\u0002\u000f\tdWM\u001c3fI\u000e\u00011C\u0001\u0001\t!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fM\")q\u0002\u0001C\u0001!\u00051A(\u001b8jiz\"\u0012!\u0005\t\u0003%\u0001i\u0011A\u0001\u0005\u0007)\u0001\u0001\u000b\u0011B\u000b\u0002\u00071|w\r\u0005\u0002\u001775\tqC\u0003\u0002\u00193\u0005)1\u000f\u001c45U*\t!$A\u0002pe\u001eL!\u0001H\f\u0003\r1{wmZ3s\u0011\u0015q\u0002\u0001\"\u0001 \u0003U\u00198-\u00198G_J|e/\u001a:mCf\u001cuN\u001c4jON$\"\u0001\t\u001a\u0011\u0007\u0005JCF\u0004\u0002#O9\u00111EJ\u0007\u0002I)\u0011QEB\u0001\u0007yI|w\u000e\u001e \n\u0003-I!\u0001\u000b\u0006\u0002\u000fA\f7m[1hK&\u0011!f\u000b\u0002\u0005\u0019&\u001cHO\u0003\u0002)\u0015A\u0011Q\u0006M\u0007\u0002])\u0011qFA\u0001\u0007G>tg-[4\n\u0005Er#!D(wKJd\u0017-_\"p]\u001aLw\rC\u00034;\u0001\u0007A'\u0001\bpm\u0016\u0014H.Y=CCN,G)\u001b:\u0011\u0005URT\"\u0001\u001c\u000b\u0005]B\u0014AA5p\u0015\u0005I\u0014\u0001\u00026bm\u0006L!a\u000f\u001c\u0003\t\u0019KG.\u001a\u0005\u0006{\u0001!\tAP\u0001\u0016g\u000e\fgNR8s%VtG/[7f\u0007>tg-[4t)\ty4\tE\u0002\"S\u0001\u0003\"!L!\n\u0005\ts#A\u0005'pG\u0006d'+\u001e8uS6,7i\u001c8gS\u001eDQ\u0001\u0012\u001fA\u0002Q\na\"\u001b8ti\u0006dGNQ1tK\u0012K'\u000fC\u0003G\u0001\u0011\u0005q)A\btG\u0006tgi\u001c:Qe>4\u0017\u000e\\3t)\rAE*\u0014\t\u0004C%J\u0005C\u0001\nK\u0013\tY%A\u0001\u0007M_\u000e\fG\u000e\u0015:pM&dW\rC\u0003E\u000b\u0002\u0007A\u0007C\u0004O\u000bB\u0005\t\u0019A(\u0002\u001dI,h\u000e^5nK\u000e{gNZ5hgB\u0019\u0011\u0002U \n\u0005ES!AB(qi&|g\u000eC\u0004T\u0001E\u0005I\u0011\u0001+\u00023M\u001c\u0017M\u001c$peB\u0013xNZ5mKN$C-\u001a4bk2$HEM\u000b\u0002+*\u0012qJV\u0016\u0002/B\u0011\u0001,X\u0007\u00023*\u0011!lW\u0001\nk:\u001c\u0007.Z2lK\u0012T!\u0001\u0018\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002_3\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\b\u000b\u0001\u0014\u0001\u0012A1\u0002\u001fA\u0013xNZ5mK\u001a\u001b\b*\u001a7qKJ\u0004\"A\u00052\u0007\u000b\u0005\u0011\u0001\u0012A2\u0014\u0005\t\f\u0002\"B\bc\t\u0003)G#A1")
public class ProfileFsHelper {
    private final Logger log = LoggerFactory.getLogger(ProfileFsHelper.class);

    /*
     * WARNING - void declaration
     */
    public List<OverlayConfig> scanForOverlayConfigs(File overlayBaseDir) {
        void var3_3;
        this.log.debug("Scanning for overlays configs in: {}", new Object[]{overlayBaseDir});
        File[] confFiles = (File[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)overlayBaseDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ProfileFsHelper.$anonfun$scanForOverlayConfigs$2(f)));
        List configs = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])confFiles)).toList().flatMap((Function1 & Serializable & scala.Serializable)file -> {
            List list;
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file).resolve()).flatMap((Function1 & Serializable & scala.Serializable)config -> OverlayConfigCompanion$.MODULE$.read(config));
            if (try_ instanceof Success) {
                Success success = (Success)try_;
                OverlayConfig overlayConfig = (OverlayConfig)success.value();
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OverlayConfig[]{overlayConfig}));
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable e = failure.exception();
                $this.log.error("Could not parse overlay config file: {}", new Object[]{new Object[]{file, e}});
                list = Nil$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            return list;
        }, List$.MODULE$.canBuildFrom());
        this.log.debug("Found overlay configs : {}", new Object[]{configs});
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public List<LocalRuntimeConfig> scanForRuntimeConfigs(File installBaseDir) {
        void var3_3;
        this.log.debug("Scanning for runtime configs in {}", new Object[]{installBaseDir});
        List configFiles = (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)installBaseDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).toList().flatMap((Function1 & Serializable & scala.Serializable)nameDir -> (List)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)nameDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).toList().flatMap((Function1 & Serializable & scala.Serializable)versionDir -> {
            File profileFile = new File((File)versionDir, "profile.conf");
            return profileFile.exists() ? Option$.MODULE$.option2Iterable((Option)new Some((Object)profileFile)) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom());
        this.log.debug("Found potential runtime config files: {}", new Object[]{configFiles});
        List runtimeConfigs = (List)configFiles.flatMap((Function1 & Serializable & scala.Serializable)runtimeConfigFile -> (List)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Nil$ nil$;
            File versionDir = runtimeConfigFile.getParentFile();
            String version = versionDir.getName();
            String name = versionDir.getParentFile().getName();
            Config config = ConfigFactory.parseFile((File)runtimeConfigFile, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            ResolvedRuntimeConfig resolved = new ResolvedRuntimeConfig((RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get());
            File x$3 = versionDir;
            ResolvedRuntimeConfig x$4 = resolved;
            LocalRuntimeConfig local = new LocalRuntimeConfig(x$4, x$3);
            String string = local.runtimeConfig().name();
            String string2 = name;
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                String string3 = local.runtimeConfig().version();
                String string4 = version;
                if (!(string3 != null ? !string3.equals(string4) : string4 != null)) {
                    nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LocalRuntimeConfig[]{local}));
                    return nil$;
                }
            }
            $this.log.warn(new StringBuilder(55).append("Profile name and version do not match directory names: ").append(runtimeConfigFile).toString());
            nil$ = Nil$.MODULE$;
            return nil$;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            $this.log.warn(new StringBuilder(29).append("Could not read profile file: ").append(runtimeConfigFile).toString());
            return Nil$.MODULE$;
        }), List$.MODULE$.canBuildFrom());
        this.log.debug(new StringBuilder(23).append("Found runtime configs: ").append(((TraversableOnce)((List)runtimeConfigs.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)wi -> new StringBuilder(2).append(wi._2$mcI$sp()).append(": ").append(wi._1()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n")).toString());
        return var3_3;
    }

    public List<LocalProfile> scanForProfiles(File installBaseDir, Option<List<LocalRuntimeConfig>> runtimeConfigs) {
        this.log.debug("Scanning for profiles in: {}", new Object[]{installBaseDir});
        List rcs = ((List)runtimeConfigs.getOrElse((Function0 & Serializable & scala.Serializable)() -> this.scanForRuntimeConfigs(installBaseDir))).toList();
        List runtimeConfigsWithIssues = (List)rcs.flatMap((Function1 & Serializable & scala.Serializable)localConfig -> {
            List issues = localConfig.validate(false, true).toList();
            $this.log.debug(new StringBuilder(27).append("Runtime config ").append(localConfig.runtimeConfig().name()).append("-").append(localConfig.runtimeConfig().version()).append(" issues: {}").toString(), new Object[]{issues});
            return List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(localConfig), (Object)issues)}));
        }, List$.MODULE$.canBuildFrom());
        this.log.debug(new StringBuilder(31).append("Runtime configs (with issues): ").append(runtimeConfigsWithIssues).toString());
        List fullProfiles = (List)runtimeConfigsWithIssues.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            List list;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                LocalRuntimeConfig localRuntimeConfig = (LocalRuntimeConfig)tuple2._1();
                List issues = (List)tuple2._2();
                File profileDir = localRuntimeConfig.baseDir();
                File overlayDir = new File(profileDir, "overlays");
                List overlayFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)overlayDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class))))).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)ProfileFsHelper.$anonfun$scanForProfiles$5(f))))).toList();
                if (overlayFiles.isEmpty()) {
                    $this.log.warn("Could not found any overlay configs for profile: {}", new Object[]{localRuntimeConfig.profileFileLocation()});
                    list = Nil$.MODULE$;
                } else {
                    list = (List)overlayFiles.flatMap((Function1 & Serializable & scala.Serializable)file -> {
                        Iterable iterable;
                        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve()).flatMap((Function1 & Serializable & scala.Serializable)c -> LocalOverlays$.MODULE$.read(c, profileDir));
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            $this.log.error(new StringBuilder(36).append("Could not load overlay config file: ").append(file).toString(), e);
                            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                        } else if (try_ instanceof Success) {
                            Nil$ nil$;
                            File canonicalFile;
                            Success success = (Success)try_;
                            LocalOverlays localOverlays = (LocalOverlays)success.value();
                            File file2 = canonicalFile = LocalOverlays$.MODULE$.preferredConfigFile((Iterable)localOverlays.overlays().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.overlayRef(), List$.MODULE$.canBuildFrom()), profileDir);
                            File file3 = file;
                            if (file2 == null ? file3 != null : !((Object)file2).equals(file3)) {
                                $this.log.error("Skipping found overlays file because filename does not match the expected file name: {}", new Object[]{file});
                                nil$ = Nil$.MODULE$;
                            } else {
                                Nil$ nil$2;
                                List list = localOverlays.validate();
                                Some some = Seq$.MODULE$.unapplySeq((Seq)list);
                                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
                                    nil$2 = localOverlays.isMaterialized() ? Nil$.MODULE$ : List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Overlays not materialized"}));
                                } else {
                                    $this.log.error("Skipping found overlays file because it is not valid: {}. Issue: {}", new Object[]{new Object[]{file, list.mkString(" / ")}});
                                    nil$2 = list.toList();
                                }
                                Nil$ overlayIssues = nil$2;
                                $this.log.debug("Found overlay:", new Object[]{localOverlays});
                                $this.log.debug("Found overlay issues: {}", new Object[]{issues});
                                LocalProfile[] localProfileArray = new LocalProfile[1];
                                List list2 = issues;
                                localProfileArray[0] = new LocalProfile(localRuntimeConfig, localOverlays, ProfileFsHelper.profileState$1(overlayIssues.$colon$colon$colon(list2)));
                                nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])localProfileArray));
                            }
                            iterable = nil$;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return iterable;
                    }, List$.MODULE$.canBuildFrom());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            List list2 = list;
            return list2;
        }, List$.MODULE$.canBuildFrom());
        return fullProfiles;
    }

    public Option<List<LocalRuntimeConfig>> scanForProfiles$default$2() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$scanForOverlayConfigs$2(File f) {
        return f.isFile() && f.getName().endsWith(".conf");
    }

    private static final LocalProfile.ProfileState profileState$1(List issues) {
        List list = issues;
        Some some = Seq$.MODULE$.unapplySeq((Seq)list);
        LocalProfile.ProfileState profileState = !some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0 ? LocalProfile$Staged$.MODULE$ : new LocalProfile.Pending((List<String>)list);
        return profileState;
    }

    public static final /* synthetic */ boolean $anonfun$scanForProfiles$5(File f) {
        return f.getName().endsWith(".conf");
    }
}

