/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.internal;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.pattern.package$;
import akka.util.Timeout;
import akka.util.Timeout$;
import blended.updater.Updater;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.OverlayRef;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.internal.UpdateEnv;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055c\u0001B\u0001\u0003\u0001%\u0011\u0001bQ8n[\u0006tGm\u001d\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0002\u0001\u0003\u0002\u0003\u0006I!\u0005\t\u0003%]i\u0011a\u0005\u0006\u0003)U\tQ!Y2u_JT\u0011AF\u0001\u0005C.\\\u0017-\u0003\u0002\u0019'\tA\u0011i\u0019;peJ+g\r\u0003\u0005\u001b\u0001\t\u0005\t\u0015!\u0003\u001c\u0003\r)gN\u001e\t\u0004\u0017qq\u0012BA\u000f\r\u0005\u0019y\u0005\u000f^5p]B\u0011q\u0004I\u0007\u0002\u0005%\u0011\u0011E\u0001\u0002\n+B$\u0017\r^3F]ZD\u0001b\t\u0001\u0003\u0006\u0004%\u0019\u0001J\u0001\fC\u000e$xN]*zgR,W.F\u0001&!\t\u0011b%\u0003\u0002('\tY\u0011i\u0019;peNK8\u000f^3n\u0011!I\u0003A!A!\u0002\u0013)\u0013\u0001D1di>\u00148+_:uK6\u0004\u0003\"B\u0016\u0001\t\u0003a\u0013A\u0002\u001fj]&$h\bF\u0002.aE\"\"AL\u0018\u0011\u0005}\u0001\u0001\"B\u0012+\u0001\b)\u0003\"B\u0003+\u0001\u0004\t\u0002\"\u0002\u000e+\u0001\u0004Y\u0002BB\u001a\u0001A\u0003%A'A\u0002m_\u001e\u0004\"!\u000e\u001e\u000e\u0003YR!a\u000e\u001d\u0002\u000bMdg\r\u000e6\u000b\u0003e\n1a\u001c:h\u0013\tYdG\u0001\u0004M_\u001e<WM\u001d\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0003]\u0019w.\\7b]\u0012\u001cx+\u001b;i\t\u0016\u001c8M]5qi&|g.F\u0001@!\r\u00015)R\u0007\u0002\u0003*\u0011!\tD\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\r\u0019V-\u001d\t\u0005\u0017\u0019C\u0005*\u0003\u0002H\u0019\t1A+\u001e9mKJ\u0002\"!\u0013(\u000e\u0003)S!a\u0013'\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0006!!.\u0019<b\u0013\ty%J\u0001\u0004TiJLgn\u001a\u0005\u0007#\u0002\u0001\u000b\u0011B \u00021\r|W.\\1oIN<\u0016\u000e\u001e5EKN\u001c'/\u001b9uS>t\u0007\u0005C\u0003T\u0001\u0011\u0005A+\u0001\u0007tQ><\bK]8gS2,7\u000fF\u0001\u000b\u0011\u00151\u0006\u0001\"\u0001U\u0003I\u0019\bn\\<Sk:$\u0018.\\3D_:4\u0017nZ:\t\u000ba\u0003A\u0011\u0001+\u0002\u0019MDwn^(wKJd\u0017-_:\t\u000bi\u0003A\u0011A.\u0002\u001fI,w-[:uKJ\u0004&o\u001c4jY\u0016$\"A\u0003/\t\u000buK\u0006\u0019\u00010\u0002\t\u0019LG.\u001a\t\u0003?\nl\u0011\u0001\u0019\u0006\u0003C2\u000b!![8\n\u0005\r\u0004'\u0001\u0002$jY\u0016DQ!\u001a\u0001\u0005\u0002\u0019\fQC]3hSN$XM\u001d*v]RLW.Z\"p]\u001aLw\r\u0006\u0002\u000bO\")Q\f\u001aa\u0001=\")\u0011\u000e\u0001C\u0001U\u0006y!/Z4jgR,'o\u0014<fe2\f\u0017\u0010\u0006\u0002\u000bW\")Q\f\u001ba\u0001=\")Q\u000e\u0001C\u0001]\u0006i\u0001/\u0019:tK>3XM\u001d7bsN$\"a\u001c?\u0011\u0007A\u001chO\u0004\u0002\fc&\u0011!\u000fD\u0001\u0007!J,G-\u001a4\n\u0005Q,(aA*fi*\u0011!\u000f\u0004\t\u0003ojl\u0011\u0001\u001f\u0006\u0003s\u0012\taaY8oM&<\u0017BA>y\u0005)ye/\u001a:mCf\u0014VM\u001a\u0005\u0006{2\u0004\rA`\u0001\u0013_Z,'\u000f\\1z\u001d\u0006lWMV3sg&|g\u000eE\u0003\u0000\u0003\u001f\t\u0019B\u0004\u0003\u0002\u0002\u0005-a\u0002BA\u0002\u0003\u0013i!!!\u0002\u000b\u0007\u0005\u001d\u0001\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u0019\u0011Q\u0002\u0007\u0002\u000fA\f7m[1hK&\u0019A)!\u0005\u000b\u0007\u00055A\u0002E\u0002q\u0003+I!aT;\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c\u0005a1\u000f^1hKB\u0013xNZ5mKR9!\"!\b\u0002\"\u0005\u0015\u0002\u0002CA\u0010\u0003/\u0001\r!a\u0005\u0002\rI\u001cg*Y7f\u0011!\t\u0019#a\u0006A\u0002\u0005M\u0011!\u0003:d-\u0016\u00148/[8o\u0011\u001di\u0018q\u0003a\u0001\u0003O\u0001RaCA\u0015\u0003'I1!a\u000b\r\u0005)a$/\u001a9fCR,GM\u0010\u0015\u0005\u0003/\ty\u0003\u0005\u0003\u00022\u0005]RBAA\u001a\u0015\r\t)\u0004D\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u001d\u0003g\u0011qA^1sCJ<7\u000fC\u0004\u0002>\u0001!\t!a\u0010\u0002\u001f\u0005\u001cG/\u001b<bi\u0016\u0004&o\u001c4jY\u0016$rACA!\u0003\u000b\nI\u0005\u0003\u0005\u0002D\u0005m\u0002\u0019AA\n\u0003\u0011q\u0017-\\3\t\u0011\u0005\u001d\u00131\ba\u0001\u0003'\tqA^3sg&|g\u000eC\u0004~\u0003w\u0001\r!a\n)\t\u0005m\u0012q\u0006")
public class Commands {
    private final ActorRef updater;
    private final Option<UpdateEnv> env;
    private final ActorSystem actorSystem;
    private final Logger log;
    private final Seq<Tuple2<String, String>> commandsWithDescription;

    public Object stageProfile(String rcName, String rcVersion, String ... overlayNameVersion) {
        return this.stageProfile(rcName, rcVersion, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public Object activateProfile(String name, String version, String ... overlayNameVersion) {
        return this.activateProfile(name, version, (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])overlayNameVersion));
    }

    public ActorSystem actorSystem() {
        return this.actorSystem;
    }

    public Seq<Tuple2<String, String>> commandsWithDescription() {
        return this.commandsWithDescription;
    }

    public Object showProfiles() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Option activeProfile = this.env.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Updater.ProfileId apply(UpdateEnv env) {
                return new Updater.ProfileId(env.launchedProfileName(), env.launchedProfileVersion(), (Set<OverlayRef>)((Set)env.overlays().getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Set<OverlayRef> apply() {
                        return (Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$);
                    }
                })));
            }
        });
        this.log.debug("acitive profile: {}", new Object[]{activeProfile});
        Set profiles = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetProfiles(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " profiles:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)profiles.size()), ((TraversableOnce)profiles.map((Function1)new Serializable(this, activeProfile){
            public static final long serialVersionUID = 0L;
            private final Option activeProfile$1;

            public final String apply(Object x0$1) {
                Object object = x0$1;
                if (object instanceof Updater.Profile) {
                    Updater.Profile profile = (Updater.Profile)object;
                    String activePart = this.activeProfile$1.exists((Function1)new Serializable(this, profile){
                        public static final long serialVersionUID = 0L;
                        private final Updater.Profile x2$1;

                        public final boolean apply(Updater.ProfileId x$1) {
                            Updater.ProfileId profileId = x$1;
                            Updater.ProfileId profileId2 = this.x2$1.profileId();
                            return !(profileId != null ? !((Object)profileId).equals(profileId2) : profileId2 != null);
                        }
                        {
                            this.x2$1 = x2$1;
                        }
                    }) ? " (active)" : "";
                    String string = new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)profile.profileId()), ": ")).append((Object)profile.state()).append((Object)activePart).toString();
                    return string;
                }
                throw new MatchError(object);
            }
            {
                this.activeProfile$1 = activeProfile$1;
            }
        }, Set$.MODULE$.canBuildFrom())).mkString("\n")}));
    }

    public Object showRuntimeConfigs() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetRuntimeConfigs(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " runtime configs:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configs.size()), ((TraversableOnce)((SeqLike)configs.toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Object x0$2) {
                Object object = x0$2;
                if (object instanceof LocalRuntimeConfig) {
                    LocalRuntimeConfig localRuntimeConfig = (LocalRuntimeConfig)object;
                    ResolvedRuntimeConfig c = localRuntimeConfig.resolvedRuntimeConfig();
                    String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{c.runtimeConfig().name(), c.runtimeConfig().version()}));
                    return string;
                }
                throw new MatchError(object);
            }
        }, List$.MODULE$.canBuildFrom())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("\n")}));
    }

    public Object showOverlays() {
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        Set configs = (Set)((Updater.Result)Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.GetOverlays(UUID.randomUUID().toString()), timeout).mapTo(ClassTag$.MODULE$.apply(Updater.Result.class)), (Duration)timeout.duration())).result();
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " overlay configs:\\n", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)configs.size()), configs.mkString("\n")}));
    }

    public Object registerProfile(File file) {
        return this.registerRuntimeConfig(file);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerRuntimeConfig(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        RuntimeConfig runtimeConfig = (RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"About to add: ").append((Object)runtimeConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddRuntimeConfig(reqId, runtimeConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder().append((Object)"Added: ").append((Object)runtimeConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder().append((Object)"Added: ").append((Object)runtimeConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder().append((Object)"Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder().append((Object)"Error: ").append(object).toString();
            return new StringBuilder().append((Object)"Failed: ").append((Object)error).toString();
        }
        if (string5 == null) return new StringBuilder().append((Object)"Failed: ").append((Object)error).toString();
        return new StringBuilder().append((Object)"Error: ").append(object).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object registerOverlay(File file) {
        Config config = ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
        OverlayConfig overlayConfig = (OverlayConfig)OverlayConfigCompanion$.MODULE$.read(config).get();
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"About to add: ").append((Object)overlayConfig).toString());
        Timeout timeout = Timeout$.MODULE$.apply(5L, TimeUnit.SECONDS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.AddOverlayConfig(reqId, overlayConfig), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder().append((Object)"Added: ").append((Object)overlayConfig).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder().append((Object)"Added: ").append((Object)overlayConfig).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder().append((Object)"Error: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String error = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder().append((Object)"Error: ").append(object).toString();
            return new StringBuilder().append((Object)"Failed: ").append((Object)error).toString();
        }
        if (string5 == null) return new StringBuilder().append((Object)"Failed: ").append((Object)error).toString();
        return new StringBuilder().append((Object)"Error: ").append(object).toString();
    }

    public Set<OverlayRef> parseOverlays(Seq<String> overlayNameVersion) {
        if (overlayNameVersion.size() % 2 != 0) {
            throw scala.sys.package$.MODULE$.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Missing version for overlay ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{overlayNameVersion.last()})));
        }
        return overlayNameVersion.sliding(2, 2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final OverlayRef apply(Seq<String> o) {
                return new OverlayRef((String)o.apply(0), (String)o.apply(1));
            }
        }).toSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object stageProfile(String rcName, String rcVersion, Seq<String> overlayNameVersion) {
        Set<OverlayRef> overlays = this.parseOverlays(overlayNameVersion);
        String overlaysAsString = overlays.isEmpty() ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(OverlayRef o) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.name(), o.version()}));
            }
        }, List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
        String asString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rcName, rcVersion, overlaysAsString}));
        Timeout timeout = Timeout$.MODULE$.apply(1L, TimeUnit.HOURS);
        String reqId = UUID.randomUUID().toString();
        Object object = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.StageProfile(reqId, rcName, rcVersion, overlays), timeout), (Duration)timeout.duration());
        if (object instanceof Updater.OperationSucceeded) {
            Updater.OperationSucceeded operationSucceeded = (Updater.OperationSucceeded)object;
            String string = operationSucceeded.requestId();
            String string2 = reqId;
            String string3 = string;
            if (string2 == null) {
                if (string3 == null) return new StringBuilder().append((Object)"Staged: ").append((Object)asString).toString();
            } else if (string2.equals(string3)) {
                return new StringBuilder().append((Object)"Staged: ").append((Object)asString).toString();
            }
        }
        if (!(object instanceof Updater.OperationFailed)) return new StringBuilder().append((Object)"Stage failed: ").append((Object)asString).append((Object)"\nError: ").append(object).toString();
        Updater.OperationFailed operationFailed = (Updater.OperationFailed)object;
        String string = operationFailed.requestId();
        String reason = operationFailed.reason();
        String string4 = reqId;
        String string5 = string;
        if (string4 != null) {
            if (!string4.equals(string5)) return new StringBuilder().append((Object)"Stage failed: ").append((Object)asString).append((Object)"\nError: ").append(object).toString();
            return new StringBuilder().append((Object)"Stage failed: ").append((Object)asString).append((Object)"\nReason: ").append((Object)reason).toString();
        }
        if (string5 == null) return new StringBuilder().append((Object)"Stage failed: ").append((Object)asString).append((Object)"\nReason: ").append((Object)reason).toString();
        return new StringBuilder().append((Object)"Stage failed: ").append((Object)asString).append((Object)"\nError: ").append(object).toString();
    }

    /*
     * Unable to fully structure code
     */
    public Object activateProfile(String name, String version, Seq<String> overlayNameVersion) {
        block2: {
            block4: {
                block3: {
                    overlays = this.parseOverlays(overlayNameVersion);
                    overlaysAsString = overlays.isEmpty() != false ? "" : ((TraversableOnce)((List)overlays.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(OverlayRef o) {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{o.name(), o.version()}));
                        }
                    }, List$.MODULE$.canBuildFrom())).mkString(" with ", " with ", "");
                    asString = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name, version, overlaysAsString}));
                    var7_7 = this.env;
                    if (!(var7_7 instanceof Some) || (var9_9 = (UpdateEnv)(var8_8 = (Some)var7_7).x()) == null || !((var10_10 = var9_9.launchProfileLookupFile()) instanceof Some)) break block2;
                    timeout = Timeout$.MODULE$.apply(5L, TimeUnit.MINUTES);
                    reqId = UUID.randomUUID().toString();
                    var14_13 = Await$.MODULE$.result((Awaitable)package$.MODULE$.ask(this.updater, (Object)new Updater.ActivateProfile(reqId, name, version, overlays), timeout), (Duration)timeout.duration());
                    if (!(var14_13 instanceof Updater.OperationSucceeded)) break block3;
                    var15_14 = (Updater.OperationSucceeded)var14_13;
                    var16_15 = var15_14.requestId();
                    v0 = reqId;
                    var17_16 = var16_15;
                    if (v0 != null ? v0.equals(var17_16) == false : var17_16 != null) break block3;
                    var18_17 = new StringBuilder().append((Object)"Activated: ").append((Object)asString).toString();
                    break block4;
                }
                if (!(var14_13 instanceof Updater.OperationFailed)) ** GOTO lbl-1000
                var19_18 = (Updater.OperationFailed)var14_13;
                var20_19 = var19_18.requestId();
                reason = var19_18.reason();
                v1 = reqId;
                var22_21 = var20_19;
                if (!(v1 != null ? v1.equals(var22_21) == false : var22_21 != null)) {
                    var18_17 = new StringBuilder().append((Object)"Activation failed: ").append((Object)asString).append((Object)"\nReason: ").append((Object)reason).toString();
                } else lbl-1000:
                // 2 sources

                {
                    var18_17 = new StringBuilder().append((Object)"Activation failed: ").append((Object)asString).append((Object)"\nError: ").append(var14_13).toString();
                }
            }
            var11_22 = var18_17;
            return var11_22;
        }
        throw scala.sys.package$.MODULE$.error("No updateable environment detected. No profile lookup file defined.");
    }

    public Commands(ActorRef updater, Option<UpdateEnv> env, ActorSystem actorSystem) {
        this.updater = updater;
        this.env = env;
        this.actorSystem = actorSystem;
        this.log = LoggerFactory.getLogger(Commands.class);
        this.commandsWithDescription = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showProfiles"), (Object)"Show all (staged) profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showRuntimeConfigs"), (Object)"Show all known runtime configs"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"showOverlays"), (Object)"Show all known overlays"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerRuntimeConfig"), (Object)"Add a new runtime config"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Add a new profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Add a new overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"stageProfile"), (Object)"Stage a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"activateProfile"), (Object)"Activate a profile")}));
    }
}

