/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.tools.configbuilder;

import blended.updater.config.Artifact;
import blended.updater.config.BundleConfig;
import blended.updater.config.ConfigWriter$;
import blended.updater.config.FeatureConfig;
import blended.updater.config.FeatureConfigCompanion$;
import blended.updater.config.FeatureResolver;
import blended.updater.config.FeatureResolver$;
import blended.updater.config.LocalProfile;
import blended.updater.config.MvnGav;
import blended.updater.config.MvnGav$;
import blended.updater.config.Profile;
import blended.updater.config.Profile$;
import blended.updater.config.ProfileCompanion$;
import blended.updater.config.ProfileLookup;
import blended.updater.config.ProfileLookup$;
import blended.updater.config.ResolvedProfile;
import blended.updater.config.util.Unzipper$;
import blended.updater.tools.configbuilder.MvnGavSupport$;
import blended.updater.tools.configbuilder.ProfileBuilder;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigParseOptions;
import de.tototec.cmdoption.CmdlineParser;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class ProfileBuilder$ {
    public static final ProfileBuilder$ MODULE$ = new ProfileBuilder$();
    private static final Function1<ProfileBuilder.CmdOptions, Function1<Option<Function1<String, BoxedUnit>>, Function1<String, BoxedUnit>>> debug = (Function1 & Serializable)options -> (Function1 & Serializable)x0$1 -> {
        Function1 & Serializable intersect;
        Option option = x0$1;
        if (option instanceof Some) {
            Function1 & Serializable dl;
            Some some = (Some)option;
            intersect = dl = (Function1 & Serializable)some.value();
        } else if (None$.MODULE$.equals(option)) {
            intersect = options.debug() ? (Function1 & Serializable)msg -> {
                ProfileBuilder$.$anonfun$debug$3(msg);
                return BoxedUnit.UNIT;
            } : (Function1 & Serializable)x$2 -> {
                ProfileBuilder$.$anonfun$debug$4(x$2);
                return BoxedUnit.UNIT;
            };
        } else {
            throw new MatchError((Object)option);
        }
        return intersect;
    };

    public void main(String[] args) {
        try {
            this.run(args);
            throw package$.MODULE$.exit(0);
        }
        catch (Throwable e) {
            StringWriter sw = new StringWriter();
            PrintWriter writer = new PrintWriter(new StringWriter());
            e.printStackTrace(writer);
            Console$.MODULE$.err().println(new StringBuilder(19).append("An error occurred: ").append(e.getMessage()).toString());
            Console$.MODULE$.err().println(sw.toString());
            throw package$.MODULE$.exit(1);
        }
    }

    public void run(String[] args) {
        this.run(args, (Option<Function1<String, BoxedUnit>>)None$.MODULE$, this.run$default$3(), this.run$default$4());
    }

    public Function1<ProfileBuilder.CmdOptions, Function1<Option<Function1<String, BoxedUnit>>, Function1<String, BoxedUnit>>> debug() {
        return debug;
    }

    public void run(String[] args, Option<Function1<String, BoxedUnit>> debugLog, Function1<String, BoxedUnit> infoLog, Function1<String, BoxedUnit> errorLog) {
        Option option;
        Profile profile;
        List files;
        List states;
        List issues;
        Seq issues2;
        Function1 & Serializable intersect;
        LazyRef mvnUrls$lzy = new LazyRef();
        ProfileBuilder.CmdOptions options = new ProfileBuilder.CmdOptions();
        CmdlineParser cp = new CmdlineParser(new Object[]{options});
        cp.parse(args);
        if (options.help()) {
            cp.usage();
            return;
        }
        Option<Function1<String, BoxedUnit>> option2 = debugLog;
        if (option2 instanceof Some) {
            Function1 & Serializable dl;
            Some some = (Some)option2;
            intersect = dl = (Function1 & Serializable)some.value();
        } else if (None$.MODULE$.equals(option2)) {
            intersect = options.debug() ? (Function1 & Serializable)msg -> {
                ProfileBuilder$.$anonfun$run$1(msg);
                return BoxedUnit.UNIT;
            } : (Function1 & Serializable)msg -> {
                ProfileBuilder$.$anonfun$run$2(msg);
                return BoxedUnit.UNIT;
            };
        } else {
            throw new MatchError(option2);
        }
        Function1 & Serializable debug = intersect;
        debug.apply((Object)new StringBuilder(16).append("ProfileBuilder: ").append(Predef$.MODULE$.wrapRefArray((Object[])args).mkString(" ")).toString());
        if (options.configFile().isEmpty()) {
            throw package$.MODULE$.error("No config file given");
        }
        Seq mvnGavs = (Seq)((IterableOps)options.mavenArtifacts().map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String gav = (String)tuple2._1();
            String file = (String)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MvnGav$.MODULE$.parse(gav)), (Object)file);
            return tuple22;
        })).collect((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<Try<MvnGav>, String>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 != null) {
                    Try try_ = (Try)A1._1();
                    String file = (String)A1._2();
                    if (try_ instanceof Success) {
                        Success success = (Success)try_;
                        MvnGav gav = (MvnGav)success.value();
                        object = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)gav), (Object)file);
                        return (B1)object;
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<Try<MvnGav>, String> x1) {
                Try try_;
                Tuple2<Try<MvnGav>, String> tuple2 = x1;
                boolean bl = tuple2 != null && (try_ = (Try)tuple2._1()) instanceof Success;
                return bl;
            }
        });
        List features = ((IterableOnceOps)options.featureRepos().map((Function1 & Serializable)fileName -> {
            Config featureConfig = ConfigFactory.parseFile((File)new File((String)fileName), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            return (FeatureConfig)FeatureConfigCompanion$.MODULE$.read(featureConfig).get();
        })).toList();
        debug.apply((Object)new StringBuilder(10).append("features: ").append(features.map((Function1 & Serializable)x$3 -> x$3.toRef()).mkString("\n  ")).toString());
        File configFile = new File(options.configFile()).getAbsoluteFile();
        Option outFile = Option$.MODULE$.apply((Object)options.outFile().trim()).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ProfileBuilder$.$anonfun$run$6(x$4))).orElse((Function0 & Serializable)() -> options.inPlace() ? Option$.MODULE$.apply((Object)configFile.getPath()) : None$.MODULE$).map((Function1 & Serializable)x$5 -> new File((String)x$5).getAbsoluteFile());
        File dir = (File)outFile.flatMap((Function1 & Serializable)f -> Option$.MODULE$.apply((Object)f.getParentFile())).getOrElse((Function0 & Serializable)() -> configFile.getParentFile());
        File featureDir = new File(dir, "features");
        Object object = !featureDir.exists() ? BoxesRunTime.boxToBoolean((boolean)featureDir.mkdirs()) : BoxedUnit.UNIT;
        Config config = ConfigFactory.parseFile((File)configFile, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).withFallback((ConfigMergeable)ConfigFactory.parseMap((java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)options.envVars().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl())).asJava())).resolve();
        Profile unresolvedProfile = (Profile)ProfileCompanion$.MODULE$.read(config).get();
        debug.apply((Object)new StringBuilder(20).append("unresolved profile: ").append(unresolvedProfile).toString());
        FeatureResolver resolver = new FeatureResolver(featureDir, features, FeatureResolver$.MODULE$.$lessinit$greater$default$3());
        ResolvedProfile resolved = (ResolvedProfile)resolver.resolve(unresolvedProfile).get();
        debug.apply((Object)new StringBuilder(32).append("profile with resolved features: ").append(resolved).toString());
        LocalProfile localRuntimeConfig = new LocalProfile(resolved, dir);
        if (options.check() && (issues2 = (Seq)localRuntimeConfig.validate(true, false).get()).nonEmpty()) {
            throw package$.MODULE$.error(issues2.mkString("\n"));
        }
        debug.apply((Object)new StringBuilder(12).append("Maven URLs: ").append(ProfileBuilder$.mvnUrls$1(mvnUrls$lzy, resolved, options)).toString());
        if (options.downloadMissing() && (issues = (states = (files = (List)((List)((SeqOps)resolved.allBundles().get()).distinct()).map((Function1 & Serializable)b -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ProfileCompanion$.MODULE$.bundleLocation(b, dir)), (Object)ProfileBuilder$.downloadUrls$1(b.artifact(), mvnGavs, options, mvnUrls$lzy, resolved))).$plus$plus((IterableOnce)resolved.profile().resources().map((Function1 & Serializable)r -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ProfileCompanion$.MODULE$.resourceArchiveLocation(r, dir)), (Object)ProfileBuilder$.downloadUrls$1(r, mvnGavs, options, mvnUrls$lzy, resolved))))).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            File file = (File)tuple2._1();
            Seq urls = (Seq)tuple2._2();
            Tuple2 tuple22 = !file.exists() ? (Tuple2)urls.find((Function1 & Serializable)url -> BoxesRunTime.boxToBoolean((boolean)ProfileBuilder$.$anonfun$run$17(debug, file, url))).map((Function1 & Serializable)url -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)Try$.MODULE$.apply((Function0 & Serializable)() -> file))).getOrElse((Function0 & Serializable)() -> {
                String msg = new StringBuilder(28).append("Could not download [").append(file.getName()).append("] from: ").append(urls).toString();
                errorLog.apply((Object)msg);
                return package$.MODULE$.error(msg);
            }) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), (Object)Try$.MODULE$.apply((Function0 & Serializable)() -> file));
            return tuple22;
        })).collect((PartialFunction)new Serializable(errorLog){
            private static final long serialVersionUID = 0L;
            private final Function1 errorLog$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends Tuple2<File, Try<File>>, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x2;
                if (A1 != null) {
                    File file = (File)A1._1();
                    Try try_ = (Try)A1._2();
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.errorLog$1.apply((Object)new StringBuilder(25).append("Could not download: ").append(file).append(" (").append(e.getClass().getSimpleName()).append(": ").append(e.getMessage()).append(")").toString());
                        object = e;
                        return (B1)object;
                    }
                }
                object = function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<File, Try<File>> x2) {
                Try try_;
                Tuple2<File, Try<File>> tuple2 = x2;
                boolean bl = tuple2 != null && (try_ = (Try)tuple2._2()) instanceof Failure;
                return bl;
            }
            {
                this.errorLog$1 = errorLog$1;
            }
        })).nonEmpty()) {
            throw package$.MODULE$.error(issues.mkString("\n"));
        }
        if (options.updateChecksums()) {
            ObjectRef checkedFiles = ObjectRef.create((Object)((scala.collection.immutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
            List x$1 = resolved.profile().bundles().map((Function1 & Serializable)b -> ProfileBuilder$.checkAndUpdateBundle$1(b, localRuntimeConfig, checkedFiles, debug));
            List x$2 = ((List)resolved.allReferencedFeatures().get()).map((Function1 & Serializable)f -> ProfileBuilder$.checkAndUpdateFeatures$1(f, localRuntimeConfig, checkedFiles, debug));
            List x$32 = resolved.profile().resources().map((Function1 & Serializable)a -> ProfileBuilder$.checkAndUpdateResource$1(a, localRuntimeConfig, checkedFiles, debug));
            String x$42 = resolved.profile().copy$default$1();
            String x$52 = resolved.profile().copy$default$2();
            int x$6 = resolved.profile().copy$default$4();
            int x$7 = resolved.profile().copy$default$5();
            scala.collection.immutable.Map x$8 = resolved.profile().copy$default$6();
            scala.collection.immutable.Map x$9 = resolved.profile().copy$default$7();
            scala.collection.immutable.Map x$10 = resolved.profile().copy$default$8();
            List x$11 = resolved.profile().copy$default$9();
            profile = new ResolvedProfile(resolved.profile().copy(x$42, x$52, x$1, x$6, x$7, x$8, x$9, x$10, x$11, x$32, x$2)).profile();
        } else {
            profile = resolved.profile();
        }
        Profile newProfile = profile;
        Object object2 = options.explodeResources() ? newProfile.resources().map((Function1 & Serializable)r -> {
            ProfileBuilder$.$anonfun$run$30(localRuntimeConfig, r);
            return BoxedUnit.UNIT;
        }) : BoxedUnit.UNIT;
        if (Option$.MODULE$.apply((Object)options.createLaunchConfigFile()).isDefined()) {
            String profileBaseDir = options.profileBaseDir();
            ProfileLookup profileLookup = new ProfileLookup(localRuntimeConfig.runtimeConfig().name(), localRuntimeConfig.runtimeConfig().version(), new File("REPLACE_BASE_DIR"));
            File file = new File(options.createLaunchConfigFile());
            debug.apply((Object)new StringBuilder(28).append("Writing launch config file: ").append(file).toString());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ConfigWriter$.MODULE$.write(ProfileLookup$.MODULE$.toConfig(profileLookup), (OutputStream)os, (Option)None$.MODULE$);
            String confOutput = Pattern.compile("[\"]REPLACE_BASE_DIR[\"]").matcher(os.toString()).replaceAll(Matcher.quoteReplacement(profileBaseDir));
            try (PrintStream ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));){
                ps.println(confOutput);
            }
        }
        if (None$.MODULE$.equals(option = outFile)) {
            ConfigWriter$.MODULE$.write(ProfileCompanion$.MODULE$.toConfig(newProfile), (OutputStream)Console$.MODULE$.out(), (Option)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            File f2 = (File)some.value();
            debug.apply((Object)new StringBuilder(21).append("Writing config file: ").append(f2.getAbsolutePath()).toString());
            ConfigWriter$.MODULE$.write(ProfileCompanion$.MODULE$.toConfig(newProfile), f2, (Option)None$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public Option<Function1<String, BoxedUnit>> run$default$2() {
        return None$.MODULE$;
    }

    public Function1<String, BoxedUnit> run$default$3() {
        PrintStream printStream = Console$.MODULE$.out();
        return (Function1 & Serializable)x$1 -> {
            printStream.println(x$1);
            return BoxedUnit.UNIT;
        };
    }

    public Function1<String, BoxedUnit> run$default$4() {
        PrintStream printStream = Console$.MODULE$.err();
        return (Function1 & Serializable)x$1 -> {
            printStream.println(x$1);
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$debug$3(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public static final /* synthetic */ void $anonfun$debug$4(String x$2) {
    }

    public static final /* synthetic */ void $anonfun$run$1(String msg) {
        Console$.MODULE$.err().println(msg);
    }

    public static final /* synthetic */ void $anonfun$run$2(String msg) {
    }

    public static final /* synthetic */ boolean $anonfun$run$6(String x$4) {
        return !x$4.isEmpty();
    }

    private static final /* synthetic */ Seq mvnUrls$lzycompute$1(LazyRef mvnUrls$lzy$1, ResolvedProfile resolved$1, ProfileBuilder.CmdOptions options$2) {
        Seq seq;
        LazyRef lazyRef = mvnUrls$lzy$1;
        synchronized (lazyRef) {
            seq = mvnUrls$lzy$1.initialized() ? (Seq)mvnUrls$lzy$1.value() : (Seq)mvnUrls$lzy$1.initialize(Option$.MODULE$.option2Iterable(resolved$1.profile().properties().get((Object)Profile.Properties$.MODULE$.MVN_REPO())).toSeq().$plus$plus(options$2.mavenUrls()));
        }
        return seq;
    }

    private static final Seq mvnUrls$1(LazyRef mvnUrls$lzy$1, ResolvedProfile resolved$1, ProfileBuilder.CmdOptions options$2) {
        return mvnUrls$lzy$1.initialized() ? (Seq)mvnUrls$lzy$1.value() : ProfileBuilder$.mvnUrls$lzycompute$1(mvnUrls$lzy$1, resolved$1, options$2);
    }

    private static final Seq downloadUrls$1(Artifact b, Seq mvnGavs$1, ProfileBuilder.CmdOptions options$2, LazyRef mvnUrls$lzy$1, ResolvedProfile resolved$1) {
        Option<String> directUrl = MvnGavSupport$.MODULE$.downloadUrls((Seq<Tuple2<MvnGav, String>>)mvnGavs$1, b, options$2.debug());
        return (Seq)directUrl.map((Function1 & Serializable)x$6 -> (Seq)new .colon.colon(x$6, (List)Nil$.MODULE$)).getOrElse((Function0 & Serializable)() -> ((IterableOnceOps)ProfileBuilder$.mvnUrls$1(mvnUrls$lzy$1, resolved$1, options$2).flatMap((Function1 & Serializable)baseUrl -> Profile$.MODULE$.resolveBundleUrl(b.url(), Option$.MODULE$.apply(baseUrl)).toOption())).toList());
    }

    public static final /* synthetic */ boolean $anonfun$run$17(Function1 debug$1, File file$1, String url) {
        debug$1.apply((Object)new StringBuilder(22).append("Downloading [").append(file$1.getName()).append("] from [").append(url).append("]").toString());
        return ProfileCompanion$.MODULE$.download(url, file$1).isSuccess();
    }

    private static final Artifact checkAndUpdate$1(File file, Artifact r, ObjectRef checkedFiles$1, Function1 debug$1) {
        return (Artifact)((scala.collection.immutable.Map)checkedFiles$1.elem).get((Object)file).orElse((Function0 & Serializable)() -> ProfileCompanion$.MODULE$.digestFile(file)).map((Function1 & Serializable)checksum -> {
            Artifact artifact;
            checkedFiles$1.elem = (scala.collection.immutable.Map)((scala.collection.immutable.Map)checkedFiles$1.elem).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), checksum));
            Option option = r.sha1Sum();
            Option option2 = Option$.MODULE$.apply(checksum);
            if (option == null ? option2 != null : !option.equals(option2)) {
                debug$1.apply((Object)new StringBuilder(15).append((Object)(r.sha1Sum().isDefined() ? "Updating" : "Creating")).append(" checksum for: ").append(r.fileName().getOrElse((Function0 & Serializable)() -> (String)Profile$.MODULE$.resolveFileName(r.url()).get())).toString());
                Option x$1 = Option$.MODULE$.apply(checksum);
                String x$2 = r.copy$default$1();
                Option x$3 = r.copy$default$2();
                artifact = r.copy(x$2, x$3, x$1);
            } else {
                artifact = r;
            }
            return artifact;
        }).getOrElse((Function0 & Serializable)() -> r);
    }

    private static final Artifact checkAndUpdateResource$1(Artifact a, LocalProfile localRuntimeConfig$1, ObjectRef checkedFiles$1, Function1 debug$1) {
        return ProfileBuilder$.checkAndUpdate$1(localRuntimeConfig$1.resourceArchiveLocation(a), a, checkedFiles$1, debug$1);
    }

    private static final BundleConfig checkAndUpdateBundle$1(BundleConfig b, LocalProfile localRuntimeConfig$1, ObjectRef checkedFiles$1, Function1 debug$1) {
        return b.copy(ProfileBuilder$.checkAndUpdate$1(localRuntimeConfig$1.bundleLocation(b), b.artifact(), checkedFiles$1, debug$1), b.copy$default$2(), b.copy$default$3());
    }

    private static final FeatureConfig checkAndUpdateFeatures$1(FeatureConfig f, LocalProfile localRuntimeConfig$1, ObjectRef checkedFiles$1, Function1 debug$1) {
        List x$1 = f.bundles().map((Function1 & Serializable)b -> ProfileBuilder$.checkAndUpdateBundle$1(b, localRuntimeConfig$1, checkedFiles$1, debug$1));
        String x$2 = f.copy$default$1();
        String x$3 = f.copy$default$2();
        List x$4 = f.copy$default$4();
        return f.copy(x$2, x$3, x$1, x$4);
    }

    public static final /* synthetic */ boolean $anonfun$run$31(List blacklist$1, String fileName) {
        return !blacklist$1.contains((Object)fileName);
    }

    public static final /* synthetic */ void $anonfun$run$30(LocalProfile localRuntimeConfig$1, Artifact r) {
        File resourceFile = localRuntimeConfig$1.resourceArchiveLocation(r);
        if (!resourceFile.exists()) {
            throw package$.MODULE$.error(new StringBuilder(40).append("Could not unpack missing resource file: ").append(resourceFile).toString());
        }
        List blacklist = (List)new .colon.colon((Object)"profile.conf", (List)new .colon.colon((Object)"bundles", (List)new .colon.colon((Object)"resources", (List)Nil$.MODULE$)));
        Try try_ = Unzipper$.MODULE$.unzip(resourceFile, localRuntimeConfig$1.baseDir(), (List)Nil$.MODULE$, (Option)new Some((Function1 & Serializable)fileName -> BoxesRunTime.boxToBoolean((boolean)ProfileBuilder$.$anonfun$run$31(blacklist, fileName))), (Option)None$.MODULE$);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            throw new RuntimeException(new StringBuilder(32).append("Could not update resource file: ").append(resourceFile).toString(), e);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        Try try_2 = localRuntimeConfig$1.createResourceArchiveTouchFile(r, r.sha1Sum());
        if (try_2 instanceof Failure) {
            Failure failure = (Failure)try_2;
            Throwable e = failure.exception();
            throw new RuntimeException(new StringBuilder(64).append("Could not create resource archive touch file for resource file: ").append(resourceFile).toString(), e);
        }
        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
    }

    private ProfileBuilder$() {
    }
}

