/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote.internal;

import blended.updater.config.ActivateProfile;
import blended.updater.config.AddOverlayConfig;
import blended.updater.config.AddRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.config.StageProfile;
import blended.updater.config.UpdateAction;
import blended.updater.remote.ContainerState;
import blended.updater.remote.RemoteUpdater;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0004\b\u0001/!Aa\u0004\u0001B\u0001B\u0003%q\u0004C\u0003$\u0001\u0011\u0005A\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0003<\u0001\u0011\u0005A\bC\u0003M\u0001\u0011\u0005Q\nC\u0003M\u0001\u0011\u0005a\nC\u0003R\u0001\u0011\u0005Q\nC\u0003S\u0001\u0011\u0005Q\nC\u0003T\u0001\u0011\u0005A\u000bC\u0003[\u0001\u0011\u00051\fC\u0003_\u0001\u0011\u0005q\fC\u0003f\u0001\u0011\u0005aM\u0001\bSK6|G/Z\"p[6\fg\u000eZ:\u000b\u0005=\u0001\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005E\u0011\u0012A\u0002:f[>$XM\u0003\u0002\u0014)\u00059Q\u000f\u001d3bi\u0016\u0014(\"A\u000b\u0002\u000f\tdWM\u001c3fI\u000e\u00011C\u0001\u0001\u0019!\tIB$D\u0001\u001b\u0015\u0005Y\u0012!B:dC2\f\u0017BA\u000f\u001b\u0005\u0019\te.\u001f*fM\u0006i!/Z7pi\u0016,\u0006\u000fZ1uKJ\u0004\"\u0001I\u0011\u000e\u0003AI!A\t\t\u0003\u001bI+Wn\u001c;f+B$\u0017\r^3s\u0003\u0019a\u0014N\\5u}Q\u0011Qe\n\t\u0003M\u0001i\u0011A\u0004\u0005\u0006=\t\u0001\raH\u0001\tG>lW.\u00198egV\t!\u0006E\u0002,]Aj\u0011\u0001\f\u0006\u0003[i\t!bY8mY\u0016\u001cG/[8o\u0013\tyCFA\u0002TKF\u0004B!G\u00194g%\u0011!G\u0007\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005QJT\"A\u001b\u000b\u0005Y:\u0014\u0001\u00027b]\u001eT\u0011\u0001O\u0001\u0005U\u00064\u0018-\u0003\u0002;k\t11\u000b\u001e:j]\u001e\fAC]3oI\u0016\u00148i\u001c8uC&tWM]*uCR,GCA\u001fH!\tqTI\u0004\u0002@\u0007B\u0011\u0001IG\u0007\u0002\u0003*\u0011!IF\u0001\u0007yI|w\u000e\u001e \n\u0005\u0011S\u0012A\u0002)sK\u0012,g-\u0003\u0002;\r*\u0011AI\u0007\u0005\u0006\u0011\u0012\u0001\r!S\u0001\u0006gR\fG/\u001a\t\u0003A)K!a\u0013\t\u0003\u001d\r{g\u000e^1j]\u0016\u00148\u000b^1uK\u0006Q!/Z7pi\u0016\u001c\u0006n\\<\u0015\u0003u\"\"!P(\t\u000bA3\u0001\u0019A\u001f\u0002\u0017\r|g\u000e^1j]\u0016\u0014\u0018\nZ\u0001\taJ|g-\u001b7fg\u0006AqN^3sY\u0006L8/A\bsK\u001eL7\u000f^3s!J|g-\u001b7f)\t)\u0006\f\u0005\u0002\u001a-&\u0011qK\u0007\u0002\u0005+:LG\u000fC\u0003Z\u0013\u0001\u0007Q(A\u0006qe>4\u0017\u000e\\3GS2,\u0017a\u0004:fO&\u001cH/\u001a:Pm\u0016\u0014H.Y=\u0015\u0005Uc\u0006\"B/\u000b\u0001\u0004i\u0014aC8wKJd\u0017-\u001f$jY\u0016\f1B]3n_R,7\u000b^1hKR!Q\u000bY1d\u0011\u0015\u00016\u00021\u0001>\u0011\u0015\u00117\u00021\u0001>\u0003-\u0001(o\u001c4jY\u0016t\u0015-\\3\t\u000b\u0011\\\u0001\u0019A\u001f\u0002\u001dA\u0014xNZ5mKZ+'o]5p]\u0006q!/Z7pi\u0016\f5\r^5wCR,G\u0003B+hQ&DQ\u0001\u0015\u0007A\u0002uBQA\u0019\u0007A\u0002uBQ\u0001\u001a\u0007A\u0002u\u0002")
public class RemoteCommands {
    private final RemoteUpdater remoteUpdater;

    public Seq<Tuple2<String, String>> commands() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteShow"), (Object)"Show update information about remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteStage"), (Object)"Stage a profile for a remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteActivate"), (Object)"Activate a profile for a remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Register a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Register an overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"profiles"), (Object)"Show all registered profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overlays"), (Object)"Show all registered overlays")}));
    }

    public String renderContainerState(ContainerState state) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("Container ID: ").append(state.containerId()).append("\n        |  profiles: ").append(state.profiles().mkString(", ")).append("\n        |  outstanding actions: ").append(((TraversableOnce)state.outstandingActions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            UpdateAction updateAction = x0$1;
            if (updateAction instanceof AddRuntimeConfig) {
                AddRuntimeConfig addRuntimeConfig = (AddRuntimeConfig)updateAction;
                RuntimeConfig rc = addRuntimeConfig.runtimeConfig();
                string = new StringBuilder(20).append("add runtime config ").append(rc.name()).append("-").append(rc.version()).toString();
            } else if (updateAction instanceof AddOverlayConfig) {
                AddOverlayConfig addOverlayConfig = (AddOverlayConfig)updateAction;
                OverlayConfig oc = addOverlayConfig.overlay();
                string = new StringBuilder(20).append("add overlay config ").append(oc.name()).append("-").append(oc.version()).toString();
            } else if (updateAction instanceof StageProfile) {
                StageProfile stageProfile = (StageProfile)updateAction;
                String n = stageProfile.profileName();
                String v = stageProfile.profileVersion();
                Set o = stageProfile.overlays();
                string = new StringBuilder(13).append("stage ").append(n).append("-").append(v).append(" with ").append(((TraversableOnce)o.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(" and ")).toString();
            } else if (updateAction instanceof ActivateProfile) {
                ActivateProfile activateProfile = (ActivateProfile)updateAction;
                String n = activateProfile.profileName();
                String v = activateProfile.profileVersion();
                Set o = activateProfile.overlays();
                string = new StringBuilder(16).append("activate ").append(n).append("-").append(v).append(" with ").append(((TraversableOnce)o.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(" and ")).toString();
            } else {
                throw new MatchError((Object)updateAction);
            }
            return string;
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).append("\n        |  last sync: ").append(Option$.MODULE$.option2Iterable(state.syncTimeStamp().map((Function1 & Serializable & scala.Serializable)s -> RemoteCommands.$anonfun$renderContainerState$2(BoxesRunTime.unboxToLong((Object)s)))).mkString()).toString())).stripMargin();
    }

    public String remoteShow() {
        return ((TraversableOnce)this.remoteUpdater.getContainerIds().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(37).append("Update state of container with ID ").append((String)id).append(":\n").append($this.remoteUpdater.getContainerState((String)id).map((Function1 & Serializable & scala.Serializable)state -> this.renderContainerState((ContainerState)state))).append("\n").toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String remoteShow(String containerId) {
        String string;
        Option<ContainerState> option = this.remoteUpdater.getContainerState(containerId);
        if (option instanceof Some) {
            Some some = (Some)option;
            ContainerState state = (ContainerState)some.value();
            string = new StringBuilder(37).append("Update state of container with ID ").append(containerId).append(":\n").append(state).append("\n").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(22).append("Unknown container ID: ").append(containerId).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String profiles() {
        return ((TraversableOnce)this.remoteUpdater.getRuntimeConfigs().map((Function1 & Serializable & scala.Serializable)rc -> new StringBuilder(1).append(rc.name()).append("-").append(rc.version()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String overlays() {
        return ((TraversableOnce)this.remoteUpdater.getOverlayConfigs().map((Function1 & Serializable & scala.Serializable)oc -> new StringBuilder(1).append(oc.name()).append("-").append(oc.version()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public void registerProfile(String profileFile) {
        File file = new File(profileFile);
        if (!file.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("File ").append(file.toURI()).append(" does not exist").toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Reading profile from file: ").append(file.toURI()).toString());
            Config config = ConfigFactory.parseFile((File)file).resolve();
            Try runtimeConfig = RuntimeConfigCompanion$.MODULE$.read(config);
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("Profile: ").append(runtimeConfig).toString());
            this.remoteUpdater.registerRuntimeConfig((RuntimeConfig)runtimeConfig.get());
        }
    }

    public void registerOverlay(String overlayFile) {
        File file = new File(overlayFile);
        if (!file.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("File ").append(file.toURI()).append(" does not exist").toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Reading overlay from file: ").append(file.toURI()).toString());
            Config config = ConfigFactory.parseFile((File)file).resolve();
            Try overlayConfig = OverlayConfigCompanion$.MODULE$.read(config);
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("Overlay: ").append(overlayConfig).toString());
            this.remoteUpdater.registerOverlayConfig((OverlayConfig)overlayConfig.get());
        }
    }

    public void remoteStage(String containerId, String profileName, String profileVersion) {
        Option option = this.remoteUpdater.getRuntimeConfigs().find((Function1 & Serializable & scala.Serializable)rc -> BoxesRunTime.boxToBoolean((boolean)RemoteCommands.$anonfun$remoteStage$1(profileName, profileVersion, rc)));
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Profile '").append(profileName).append("-").append(profileVersion).append("' not found").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            RuntimeConfig rc2 = (RuntimeConfig)some.value();
            this.remoteUpdater.addAction(containerId, (UpdateAction)new AddRuntimeConfig(UUID.randomUUID().toString(), rc2));
            this.remoteUpdater.addAction(containerId, (UpdateAction)new StageProfile(UUID.randomUUID().toString(), profileName, profileVersion, Predef$.MODULE$.Set().empty()));
            Predef$.MODULE$.println((Object)new StringBuilder(59).append("Scheduled profile staging for container with ID ").append(containerId).append(". Config: ").append(profileName).append("-").append(profileVersion).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void remoteActivate(String containerId, String profileName, String profileVersion) {
        this.remoteUpdater.addAction(containerId, (UpdateAction)new ActivateProfile(UUID.randomUUID().toString(), profileName, profileVersion, Predef$.MODULE$.Set().empty()));
        Predef$.MODULE$.println((Object)new StringBuilder(63).append("Scheduled profile activation for container with ID ").append(containerId).append(". Profile: ").append(profileName).append("-").append(profileVersion).toString());
    }

    public static final /* synthetic */ Date $anonfun$renderContainerState$2(long s) {
        return new Date(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$remoteStage$1(String profileName$1, String profileVersion$1, RuntimeConfig rc) {
        String string = rc.name();
        String string2 = profileName$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = rc.version();
        String string4 = profileVersion$1;
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public RemoteCommands(RemoteUpdater remoteUpdater) {
        this.remoteUpdater = remoteUpdater;
    }
}

