/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.remote.RuntimeConfigPersistor;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114AAC\u0006\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003'\u0001\u0011\u0005q\u0005\u0003\u0004+\u0001\u0001\u0006Ia\u000b\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u001b\t\r\u0015\u0003\u0001\u0015)\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015I\u0006\u0001\"\u0011[\u0005\u00012\u0015\u000e\\3TsN$X-\u001c*v]RLW.Z\"p]\u001aLw\rU3sg&\u001cHo\u001c:\u000b\u00051i\u0011A\u0002:f[>$XM\u0003\u0002\u000f\u001f\u00059Q\u000f\u001d3bi\u0016\u0014(\"\u0001\t\u0002\u000f\tdWM\u001c3fI\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003-I+h\u000e^5nK\u000e{gNZ5h!\u0016\u00148/[:u_J\f!b\u001d;pe\u0006<W\rR5s!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u00111\u0015\u000e\\3\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u001b\u0001!)QD\u0001a\u0001=\u0005\u0019An\\4\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003a=\tA!\u001e;jY&\u0011!'\f\u0002\u0007\u0019><w-\u001a:\u0002\u001dI,h\u000e^5nK\u000e{gNZ5hgB!Q\u0007\u0010\u0010@\u001d\t1$\b\u0005\u00028+5\t\u0001H\u0003\u0002:#\u00051AH]8pizJ!aO\u000b\u0002\rA\u0013X\rZ3g\u0013\tidHA\u0002NCBT!aO\u000b\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tk\u0011AB2p]\u001aLw-\u0003\u0002E\u0003\ni!+\u001e8uS6,7i\u001c8gS\u001e\f1\"\u001b8ji&\fG.\u001b>fIB\u0011AcR\u0005\u0003\u0011V\u0011qAQ8pY\u0016\fg.\u0001\u0005gS2,g*Y7f)\tYe\n\u0005\u00026\u0019&\u0011QJ\u0010\u0002\u0007'R\u0014\u0018N\\4\t\u000b=3\u0001\u0019A \u0002\u0005I\u001c\u0017AC5oSRL\u0017\r\\5{KR\t!\u000b\u0005\u0002\u0015'&\u0011A+\u0006\u0002\u0005+:LG/\u0001\u000bqKJ\u001c\u0018n\u001d;Sk:$\u0018.\\3D_:4\u0017n\u001a\u000b\u0003%^CQ\u0001\u0017\u0005A\u0002}\nQB];oi&lWmQ8oM&<\u0017A\u00054j]\u0012\u0014VO\u001c;j[\u0016\u001cuN\u001c4jON$\u0012a\u0017\t\u00049\u0006|dBA/`\u001d\t9d,C\u0001\u0017\u0013\t\u0001W#A\u0004qC\u000e\\\u0017mZ3\n\u0005\t\u001c'\u0001\u0002'jgRT!\u0001Y\u000b")
public class FileSystemRuntimeConfigPersistor
implements RuntimeConfigPersistor {
    private final File storageDir;
    private final Logger log;
    private Map<File, RuntimeConfig> runtimeConfigs;
    private boolean initialized;

    public String fileName(RuntimeConfig rc) {
        return new StringBuilder(6).append(rc.name()).append("-").append(rc.version()).append(".conf").toString();
    }

    public void initialize() {
        Map map;
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("About to initialize runtime config persistor for storageDir: ").append($this.storageDir).toString());
        if (!this.storageDir.exists()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)));
            Tuple2[] rcs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).flatMap((Function1 & Serializable & scala.Serializable)file -> {
                Try rc2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file).resolve()).flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> RuntimeConfigCompanion$.MODULE$.read(rawConfig));
                $this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Found file: ").append(file).append(" with: ").append(rc2).toString());
                return Option$.MODULE$.option2Iterable(rc2.toOption().map((Function1 & Serializable & scala.Serializable)rc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), rc)));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rcs)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemRuntimeConfigPersistor.$anonfun$initialize$8(this, x0$1))))).toMap(Predef$.MODULE$.$conforms());
        }
        this.runtimeConfigs = map;
        this.initialized = true;
    }

    @Override
    public void persistRuntimeConfig(RuntimeConfig runtimeConfig) {
        File configFile;
        if (!this.initialized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.fileName(runtimeConfig))).exists()) {
            Option option = this.runtimeConfigs.get((Object)configFile);
            Some some = new Some((Object)runtimeConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.log.debug((Function0 & Serializable & scala.Serializable)() -> "RuntimeConfig already persistent");
            } else {
                String msg = "Cannot persist runtime config. Storage location already taken for a different configuration.";
                this.log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(msg).append(" Found file ").append(configFile).append(" with config: ").append($this.runtimeConfigs.get((Object)configFile)).toString());
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(RuntimeConfigCompanion$.MODULE$.toConfig(runtimeConfig), configFile, (Option)None$.MODULE$);
        this.runtimeConfigs = this.runtimeConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configFile), (Object)runtimeConfig));
    }

    @Override
    public List<RuntimeConfig> findRuntimeConfigs() {
        block0: {
            if (this.initialized) break block0;
            this.initialize();
        }
        return this.runtimeConfigs.values().toList();
    }

    public static final /* synthetic */ boolean $anonfun$initialize$8(FileSystemRuntimeConfigPersistor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        RuntimeConfig rc = (RuntimeConfig)tuple2._2();
        String string = file.getName();
        String string2 = $this.fileName(rc);
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public FileSystemRuntimeConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileSystemRuntimeConfigPersistor.class));
        this.runtimeConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initialized = false;
    }
}

