/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.remote.OverlayConfigPersistor;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114AAC\u0006\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004C\u0003'\u0001\u0011\u0005q\u0005\u0003\u0004+\u0001\u0001\u0006Ia\u000b\u0005\u0007g\u0001\u0001\u000b\u0015\u0002\u001b\t\r\u0015\u0003\u0001\u0015)\u0003G\u0011\u0015I\u0005\u0001\"\u0001K\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0011W\u0011\u0015I\u0006\u0001\"\u0011[\u0005\u00012\u0015\u000e\\3TsN$X-\\(wKJd\u0017-_\"p]\u001aLw\rU3sg&\u001cHo\u001c:\u000b\u00051i\u0011A\u0002:f[>$XM\u0003\u0002\u000f\u001f\u00059Q\u000f\u001d3bi\u0016\u0014(\"\u0001\t\u0002\u000f\tdWM\u001c3fI\u000e\u00011c\u0001\u0001\u00143A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\u0004\"AG\u000e\u000e\u0003-I!\u0001H\u0006\u0003-=3XM\u001d7bs\u000e{gNZ5h!\u0016\u00148/[:u_J\f!b\u001d;pe\u0006<W\rR5s!\tyB%D\u0001!\u0015\t\t#%\u0001\u0002j_*\t1%\u0001\u0003kCZ\f\u0017BA\u0013!\u0005\u00111\u0015\u000e\\3\u0002\rqJg.\u001b;?)\tA\u0013\u0006\u0005\u0002\u001b\u0001!)QD\u0001a\u0001=\u0005\u0019An\\4\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003a=\tA!\u001e;jY&\u0011!'\f\u0002\u0007\u0019><w-\u001a:\u0002\u001d=4XM\u001d7bs\u000e{gNZ5hgB!Q\u0007\u0010\u0010@\u001d\t1$\b\u0005\u00028+5\t\u0001H\u0003\u0002:#\u00051AH]8pizJ!aO\u000b\u0002\rA\u0013X\rZ3g\u0013\tidHA\u0002NCBT!aO\u000b\u0011\u0005\u0001\u001bU\"A!\u000b\u0005\tk\u0011AB2p]\u001aLw-\u0003\u0002E\u0003\niqJ^3sY\u0006L8i\u001c8gS\u001e\f!\"\u001b8ji\u0006d\u0017N_3e!\t!r)\u0003\u0002I+\t9!i\\8mK\u0006t\u0017!F8wKJd\u0017-_\"p]\u001aLwMR5mK:\u000bW.\u001a\u000b\u0003\u0017:\u0003\"!\u000e'\n\u00055s$AB*ue&tw\rC\u0003P\r\u0001\u0007q(\u0001\u0002pG\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u0003I\u0003\"\u0001F*\n\u0005Q+\"\u0001B+oSR\fA\u0003]3sg&\u001cHo\u0014<fe2\f\u0017pQ8oM&<GC\u0001*X\u0011\u0015A\u0006\u00021\u0001@\u00035yg/\u001a:mCf\u001cuN\u001c4jO\u0006\u0011b-\u001b8e\u001fZ,'\u000f\\1z\u0007>tg-[4t)\u0005Y\u0006c\u0001/b\u007f9\u0011Ql\u0018\b\u0003oyK\u0011AF\u0005\u0003AV\tq\u0001]1dW\u0006<W-\u0003\u0002cG\n!A*[:u\u0015\t\u0001W\u0003")
public class FileSystemOverlayConfigPersistor
implements OverlayConfigPersistor {
    private final File storageDir;
    private final Logger log;
    private Map<File, OverlayConfig> overlayConfigs;
    private boolean initalized;

    public String overlayConfigFileName(OverlayConfig oc) {
        return new StringBuilder(6).append(oc.name()).append("-").append(oc.version()).append(".conf").toString();
    }

    public void initialize() {
        Map map;
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("About to initialize overlay config persistor for storageDir: ").append($this.storageDir).toString());
        if (!this.storageDir.exists()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)));
            Tuple2[] ocs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).flatMap((Function1 & Serializable & scala.Serializable)file -> {
                Try oc2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file).resolve()).flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> OverlayConfigCompanion$.MODULE$.read(rawConfig));
                $this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Found file: ").append(file).append(" with: {oc}").toString());
                return Option$.MODULE$.option2Iterable(oc2.toOption().map((Function1 & Serializable & scala.Serializable)oc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), oc)));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ocs)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemOverlayConfigPersistor.$anonfun$initialize$8(this, x0$1))))).toMap(Predef$.MODULE$.$conforms());
        }
        this.overlayConfigs = map;
        this.initalized = true;
    }

    @Override
    public void persistOverlayConfig(OverlayConfig overlayConfig) {
        File configFile;
        if (!this.initalized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.overlayConfigFileName(overlayConfig))).exists()) {
            Option option = this.overlayConfigs.get((Object)configFile);
            Some some = new Some((Object)overlayConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.log.debug((Function0 & Serializable & scala.Serializable)() -> "OverlayConfig already persistent");
            } else {
                String msg = "Cannot persist overlay config. Storage location already taken for a different configuration.";
                this.log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append(msg).append(" Found file ").append(configFile).append(" with config: ").append($this.overlayConfigs.get((Object)configFile)).toString());
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(OverlayConfigCompanion$.MODULE$.toConfig(overlayConfig), configFile, (Option)None$.MODULE$);
        this.overlayConfigs = this.overlayConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configFile), (Object)overlayConfig));
    }

    @Override
    public List<OverlayConfig> findOverlayConfigs() {
        block0: {
            if (this.initalized) break block0;
            this.initialize();
        }
        return this.overlayConfigs.values().toList();
    }

    public static final /* synthetic */ boolean $anonfun$initialize$8(FileSystemOverlayConfigPersistor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        OverlayConfig oc = (OverlayConfig)tuple2._2();
        String string = file.getName();
        String string2 = $this.overlayConfigFileName(oc);
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public FileSystemOverlayConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileSystemOverlayConfigPersistor.class));
        this.overlayConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initalized = false;
    }
}

