/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote.internal;

import blended.updater.config.ActivateProfile;
import blended.updater.config.AddOverlayConfig;
import blended.updater.config.AddRuntimeConfig;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.config.StageProfile;
import blended.updater.config.UpdateAction;
import blended.updater.remote.ContainerState;
import blended.updater.remote.RemoteUpdater;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import java.util.Date;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001)4A!\u0001\u0002\u0001\u0017\tq!+Z7pi\u0016\u001cu.\\7b]\u0012\u001c(BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\u0019\u0011X-\\8uK*\u0011q\u0001C\u0001\bkB$\u0017\r^3s\u0015\u0005I\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\t'\u0001\u0011\t\u0011)A\u0005)\u0005i!/Z7pi\u0016,\u0006\u000fZ1uKJ\u0004\"!\u0006\f\u000e\u0003\u0011I!a\u0006\u0003\u0003\u001bI+Wn\u001c;f+B$\u0017\r^3s\u0011\u0015I\u0002\u0001\"\u0001\u001b\u0003\u0019a\u0014N\\5u}Q\u00111$\b\t\u00039\u0001i\u0011A\u0001\u0005\u0006'a\u0001\r\u0001\u0006\u0005\u0006?\u0001!\t\u0001I\u0001\tG>lW.\u00198egV\t\u0011\u0005E\u0002#K\u001dj\u0011a\t\u0006\u0003I9\t!bY8mY\u0016\u001cG/[8o\u0013\t13EA\u0002TKF\u0004B!\u0004\u0015+U%\u0011\u0011F\u0004\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005-\u0002T\"\u0001\u0017\u000b\u00055r\u0013\u0001\u00027b]\u001eT\u0011aL\u0001\u0005U\u00064\u0018-\u0003\u00022Y\t11\u000b\u001e:j]\u001eDQa\r\u0001\u0005\u0002Q\nAC]3oI\u0016\u00148i\u001c8uC&tWM]*uCR,GCA\u001b@!\t1TH\u0004\u00028wA\u0011\u0001HD\u0007\u0002s)\u0011!HC\u0001\u0007yI|w\u000e\u001e \n\u0005qr\u0011A\u0002)sK\u0012,g-\u0003\u00022})\u0011AH\u0004\u0005\u0006\u0001J\u0002\r!Q\u0001\u0006gR\fG/\u001a\t\u0003+\tK!a\u0011\u0003\u0003\u001d\r{g\u000e^1j]\u0016\u00148\u000b^1uK\")Q\t\u0001C\u0001\r\u0006Q!/Z7pi\u0016\u001c\u0006n\\<\u0015\u0003UBQ!\u0012\u0001\u0005\u0002!#\"!N%\t\u000b);\u0005\u0019A\u001b\u0002\u0017\r|g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\u0006\u0019\u0002!\tAR\u0001\taJ|g-\u001b7fg\")a\n\u0001C\u0001\r\u0006AqN^3sY\u0006L8\u000fC\u0003Q\u0001\u0011\u0005\u0011+A\bsK\u001eL7\u000f^3s!J|g-\u001b7f)\t\u0011V\u000b\u0005\u0002\u000e'&\u0011AK\u0004\u0002\u0005+:LG\u000fC\u0003W\u001f\u0002\u0007Q'A\u0006qe>4\u0017\u000e\\3GS2,\u0007\"\u0002-\u0001\t\u0003I\u0016a\u0004:fO&\u001cH/\u001a:Pm\u0016\u0014H.Y=\u0015\u0005IS\u0006\"B.X\u0001\u0004)\u0014aC8wKJd\u0017-\u001f$jY\u0016DQ!\u0018\u0001\u0005\u0002y\u000b1B]3n_R,7\u000b^1hKR!!k\u00181c\u0011\u0015QE\f1\u00016\u0011\u0015\tG\f1\u00016\u0003-\u0001(o\u001c4jY\u0016t\u0015-\\3\t\u000b\rd\u0006\u0019A\u001b\u0002\u001dA\u0014xNZ5mKZ+'o]5p]\")Q\r\u0001C\u0001M\u0006q!/Z7pi\u0016\f5\r^5wCR,G\u0003\u0002*hQ&DQA\u00133A\u0002UBQ!\u00193A\u0002UBQa\u00193A\u0002U\u0002")
public class RemoteCommands {
    private final RemoteUpdater remoteUpdater;

    public Seq<Tuple2<String, String>> commands() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteShow"), (Object)"Show update information about remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteStage"), (Object)"Stage a profile for a remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remoteActivate"), (Object)"Activate a profile for a remote container"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerProfile"), (Object)"Register a profile"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"registerOverlay"), (Object)"Register an overlay"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"profiles"), (Object)"Show all registered profiles"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"overlays"), (Object)"Show all registered overlays")}));
    }

    public String renderContainerState(ContainerState state) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(92).append("Container ID: ").append(state.containerId()).append("\n        |  profiles: ").append(state.profiles().mkString(", ")).append("\n        |  outstanding actions: ").append(((TraversableOnce)state.outstandingActions().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            String string;
            UpdateAction updateAction = x0$1;
            if (updateAction instanceof AddRuntimeConfig) {
                AddRuntimeConfig addRuntimeConfig = (AddRuntimeConfig)updateAction;
                RuntimeConfig rc = addRuntimeConfig.runtimeConfig();
                string = new StringBuilder(20).append("add runtime config ").append(rc.name()).append("-").append(rc.version()).toString();
            } else if (updateAction instanceof AddOverlayConfig) {
                AddOverlayConfig addOverlayConfig = (AddOverlayConfig)updateAction;
                OverlayConfig oc = addOverlayConfig.overlay();
                string = new StringBuilder(20).append("add overlay config ").append(oc.name()).append("-").append(oc.version()).toString();
            } else if (updateAction instanceof StageProfile) {
                StageProfile stageProfile = (StageProfile)updateAction;
                String n = stageProfile.profileName();
                String v = stageProfile.profileVersion();
                List o = stageProfile.overlays();
                string = new StringBuilder(13).append("stage ").append(n).append("-").append(v).append(" with ").append(((TraversableOnce)o.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(" and ")).toString();
            } else if (updateAction instanceof ActivateProfile) {
                ActivateProfile activateProfile = (ActivateProfile)updateAction;
                String n = activateProfile.profileName();
                String v = activateProfile.profileVersion();
                List o = activateProfile.overlays();
                string = new StringBuilder(16).append("activate ").append(n).append("-").append(v).append(" with ").append(((TraversableOnce)o.toList().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(" and ")).toString();
            } else {
                throw new MatchError((Object)updateAction);
            }
            return string;
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).append("\n        |  last sync: ").append(Option$.MODULE$.option2Iterable(state.syncTimeStamp().map((Function1 & Serializable & scala.Serializable)s -> RemoteCommands.$anonfun$renderContainerState$2(BoxesRunTime.unboxToLong((Object)s)))).mkString()).toString())).stripMargin();
    }

    public String remoteShow() {
        return ((TraversableOnce)this.remoteUpdater.getContainerIds().map((Function1 & Serializable & scala.Serializable)id -> new StringBuilder(37).append("Update state of container with ID ").append((String)id).append(":\n").append($this.remoteUpdater.getContainerState((String)id).map((Function1 & Serializable & scala.Serializable)state -> this.renderContainerState((ContainerState)state))).append("\n").toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String remoteShow(String containerId) {
        String string;
        Option<ContainerState> option = this.remoteUpdater.getContainerState(containerId);
        if (option instanceof Some) {
            Some some = (Some)option;
            ContainerState state = (ContainerState)some.value();
            string = new StringBuilder(37).append("Update state of container with ID ").append(containerId).append(":\n").append(state).append("\n").toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(22).append("Unknown container ID: ").append(containerId).toString();
        } else {
            throw new MatchError(option);
        }
        return string;
    }

    public String profiles() {
        return ((TraversableOnce)this.remoteUpdater.getRuntimeConfigs().map((Function1 & Serializable & scala.Serializable)rc -> new StringBuilder(1).append(rc.name()).append("-").append(rc.version()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public String overlays() {
        return ((TraversableOnce)this.remoteUpdater.getOverlayConfigs().map((Function1 & Serializable & scala.Serializable)oc -> new StringBuilder(1).append(oc.name()).append("-").append(oc.version()).toString(), List$.MODULE$.canBuildFrom())).mkString("\n");
    }

    public void registerProfile(String profileFile) {
        File file = new File(profileFile);
        if (!file.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("File ").append(file.toURI()).append(" does not exist").toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Reading profile from file: ").append(file.toURI()).toString());
            Config config = ConfigFactory.parseFile((File)file).resolve();
            Try runtimeConfig = RuntimeConfigCompanion$.MODULE$.read(config);
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("Profile: ").append(runtimeConfig).toString());
            this.remoteUpdater.registerRuntimeConfig((RuntimeConfig)runtimeConfig.get());
        }
    }

    public void registerOverlay(String overlayFile) {
        File file = new File(overlayFile);
        if (!file.exists()) {
            Predef$.MODULE$.println((Object)new StringBuilder(20).append("File ").append(file.toURI()).append(" does not exist").toString());
        } else {
            Predef$.MODULE$.println((Object)new StringBuilder(27).append("Reading overlay from file: ").append(file.toURI()).toString());
            Config config = ConfigFactory.parseFile((File)file).resolve();
            Try overlayConfig = OverlayConfigCompanion$.MODULE$.read(config);
            Predef$.MODULE$.println((Object)new StringBuilder(9).append("Overlay: ").append(overlayConfig).toString());
            this.remoteUpdater.registerOverlayConfig((OverlayConfig)overlayConfig.get());
        }
    }

    public void remoteStage(String containerId, String profileName, String profileVersion) {
        Option option = this.remoteUpdater.getRuntimeConfigs().find((Function1 & Serializable & scala.Serializable)rc -> BoxesRunTime.boxToBoolean((boolean)RemoteCommands.$anonfun$remoteStage$1(profileName, profileVersion, rc)));
        if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)new StringBuilder(21).append("Profile '").append(profileName).append("-").append(profileVersion).append("' not found").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            RuntimeConfig rc2 = (RuntimeConfig)some.value();
            this.remoteUpdater.addAction(containerId, (UpdateAction)new AddRuntimeConfig(rc2));
            this.remoteUpdater.addAction(containerId, (UpdateAction)new StageProfile(profileName, profileVersion, List$.MODULE$.empty()));
            Predef$.MODULE$.println((Object)new StringBuilder(59).append("Scheduled profile staging for container with ID ").append(containerId).append(". Config: ").append(profileName).append("-").append(profileVersion).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public void remoteActivate(String containerId, String profileName, String profileVersion) {
        this.remoteUpdater.addAction(containerId, (UpdateAction)new ActivateProfile(profileName, profileVersion, List$.MODULE$.empty()));
        Predef$.MODULE$.println((Object)new StringBuilder(63).append("Scheduled profile activation for container with ID ").append(containerId).append(". Profile: ").append(profileName).append("-").append(profileVersion).toString());
    }

    public static final /* synthetic */ Date $anonfun$renderContainerState$2(long s) {
        return new Date(s);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$remoteStage$1(String profileName$1, String profileVersion$1, RuntimeConfig rc) {
        String string = rc.name();
        String string2 = profileName$1;
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        String string3 = rc.version();
        String string4 = profileVersion$1;
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public RemoteCommands(RemoteUpdater remoteUpdater) {
        this.remoteUpdater = remoteUpdater;
    }
}

