/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.persistence.PersistenceService;
import blended.updater.remote.ContainerState;
import blended.updater.remote.ContainerStatePersistor;
import blended.updater.remote.Mapper$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u0013\t\t\u0003+\u001a:tSN$XM\u001c;D_:$\u0018-\u001b8feN#\u0018\r^3QKJ\u001c\u0018n\u001d;pe*\u00111\u0001B\u0001\u0007e\u0016lw\u000e^3\u000b\u0005\u00151\u0011aB;qI\u0006$XM\u001d\u0006\u0002\u000f\u00059!\r\\3oI\u0016$7\u0001A\n\u0004\u0001)\u0001\u0002CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\u0012%5\t!!\u0003\u0002\u0014\u0005\t92i\u001c8uC&tWM]*uCR,\u0007+\u001a:tSN$xN\u001d\u0005\t+\u0001\u0011\t\u0011)A\u0005-\u0005\u0011\u0002/\u001a:tSN$XM\\2f'\u0016\u0014h/[2f!\t9\"$D\u0001\u0019\u0015\tIb!A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,\u0017BA\u000e\u0019\u0005I\u0001VM]:jgR,gnY3TKJ4\u0018nY3\t\u000bu\u0001A\u0011\u0001\u0010\u0002\rqJg.\u001b;?)\ty\u0002\u0005\u0005\u0002\u0012\u0001!)Q\u0003\ba\u0001-!1!\u0005\u0001Q\u0001\n\r\n1\u0001\\8h!\t!\u0013&D\u0001&\u0015\t1s%A\u0003tY\u001a$$NC\u0001)\u0003\ry'oZ\u0005\u0003U\u0015\u0012a\u0001T8hO\u0016\u0014\bb\u0002\u0017\u0001\u0005\u0004%\t!L\u0001\u000ba\u000ec\u0017m]:OC6,W#\u0001\u0018\u0011\u0005=\"T\"\u0001\u0019\u000b\u0005E\u0012\u0014\u0001\u00027b]\u001eT\u0011aM\u0001\u0005U\u00064\u0018-\u0003\u00026a\t11\u000b\u001e:j]\u001eDaa\u000e\u0001!\u0002\u0013q\u0013a\u00039DY\u0006\u001c8OT1nK\u0002BQ!\u000f\u0001\u0005Bi\naCZ5oI\u0006cGnQ8oi\u0006Lg.\u001a:Ti\u0006$Xm\u001d\u000b\u0002wA\u0019A\bR$\u000f\u0005u\u0012eB\u0001 B\u001b\u0005y$B\u0001!\t\u0003\u0019a$o\\8u}%\tQ\"\u0003\u0002D\u0019\u00059\u0001/Y2lC\u001e,\u0017BA#G\u0005\u0011a\u0015n\u001d;\u000b\u0005\rc\u0001CA\tI\u0013\tI%A\u0001\bD_:$\u0018-\u001b8feN#\u0018\r^3\t\u000b-\u0003A\u0011\t'\u0002%\u0019Lg\u000eZ\"p]R\f\u0017N\\3s'R\fG/\u001a\u000b\u0003\u001bB\u00032a\u0003(H\u0013\tyEB\u0001\u0004PaRLwN\u001c\u0005\u0006#*\u0003\rAU\u0001\fG>tG/Y5oKJLE\r\u0005\u0002T/:\u0011A+\u0016\t\u0003}1I!A\u0016\u0007\u0002\rA\u0013X\rZ3g\u0013\t)\u0004L\u0003\u0002W\u0019!)!\f\u0001C!7\u0006!R\u000f\u001d3bi\u0016\u001cuN\u001c;bS:,'o\u0015;bi\u0016$\"\u0001X0\u0011\u0005-i\u0016B\u00010\r\u0005\u0011)f.\u001b;\t\u000b\u0001L\u0006\u0019A$\u0002\u001d\r|g\u000e^1j]\u0016\u00148\u000b^1uK\u0002")
public class PersistentContainerStatePersistor
implements ContainerStatePersistor {
    private final PersistenceService persistenceService;
    private final Logger log;
    private final String pClassName;

    public String pClassName() {
        return this.pClassName;
    }

    @Override
    public List<ContainerState> findAllContainerStates() {
        Seq state = this.persistenceService.findAll(this.pClassName());
        return ((TraversableOnce)state.flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(Mapper$.MODULE$.unmapContainerState(s).toOption()), Seq$.MODULE$.canBuildFrom())).toList();
    }

    @Override
    public Option<ContainerState> findContainerState(String containerId) {
        Seq state = this.persistenceService.findByExample(this.pClassName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"containerId"), (Object)containerId)}))).asJava());
        return ((TraversableLike)state.flatMap((Function1 & Serializable & scala.Serializable)s -> Option$.MODULE$.option2Iterable(Mapper$.MODULE$.unmapContainerState(s).toOption()), Seq$.MODULE$.canBuildFrom())).headOption();
    }

    @Override
    public void updateContainerState(ContainerState containerState) {
        this.log.debug("About to persist container state: {}", new Object[]{containerState});
        long deleteCount = this.persistenceService.deleteByExample(this.pClassName(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"containerId"), (Object)containerState.containerId())}))).asJava());
        this.log.debug("deleted {} old entries", (Object)BoxesRunTime.boxToLong((long)deleteCount));
        java.util.Map entry = this.persistenceService.persist(this.pClassName(), Mapper$.MODULE$.mapContainerState(containerState));
        this.log.debug("persisted 1 new entry: {}", new Object[]{entry});
    }

    public PersistentContainerStatePersistor(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
        this.log = LoggerFactory.getLogger(PersistentContainerStatePersistor.class);
        this.pClassName = "ContainerState";
    }
}

