/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.remote.RuntimeConfigPersistor;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u0013\t\u0001c)\u001b7f'f\u001cH/Z7Sk:$\u0018.\\3D_:4\u0017n\u001a)feNL7\u000f^8s\u0015\t\u0019A!\u0001\u0004sK6|G/\u001a\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005Y\u0011VO\u001c;j[\u0016\u001cuN\u001c4jOB+'o]5ti>\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0015M$xN]1hK\u0012K'\u000f\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011\u0011\u0003\u0001\u0005\u0006+y\u0001\rA\u0006\u0005\u0007I\u0001\u0001\u000b\u0011B\u0013\u0002\u00071|w\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&A\u0002pe\u001eL!\u0001L\u0014\u0003\r1{wmZ3s\u0011\u0019q\u0003\u0001)Q\u0005_\u0005q!/\u001e8uS6,7i\u001c8gS\u001e\u001c\b\u0003\u0002\u00198-ir!!M\u001b\u0011\u0005IbQ\"A\u001a\u000b\u0005QB\u0011A\u0002\u001fs_>$h(\u0003\u00027\u0019\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\u00075\u000b\u0007O\u0003\u00027\u0019A\u00111HP\u0007\u0002y)\u0011Q\bB\u0001\u0007G>tg-[4\n\u0005}b$!\u0004*v]RLW.Z\"p]\u001aLw\r\u0003\u0004B\u0001\u0001\u0006KAQ\u0001\fS:LG/[1mSj,G\r\u0005\u0002\f\u0007&\u0011A\t\u0004\u0002\b\u0005>|G.Z1o\u0011\u00151\u0005\u0001\"\u0001H\u0003!1\u0017\u000e\\3OC6,GC\u0001%L!\t\u0001\u0014*\u0003\u0002Ks\t11\u000b\u001e:j]\u001eDQ\u0001T#A\u0002i\n!A]2\t\u000b9\u0003A\u0011A(\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001Q!\tY\u0011+\u0003\u0002S\u0019\t!QK\\5u\u0011\u0015!\u0006\u0001\"\u0011V\u0003Q\u0001XM]:jgR\u0014VO\u001c;j[\u0016\u001cuN\u001c4jOR\u0011\u0001K\u0016\u0005\u0006/N\u0003\rAO\u0001\u000eeVtG/[7f\u0007>tg-[4\t\u000be\u0003A\u0011\t.\u0002%\u0019Lg\u000e\u001a*v]RLW.Z\"p]\u001aLwm\u001d\u000b\u00027B\u0019A,\u0019\u001e\u000f\u0005u{fB\u0001\u001a_\u0013\u0005i\u0011B\u00011\r\u0003\u001d\u0001\u0018mY6bO\u0016L!AY2\u0003\t1K7\u000f\u001e\u0006\u0003A2\u0001")
public class FileSystemRuntimeConfigPersistor
implements RuntimeConfigPersistor {
    private final File storageDir;
    private final Logger log;
    private Map<File, RuntimeConfig> runtimeConfigs;
    private boolean initialized;

    public String fileName(RuntimeConfig rc) {
        return new StringBuilder(6).append(rc.name()).append("-").append(rc.version()).append(".conf").toString();
    }

    public void initialize() {
        Map map;
        this.log.debug("About to initialize runtime config persistor for storageDir: {}", new Object[]{this.storageDir});
        if (!this.storageDir.exists()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)));
            Tuple2[] rcs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).flatMap((Function1 & Serializable & scala.Serializable)file -> {
                Try rc2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file).resolve()).flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> RuntimeConfigCompanion$.MODULE$.read(rawConfig));
                $this.log.debug("Found file: {} with: {}", new Object[]{new Object[]{file, rc2}});
                return Option$.MODULE$.option2Iterable(rc2.toOption().map((Function1 & Serializable & scala.Serializable)rc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), rc)));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rcs)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemRuntimeConfigPersistor.$anonfun$initialize$6(this, x0$1))))).toMap(Predef$.MODULE$.$conforms());
        }
        this.runtimeConfigs = map;
        this.initialized = true;
    }

    @Override
    public void persistRuntimeConfig(RuntimeConfig runtimeConfig) {
        File configFile;
        if (!this.initialized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.fileName(runtimeConfig))).exists()) {
            Option option = this.runtimeConfigs.get((Object)configFile);
            Some some = new Some((Object)runtimeConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.log.debug("RuntimeConfig already persistent");
            } else {
                String msg = "Cannot persist runtime config. Storage location already taken for a different configuration.";
                this.log.error("{} Found file {} with config: {}", new Object[]{msg, configFile, this.runtimeConfigs.get((Object)configFile)});
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(RuntimeConfigCompanion$.MODULE$.toConfig(runtimeConfig), configFile, (Option)None$.MODULE$);
        this.runtimeConfigs = this.runtimeConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configFile), (Object)runtimeConfig));
    }

    @Override
    public List<RuntimeConfig> findRuntimeConfigs() {
        block0: {
            if (this.initialized) break block0;
            this.initialize();
        }
        return this.runtimeConfigs.values().toList();
    }

    public static final /* synthetic */ boolean $anonfun$initialize$6(FileSystemRuntimeConfigPersistor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        RuntimeConfig rc = (RuntimeConfig)tuple2._2();
        String string = file.getName();
        String string2 = $this.fileName(rc);
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public FileSystemRuntimeConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.log = LoggerFactory.getLogger(FileSystemRuntimeConfigPersistor.class);
        this.runtimeConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initialized = false;
    }
}

