/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfigCompanion$;
import blended.updater.remote.OverlayConfigPersistor;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u0013\t\u0001c)\u001b7f'f\u001cH/Z7Pm\u0016\u0014H.Y=D_:4\u0017n\u001a)feNL7\u000f^8s\u0015\t\u0019A!\u0001\u0004sK6|G/\u001a\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005Yye/\u001a:mCf\u001cuN\u001c4jOB+'o]5ti>\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0015M$xN]1hK\u0012K'\u000f\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011\u0011\u0003\u0001\u0005\u0006+y\u0001\rA\u0006\u0005\u0007I\u0001\u0001\u000b\u0011B\u0013\u0002\u00071|w\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&A\u0002pe\u001eL!\u0001L\u0014\u0003\r1{wmZ3s\u0011\u0019q\u0003\u0001)Q\u0005_\u0005qqN^3sY\u0006L8i\u001c8gS\u001e\u001c\b\u0003\u0002\u00198-ir!!M\u001b\u0011\u0005IbQ\"A\u001a\u000b\u0005QB\u0011A\u0002\u001fs_>$h(\u0003\u00027\u0019\u00051\u0001K]3eK\u001aL!\u0001O\u001d\u0003\u00075\u000b\u0007O\u0003\u00027\u0019A\u00111HP\u0007\u0002y)\u0011Q\bB\u0001\u0007G>tg-[4\n\u0005}b$!D(wKJd\u0017-_\"p]\u001aLw\r\u0003\u0004B\u0001\u0001\u0006KAQ\u0001\u000bS:LG/\u00197ju\u0016$\u0007CA\u0006D\u0013\t!EBA\u0004C_>dW-\u00198\t\u000b\u0019\u0003A\u0011A$\u0002+=4XM\u001d7bs\u000e{gNZ5h\r&dWMT1nKR\u0011\u0001j\u0013\t\u0003a%K!AS\u001d\u0003\rM#(/\u001b8h\u0011\u0015aU\t1\u0001;\u0003\ty7\rC\u0003O\u0001\u0011\u0005q*\u0001\u0006j]&$\u0018.\u00197ju\u0016$\u0012\u0001\u0015\t\u0003\u0017EK!A\u0015\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006)\u0002!\t%V\u0001\u0015a\u0016\u00148/[:u\u001fZ,'\u000f\\1z\u0007>tg-[4\u0015\u0005A3\u0006\"B,T\u0001\u0004Q\u0014!D8wKJd\u0017-_\"p]\u001aLw\rC\u0003Z\u0001\u0011\u0005#,\u0001\ngS:$wJ^3sY\u0006L8i\u001c8gS\u001e\u001cH#A.\u0011\u0007q\u000b'H\u0004\u0002^?:\u0011!GX\u0005\u0002\u001b%\u0011\u0001\rD\u0001\ba\u0006\u001c7.Y4f\u0013\t\u00117M\u0001\u0003MSN$(B\u00011\r\u0001")
public class FileSystemOverlayConfigPersistor
implements OverlayConfigPersistor {
    private final File storageDir;
    private final Logger log;
    private Map<File, OverlayConfig> overlayConfigs;
    private boolean initalized;

    public String overlayConfigFileName(OverlayConfig oc) {
        return new StringBuilder(6).append(oc.name()).append("-").append(oc.version()).append(".conf").toString();
    }

    public void initialize() {
        Map map;
        this.log.debug("About to initialize overlay config persistor for storageDir: {}", new Object[]{this.storageDir});
        if (!this.storageDir.exists()) {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        } else {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0 & Serializable & scala.Serializable)() -> (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class)));
            Tuple2[] ocs = (Tuple2[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).flatMap((Function1 & Serializable & scala.Serializable)file -> {
                Try oc2 = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> ConfigFactory.parseFile((File)file).resolve()).flatMap((Function1 & Serializable & scala.Serializable)rawConfig -> OverlayConfigCompanion$.MODULE$.read(rawConfig));
                $this.log.debug("Found file: {} with: {}", new Object[]{new Object[]{file, oc2}});
                return Option$.MODULE$.option2Iterable(oc2.toOption().map((Function1 & Serializable & scala.Serializable)oc -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(file), oc)));
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ocs)).filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FileSystemOverlayConfigPersistor.$anonfun$initialize$6(this, x0$1))))).toMap(Predef$.MODULE$.$conforms());
        }
        this.overlayConfigs = map;
        this.initalized = true;
    }

    @Override
    public void persistOverlayConfig(OverlayConfig overlayConfig) {
        File configFile;
        if (!this.initalized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.overlayConfigFileName(overlayConfig))).exists()) {
            Option option = this.overlayConfigs.get((Object)configFile);
            Some some = new Some((Object)overlayConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.log.debug("OverlayConfig already persistent");
            } else {
                String msg = "Cannot persist overlay config. Storage location already taken for a different configuration.";
                this.log.error("{} Found file {} with config: {}", new Object[]{msg, configFile, this.overlayConfigs.get((Object)configFile)});
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(OverlayConfigCompanion$.MODULE$.toConfig(overlayConfig), configFile, (Option)None$.MODULE$);
        this.overlayConfigs = this.overlayConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configFile), (Object)overlayConfig));
    }

    @Override
    public List<OverlayConfig> findOverlayConfigs() {
        block0: {
            if (this.initalized) break block0;
            this.initialize();
        }
        return this.overlayConfigs.values().toList();
    }

    public static final /* synthetic */ boolean $anonfun$initialize$6(FileSystemOverlayConfigPersistor $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        File file = (File)tuple2._1();
        OverlayConfig oc = (OverlayConfig)tuple2._2();
        String string = file.getName();
        String string2 = $this.overlayConfigFileName(oc);
        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
        return bl;
    }

    public FileSystemOverlayConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.log = LoggerFactory.getLogger(FileSystemOverlayConfigPersistor.class);
        this.overlayConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initalized = false;
    }
}

