/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.remote.RuntimeConfigPersistor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\r4A!\u0001\u0002\u0001\u0013\t\u0001c)\u001b7f'f\u001cH/Z7Sk:$\u0018.\\3D_:4\u0017n\u001a)feNL7\u000f^8s\u0015\t\u0019A!\u0001\u0004sK6|G/\u001a\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005Y\u0011VO\u001c;j[\u0016\u001cuN\u001c4jOB+'o]5ti>\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0015M$xN]1hK\u0012K'\u000f\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011\u0011\u0003\u0001\u0005\u0006+y\u0001\rA\u0006\u0005\u0007I\u0001\u0001\u000b\u0011B\u0013\u0002\u00071|w\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&A\u0002pe\u001eL!\u0001L\u0014\u0003\r1{wmZ3s\u0011\u0019q\u0003\u0001)Q\u0005_\u0005q!/\u001e8uS6,7i\u001c8gS\u001e\u001c\b\u0003\u0002\u00194-Yr!aC\u0019\n\u0005Ib\u0011A\u0002)sK\u0012,g-\u0003\u00025k\t\u0019Q*\u00199\u000b\u0005Ib\u0001CA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003\u0019\u0019wN\u001c4jO&\u00111\b\u000f\u0002\u000e%VtG/[7f\u0007>tg-[4\t\ru\u0002\u0001\u0015)\u0003?\u0003-Ig.\u001b;jC2L'0\u001a3\u0011\u0005-y\u0014B\u0001!\r\u0005\u001d\u0011un\u001c7fC:DQA\u0011\u0001\u0005\u0002\r\u000b\u0001BZ5mK:\u000bW.\u001a\u000b\u0003\t\u001e\u0003\"\u0001M#\n\u0005\u0019+$AB*ue&tw\rC\u0003I\u0003\u0002\u0007a'\u0001\u0002sG\")!\n\u0001C\u0001\u0017\u0006Q\u0011N\\5uS\u0006d\u0017N_3\u0015\u00031\u0003\"aC'\n\u00059c!\u0001B+oSRDQ\u0001\u0015\u0001\u0005BE\u000bA\u0003]3sg&\u001cHOU;oi&lWmQ8oM&<GC\u0001'S\u0011\u0015\u0019v\n1\u00017\u00035\u0011XO\u001c;j[\u0016\u001cuN\u001c4jO\")Q\u000b\u0001C!-\u0006\u0011b-\u001b8e%VtG/[7f\u0007>tg-[4t)\u00059\u0006c\u0001-am9\u0011\u0011L\u0018\b\u00035vk\u0011a\u0017\u0006\u00039\"\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005}c\u0011a\u00029bG.\fw-Z\u0005\u0003C\n\u0014A\u0001T5ti*\u0011q\f\u0004")
public class FileSystemRuntimeConfigPersistor
implements RuntimeConfigPersistor {
    private final File storageDir;
    public final Logger blended$updater$remote$FileSystemRuntimeConfigPersistor$$log;
    private Map<File, RuntimeConfig> runtimeConfigs;
    private boolean initialized;

    public String fileName(RuntimeConfig rc) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{rc.name(), rc.version()}));
    }

    public void initialize() {
        Map map;
        this.blended$updater$remote$FileSystemRuntimeConfigPersistor$$log.debug("About to initialize runtime config persistor for storageDir: {}", new Object[]{this.storageDir});
        if (this.storageDir.exists()) {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final File[] apply() {
                    return (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class));
                }
            });
            Tuple2[] rcs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])files).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemRuntimeConfigPersistor $outer;

                public final Iterable<Tuple2<File, RuntimeConfig>> apply(File file) {
                    Try rc = Try$.MODULE$.apply((Function0)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final Config apply() {
                            return ConfigFactory.parseFile((File)this.file$1).resolve();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Try<RuntimeConfig> apply(Config rawConfig) {
                            return RuntimeConfigCompanion$.MODULE$.read(rawConfig);
                        }
                    });
                    this.$outer.blended$updater$remote$FileSystemRuntimeConfigPersistor$$log.debug("Found file: {} with: {}", new Object[]{new Object[]{file, rc}});
                    return Option$.MODULE$.option2Iterable(rc.toOption().map((Function1)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final Tuple2<File, RuntimeConfig> apply(RuntimeConfig rc) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.file$1), (Object)rc);
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])rcs).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemRuntimeConfigPersistor $outer;

                public final boolean apply(Tuple2<File, RuntimeConfig> x0$1) {
                    Tuple2<File, RuntimeConfig> tuple2 = x0$1;
                    if (tuple2 != null) {
                        File file = (File)tuple2._1();
                        RuntimeConfig rc = (RuntimeConfig)tuple2._2();
                        String string = file.getName();
                        String string2 = this.$outer.fileName(rc);
                        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            })).toMap(Predef$.MODULE$.$conforms());
        } else {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        this.runtimeConfigs = map;
        this.initialized = true;
    }

    @Override
    public void persistRuntimeConfig(RuntimeConfig runtimeConfig) {
        File configFile;
        if (!this.initialized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.fileName(runtimeConfig))).exists()) {
            Option option = this.runtimeConfigs.get((Object)configFile);
            Some some = new Some((Object)runtimeConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.blended$updater$remote$FileSystemRuntimeConfigPersistor$$log.debug("RuntimeConfig already persistent");
            } else {
                String msg = "Cannot persist runtime config. Storage location already taken for a different configuration.";
                this.blended$updater$remote$FileSystemRuntimeConfigPersistor$$log.error("{} Found file {} with config: {}", new Object[]{msg, configFile, this.runtimeConfigs.get((Object)configFile)});
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(RuntimeConfigCompanion$.MODULE$.toConfig(runtimeConfig), configFile, (Option)None$.MODULE$);
        this.runtimeConfigs = this.runtimeConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)configFile), (Object)runtimeConfig));
    }

    @Override
    public List<RuntimeConfig> findRuntimeConfigs() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.runtimeConfigs.values().toList();
    }

    public FileSystemRuntimeConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.blended$updater$remote$FileSystemRuntimeConfigPersistor$$log = LoggerFactory.getLogger(FileSystemRuntimeConfigPersistor.class);
        this.runtimeConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initialized = false;
    }
}

