/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.updater.config.ConfigWriter$;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayConfig$;
import blended.updater.remote.OverlayConfigPersistor;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001}3A!\u0001\u0002\u0001\u0013\t\u0001c)\u001b7f'f\u001cH/Z7Pm\u0016\u0014H.Y=D_:4\u0017n\u001a)feNL7\u000f^8s\u0015\t\u0019A!\u0001\u0004sK6|G/\u001a\u0006\u0003\u000b\u0019\tq!\u001e9eCR,'OC\u0001\b\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0015A\u0001\"a\u0003\b\u000e\u00031Q\u0011!D\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001f1\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005Yye/\u001a:mCf\u001cuN\u001c4jOB+'o]5ti>\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u0015M$xN]1hK\u0012K'\u000f\u0005\u0002\u001895\t\u0001D\u0003\u0002\u001a5\u0005\u0011\u0011n\u001c\u0006\u00027\u0005!!.\u0019<b\u0013\ti\u0002D\u0001\u0003GS2,\u0007\"B\u0010\u0001\t\u0003\u0001\u0013A\u0002\u001fj]&$h\b\u0006\u0002\"EA\u0011\u0011\u0003\u0001\u0005\u0006+y\u0001\rA\u0006\u0005\u0007I\u0001\u0001\u000b\u0011B\u0013\u0002\u00071|w\r\u0005\u0002'W5\tqE\u0003\u0002)S\u0005)1\u000f\u001c45U*\t!&A\u0002pe\u001eL!\u0001L\u0014\u0003\r1{wmZ3s\u0011\u0019q\u0003\u0001)Q\u0005_\u0005qqN^3sY\u0006L8i\u001c8gS\u001e\u001c\b\u0003\u0002\u00194-Yr!aC\u0019\n\u0005Ib\u0011A\u0002)sK\u0012,g-\u0003\u00025k\t\u0019Q*\u00199\u000b\u0005Ib\u0001CA\u001c;\u001b\u0005A$BA\u001d\u0005\u0003\u0019\u0019wN\u001c4jO&\u00111\b\u000f\u0002\u000e\u001fZ,'\u000f\\1z\u0007>tg-[4\t\ru\u0002\u0001\u0015)\u0003?\u0003)Ig.\u001b;bY&TX\r\u001a\t\u0003\u0017}J!\u0001\u0011\u0007\u0003\u000f\t{w\u000e\\3b]\")!\t\u0001C\u0001\u0007\u0006)rN^3sY\u0006L8i\u001c8gS\u001e4\u0015\u000e\\3OC6,GC\u0001#H!\t\u0001T)\u0003\u0002Gk\t11\u000b\u001e:j]\u001eDQ\u0001S!A\u0002Y\n!a\\2\t\u000b)\u0003A\u0011A&\u0002\u0015%t\u0017\u000e^5bY&TX\rF\u0001M!\tYQ*\u0003\u0002O\u0019\t!QK\\5u\u0011\u0015\u0001\u0006\u0001\"\u0011R\u0003Q\u0001XM]:jgR|e/\u001a:mCf\u001cuN\u001c4jOR\u0011AJ\u0015\u0005\u0006'>\u0003\rAN\u0001\u000e_Z,'\u000f\\1z\u0007>tg-[4\t\u000bU\u0003A\u0011\t,\u0002%\u0019Lg\u000eZ(wKJd\u0017-_\"p]\u001aLwm\u001d\u000b\u0002/B\u0019\u0001,\u0018\u001c\u000e\u0003eS!AW.\u0002\u0013%lW.\u001e;bE2,'B\u0001/\r\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003=f\u00131aU3r\u0001")
public class FileSystemOverlayConfigPersistor
implements OverlayConfigPersistor {
    private final File storageDir;
    public final Logger blended$updater$remote$FileSystemOverlayConfigPersistor$$log;
    private Map<File, OverlayConfig> overlayConfigs;
    private boolean initalized;

    public String overlayConfigFileName(OverlayConfig oc) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ".conf"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{oc.name(), oc.version()}));
    }

    public void initialize() {
        Map map;
        this.blended$updater$remote$FileSystemOverlayConfigPersistor$$log.debug("About to initialize overlay config persistor for storageDir: {}", new Object[]{this.storageDir});
        if (this.storageDir.exists()) {
            File[] files = (File[])Option$.MODULE$.apply((Object)this.storageDir.listFiles()).getOrElse((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final File[] apply() {
                    return (File[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(File.class));
                }
            });
            Tuple2[] ocs = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])files).flatMap((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemOverlayConfigPersistor $outer;

                public final Iterable<Tuple2<File, OverlayConfig>> apply(File file) {
                    Try oc = Try$.MODULE$.apply((Function0)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final Config apply() {
                            return ConfigFactory.parseFile((File)this.file$1).resolve();
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }).flatMap((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Try<OverlayConfig> apply(Config rawConfig) {
                            return OverlayConfig$.MODULE$.read(rawConfig);
                        }
                    });
                    this.$outer.blended$updater$remote$FileSystemOverlayConfigPersistor$$log.debug("Found file: {} with: {}", new Object[]{new Object[]{file, oc}});
                    return Option$.MODULE$.option2Iterable(oc.toOption().map((Function1)new Serializable(this, file){
                        public static final long serialVersionUID = 0L;
                        private final File file$1;

                        public final Tuple2<File, OverlayConfig> apply(OverlayConfig oc) {
                            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.file$1), (Object)oc);
                        }
                        {
                            this.file$1 = file$1;
                        }
                    }));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            map = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])ocs).filter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ FileSystemOverlayConfigPersistor $outer;

                public final boolean apply(Tuple2<File, OverlayConfig> x0$1) {
                    Tuple2<File, OverlayConfig> tuple2 = x0$1;
                    if (tuple2 != null) {
                        File file = (File)tuple2._1();
                        OverlayConfig oc = (OverlayConfig)tuple2._2();
                        String string = file.getName();
                        String string2 = this.$outer.overlayConfigFileName(oc);
                        boolean bl = !(string != null ? !string.equals(string2) : string2 != null);
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            })).toMap(Predef$.MODULE$.conforms());
        } else {
            map = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        }
        this.overlayConfigs = map;
        this.initalized = true;
    }

    @Override
    public void persistOverlayConfig(OverlayConfig overlayConfig) {
        File configFile;
        if (!this.initalized) {
            this.initialize();
        }
        if ((configFile = new File(this.storageDir, this.overlayConfigFileName(overlayConfig))).exists()) {
            Option option = this.overlayConfigs.get((Object)configFile);
            Some some = new Some((Object)overlayConfig);
            if (!(option != null ? !option.equals(some) : some != null)) {
                this.blended$updater$remote$FileSystemOverlayConfigPersistor$$log.debug("OverlayConfig already persistent");
            } else {
                String msg = "Cannot persist overlay config. Storage location already taken for a different configuration.";
                this.blended$updater$remote$FileSystemOverlayConfigPersistor$$log.error("{} Found file {} with config: {}", new Object[]{msg, configFile, this.overlayConfigs.get((Object)configFile)});
                throw package$.MODULE$.error(msg);
            }
        }
        ConfigWriter$.MODULE$.write(OverlayConfig$.MODULE$.toConfig(overlayConfig), configFile, (Option)None$.MODULE$);
        this.overlayConfigs = this.overlayConfigs.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)configFile), (Object)overlayConfig));
    }

    @Override
    public scala.collection.immutable.Seq<OverlayConfig> findOverlayConfigs() {
        if (!this.initalized) {
            this.initialize();
        }
        return this.overlayConfigs.values().toList();
    }

    public FileSystemOverlayConfigPersistor(File storageDir) {
        this.storageDir = storageDir;
        this.blended$updater$remote$FileSystemOverlayConfigPersistor$$log = LoggerFactory.getLogger(FileSystemOverlayConfigPersistor.class);
        this.overlayConfigs = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
        this.initalized = false;
    }
}

