/*
 * Decompiled with CFR 0.152.
 */
package blended.updater.remote;

import blended.mgmt.base.ActivateProfile;
import blended.mgmt.base.ContainerInfo;
import blended.mgmt.base.ServiceInfo;
import blended.mgmt.base.StageProfile;
import blended.mgmt.base.UpdateAction;
import blended.updater.config.OverlayConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.remote.ContainerState;
import blended.updater.remote.ContainerState$;
import blended.updater.remote.ContainerStatePersistor;
import blended.updater.remote.OverlayConfigPersistor;
import blended.updater.remote.RuntimeConfigPersistor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u0001%\u0011QBU3n_R,W\u000b\u001d3bi\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\\8uK*\u0011QAB\u0001\bkB$\u0017\r^3s\u0015\u00059\u0011a\u00022mK:$W\rZ\u0002\u0001'\t\u0001!\u0002\u0005\u0002\f\u001d5\tABC\u0001\u000e\u0003\u0015\u00198-\u00197b\u0013\tyAB\u0001\u0004B]f\u0014VM\u001a\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u00051\"/\u001e8uS6,7i\u001c8gS\u001e\u0004VM]:jgR|'\u000f\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t1\"+\u001e8uS6,7i\u001c8gS\u001e\u0004VM]:jgR|'\u000f\u0003\u0005\u0018\u0001\t\u0005\t\u0015!\u0003\u0019\u0003]\u0019wN\u001c;bS:,'o\u0015;bi\u0016\u0004VM]:jgR|'\u000f\u0005\u0002\u00143%\u0011!D\u0001\u0002\u0018\u0007>tG/Y5oKJ\u001cF/\u0019;f!\u0016\u00148/[:u_JD\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!H\u0001\u0017_Z,'\u000f\\1z\u0007>tg-[4QKJ\u001c\u0018n\u001d;peB\u00111CH\u0005\u0003?\t\u0011ac\u0014<fe2\f\u0017pQ8oM&<\u0007+\u001a:tSN$xN\u001d\u0005\u0006C\u0001!\tAI\u0001\u0007y%t\u0017\u000e\u001e \u0015\t\r\"SE\n\t\u0003'\u0001AQ!\u0005\u0011A\u0002IAQa\u0006\u0011A\u0002aAQ\u0001\b\u0011A\u0002uAa\u0001\u000b\u0001!\u0002\u0013I\u0013a\u00017pOB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\u0006g24GG\u001b\u0006\u0002]\u0005\u0019qN]4\n\u0005AZ#A\u0002'pO\u001e,'/\u0002\u00033\u0001\u0001\u0019$aC\"p]R\f\u0017N\\3s\u0013\u0012\u0004\"\u0001N\u001c\u000f\u0005-)\u0014B\u0001\u001c\r\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001(\u000f\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Yb\u0001\"B\u001e\u0001\t\u0003a\u0014!C1eI\u0006\u001bG/[8o)\ri\u0004\t\u0012\t\u0003\u0017yJ!a\u0010\u0007\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u0003j\u0002\rAQ\u0001\fG>tG/Y5oKJLE\r\u0005\u0002Dc5\t\u0001\u0001C\u0003Fu\u0001\u0007a)\u0001\u0004bGRLwN\u001c\t\u0003\u000f2k\u0011\u0001\u0013\u0006\u0003\u0013*\u000bAAY1tK*\u00111JB\u0001\u0005[\u001elG/\u0003\u0002N\u0011\naQ\u000b\u001d3bi\u0016\f5\r^5p]\")q\n\u0001C\u0001!\u0006!R\u000f\u001d3bi\u0016\u001cuN\u001c;bS:,'o\u0015;bi\u0016$\"!\u0015+\u0011\u0005M\u0011\u0016BA*\u0003\u00059\u0019uN\u001c;bS:,'o\u0015;bi\u0016DQ!\u0016(A\u0002Y\u000bQbY8oi\u0006Lg.\u001a:J]\u001a|\u0007CA$X\u0013\tA\u0006JA\u0007D_:$\u0018-\u001b8fe&sgm\u001c\u0005\u00065\u0002!\taW\u0001\u0012O\u0016$8i\u001c8uC&tWM]*uCR,GC\u0001/`!\rYQ,U\u0005\u0003=2\u0011aa\u00149uS>t\u0007\"B!Z\u0001\u0004\u0011\u0005\"B1\u0001\t\u0003\u0011\u0017aE4fi\u000e{g\u000e^1j]\u0016\u0014\u0018i\u0019;j_:\u001cHCA2l!\r!\u0017NR\u0007\u0002K*\u0011amZ\u0001\nS6lW\u000f^1cY\u0016T!\u0001\u001b\u0007\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kK\n\u00191+Z9\t\u000b\u0005\u0003\u0007\u0019\u0001\"\t\u000b5\u0004A\u0011\u00018\u0002\u001f\u001d,GoQ8oi\u0006Lg.\u001a:JIN$\u0012a\u001c\t\u0004I&\u0014\u0005\"B9\u0001\t\u0003\u0011\u0018!\u0006:fO&\u001cH/\u001a:Sk:$\u0018.\\3D_:4\u0017n\u001a\u000b\u0003{MDQ\u0001\u001e9A\u0002U\fQB];oi&lWmQ8oM&<\u0007C\u0001<z\u001b\u00059(B\u0001=\u0005\u0003\u0019\u0019wN\u001c4jO&\u0011!p\u001e\u0002\u000e%VtG/[7f\u0007>tg-[4\t\u000bq\u0004A\u0011A?\u0002#\u001d,GOU;oi&lWmQ8oM&<7\u000fF\u0001\u007f!\r!\u0017.\u001e\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0003E9W\r^(wKJd\u0017-_\"p]\u001aLwm\u001d\u000b\u0003\u0003\u000b\u0001B\u0001Z5\u0002\bA\u0019a/!\u0003\n\u0007\u0005-qOA\u0007Pm\u0016\u0014H.Y=D_:4\u0017n\u001a\u0005\b\u0003\u001f\u0001A\u0011AA\t\u0003U\u0011XmZ5ti\u0016\u0014xJ^3sY\u0006L8i\u001c8gS\u001e$2!PA\n\u0011!\t)\"!\u0004A\u0002\u0005\u001d\u0011!D8wKJd\u0017-_\"p]\u001aLw\r")
public class RemoteUpdater {
    private final RuntimeConfigPersistor runtimeConfigPersistor;
    private final ContainerStatePersistor containerStatePersistor;
    private final OverlayConfigPersistor overlayConfigPersistor;
    private final Logger log;

    public void addAction(String containerId, UpdateAction action) {
        scala.collection.immutable.Seq newActions;
        ContainerState state = (ContainerState)this.containerStatePersistor.findContainerState(containerId).getOrElse((Function0)new Serializable(this, containerId){
            public static final long serialVersionUID = 0L;
            private final String containerId$1;

            public final ContainerState apply() {
                return new ContainerState(this.containerId$1, ContainerState$.MODULE$.apply$default$2(), ContainerState$.MODULE$.apply$default$3(), ContainerState$.MODULE$.apply$default$4(), ContainerState$.MODULE$.apply$default$5(), ContainerState$.MODULE$.apply$default$6());
            }
            {
                this.containerId$1 = containerId$1;
            }
        });
        scala.collection.immutable.Seq actions = state.outstandingActions();
        scala.collection.immutable.Seq x$15 = newActions = actions.exists((Function1)new Serializable(this, action){
            public static final long serialVersionUID = 0L;
            private final UpdateAction action$1;

            public final boolean apply(UpdateAction x$1) {
                UpdateAction updateAction = x$1;
                UpdateAction updateAction2 = this.action$1;
                return !(updateAction != null ? !updateAction.equals(updateAction2) : updateAction2 != null);
            }
            {
                this.action$1 = action$1;
            }
        }) ? actions : (scala.collection.immutable.Seq)actions.$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new UpdateAction[]{action})), Seq$.MODULE$.canBuildFrom());
        String x$16 = state.copy$default$1();
        Option<String> x$17 = state.copy$default$3();
        scala.collection.immutable.Seq<String> x$18 = state.copy$default$4();
        scala.collection.immutable.Seq<String> x$19 = state.copy$default$5();
        Option<Object> x$20 = state.copy$default$6();
        this.containerStatePersistor.updateContainerState(state.copy(x$16, (scala.collection.immutable.Seq<UpdateAction>)x$15, x$17, x$18, x$19, x$20));
    }

    public ContainerState updateContainerState(ContainerInfo containerInfo) {
        this.log.debug(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"About to analyze update properties from container info: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{containerInfo})));
        long timeStamp = System.currentTimeMillis();
        ContainerState state = (ContainerState)this.containerStatePersistor.findContainerState(containerInfo.containerId()).getOrElse((Function0)new Serializable(this, containerInfo){
            public static final long serialVersionUID = 0L;
            private final ContainerInfo containerInfo$1;

            public final ContainerState apply() {
                return new ContainerState(this.containerInfo$1.containerId(), ContainerState$.MODULE$.apply$default$2(), ContainerState$.MODULE$.apply$default$3(), ContainerState$.MODULE$.apply$default$4(), ContainerState$.MODULE$.apply$default$5(), ContainerState$.MODULE$.apply$default$6());
            }
            {
                this.containerInfo$1 = containerInfo$1;
            }
        });
        Map props = (Map)containerInfo.serviceInfos().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(ServiceInfo x$2) {
                return x$2.name().endsWith("/blended.updater");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, String> apply(ServiceInfo si) {
                return si.props();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Map<String, Nothing$> apply() {
                return (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
            }
        });
        Option active = props.get((Object)"profile.active").map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$3) {
                return x$3.trim();
            }
        }).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$4) {
                return !x$4.isEmpty();
            }
        });
        List valid = (List)((TraversableLike)((TraversableLike)props.get((Object)"profiles.valid").toList().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$5) {
                return Predef$.MODULE$.refArrayOps((Object[])x$5.split(","));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$6) {
                return x$6.trim();
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$7) {
                return !x$7.isEmpty();
            }
        });
        List invalid = (List)((TraversableLike)((TraversableLike)props.get((Object)"profiles.invalid").toList().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayOps<String> apply(String x$8) {
                return Predef$.MODULE$.refArrayOps((Object[])x$8.split(","));
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$9) {
                return x$9.trim();
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$10) {
                return !x$10.isEmpty();
            }
        });
        scala.collection.immutable.Seq newUpdateActions = (scala.collection.immutable.Seq)state.outstandingActions().filter((Function1)new Serializable(this, active, valid){
            public static final long serialVersionUID = 0L;
            private final Option active$1;
            private final List valid$1;

            public final boolean apply(UpdateAction x0$1) {
                String v;
                StageProfile stageProfile;
                String n;
                String v2;
                ActivateProfile activateProfile;
                String n2;
                UpdateAction updateAction = x0$1;
                boolean bl = updateAction instanceof ActivateProfile ? !this.active$1.exists((Function1)new Serializable(this, n2 = (activateProfile = (ActivateProfile)updateAction).profileName(), v2 = activateProfile.profileVersion()){
                    public static final long serialVersionUID = 0L;
                    private final String n$1;
                    private final String v$1;

                    public final boolean apply(String x$11) {
                        String string = x$11;
                        String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.n$1, this.v$1}));
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.n$1 = n$1;
                        this.v$1 = v$1;
                    }
                }) : (updateAction instanceof StageProfile ? !this.valid$1.exists((Function1)new Serializable(this, n = (stageProfile = (StageProfile)updateAction).profileName(), v = stageProfile.profileVersion()){
                    public static final long serialVersionUID = 0L;
                    private final String n$2;
                    private final String v$2;

                    public final boolean apply(String x$12) {
                        String string = x$12;
                        String string2 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.n$2, this.v$2}));
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    }
                    {
                        this.n$2 = n$2;
                        this.v$2 = v$2;
                    }
                }) : true);
                return bl;
            }
            {
                this.active$1 = active$1;
                this.valid$1 = valid$1;
            }
        });
        Option x$21 = active;
        List x$22 = valid;
        List x$23 = invalid;
        scala.collection.immutable.Seq x$24 = newUpdateActions;
        Some x$25 = new Some((Object)BoxesRunTime.boxToLong((long)timeStamp));
        String x$26 = state.copy$default$1();
        ContainerState newState = state.copy(x$26, (scala.collection.immutable.Seq<UpdateAction>)x$24, (Option<String>)x$21, (scala.collection.immutable.Seq<String>)x$22, (scala.collection.immutable.Seq<String>)x$23, (Option<Object>)x$25);
        this.containerStatePersistor.updateContainerState(newState);
        return newState;
    }

    public Option<ContainerState> getContainerState(String containerId) {
        return this.containerStatePersistor.findContainerState(containerId);
    }

    public scala.collection.immutable.Seq<UpdateAction> getContainerActions(String containerId) {
        return (scala.collection.immutable.Seq)this.getContainerState(containerId).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Seq<UpdateAction> apply(ContainerState x$13) {
                return x$13.outstandingActions();
            }
        }).getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final scala.collection.immutable.Seq<Nothing$> apply() {
                return (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        });
    }

    public scala.collection.immutable.Seq<String> getContainerIds() {
        return (scala.collection.immutable.Seq)this.containerStatePersistor.findAllContainerStates().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(ContainerState x$14) {
                return x$14.containerId();
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    public void registerRuntimeConfig(RuntimeConfig runtimeConfig) {
        this.runtimeConfigPersistor.persistRuntimeConfig(runtimeConfig);
    }

    public scala.collection.immutable.Seq<RuntimeConfig> getRuntimeConfigs() {
        return this.runtimeConfigPersistor.findRuntimeConfigs();
    }

    public scala.collection.immutable.Seq<OverlayConfig> getOverlayConfigs() {
        return this.overlayConfigPersistor.findOverlayConfigs();
    }

    public void registerOverlayConfig(OverlayConfig overlayConfig) {
        this.overlayConfigPersistor.persistOverlayConfig(overlayConfig);
    }

    public RemoteUpdater(RuntimeConfigPersistor runtimeConfigPersistor, ContainerStatePersistor containerStatePersistor, OverlayConfigPersistor overlayConfigPersistor) {
        this.runtimeConfigPersistor = runtimeConfigPersistor;
        this.containerStatePersistor = containerStatePersistor;
        this.overlayConfigPersistor = overlayConfigPersistor;
        this.log = LoggerFactory.getLogger(RemoteUpdater.class);
    }
}

