/*
 * Decompiled with CFR 0.152.
 */
package blended.testsupport;

import blended.testsupport.MessageFactory;
import blended.util.FileHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLMessageFactory
implements MessageFactory {
    private final String resourceName;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLMessageFactory.class);
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public XMLMessageFactory(String string) {
        this.resourceName = string;
    }

    @Override
    public Message createTextMessage() throws Exception {
        return this.createMessage(false);
    }

    @Override
    public Message createBinaryMessage() throws Exception {
        return this.createMessage(true);
    }

    private Message createMessage(boolean bl) throws Exception {
        DefaultMessage defaultMessage = new DefaultMessage();
        LOGGER.debug("Creating message from file [{}]", (Object)this.resourceName);
        Document document = this.readMessageFile();
        this.populateHeader((Message)defaultMessage, document);
        this.populateBody((Message)defaultMessage, document, bl);
        return defaultMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readMessageFile() throws Exception {
        byte[] byArray = FileHelper.readFile((String)this.resourceName);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            Document document;
            DocumentBuilder documentBuilder = dbf.newDocumentBuilder();
            Document document2 = document = documentBuilder.parse(byteArrayInputStream);
            return document2;
        }
        finally {
            if (byteArrayInputStream != null) {
                try {
                    ((InputStream)byteArrayInputStream).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void populateHeader(Message message, Document document) throws Exception {
        NodeList nodeList = document.getElementsByTagName("headerProperty");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            String string = element.getAttribute("type");
            String string2 = element.getAttribute("name");
            String string3 = element.getAttribute("value");
            Class<?> clazz = Class.forName(string);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            Object obj = constructor.newInstance(string3);
            LOGGER.debug("Setting property [{}] to [{}]", (Object)string2, (Object)obj.toString());
            message.setHeader(string2, obj);
        }
    }

    private void populateBody(Message message, Document document, boolean bl) throws Exception {
        NodeList nodeList = document.getElementsByTagName("text");
        if (nodeList.getLength() > 0) {
            String string = ((Element)nodeList.item(0)).getTextContent();
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
            if (bl) {
                message.setBody((Object)byArray);
                LOGGER.debug("Set message body to byte Array of length[{}]", (Object)byArray.length);
            } else {
                message.setBody((Object)new String(byArray, "UTF-8"));
                LOGGER.debug("Set message body to [{}]", message.getBody(String.class));
            }
        }
    }
}

