/*
 * Decompiled with CFR 0.152.
 */
package blended.testsupport;

import blended.testsupport.MessageFactory;
import blended.util.FileReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.camel.Message;
import org.apache.camel.impl.DefaultMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLMessageFactory
implements MessageFactory {
    private final String resourceName;
    private static final Logger LOGGER = LoggerFactory.getLogger(XMLMessageFactory.class);
    private static final DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();

    public XMLMessageFactory(String fileName) {
        this.resourceName = fileName;
    }

    @Override
    public Message createTextMessage() throws Exception {
        return this.createMessage(false);
    }

    @Override
    public Message createBinaryMessage() throws Exception {
        return this.createMessage(true);
    }

    private Message createMessage(boolean binary) throws Exception {
        DefaultMessage result = new DefaultMessage();
        LOGGER.debug("Creating message from file [{}]", (Object)this.resourceName);
        Document doc = this.readMessageFile();
        this.populateHeader((Message)result, doc);
        this.populateBody((Message)result, doc, binary);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readMessageFile() throws Exception {
        byte[] content = FileReader.readFile((String)this.resourceName);
        ByteArrayInputStream is = new ByteArrayInputStream(content);
        try {
            Document doc;
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            Document document = doc = dBuilder.parse(is);
            return document;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void populateHeader(Message message, Document doc) throws Exception {
        NodeList headerList = doc.getElementsByTagName("headerProperty");
        for (int i = 0; i < headerList.getLength(); ++i) {
            Element headerElement = (Element)headerList.item(i);
            String type = headerElement.getAttribute("type");
            String name = headerElement.getAttribute("name");
            String value = headerElement.getAttribute("value");
            Class<?> clazz = Class.forName(type);
            Constructor<?> contructor = clazz.getConstructor(String.class);
            Object obj = contructor.newInstance(value);
            LOGGER.debug("Setting property [{}] to [{}]", (Object)name, (Object)obj.toString());
            message.setHeader(name, obj);
        }
    }

    private void populateBody(Message message, Document doc, boolean binary) throws Exception {
        NodeList textElements = doc.getElementsByTagName("text");
        if (textElements.getLength() > 0) {
            String base64 = ((Element)textElements.item(0)).getTextContent();
            byte[] decoded = DatatypeConverter.parseBase64Binary((String)base64);
            if (binary) {
                message.setBody((Object)decoded);
                LOGGER.debug("Set message body to byte Array of length[{}]", (Object)decoded.length);
            } else {
                message.setBody((Object)new String(decoded, "UTF-8"));
                LOGGER.debug("Set message body to [{}]", message.getBody(String.class));
            }
        }
    }
}

