/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.connect;

import java.util.HashSet;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.packageadmin.RequiredBundle;

public class RequiredBundleImpl
implements RequiredBundle {
    private final Bundle m_bundle;

    public RequiredBundleImpl(Bundle bundle) {
        this.m_bundle = bundle;
    }

    public String getSymbolicName() {
        return this.m_bundle.getSymbolicName();
    }

    public Bundle getBundle() {
        return this.m_bundle;
    }

    public Bundle[] getRequiringBundles() {
        HashSet<Bundle> set = new HashSet<Bundle>();
        for (BundleWire wire : ((BundleWiring)this.m_bundle.adapt(BundleWiring.class)).getProvidedWires(null)) {
            if (!"osgi.wiring.bundle".equals(wire.getCapability().getNamespace())) continue;
            set.add(wire.getRequirer().getBundle());
        }
        return set.toArray(new Bundle[set.size()]);
    }

    public Version getVersion() {
        return this.m_bundle.getVersion();
    }

    public boolean isRemovalPending() {
        return false;
    }

    public String toString() {
        return this.m_bundle.getSymbolicName() + "; version=" + this.m_bundle.getVersion();
    }
}

