/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.stream.FanOutShape2;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.UniformFanInShape;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Merge$;
import akka.stream.scaladsl.Source;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.streams.BlendedStreamsConfig;
import blended.streams.FlowHeaderConfig;
import blended.streams.FlowProcessor$;
import blended.streams.StreamController$;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.FlowHeaderConfigAware;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsConsumerSettings$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsDestinationResolver;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsKeyFormatStrategy;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsRetryConfig;
import blended.streams.jms.JmsRetryRouter;
import blended.streams.jms.JmsSendParameter;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowEnvelopeLogger$;
import blended.streams.message.FlowMessage;
import blended.streams.processor.AckProcessor;
import blended.streams.processor.Collector;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.LogLevel$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.Session;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rf\u0001\u0002\u000f\u001e\u0001\u0011B\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\ti\u0001\u0011)\u0019!C\u0001k!A\u0011\b\u0001B\u0001B\u0003%a\u0007\u0003\u0005;\u0001\t\u0005\t\u0015a\u0003<\u0011\u0015\u0019\u0005\u0001\"\u0001E\u0011\u0019Q\u0005\u0001)A\u0005\u0017\"1a\u000b\u0001Q\u0001\n]Ca!\u0018\u0001!\u0002\u0013q\u0006B\u0002 \u0001A\u0003&a\r\u0003\u0004m\u0001\u0001\u0006I!\u001c\u0004\u0005a\u0002\u0001\u0011\u000f\u0003\u0005y\u0017\t\u0015\r\u0011\"\u0011z\u0011!i8B!A!\u0002\u0013Q\b\u0002\u0003@\f\u0005\u000b\u0007I\u0011I@\t\u0015\u0005\u001d1B!A!\u0002\u0013\t\t\u0001\u0003\u0006\u0002\n-\u0011)\u0019!C\u0001\u0003\u0017A!\"a\u0007\f\u0005\u0003\u0005\u000b\u0011BA\u0007\u0011\u0019\u00195\u0002\"\u0001\u0002\u001e!9\u0011\u0011F\u0006\u0005B\u0005-\u0002bBA-\u0001\u0011E\u00111\f\u0005\b\u0003k\u0002A\u0011CA<\u0011\u001d\ty\b\u0001C\t\u0003oBq!!!\u0001\t#\t9\bC\u0004\u0002\u0004\u0002!\t\"a\u001e\t\u000f\u0005\u0015\u0005\u0001\"\u0005\u0002\b\"9\u0011q\u0013\u0001\u0005\u0002\u0005e\u0005bBAQ\u0001\u0011\u0005\u0011\u0011\u0014\u0002\u0012\u00156\u001c(+\u001a;ssB\u0013xnY3tg>\u0014(B\u0001\u0010 \u0003\rQWn\u001d\u0006\u0003A\u0005\nqa\u001d;sK\u0006l7OC\u0001#\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001K-\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0007C\u0001\u0017.\u001b\u0005i\u0012B\u0001\u0018\u001e\u0005AQUn]*ue\u0016\fWnU;qa>\u0014H/\u0001\u0006tiJ,\u0017-\\:DM\u001e\u0004\"!\r\u001a\u000e\u0003}I!aM\u0010\u0003)\tcWM\u001c3fIN#(/Z1ng\u000e{gNZ5h\u0003!\u0011X\r\u001e:z\u0007\u001a<W#\u0001\u001c\u0011\u00051:\u0014B\u0001\u001d\u001e\u00059QUn\u001d*fiJL8i\u001c8gS\u001e\f\u0011B]3uef\u001cem\u001a\u0011\u0002\rML8\u000f^3n!\ta\u0014)D\u0001>\u0015\tqt(A\u0003bGR|'OC\u0001A\u0003\u0011\t7n[1\n\u0005\tk$aC!di>\u00148+_:uK6\fa\u0001P5oSRtDcA#I\u0013R\u0011ai\u0012\t\u0003Y\u0001AQAO\u0003A\u0004mBQaL\u0003A\u0002ABQ\u0001N\u0003A\u0002Y\n!!\u001b3\u0011\u00051\u001bfBA'R!\tqu%D\u0001P\u0015\t\u00016%\u0001\u0004=e>|GOP\u0005\u0003%\u001e\na\u0001\u0015:fI\u00164\u0017B\u0001+V\u0005\u0019\u0019FO]5oO*\u0011!kJ\u0001\te\u0016$(/\u001f'pOB\u0011\u0001lW\u0007\u00023*\u0011!lH\u0001\b[\u0016\u001c8/Y4f\u0013\ta\u0016L\u0001\nGY><XI\u001c<fY>\u0004X\rT8hO\u0016\u0014\u0018a\u00017pOB\u0011q\fZ\u0007\u0002A*\u0011\u0011MY\u0001\bY><w-\u001b8h\u0015\t\u0019\u0017%\u0001\u0003vi&d\u0017BA3a\u0005\u0019aunZ4feB\u0019aeZ5\n\u0005!<#AB(qi&|g\u000e\u0005\u0002=U&\u00111.\u0010\u0002\t\u0003\u000e$xN\u001d*fM\u00061!o\\;uKJ\u0004\"\u0001\f8\n\u0005=l\"A\u0004&ngJ+GO]=S_V$XM\u001d\u0002\u0019%\u0016$(/\u001f#fgRLg.\u0019;j_:\u0014Vm]8mm\u0016\u00148\u0003B\u0006&eV\u0004\"\u0001L:\n\u0005Ql\"!\u0006$m_^DU-\u00193fe\u000e{gNZ5h\u0003^\f'/\u001a\t\u0003YYL!a^\u000f\u0003#)k7/\u00128wK2|\u0007/\u001a%fC\u0012,'/\u0001\u0007iK\u0006$WM]\"p]\u001aLw-F\u0001{!\t\t40\u0003\u0002}?\t\u0001b\t\\8x\u0011\u0016\fG-\u001a:D_:4\u0017nZ\u0001\u000eQ\u0016\fG-\u001a:D_:4\u0017n\u001a\u0011\u0002\u0011M,G\u000f^5oON,\"!!\u0001\u0011\u00071\n\u0019!C\u0002\u0002\u0006u\u00111CS7t!J|G-^2feN+G\u000f^5oON\f\u0011b]3ui&twm\u001d\u0011\u0002\u0013Y\fG.\u001b3bi>\u0014XCAA\u0007!\u0011\ty!!\u0006\u000f\u0007E\n\t\"C\u0002\u0002\u0014}\tQB\u00127poB\u0013xnY3tg>\u0014\u0018\u0002BA\f\u00033\u0011q\"\u00138uK\u001e\u0014\u0018\r^5p]N#X\r\u001d\u0006\u0004\u0003'y\u0012A\u0003<bY&$\u0017\r^8sAQA\u0011qDA\u0012\u0003K\t9\u0003E\u0002\u0002\"-i\u0011\u0001\u0001\u0005\u0006qJ\u0001\rA\u001f\u0005\u0007}J\u0001\r!!\u0001\t\u000f\u0005%!\u00031\u0001\u0002\u000e\u0005i1/\u001a8e!\u0006\u0014\u0018-\\3uKJ$b!!\f\u0002>\u0005=\u0003CBA\u0018\u0003g\t9$\u0004\u0002\u00022)\u00111mJ\u0005\u0005\u0003k\t\tDA\u0002Uef\u00042\u0001LA\u001d\u0013\r\tY$\b\u0002\u0011\u00156\u001c8+\u001a8e!\u0006\u0014\u0018-\\3uKJDq!a\u0010\u0014\u0001\u0004\t\t%A\u0004tKN\u001c\u0018n\u001c8\u0011\t\u0005\r\u00131J\u0007\u0003\u0003\u000bR1AHA$\u0015\t\tI%A\u0003kCZ\f\u00070\u0003\u0003\u0002N\u0005\u0015#aB*fgNLwN\u001c\u0005\b\u0003#\u001a\u0002\u0019AA*\u0003\r)gN\u001e\t\u00041\u0006U\u0013bAA,3\naa\t\\8x\u000b:4X\r\\8qK\u0006Y!/\u001a;ssN{WO]2f+\t\ti\u0006\u0005\u0005\u0002`\u0005%\u00141KA7\u001b\t\t\tG\u0003\u0003\u0002d\u0005\u0015\u0014\u0001C:dC2\fGm\u001d7\u000b\u0007\u0005\u001dt(\u0001\u0004tiJ,\u0017-\\\u0005\u0005\u0003W\n\tG\u0001\u0004T_V\u00148-\u001a\t\u0005\u0003_\n\t(D\u0001@\u0013\r\t\u0019h\u0010\u0002\b\u001d>$Xk]3e\u00035\u0011Xm]3oI6+7o]1hKV\u0011\u0011\u0011\u0010\t\u000b\u0003?\nY(a\u0015\u0002T\u00055\u0014\u0002BA?\u0003C\u0012AA\u00127po\u0006y1/\u001a8e)J\fgn]1di&|g.\u0001\btK:$Gk\\(sS\u001eLg.\u00197\u0002\u0017M,g\u000e\u001a+p%\u0016$(/_\u0001\u000be\u0016$(/_$sCBDWCAAE!!\tY)!$\u0002\u0012\u00065TBAA3\u0013\u0011\ty)!\u001a\u0003\u000b\u001d\u0013\u0018\r\u001d5\u0011\u0011\u0005-\u00151SA*\u0003'JA!!&\u0002f\tIa\t\\8x'\"\f\u0007/Z\u0001\u0006gR\f'\u000f\u001e\u000b\u0003\u00037\u00032AJAO\u0013\r\tyj\n\u0002\u0005+:LG/\u0001\u0003ti>\u0004\b")
public class JmsRetryProcessor
implements JmsStreamSupport {
    private final BlendedStreamsConfig streamsCfg;
    private final JmsRetryConfig retryCfg;
    private final ActorSystem system;
    private final String id;
    private final FlowEnvelopeLogger retryLog;
    private final Logger log;
    private Option<ActorRef> actor;
    private final JmsRetryRouter router;

    @Override
    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, FiniteDuration timeout, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$(this, processFlow, timeout, msgs, system);
    }

    @Override
    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, FlowEnvelopeLogger log, FiniteDuration timeout, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.sendMessages$(this, producerSettings, log, timeout, msgs, system);
    }

    @Override
    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, FlowEnvelopeLogger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, Option<Function1<Seq<FlowEnvelope>, Object>> completeOn, Option<FiniteDuration> timeout, FiniteDuration ackTimeout, ActorSystem system) {
        return JmsStreamSupport.receiveMessages$(this, headerCfg, cf, dest, log, listener, minMessageDelay, selector, completeOn, timeout, ackTimeout, system);
    }

    @Override
    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$(this);
    }

    @Override
    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$(this);
    }

    @Override
    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$(this);
    }

    @Override
    public Option<Function1<Seq<FlowEnvelope>, Object>> receiveMessages$default$8() {
        return JmsStreamSupport.receiveMessages$default$8$(this);
    }

    @Override
    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system) {
        return JmsStreamSupport.jmsProducer$(this, name, settings, autoAck, system);
    }

    @Override
    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JmsConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$(this, name, settings, minMessageDelay, system);
    }

    public JmsRetryConfig retryCfg() {
        return this.retryCfg;
    }

    public Source<FlowEnvelope, NotUsed> retrySource() {
        FlowEnvelopeLogger x$12 = this.retryLog;
        FlowHeaderConfig x$2 = this.retryCfg().headerCfg();
        IdAwareConnectionFactory x$3 = this.retryCfg().cf();
        AcknowledgeMode x$4 = AcknowledgeMode$.MODULE$.ClientAcknowledge();
        Some x$5 = new Some(JmsDestination$.MODULE$.create(this.retryCfg().retryDestName()).get());
        Function1 & Serializable x$6 = (Function1 & Serializable)x$1 -> LogLevel$.MODULE$.Debug();
        FiniteDuration x$7 = new package.DurationInt(package$.MODULE$.DurationInt(1)).second();
        JmsKeyFormatStrategy x$8 = JmsConsumerSettings$.MODULE$.apply$default$4();
        FiniteDuration x$9 = JmsConsumerSettings$.MODULE$.apply$default$6();
        int x$10 = JmsConsumerSettings$.MODULE$.apply$default$8();
        FiniteDuration x$11 = JmsConsumerSettings$.MODULE$.apply$default$9();
        FiniteDuration x$122 = JmsConsumerSettings$.MODULE$.apply$default$10();
        int x$13 = JmsConsumerSettings$.MODULE$.apply$default$12();
        Option<String> x$14 = JmsConsumerSettings$.MODULE$.apply$default$13();
        Option<String> x$15 = JmsConsumerSettings$.MODULE$.apply$default$15();
        JmsConsumerSettings settings = new JmsConsumerSettings(x$12, (Function1<FlowEnvelope, Enumeration.Value>)x$6, x$2, x$8, x$3, x$9, (Option<JmsDestination>)x$5, x$10, x$11, x$122, x$4, x$13, x$14, x$7, x$15);
        return this.jmsConsumer(((JmsDestination)settings.jmsDestination().get()).asString(), settings, (Option<FiniteDuration>)new Some((Object)this.retryCfg().retryInterval()), this.system);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> resendMessage() {
        FlowEnvelopeLogger x$1 = this.retryLog;
        FlowHeaderConfig x$2 = this.retryCfg().headerCfg();
        IdAwareConnectionFactory x$3 = this.retryCfg().cf();
        Function1 & Serializable x$4 = (Function1 & Serializable)s -> new RetryDestinationResolver(this, this.retryCfg().headerCfg(), (JmsProducerSettings)s, (Function1<FlowEnvelope, Try<FlowEnvelope>>)((Function1)$this.router.validate().apply((Object)LogLevel$.MODULE$.Trace())));
        JmsDeliveryMode x$5 = JmsDeliveryMode$.MODULE$.Persistent();
        None$ x$6 = None$.MODULE$;
        boolean x$7 = true;
        Function1 & Serializable x$8 = (Function1 & Serializable)env -> ((Try)((Function1)$this.router.validate().apply((Object)LogLevel$.MODULE$.Trace())).apply(env)).isFailure() ? LogLevel$.MODULE$.Info() : LogLevel$.MODULE$.Debug();
        JmsKeyFormatStrategy x$9 = JmsProducerSettings$.MODULE$.apply$default$4();
        FiniteDuration x$10 = JmsProducerSettings$.MODULE$.apply$default$6();
        Option<JmsDestination> x$11 = JmsProducerSettings$.MODULE$.apply$default$7();
        int x$12 = JmsProducerSettings$.MODULE$.apply$default$8();
        int x$13 = JmsProducerSettings$.MODULE$.apply$default$10();
        Function0<Option<String>> x$14 = JmsProducerSettings$.MODULE$.apply$default$13();
        JmsProducerSettings producerSettings = new JmsProducerSettings(x$1, (Function1<FlowEnvelope, Enumeration.Value>)x$8, x$2, x$9, x$3, x$10, x$11, x$12, (Function1<JmsProducerSettings, JmsDestinationResolver>)x$4, x$13, x$5, (Option<FiniteDuration>)x$6, x$14, true);
        return this.jmsProducer(new StringBuilder(10).append(this.id).append(".routeSend").toString(), producerSettings, false, this.system);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendTransaction() {
        TransactionWiretap wiretap = new TransactionWiretap(this.retryCfg().cf(), (JmsDestination)JmsDestination$.MODULE$.create(this.retryCfg().eventDestName()).get(), this.retryCfg().headerCfg(), false, this.id, this.retryLog, this.system);
        return Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.fromFunction(this.id, this.retryLog, (Function1<FlowEnvelope, Try<FlowEnvelope>>)((Function1)this.router.validate().apply((Object)LogLevel$.MODULE$.Trace())))).via(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), this.retryLog, "Creating transaction failed event")).via(wiretap.flow(true));
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToOriginal() {
        return this.resendMessage();
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> sendToRetry() {
        return this.resendMessage();
    }

    public Graph<FlowShape<FlowEnvelope, FlowEnvelope>, NotUsed> retryGraph() {
        return GraphDSL$.MODULE$.create((Function1 & Serializable)b -> {
            FlowShape route = (FlowShape)b.add($this.router.flow());
            FlowShape routeSend = (FlowShape)b.add(this.sendToOriginal());
            GraphDSL.Implicits$.MODULE$.port2flow(route.out(), b).$tilde$greater(routeSend.in(), b);
            FanOutShape2 routeErrorSplit = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JmsRetryProcessor.$anonfun$retryGraph$2(x$2))));
            GraphDSL.Implicits$.MODULE$.port2flow(routeSend.out(), b).$tilde$greater(routeErrorSplit.in(), b);
            UniformFanInShape merge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.port2flow(routeErrorSplit.out0(), b).$tilde$greater(merge.in(0), b);
            FlowShape retrySend = (FlowShape)b.add(this.sendToRetry());
            GraphDSL.Implicits$.MODULE$.port2flow(routeErrorSplit.out1(), b).$tilde$greater(retrySend, b).$tilde$greater(merge.in(1), b);
            FanOutShape2 transSplit = (FanOutShape2)b.add(FlowProcessor$.MODULE$.partition((Function1 & Serializable)env -> BoxesRunTime.boxToBoolean((boolean)JmsRetryProcessor.$anonfun$retryGraph$3(this, env))));
            UniformFanInShape transMerge = (UniformFanInShape)b.add((Graph)Merge$.MODULE$.apply(2, Merge$.MODULE$.apply$default$2()));
            GraphDSL.Implicits$.MODULE$.port2flow(merge.out(), b).$tilde$greater(transSplit.in(), b);
            GraphDSL.Implicits$.MODULE$.port2flow(transSplit.out0(), b).$tilde$greater(this.sendTransaction(), b).$tilde$greater(transMerge.in(0), b);
            GraphDSL.Implicits$.MODULE$.port2flow(transSplit.out1(), b).$tilde$greater(transMerge.in(1), b);
            FlowShape ack = (FlowShape)b.add((Graph)Flow$.MODULE$.fromGraph(FlowProcessor$.MODULE$.log(LogLevel$.MODULE$.Debug(), $this.retryLog, "Before Acknowledge")).via(new AckProcessor(new StringBuilder(4).append($this.id).append(".ack").toString()).flow()));
            GraphDSL.Implicits$.MODULE$.port2flow(transMerge.out(), b).$tilde$greater(ack.in(), b);
            return new FlowShape(route.in(), ack.out());
        });
    }

    public void start() {
        Option<ActorRef> option = this.actor;
        synchronized (option) {
            if (this.actor.isEmpty()) {
                this.log.info((Function0 & Serializable)() -> new StringBuilder(39).append("Starting Jms Retry processor [").append($this.id).append("] with [").append(this.retryCfg()).append("]").toString());
                this.actor = new Some((Object)this.system.actorOf(StreamController$.MODULE$.props(this.id, this.retrySource().via(this.retryGraph()), this.streamsCfg, (Function1 & Serializable)x$3 -> {
                    JmsRetryProcessor.$anonfun$start$2(x$3);
                    return BoxedUnit.UNIT;
                })));
            }
        }
    }

    public void stop() {
        Option<ActorRef> option = this.actor;
        synchronized (option) {
            this.actor.foreach((Function1 & Serializable)actor -> {
                this.system.stop(actor);
                return BoxedUnit.UNIT;
            });
            this.actor = None$.MODULE$;
        }
    }

    public static final /* synthetic */ boolean $anonfun$retryGraph$2(FlowEnvelope x$2) {
        return x$2.exception().isEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$retryGraph$3(JmsRetryProcessor $this, FlowEnvelope env) {
        return env.exception().isEmpty() && ((Try)((Function1)$this.router.validate().apply((Object)LogLevel$.MODULE$.Trace())).apply((Object)env)).isFailure();
    }

    public static final /* synthetic */ void $anonfun$start$2(NotUsed x$3) {
    }

    public JmsRetryProcessor(BlendedStreamsConfig streamsCfg, JmsRetryConfig retryCfg, ActorSystem system) {
        this.streamsCfg = streamsCfg;
        this.retryCfg = retryCfg;
        this.system = system;
        JmsStreamSupport.$init$(this);
        this.id = new StringBuilder(7).append(retryCfg.headerCfg().prefix()).append(".retry.").append(retryCfg.retryDestName()).toString();
        this.retryLog = FlowEnvelopeLogger$.MODULE$.create(retryCfg.headerCfg(), Logger$.MODULE$.apply(this.id));
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JmsRetryProcessor.class));
        this.actor = None$.MODULE$;
        this.router = new JmsRetryRouter("route", retryCfg, this.retryLog);
    }

    public class RetryDestinationResolver
    implements FlowHeaderConfigAware,
    JmsEnvelopeHeader {
        private final FlowHeaderConfig headerConfig;
        private final JmsProducerSettings settings;
        private final Function1<FlowEnvelope, Try<FlowEnvelope>> validator;
        private Function1<String, String> jmsHeaderPrefix;
        private Function1<String, String> srcVendorHeader;
        private Function1<String, String> srcProviderHeader;
        private Function1<String, String> srcDestHeader;
        private Function1<String, String> destHeader;
        private Function1<String, String> corrIdHeader;
        private Function1<String, String> priorityHeader;
        private Function1<String, String> expireHeader;
        private Function1<String, String> deliveryModeHeader;
        private Function1<String, String> replyToHeader;
        private Function1<String, String> timestampHeader;
        private Function1<String, String> typeHeader;
        private Function1<String, String> msgIdHeader;
        private Function1<String, String> redeliveryHeader;
        private String replyToQueueName;
        private Logger log;
        private Function1<FlowMessage, Object> priority;
        private Function1<FlowMessage, Option<FiniteDuration>> timeToLive;
        private Function1<FlowMessage, JmsDeliveryMode> deliveryMode;
        public final /* synthetic */ JmsRetryProcessor $outer;

        @Override
        public Option<String> correlationId(FlowEnvelope env) {
            return FlowHeaderConfigAware.correlationId$(this, env);
        }

        @Override
        public Try<Option<Destination>> replyTo(Session session, FlowEnvelope env) {
            return FlowHeaderConfigAware.replyTo$(this, session, env);
        }

        @Override
        public Try<JmsDestination> destination(FlowEnvelope env) {
            return FlowHeaderConfigAware.destination$(this, env);
        }

        @Override
        public Try<Message> createJmsMessage(Session session, FlowEnvelope env) {
            return JmsDestinationResolver.createJmsMessage$(this, session, env);
        }

        @Override
        public Function1<String, String> jmsHeaderPrefix() {
            return this.jmsHeaderPrefix;
        }

        @Override
        public Function1<String, String> srcVendorHeader() {
            return this.srcVendorHeader;
        }

        @Override
        public Function1<String, String> srcProviderHeader() {
            return this.srcProviderHeader;
        }

        @Override
        public Function1<String, String> srcDestHeader() {
            return this.srcDestHeader;
        }

        @Override
        public Function1<String, String> destHeader() {
            return this.destHeader;
        }

        @Override
        public Function1<String, String> corrIdHeader() {
            return this.corrIdHeader;
        }

        @Override
        public Function1<String, String> priorityHeader() {
            return this.priorityHeader;
        }

        @Override
        public Function1<String, String> expireHeader() {
            return this.expireHeader;
        }

        @Override
        public Function1<String, String> deliveryModeHeader() {
            return this.deliveryModeHeader;
        }

        @Override
        public Function1<String, String> replyToHeader() {
            return this.replyToHeader;
        }

        @Override
        public Function1<String, String> timestampHeader() {
            return this.timestampHeader;
        }

        @Override
        public Function1<String, String> typeHeader() {
            return this.typeHeader;
        }

        @Override
        public Function1<String, String> msgIdHeader() {
            return this.msgIdHeader;
        }

        @Override
        public Function1<String, String> redeliveryHeader() {
            return this.redeliveryHeader;
        }

        @Override
        public String replyToQueueName() {
            return this.replyToQueueName;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
            this.jmsHeaderPrefix = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
            this.srcVendorHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
            this.srcProviderHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
            this.srcDestHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
            this.destHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
            this.corrIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
            this.priorityHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
            this.expireHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
            this.deliveryModeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
            this.replyToHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
            this.timestampHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
            this.typeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
            this.msgIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$redeliveryHeader_$eq(Function1<String, String> x$1) {
            this.redeliveryHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
            this.replyToQueueName = x$1;
        }

        @Override
        public Logger log() {
            return this.log;
        }

        @Override
        public Function1<FlowMessage, Object> priority() {
            return this.priority;
        }

        @Override
        public Function1<FlowMessage, Option<FiniteDuration>> timeToLive() {
            return this.timeToLive;
        }

        @Override
        public Function1<FlowMessage, JmsDeliveryMode> deliveryMode() {
            return this.deliveryMode;
        }

        @Override
        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$log_$eq(Logger x$1) {
            this.log = x$1;
        }

        @Override
        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$priority_$eq(Function1<FlowMessage, Object> x$1) {
            this.priority = x$1;
        }

        @Override
        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$timeToLive_$eq(Function1<FlowMessage, Option<FiniteDuration>> x$1) {
            this.timeToLive = x$1;
        }

        @Override
        public void blended$streams$jms$FlowHeaderConfigAware$_setter_$deliveryMode_$eq(Function1<FlowMessage, JmsDeliveryMode> x$1) {
            this.deliveryMode = x$1;
        }

        @Override
        public FlowHeaderConfig headerConfig() {
            return this.headerConfig;
        }

        @Override
        public JmsProducerSettings settings() {
            return this.settings;
        }

        public Function1<FlowEnvelope, Try<FlowEnvelope>> validator() {
            return this.validator;
        }

        @Override
        public Try<JmsSendParameter> sendParameter(Session session, FlowEnvelope env) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                JmsDestination jmsDestination;
                Option<Throwable> option = env.exception();
                if (None$.MODULE$.equals(option)) {
                    jmsDestination = (JmsDestination)JmsDestination$.MODULE$.create(env.headerWithDefault(this.headerConfig().headerRetryDestination(), this.blended$streams$jms$JmsRetryProcessor$RetryDestinationResolver$$$outer().retryCfg().failedDestName(), ManifestFactory$.MODULE$.classType(String.class))).get();
                } else if (option instanceof Some) {
                    JmsDestination jmsDestination2;
                    Try try_ = (Try)this.validator().apply((Object)env);
                    if (try_ instanceof Success) {
                        jmsDestination2 = (JmsDestination)JmsDestination$.MODULE$.create(this.blended$streams$jms$JmsRetryProcessor$RetryDestinationResolver$$$outer().retryCfg().retryDestName()).get();
                    } else if (try_ instanceof Failure) {
                        jmsDestination2 = (JmsDestination)JmsDestination$.MODULE$.create(this.blended$streams$jms$JmsRetryProcessor$RetryDestinationResolver$$$outer().retryCfg().failedDestName()).get();
                    } else {
                        throw new MatchError((Object)try_);
                    }
                    jmsDestination = jmsDestination2;
                } else {
                    throw new MatchError(option);
                }
                JmsDestination dest = jmsDestination;
                return new JmsSendParameter((Message)this.createJmsMessage(session, env).get(), dest, JmsDeliveryMode$.MODULE$.Persistent(), this.settings().priority(), this.settings().timeToLive());
            });
        }

        public /* synthetic */ JmsRetryProcessor blended$streams$jms$JmsRetryProcessor$RetryDestinationResolver$$$outer() {
            return this.$outer;
        }

        public RetryDestinationResolver(JmsRetryProcessor $outer, FlowHeaderConfig headerConfig, JmsProducerSettings settings, Function1<FlowEnvelope, Try<FlowEnvelope>> validator) {
            this.headerConfig = headerConfig;
            this.settings = settings;
            this.validator = validator;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            JmsDestinationResolver.$init$(this);
            FlowHeaderConfigAware.$init$(this);
            JmsEnvelopeHeader.$init$(this);
            Statics.releaseFence();
        }
    }
}

