/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.stream.Attributes;
import akka.stream.Outlet;
import akka.stream.Outlet$;
import akka.stream.Shape;
import akka.stream.SourceShape;
import akka.stream.stage.AsyncCallback;
import akka.stream.stage.GraphStage;
import akka.stream.stage.GraphStageLogic;
import blended.jms.utils.ConnectionStateChanged;
import blended.jms.utils.ConnectionStateListener$;
import blended.jms.utils.Disconnected$;
import blended.jms.utils.JmsConnectionState;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsSession;
import blended.jms.utils.MessageReceived;
import blended.streams.AckSourceLogic;
import blended.streams.DefaultAcknowledgeContext;
import blended.streams.FlowHeaderConfig;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JmsConnector;
import blended.streams.jms.JmsConsumerSettings;
import blended.streams.jms.JmsConsumerStage$;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsFlowSupport$;
import blended.streams.message.AcknowledgeHandler;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowEnvelope$;
import blended.streams.message.FlowEnvelopeLogger;
import blended.streams.message.FlowMessage;
import blended.util.RichTry$;
import blended.util.logging.LogLevel$;
import java.io.Serializable;
import java.util.UUID;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\rUa\u0001\u0002&L\u0005IC\u0001b\u001a\u0001\u0003\u0002\u0003\u0006I\u0001\u001b\u0005\tk\u0002\u0011\t\u0011)A\u0005m\"A!\u0010\u0001B\u0001B\u0003%1\u0010\u0003\u0006\u0002\u0010\u0001\u0011\t\u0011)A\u0006\u0003#Aq!!\b\u0001\t\u0003\ty\u0002C\u0005\u0002.\u0001\u0011\r\u0011\"\u0003\u00020!A\u0011\u0011\b\u0001!\u0002\u0013\t\t\u0004C\u0005\u0002<\u0001\u0011\r\u0011\"\u0003\u0002>!A\u0011Q\t\u0001!\u0002\u0013\ty\u0004C\u0005\u0002H\u0001\u0011\r\u0011\"\u0011\u0002J!9\u00111\n\u0001!\u0002\u0013ifABA'\u0001\u0011\ty\u0005C\u0006\u0002X1\u0011\t\u0011)A\u0005Q\u0006e\u0003bCA.\u0019\t\u0005\t\u0015!\u0003b\u0003;B!\"!\u0019\r\u0005\u000b\u0007I\u0011AA2\u0011)\t\u0019\b\u0004B\u0001B\u0003%\u0011Q\r\u0005\u000b\u0003kb!Q1A\u0005\u0002\u0005]\u0004BCAC\u0019\t\u0005\t\u0015!\u0003\u0002z!Q\u0011q\u0011\u0007\u0003\u0006\u0004%\t!!#\t\u0015\u0005eEB!A!\u0002\u0013\tY\t\u0003\u0006\u0002\u001c2\u0011)\u0019!C\u0001\u0003;C!\"!)\r\u0005\u0003\u0005\u000b\u0011BAP\u0011)\t\u0019\u000b\u0004BC\u0002\u0013\u0005\u0011Q\u0014\u0005\u000b\u0003Kc!\u0011!Q\u0001\n\u0005}\u0005bBA\u000f\u0019\u0011\u0005\u0011q\u0015\u0005\b\u0003wcA\u0011IA_\u0011\u001d\ty\f\u0004C!\u0003{3a!!1\u0001\t\u0005\r\u0007bBA\u000f9\u0011\u0005\u0011\u0011\u001b\u0005\n\u0003+d\"\u0019!C)\u0003/Dq!!7\u001dA\u0003%\u0001\u000eC\u0005\u0002\\r\u0011\r\u0011\"\u0011\u0002^\"A\u0011Q\u001d\u000f!\u0002\u0013\ty\u000eC\u0005\u0002hr\u0011\r\u0011\"\u0011\u0002j\"A\u0011\u0011\u001f\u000f!\u0002\u0013\tY\u000fC\u0005\u0002tr\u0001\r\u0011\"\u0003\u0002v\"I\u0011q \u000fA\u0002\u0013%!\u0011\u0001\u0005\t\u0005\u000fa\u0002\u0015)\u0003\u0002x\"I!\u0011\u0002\u000fC\u0002\u0013%!1\u0002\u0005\t\u0005Ka\u0002\u0015!\u0003\u0003\u000e!I!q\u0005\u000fC\u0002\u0013%!\u0011\u0006\u0005\t\u0005ca\u0002\u0015!\u0003\u0003,!I!1\u0007\u000fC\u0002\u0013%\u0011q\u001b\u0005\b\u0005ka\u0002\u0015!\u0003i\u0011%\u00119\u0004\bb\u0001\n\u0013\t9\u000eC\u0004\u0003:q\u0001\u000b\u0011\u00025\t\u0011\tmB\u0004)A\u0005\u0005{A\u0001Ba\u0015\u001dA\u0013%!Q\u000b\u0005\t\u0005?b\u0002\u0015\"\u0003\u0003b!I!Q\r\u000fC\u0002\u0013%!q\r\u0005\t\u0005Wb\u0002\u0015!\u0003\u0003j!I!Q\u000e\u000fC\u0002\u0013%!q\r\u0005\t\u0005_b\u0002\u0015!\u0003\u0003j!I!\u0011\u000f\u000fC\u0002\u0013%!1\u000f\u0005\t\u0005ob\u0002\u0015!\u0003\u0003v!Q!\u0011\u0010\u000f\t\u0006\u0004%IAa\u001f\t\u000f\t\rE\u0004\"\u0015\u0003\u0006\"I!\u0011\u0012\u000fC\u0002\u0013E#1\u0012\u0005\t\u0005'c\u0002\u0015!\u0003\u0003\u000e\"I!Q\u0013\u000fA\u0002\u0013%!q\u0013\u0005\n\u00053c\u0002\u0019!C\u0005\u00057CqAa(\u001dA\u0003&1\u0010C\u0004\u0003\"r!\tFa)\t\u000f\t\u0015F\u0004\"\u0003\u0003(\"9!\u0011\u0018\u000f\u0005\n\tm\u0006b\u0002Bf9\u0011E#Q\u001a\u0005\b\u0005/dB\u0011IA_\u0011\u001d\u0011I\u000e\bC!\u0003{CqAa7\u0001\t\u0003\u0012inB\u0005\u0003p.\u000b\t\u0011#\u0001\u0003r\u001aA!jSA\u0001\u0012\u0003\u0011\u0019\u0010C\u0004\u0002\u001e\u001d#\tAa?\t\u0013\tux)%A\u0005\u0002\t}(\u0001\u0005&ng\u000e{gn];nKJ\u001cF/Y4f\u0015\taU*A\u0002k[NT!AT(\u0002\u000fM$(/Z1ng*\t\u0001+A\u0004cY\u0016tG-\u001a3\u0004\u0001M\u0011\u0001a\u0015\t\u0004)nkV\"A+\u000b\u0005Y;\u0016!B:uC\u001e,'B\u0001-Z\u0003\u0019\u0019HO]3b[*\t!,\u0001\u0003bW.\f\u0017B\u0001/V\u0005)9%/\u00199i'R\fw-\u001a\t\u0004=~\u000bW\"A,\n\u0005\u0001<&aC*pkJ\u001cWm\u00155ba\u0016\u0004\"AY3\u000e\u0003\rT!\u0001Z'\u0002\u000f5,7o]1hK&\u0011am\u0019\u0002\r\r2|w/\u00128wK2|\u0007/Z\u0001\u0005]\u0006lW\r\u0005\u0002je:\u0011!\u000e\u001d\t\u0003W:l\u0011\u0001\u001c\u0006\u0003[F\u000ba\u0001\u0010:p_Rt$\"A8\u0002\u000bM\u001c\u0017\r\\1\n\u0005Et\u0017A\u0002)sK\u0012,g-\u0003\u0002ti\n11\u000b\u001e:j]\u001eT!!\u001d8\u0002!\r|gn];nKJ\u001cV\r\u001e;j]\u001e\u001c\bCA<y\u001b\u0005Y\u0015BA=L\u0005MQUn]\"p]N,X.\u001a:TKR$\u0018N\\4t\u0003=i\u0017N\\'fgN\fw-\u001a#fY\u0006L\bc\u0001?~\u007f6\ta.\u0003\u0002\u007f]\n1q\n\u001d;j_:\u0004B!!\u0001\u0002\f5\u0011\u00111\u0001\u0006\u0005\u0003\u000b\t9!\u0001\u0005ekJ\fG/[8o\u0015\r\tIA\\\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0007\u0003\u0007\u0011aBR5oSR,G)\u001e:bi&|g.A\u0006bGR|'oU=ti\u0016l\u0007\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]\u0011,A\u0003bGR|'/\u0003\u0003\u0002\u001c\u0005U!aC!di>\u00148+_:uK6\fa\u0001P5oSRtD\u0003CA\u0011\u0003O\tI#a\u000b\u0015\t\u0005\r\u0012Q\u0005\t\u0003o\u0002Aq!a\u0004\u0006\u0001\b\t\t\u0002C\u0003h\u000b\u0001\u0007\u0001\u000eC\u0003v\u000b\u0001\u0007a\u000fC\u0004{\u000bA\u0005\t\u0019A>\u0002\u0019!,\u0017\rZ3s\u0007>tg-[4\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003ki\u0011!T\u0005\u0004\u0003oi%\u0001\u0005$m_^DU-\u00193fe\u000e{gNZ5h\u00035AW-\u00193fe\u000e{gNZ5hA\u0005\u0019q.\u001e;\u0016\u0005\u0005}\u0002\u0003\u00020\u0002B\u0005L1!a\u0011X\u0005\u0019yU\u000f\u001e7fi\u0006!q.\u001e;!\u0003\u0015\u0019\b.\u00199f+\u0005i\u0016AB:iCB,\u0007EA\u0007K[N\f5m[\"p]R,\u0007\u0010^\n\u0004\u0019\u0005E\u0003\u0003BA\u001a\u0003'J1!!\u0016N\u0005e!UMZ1vYR\f5m\u001b8po2,GmZ3D_:$X\r\u001f;\u0002\u0015%tg\r\\5hQRLE-\u0003\u0003\u0002X\u0005M\u0013aA3om&!\u0011qLA*\u0003!)gN^3m_B,\u0017A\u00036ng6+7o]1hKV\u0011\u0011Q\r\t\u0005\u0003O\ny'\u0004\u0002\u0002j)\u0019A*a\u001b\u000b\u0005\u00055\u0014!\u00026bm\u0006D\u0018\u0002BA9\u0003S\u0012q!T3tg\u0006<W-A\u0006k[NlUm]:bO\u0016\u0004\u0013!\u00046ng6+7o]1hK\u0006\u001b7.\u0006\u0002\u0002zA9A0a\u001f\u0002f\u0005}\u0014bAA?]\nIa)\u001e8di&|g.\r\t\u0004y\u0006\u0005\u0015bAAB]\n!QK\\5u\u00039QWn]'fgN\fw-Z!dW\u0002\nqa]3tg&|g.\u0006\u0002\u0002\fB!\u0011QRAK\u001b\t\tyI\u0003\u0003\u0002\u0012\u0006M\u0015!B;uS2\u001c(B\u0001'P\u0013\u0011\t9*a$\u0003\u0015)k7oU3tg&|g.\u0001\u0005tKN\u001c\u0018n\u001c8!\u00031\u0019Xm]:j_:\u001cEn\\:f+\t\ty\nE\u0004}\u0003w\nY)a \u0002\u001bM,7o]5p]\u000ecwn]3!\u00039\u0019Xm]:j_:\u0014VmY8wKJ\fqb]3tg&|gNU3d_Z,'\u000f\t\u000b\u0011\u0003S\u000bi+a,\u00022\u0006M\u0016QWA\\\u0003s\u00032!a+\r\u001b\u0005\u0001\u0001BBA,3\u0001\u0007\u0001\u000e\u0003\u0004\u0002\\e\u0001\r!\u0019\u0005\b\u0003CJ\u0002\u0019AA3\u0011\u001d\t)(\u0007a\u0001\u0003sBq!a\"\u001a\u0001\u0004\tY\tC\u0004\u0002\u001cf\u0001\r!a(\t\u000f\u0005\r\u0016\u00041\u0001\u0002 \u0006!A-\u001a8z)\t\ty(A\u0006bG.twn\u001e7fI\u001e,'A\u0004&ngN{WO]2f\u0019><\u0017nY\n\u00069\u0005\u0015\u00171\u001a\t\u0007\u0003g\t9-!+\n\u0007\u0005%WJ\u0001\bBG.\u001cv.\u001e:dK2{w-[2\u0011\u0007]\fi-C\u0002\u0002P.\u0013\u0011CS7t\u000b:4X\r\\8qK\"+\u0017\rZ3s)\t\t\u0019\u000eE\u0002\u0002,r\t!!\u001b3\u0016\u0003!\f1!\u001b3!\u0003\rawnZ\u000b\u0003\u0003?\u00042AYAq\u0013\r\t\u0019o\u0019\u0002\u0013\r2|w/\u00128wK2|\u0007/\u001a'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013aD1vi>\f5m\u001b8po2,GmZ3\u0016\u0005\u0005-\bc\u0001?\u0002n&\u0019\u0011q\u001e8\u0003\u000f\t{w\u000e\\3b]\u0006\u0001\u0012-\u001e;p\u0003\u000e\\gn\\<mK\u0012<W\rI\u0001\u000egR\fG/\u001a'jgR,g.\u001a:\u0016\u0005\u0005]\b\u0003\u0002?~\u0003s\u0004B!a\u0005\u0002|&!\u0011Q`A\u000b\u0005!\t5\r^8s%\u00164\u0017!E:uCR,G*[:uK:,'o\u0018\u0013fcR!\u0011q\u0010B\u0002\u0011%\u0011)!JA\u0001\u0002\u0004\t90A\u0002yIE\nab\u001d;bi\u0016d\u0015n\u001d;f]\u0016\u0014\b%A\u0006iC:$G.Z#se>\u0014XC\u0001B\u0007!\u0015!&q\u0002B\n\u0013\r\u0011\t\"\u0016\u0002\u000e\u0003NLhnY\"bY2\u0014\u0017mY6\u0011\t\tU!q\u0004\b\u0005\u0005/\u0011YBD\u0002l\u00053I\u0011a\\\u0005\u0004\u0005;q\u0017a\u00029bG.\fw-Z\u0005\u0005\u0005C\u0011\u0019CA\u0005UQJ|w/\u00192mK*\u0019!Q\u00048\u0002\u0019!\fg\u000e\u001a7f\u000bJ\u0014xN\u001d\u0011\u0002\u000fM\u00148\rR3tiV\u0011!1\u0006\t\u0005\u0003\u001b\u0013i#\u0003\u0003\u00030\u0005=%A\u0004&ng\u0012+7\u000f^5oCRLwN\\\u0001\tgJ\u001cG)Z:uA\u00051a/\u001a8e_J\fqA^3oI>\u0014\b%\u0001\u0005qe>4\u0018\u000eZ3s\u0003%\u0001(o\u001c<jI\u0016\u0014\b%\u0001\u0005d_:\u001cX/\\3s!\u001d\u0011yD!\u0013i\u0005\u001bj!A!\u0011\u000b\t\t\r#QI\u0001\b[V$\u0018M\u00197f\u0015\r\u00119E\\\u0001\u000bG>dG.Z2uS>t\u0017\u0002\u0002B&\u0005\u0003\u00121!T1q!\u0011\t9Ga\u0014\n\t\tE\u0013\u0011\u000e\u0002\u0010\u001b\u0016\u001c8/Y4f\u0007>t7/^7fe\u0006Y\u0011\r\u001a3D_:\u001cX/\\3s)\u0019\tyHa\u0016\u0003\\!1!\u0011\f\u0019A\u0002!\f\u0011a\u001d\u0005\b\u0005;\u0002\u0004\u0019\u0001B'\u0003\u0005\u0019\u0017A\u0004:f[>4XmQ8ogVlWM\u001d\u000b\u0005\u0003\u007f\u0012\u0019\u0007\u0003\u0004\u0003ZE\u0002\r\u0001[\u0001\u000fe\u0016\u001cwN^3s'\u0016\u001c8/[8o+\t\u0011I\u0007E\u0003U\u0005\u001f\tY)A\bsK\u000e|g/\u001a:TKN\u001c\u0018n\u001c8!\u00031\u0019Gn\\:f'\u0016\u001c8/[8o\u00035\u0019Gn\\:f'\u0016\u001c8/[8oA\u0005Q\u0011mY6NKN\u001c\u0018mZ3\u0016\u0005\tU\u0004#\u0002+\u0003\u0010\u0005\u0015\u0014aC1dW6+7o]1hK\u0002\n\u0011bY8o]\u0016\u001cGo\u001c:\u0016\u0005\tu\u0004cA<\u0003\u0000%\u0019!\u0011Q&\u0003\u0019)k7oQ8o]\u0016\u001cGo\u001c:\u0002!\u0019\u0014X-Z%oM2Lw\r\u001b;TY>$HC\u0001BD!\raX\u0010[\u0001\u000eS:4G.[4iiNcw\u000e^:\u0016\u0005\t5\u0005#\u0002B\u000b\u0005\u001fC\u0017\u0002\u0002BI\u0005G\u0011A\u0001T5ti\u0006q\u0011N\u001c4mS\u001eDGo\u00157piN\u0004\u0013\u0001\u00058fqR\u0004v\u000e\u001c7SK2\fG/\u001b<f+\u0005Y\u0018\u0001\u00068fqR\u0004v\u000e\u001c7SK2\fG/\u001b<f?\u0012*\u0017\u000f\u0006\u0003\u0002\u0000\tu\u0005\u0002\u0003B\u0003{\u0005\u0005\t\u0019A>\u0002#9,\u0007\u0010\u001e)pY2\u0014V\r\\1uSZ,\u0007%\u0001\u0005oKb$\bk\u001c7m)\u0005Y\u0018a\u0002:fG\u0016Lg/\u001a\u000b\u0005\u0005S\u00139\f\u0005\u0004\u0003,\nE&QW\u0007\u0003\u0005[S1Aa,o\u0003\u0011)H/\u001b7\n\t\tM&Q\u0016\u0002\u0004)JL\b\u0003\u0002?~\u0003KBq!a\"A\u0001\u0004\tY)\u0001\bde\u0016\fG/Z#om\u0016dw\u000e]3\u0015\r\tu&q\u0018Ba!\u0015\u0011YK!-b\u0011\u0019!\u0017\t1\u0001\u0002f!9!1Y!A\u0002\t\u0015\u0017AC1dW\"\u000bg\u000e\u001a7feB\u0019!Ma2\n\u0007\t%7M\u0001\nBG.twn\u001e7fI\u001e,\u0007*\u00198eY\u0016\u0014\u0018!\u00043p!\u0016\u0014hm\u001c:n!>dG\u000e\u0006\u0004\u0003P\nM'Q\u001b\t\u0007\u0005W\u0013\tL!5\u0011\tql\u0018\u0011\u0016\u0005\u0007\u0003+\u0014\u0005\u0019\u00015\t\u000f\t\r'\t1\u0001\u0003F\u0006A\u0001O]3Ti\u0006\u0014H/\u0001\u0005q_N$8\u000b^8q\u0003-\u0019'/Z1uK2{w-[2\u0015\t\t}'Q\u001d\t\u0004)\n\u0005\u0018b\u0001Br+\nyqI]1qQN#\u0018mZ3M_\u001eL7\rC\u0004\u0003h\u0016\u0003\rA!;\u0002'%t\u0007.\u001a:ji\u0016$\u0017\t\u001e;sS\n,H/Z:\u0011\u0007y\u0013Y/C\u0002\u0003n^\u0013!\"\u0011;ue&\u0014W\u000f^3t\u0003AQUn]\"p]N,X.\u001a:Ti\u0006<W\r\u0005\u0002x\u000fN\u0019qI!>\u0011\u0007q\u001490C\u0002\u0003z:\u0014a!\u00118z%\u00164GC\u0001By\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%gU\u00111\u0011\u0001\u0016\u0004w\u000e\r1FAB\u0003!\u0011\u00199a!\u0005\u000e\u0005\r%!\u0002BB\u0006\u0007\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\r=a.\u0001\u0006b]:|G/\u0019;j_:LAaa\u0005\u0004\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public final class JmsConsumerStage
extends GraphStage<SourceShape<FlowEnvelope>> {
    public final String blended$streams$jms$JmsConsumerStage$$name;
    public final JmsConsumerSettings blended$streams$jms$JmsConsumerStage$$consumerSettings;
    public final Option<FiniteDuration> blended$streams$jms$JmsConsumerStage$$minMessageDelay;
    public final ActorSystem blended$streams$jms$JmsConsumerStage$$actorSystem;
    private final FlowHeaderConfig blended$streams$jms$JmsConsumerStage$$headerConfig;
    private final Outlet<FlowEnvelope> blended$streams$jms$JmsConsumerStage$$out;
    private final SourceShape<FlowEnvelope> shape;

    public static Option<FiniteDuration> $lessinit$greater$default$3() {
        return JmsConsumerStage$.MODULE$.$lessinit$greater$default$3();
    }

    public FlowHeaderConfig blended$streams$jms$JmsConsumerStage$$headerConfig() {
        return this.blended$streams$jms$JmsConsumerStage$$headerConfig;
    }

    public Outlet<FlowEnvelope> blended$streams$jms$JmsConsumerStage$$out() {
        return this.blended$streams$jms$JmsConsumerStage$$out;
    }

    public SourceShape<FlowEnvelope> shape() {
        return this.shape;
    }

    public GraphStageLogic createLogic(Attributes inheritedAttributes) {
        return new JmsSourceLogic();
    }

    public JmsConsumerStage(String name, JmsConsumerSettings consumerSettings, Option<FiniteDuration> minMessageDelay, ActorSystem actorSystem) {
        this.blended$streams$jms$JmsConsumerStage$$name = name;
        this.blended$streams$jms$JmsConsumerStage$$consumerSettings = consumerSettings;
        this.blended$streams$jms$JmsConsumerStage$$minMessageDelay = minMessageDelay;
        this.blended$streams$jms$JmsConsumerStage$$actorSystem = actorSystem;
        consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(39).append("Starting consumer [").append($this.blended$streams$jms$JmsConsumerStage$$name).append("] with ackTimeout [").append($this.blended$streams$jms$JmsConsumerStage$$consumerSettings.ackTimeout()).append("]").toString());
        this.blended$streams$jms$JmsConsumerStage$$headerConfig = consumerSettings.headerCfg();
        this.blended$streams$jms$JmsConsumerStage$$out = Outlet$.MODULE$.apply(new StringBuilder(18).append("JmsAckSource(").append(name).append(".out)").toString());
        this.shape = new SourceShape(this.blended$streams$jms$JmsConsumerStage$$out());
    }

    private class JmsAckContext
    extends DefaultAcknowledgeContext {
        private final Message jmsMessage;
        private final Function1<Message, BoxedUnit> jmsMessageAck;
        private final JmsSession session;
        private final Function1<JmsSession, BoxedUnit> sessionClose;
        private final Function1<JmsSession, BoxedUnit> sessionRecover;
        public final /* synthetic */ JmsConsumerStage $outer;

        public Message jmsMessage() {
            return this.jmsMessage;
        }

        public Function1<Message, BoxedUnit> jmsMessageAck() {
            return this.jmsMessageAck;
        }

        public JmsSession session() {
            return this.session;
        }

        public Function1<JmsSession, BoxedUnit> sessionClose() {
            return this.sessionClose;
        }

        public Function1<JmsSession, BoxedUnit> sessionRecover() {
            return this.sessionRecover;
        }

        @Override
        public void deny() {
            this.sessionRecover().apply((Object)this.session());
            this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Message [").append(this.envelope().id()).append("] has been denied. Recovering receiving session.").toString(), this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
        }

        @Override
        public void acknowledge() {
            this.jmsMessageAck().apply((Object)this.jmsMessage());
            this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(super.envelope(), LogLevel$.MODULE$.Debug(), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(39).append("Acknowledged envelope [").append(this.envelope().id()).append("] for session [").append(this.session().sessionId()).append("]").toString(), this.blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
        }

        public /* synthetic */ JmsConsumerStage blended$streams$jms$JmsConsumerStage$JmsAckContext$$$outer() {
            return this.$outer;
        }

        public JmsAckContext(JmsConsumerStage $outer, String inflightId, FlowEnvelope env, Message jmsMessage, Function1<Message, BoxedUnit> jmsMessageAck, JmsSession session, Function1<JmsSession, BoxedUnit> sessionClose, Function1<JmsSession, BoxedUnit> sessionRecover) {
            this.jmsMessage = jmsMessage;
            this.jmsMessageAck = jmsMessageAck;
            this.session = session;
            this.sessionClose = sessionClose;
            this.sessionRecover = sessionRecover;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super(inflightId, env, System.currentTimeMillis());
        }
    }

    private class JmsSourceLogic
    extends AckSourceLogic<JmsAckContext>
    implements JmsEnvelopeHeader {
        private JmsConnector connector;
        private final String id;
        private final FlowEnvelopeLogger log;
        private final boolean autoAcknowledge;
        private Option<ActorRef> stateListener;
        private final AsyncCallback<Throwable> handleError;
        private final JmsDestination srcDest;
        private final String vendor;
        private final String provider;
        private final Map<String, MessageConsumer> consumer;
        private final AsyncCallback<JmsSession> recoverSession;
        private final AsyncCallback<JmsSession> closeSession;
        private final AsyncCallback<Message> ackMessage;
        private final List<String> inflightSlots;
        private Option<FiniteDuration> nextPollRelative;
        private Function1<String, String> jmsHeaderPrefix;
        private Function1<String, String> srcVendorHeader;
        private Function1<String, String> srcProviderHeader;
        private Function1<String, String> srcDestHeader;
        private Function1<String, String> destHeader;
        private Function1<String, String> corrIdHeader;
        private Function1<String, String> priorityHeader;
        private Function1<String, String> expireHeader;
        private Function1<String, String> deliveryModeHeader;
        private Function1<String, String> replyToHeader;
        private Function1<String, String> timestampHeader;
        private Function1<String, String> typeHeader;
        private Function1<String, String> msgIdHeader;
        private Function1<String, String> redeliveryHeader;
        private String replyToQueueName;
        private volatile boolean bitmap$0;

        @Override
        public Function1<String, String> jmsHeaderPrefix() {
            return this.jmsHeaderPrefix;
        }

        @Override
        public Function1<String, String> srcVendorHeader() {
            return this.srcVendorHeader;
        }

        @Override
        public Function1<String, String> srcProviderHeader() {
            return this.srcProviderHeader;
        }

        @Override
        public Function1<String, String> srcDestHeader() {
            return this.srcDestHeader;
        }

        @Override
        public Function1<String, String> destHeader() {
            return this.destHeader;
        }

        @Override
        public Function1<String, String> corrIdHeader() {
            return this.corrIdHeader;
        }

        @Override
        public Function1<String, String> priorityHeader() {
            return this.priorityHeader;
        }

        @Override
        public Function1<String, String> expireHeader() {
            return this.expireHeader;
        }

        @Override
        public Function1<String, String> deliveryModeHeader() {
            return this.deliveryModeHeader;
        }

        @Override
        public Function1<String, String> replyToHeader() {
            return this.replyToHeader;
        }

        @Override
        public Function1<String, String> timestampHeader() {
            return this.timestampHeader;
        }

        @Override
        public Function1<String, String> typeHeader() {
            return this.typeHeader;
        }

        @Override
        public Function1<String, String> msgIdHeader() {
            return this.msgIdHeader;
        }

        @Override
        public Function1<String, String> redeliveryHeader() {
            return this.redeliveryHeader;
        }

        @Override
        public String replyToQueueName() {
            return this.replyToQueueName;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
            this.jmsHeaderPrefix = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
            this.srcVendorHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
            this.srcProviderHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
            this.srcDestHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
            this.destHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
            this.corrIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
            this.priorityHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
            this.expireHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
            this.deliveryModeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
            this.replyToHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
            this.timestampHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
            this.typeHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
            this.msgIdHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$redeliveryHeader_$eq(Function1<String, String> x$1) {
            this.redeliveryHeader = x$1;
        }

        @Override
        public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
            this.replyToQueueName = x$1;
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public FlowEnvelopeLogger log() {
            return this.log;
        }

        @Override
        public boolean autoAcknowledge() {
            return this.autoAcknowledge;
        }

        private Option<ActorRef> stateListener() {
            return this.stateListener;
        }

        private void stateListener_$eq(Option<ActorRef> x$1) {
            this.stateListener = x$1;
        }

        private AsyncCallback<Throwable> handleError() {
            return this.handleError;
        }

        private JmsDestination srcDest() {
            return this.srcDest;
        }

        private String vendor() {
            return this.vendor;
        }

        private String provider() {
            return this.provider;
        }

        private void addConsumer(String s, MessageConsumer c) {
            this.consumer.put((Object)s, (Object)c);
            this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(30).append("Jms Consumer count of [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$name).append("] is [").append($this.consumer.size()).append("]").toString());
            this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
            this.pollImmediately().invoke((Object)BoxedUnit.UNIT);
        }

        private void removeConsumer(String s) {
            this.consumer.remove((Object)s);
            this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(26).append("Consumer count of [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$name).append("] is [").append($this.consumer.size()).append("]").toString());
        }

        private AsyncCallback<JmsSession> recoverSession() {
            return this.recoverSession;
        }

        private AsyncCallback<JmsSession> closeSession() {
            return this.closeSession;
        }

        private AsyncCallback<Message> ackMessage() {
            return this.ackMessage;
        }

        private JmsConnector connector$lzycompute() {
            JmsSourceLogic jmsSourceLogic = this;
            synchronized (jmsSourceLogic) {
                if (!this.bitmap$0) {
                    this.connector = new JmsConnector(this.id(), this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings, (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)session -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(42).append("Creating message consumer for session [").append(session.sessionId()).append("], ").toString()).append(new StringBuilder(30).append("destination [").append(this.srcDest()).append("] and selector [").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.selector()).append("]").toString()).toString());
                        Try try_ = session.createConsumer(this.srcDest(), $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.selector());
                        if (try_ instanceof Success) {
                            Success success = (Success)try_;
                            MessageConsumer c = (MessageConsumer)success.value();
                            this.addConsumer(session.sessionId(), c);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(45).append("Failed to create consumer for session [").append(session.sessionId()).append("] : [").append(e.getMessage()).append("]").toString());
                            this.closeSession().invoke(session);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                    }), (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)s -> Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> $this.consumer.get((Object)s.sessionId()).foreach((Function1 & Serializable)c -> {
                        JmsSourceLogic.$anonfun$connector$7(this, s, c);
                        return BoxedUnit.UNIT;
                    })), (Function1<JmsSession, Try<BoxedUnit>>)(Function1 & Serializable)x$1 -> new Success((Object)BoxedUnit.UNIT), (Function1<Throwable, BoxedUnit>)(Function1 & Serializable)t -> {
                        JmsSourceLogic.$anonfun$connector$10(this, t);
                        return BoxedUnit.UNIT;
                    });
                    this.bitmap$0 = true;
                }
            }
            return this.connector;
        }

        private JmsConnector connector() {
            return !this.bitmap$0 ? this.connector$lzycompute() : this.connector;
        }

        @Override
        public Option<String> freeInflightSlot() {
            Some some;
            Option<String> option = this.determineNextSlot((List<String>)this.inflightSlots().filter((Function1 & Serializable)id -> BoxesRunTime.boxToBoolean((boolean)JmsSourceLogic.$anonfun$freeInflightSlot$1(this, id))));
            if (option instanceof Some) {
                Some some2 = (Some)option;
                String s = (String)some2.value();
                some = new Some((Object)s);
            } else if (None$.MODULE$.equals(option)) {
                some = this.determineNextSlot(this.inflightSlots());
            } else {
                throw new MatchError(option);
            }
            return some;
        }

        @Override
        public List<String> inflightSlots() {
            return this.inflightSlots;
        }

        private Option<FiniteDuration> nextPollRelative() {
            return this.nextPollRelative;
        }

        private void nextPollRelative_$eq(Option<FiniteDuration> x$1) {
            this.nextPollRelative = x$1;
        }

        @Override
        public Option<FiniteDuration> nextPoll() {
            Some some;
            Option<FiniteDuration> option = this.nextPollRelative();
            if (None$.MODULE$.equals(option)) {
                some = new Some((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.pollInterval());
            } else if (option instanceof Some) {
                Some some2 = (Some)option;
                FiniteDuration npr = (FiniteDuration)some2.value();
                this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
                this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(37).append("Overriding next poll interval with [").append(npr).append("]").toString());
                some = new Some((Object)npr);
            } else {
                throw new MatchError(option);
            }
            return some;
        }

        private Try<Option<Message>> receive(JmsSession session) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                None$ none$;
                Option msg = $this.consumer.get((Object)session.sessionId()).flatMap((Function1 & Serializable)c -> $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.receiveTimeout().toMillis() <= 0L ? Option$.MODULE$.apply((Object)c.receiveNoWait()) : Option$.MODULE$.apply((Object)c.receive($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.receiveTimeout().toMillis())));
                Option option = msg;
                if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else if (option instanceof Some) {
                    Option option2;
                    Some some = (Some)option;
                    Message m = (Message)some.value();
                    Option<FiniteDuration> option3 = $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$minMessageDelay;
                    if (option3 instanceof Some) {
                        Some some2;
                        Some some3 = (Some)option3;
                        FiniteDuration d = (FiniteDuration)some3.value();
                        long age = System.currentTimeMillis() - m.getJMSTimestamp();
                        if (age <= d.toMillis()) {
                            this.closeSession().invoke((Object)session);
                            this.nextPollRelative_$eq((Option<FiniteDuration>)new Some((Object)new package.DurationLong(package$.MODULE$.DurationLong(d.toMillis() - age)).millis()));
                            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(75).append("Message has not reached the minimum message delay yet ...rescheduling in [").append(this.nextPollRelative()).append("]").toString());
                            some2 = None$.MODULE$;
                        } else {
                            this.nextPollRelative_$eq((Option<FiniteDuration>)None$.MODULE$);
                            some2 = new Some((Object)m);
                        }
                        option2 = some2;
                    } else if (None$.MODULE$.equals(option3)) {
                        option2 = msg;
                    } else {
                        throw new MatchError(option3);
                    }
                    none$ = option2;
                } else {
                    throw new MatchError((Object)option);
                }
                None$ result = none$;
                return result;
            });
        }

        private Try<FlowEnvelope> createEnvelope(Message message, AcknowledgeHandler ackHandler) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                String string;
                FlowMessage flowMessage = (FlowMessage)RichTry$.MODULE$.toRichTry((Try)((Function1)((Function1)JmsFlowSupport$.MODULE$.jms2flowMessage().apply((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig())).apply((Object)$this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings)).apply((Object)message)).unwrap();
                Option option = flowMessage.header(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().headerTransId(), ManifestFactory$.MODULE$.classType(String.class));
                if (None$.MODULE$.equals(option)) {
                    String newId = UUID.randomUUID().toString();
                    $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().trace((Function0 & Serializable)() -> new StringBuilder(26).append("Created new envelope id [").append(newId).append("]").toString());
                    string = newId;
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String s = (String)some.value();
                    $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().trace((Function0 & Serializable)() -> new StringBuilder(40).append("Reusing transaction id [").append(s).append("] as envelope id").toString());
                    string = s;
                } else {
                    throw new MatchError(option);
                }
                String envelopeId = string;
                FlowEnvelope qual$1 = FlowEnvelope$.MODULE$.apply(flowMessage, envelopeId);
                String x$1 = this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().headerTransId();
                String x$2 = envelopeId;
                boolean x$3 = qual$1.withHeader$default$3();
                return ((FlowEnvelope)RichTry$.MODULE$.toRichTry(qual$1.withHeader(x$1, x$2, x$3)).unwrap()).withRequiresAcknowledge(true).withAckHandler((Option<AcknowledgeHandler>)new Some((Object)ackHandler));
            });
        }

        @Override
        public Try<Option<JmsAckContext>> doPerformPoll(String id, AcknowledgeHandler ackHandler) {
            return Try$.MODULE$.apply((Function0 & Serializable)() -> {
                None$ none$;
                Option<JmsSession> option = this.connector().getSession(id);
                if (option instanceof Some) {
                    Some some = (Some)option;
                    JmsSession s = (JmsSession)some.value();
                    none$ = ((Option)RichTry$.MODULE$.toRichTry(this.receive(s)).unwrap()).map((Function1 & Serializable)m -> {
                        FlowEnvelope e = (FlowEnvelope)RichTry$.MODULE$.toRichTry(this.createEnvelope((Message)m, ackHandler)).unwrap();
                        long now = System.currentTimeMillis();
                        long msgAge = now - BoxesRunTime.unboxToLong((Object)e.header((String)this.timestampHeader().apply((Object)this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$headerConfig().prefix()), ManifestFactory$.MODULE$.Long()).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> now));
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv(e, (Enumeration.Value)$this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.logLevel().apply((Object)e), (Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(28).append("Message received [").append(e.id()).append("][").append($this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.jmsDestination().map((Function1 & Serializable)x$2 -> x$2.asString())).append("] after ").toString()).append(new StringBuilder(13).append("[").append(msgAge).append("]ms in [").append(s.sessionId()).append("] : ").append(e.flowMessage()).toString()).toString(), $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().logEnv$default$4());
                        $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem.eventStream().publish((Object)new MessageReceived(this.vendor(), this.provider(), e.id()));
                        return new JmsAckContext(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer(), id, e, (Message)m, (Function1<Message, BoxedUnit>)(Function1 & Serializable)t -> {
                            JmsSourceLogic.$anonfun$doPerformPoll$6(this, t);
                            return BoxedUnit.UNIT;
                        }, s, (Function1<JmsSession, BoxedUnit>)(Function1 & Serializable)t -> {
                            JmsSourceLogic.$anonfun$doPerformPoll$7(this, t);
                            return BoxedUnit.UNIT;
                        }, (Function1<JmsSession, BoxedUnit>)(Function1 & Serializable)t -> {
                            JmsSourceLogic.$anonfun$doPerformPoll$8(this, t);
                            return BoxedUnit.UNIT;
                        });
                    });
                } else if (None$.MODULE$.equals(option)) {
                    none$ = None$.MODULE$;
                } else {
                    throw new MatchError(option);
                }
                return none$;
            });
        }

        @Override
        public void preStart() {
            super.preStart();
            this.stateListener_$eq((Option<ActorRef>)new Some((Object)ConnectionStateListener$.MODULE$.create(this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().vendor(), this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().provider(), (Function1 & Serializable)event -> {
                JmsSourceLogic.$anonfun$preStart$1(this, event);
                return BoxedUnit.UNIT;
            }, this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem)));
        }

        @Override
        public void postStop() {
            this.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(29).append("Stopping JmsConsumerStage [").append(this.id()).append("].").toString());
            this.stateListener().foreach((Function1 & Serializable)actor -> {
                this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$actorSystem.stop(actor);
                return BoxedUnit.UNIT;
            });
            this.connector().closeAll();
            super.postStop();
        }

        public /* synthetic */ JmsConsumerStage blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer() {
            return JmsConsumerStage.this;
        }

        public static final /* synthetic */ void $anonfun$closeSession$1(JmsSourceLogic $this, JmsSession s) {
            $this.connector().closeSession(s.sessionId());
        }

        public static final /* synthetic */ void $anonfun$connector$7(JmsSourceLogic $this, JmsSession s$1, MessageConsumer c) {
            $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> new StringBuilder(31).append("Closing message consumer for [").append(s$1.sessionId()).append("]").toString());
            c.close();
            $this.removeConsumer(s$1.sessionId());
        }

        public static final /* synthetic */ void $anonfun$connector$10(JmsSourceLogic $this, Throwable t) {
            $this.handleError().invoke((Object)t);
        }

        public static final /* synthetic */ boolean $anonfun$freeInflightSlot$1(JmsSourceLogic $this, String id) {
            return $this.connector().isOpen(id);
        }

        public static final /* synthetic */ String $anonfun$inflightSlots$1(JmsSourceLogic $this, int i) {
            return new StringBuilder(1).append($this.id()).append("-").append(i).toString();
        }

        public static final /* synthetic */ void $anonfun$doPerformPoll$6(JmsSourceLogic $this, Message t) {
            $this.ackMessage().invoke((Object)t);
        }

        public static final /* synthetic */ void $anonfun$doPerformPoll$7(JmsSourceLogic $this, JmsSession t) {
            $this.closeSession().invoke((Object)t);
        }

        public static final /* synthetic */ void $anonfun$doPerformPoll$8(JmsSourceLogic $this, JmsSession t) {
            $this.recoverSession().invoke((Object)t);
        }

        public static final /* synthetic */ void $anonfun$preStart$1(JmsSourceLogic $this, ConnectionStateChanged event) {
            JmsConnectionState jmsConnectionState = event.state().status();
            if (Disconnected$.MODULE$.equals(jmsConnectionState)) {
                String msg = new StringBuilder(39).append("Underlying JMS connection closed for [").append($this.id()).append("]").toString();
                $this.blended$streams$jms$JmsConsumerStage$JmsSourceLogic$$$outer().blended$streams$jms$JmsConsumerStage$$consumerSettings.log().underlying().debug((Function0 & Serializable)() -> msg);
                Exception t = new Exception(msg);
                $this.handleError().invoke((Object)t);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }

        public JmsSourceLogic() {
            JmsDestination d;
            if (JmsConsumerStage.this == null) {
                throw null;
            }
            super((Shape)JmsConsumerStage.this.shape(), JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$out(), JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.ackTimeout());
            JmsEnvelopeHeader.$init$(this);
            this.id = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$name;
            this.log = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.log();
            AcknowledgeMode acknowledgeMode = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.acknowledgeMode();
            AcknowledgeMode acknowledgeMode2 = AcknowledgeMode$.MODULE$.AutoAcknowledge();
            this.autoAcknowledge = !(acknowledgeMode != null ? !acknowledgeMode.equals(acknowledgeMode2) : acknowledgeMode2 != null);
            this.stateListener = None$.MODULE$;
            this.handleError = this.getAsyncCallback((Function1 & Serializable)t -> {
                this.failStage(t);
                return BoxedUnit.UNIT;
            });
            Option<JmsDestination> option = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.jmsDestination();
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new IllegalArgumentException(new StringBuilder(42).append("Destination must be set for consumer in [").append(this.id()).append("]").toString());
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            JmsDestination jmsDestination = d = (JmsDestination)some.value();
            this.srcDest = jmsDestination;
            this.vendor = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().vendor();
            this.provider = JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.connectionFactory().provider();
            this.consumer = (Map)Map$.MODULE$.empty();
            this.recoverSession = this.getAsyncCallback((Function1 & Serializable)s -> {
                s.recoverSession();
                return BoxedUnit.UNIT;
            });
            this.closeSession = this.getAsyncCallback((Function1 & Serializable)s -> {
                JmsSourceLogic.$anonfun$closeSession$1(this, s);
                return BoxedUnit.UNIT;
            });
            this.ackMessage = this.getAsyncCallback((Function1 & Serializable)m -> {
                m.acknowledge();
                return BoxedUnit.UNIT;
            });
            this.inflightSlots = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), JmsConsumerStage.this.blended$streams$jms$JmsConsumerStage$$consumerSettings.sessionCount()).map((Function1 & Serializable)i -> JmsSourceLogic.$anonfun$inflightSlots$1(this, BoxesRunTime.unboxToInt((Object)i))).toList();
            this.nextPollRelative = None$.MODULE$;
            Statics.releaseFence();
        }
    }
}

