/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.transaction.internal;

import akka.NotUsed;
import akka.actor.ActorSystem;
import akka.actor.ClassicActorSystemProvider;
import akka.stream.Graph;
import akka.stream.Materializer$;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.Sink$;
import akka.stream.scaladsl.Source;
import akka.stream.scaladsl.Source$;
import blended.streams.json.PrickleProtocol$;
import blended.streams.message.MsgProperty;
import blended.streams.transaction.FlowTransaction;
import blended.streams.transaction.FlowTransaction$;
import blended.streams.transaction.FlowTransactionEvent;
import blended.streams.transaction.FlowTransactionManager;
import blended.streams.transaction.FlowTransactionManagerConfig;
import blended.streams.transaction.FlowTransactionState;
import blended.streams.transaction.FlowTransactionState$;
import blended.streams.transaction.FlowTransactionStateCompleted$;
import blended.streams.transaction.FlowTransactionStateFailed$;
import blended.streams.transaction.FlowTransactionStateStarted$;
import blended.streams.transaction.internal.FileFlowTransactionManager$;
import blended.streams.transaction.internal.FileFlowTransactionManager$FilteredDirectoryStream$;
import blended.streams.worklist.WorklistState;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Date;
import prickle.PConfig;
import prickle.PConfig$;
import prickle.Pickle$;
import prickle.Unpickle$;
import prickle.UnpickledCurry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.io.BufferedSource;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction2;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t}r!B\u0016-\u0011\u0003)d!B\u001c-\u0011\u0003A\u0004\"B \u0002\t\u0003\u0001\u0005\"B!\u0002\t\u0003\u0011e\u0001B\u001c-\u0001\u0015C\u0001B\u0013\u0003\u0003\u0006\u0004%\te\u0013\u0005\t\u001f\u0012\u0011\t\u0011)A\u0005\u0019\"A\u0001\u000b\u0002B\u0001B\u0003-\u0011\u000bC\u0003@\t\u0011\u0005\u0011\fC\u0004^\t\t\u0007I\u0011\u00020\t\r\u001d$\u0001\u0015!\u0003`\u0011\u001dAGA1A\u0005\f%Da\u0001\u001d\u0003!\u0002\u0013Q\u0007bB9\u0005\u0005\u0004%IA\u001d\u0005\u0007w\u0012\u0001\u000b\u0011B:\t\u0011q$\u0001R1A\u0005\nuDq!a\u0001\u0005\t\u0003\n)\u0001C\u0004\u0002\"\u0011!\t%a\t\t\u000f\u0005-C\u0001\"\u0011\u0002N!9\u0011q\u000b\u0003\u0005B\u0005e\u0003bBA7\t\u0011\u0005\u0013q\u000e\u0005\n\u0003\u0003#!\u0019!C\u0005\u0003\u0007C\u0001\"a\"\u0005A\u0003%\u0011Q\u0011\u0005\b\u0003\u0013#A\u0011BAF\u0011\u001d\t)\n\u0002C\u0005\u0003/Cq!a'\u0005\t\u0013\ti\nC\u0004\u0002$\u0012!I!!*\t\u000f\u0005-F\u0001\"\u0003\u0002.\"9!\u0011\u0003\u0003\u0005\n\tM\u0001b\u0002B\u000f\t\u0011%!qD\u0004\b\u0005O!\u0001\u0012\u0002B\u0015\r\u001d\tY\r\u0002E\u0005\u0005WAaaP\u0010\u0005\u0002\t5\u0002b\u0002B\u0018?\u0011\u0005!\u0011\u0007\u0005\b\u0005kyB\u0011\u0001B\u001c\r\u0019\tY\r\u0002\u0003\u0002N\"Q\u0011QM\u0012\u0003\u0002\u0003\u0006I!a4\t\r}\u001aC\u0011AAq\u0011%\t)o\tb\u0001\n\u0013\t9\u000f\u0003\u0005\u0002p\u000e\u0002\u000b\u0011BAu\u0011%\t\tp\tb\u0001\n\u0003\t\u0019\u0010\u0003\u0005\u0003\f\r\u0002\u000b\u0011BA{\u0011\u001d\u0011ia\tC\u0001\u0005\u001f\t!DR5mK\u001acwn\u001e+sC:\u001c\u0018m\u0019;j_:l\u0015M\\1hKJT!!\f\u0018\u0002\u0011%tG/\u001a:oC2T!a\f\u0019\u0002\u0017Q\u0014\u0018M\\:bGRLwN\u001c\u0006\u0003cI\nqa\u001d;sK\u0006l7OC\u00014\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001\u0001\u0005\u00027\u00035\tAF\u0001\u000eGS2,g\t\\8x)J\fgn]1di&|g.T1oC\u001e,'o\u0005\u0002\u0002sA\u0011!(P\u0007\u0002w)\tA(A\u0003tG\u0006d\u0017-\u0003\u0002?w\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u001b\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007\r\u0013i\u0004F\u0002E\u0005w\u0001\"A\u000e\u0003\u0014\u0007\u0011Id\t\u0005\u0002H\u00116\ta&\u0003\u0002J]\t1b\t\\8x)J\fgn]1di&|g.T1oC\u001e,'/\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0019B\u0011q)T\u0005\u0003\u001d:\u0012AD\u00127poR\u0013\u0018M\\:bGRLwN\\'b]\u0006<WM]\"p]\u001aLw-A\u0004d_:4\u0017n\u001a\u0011\u0002\rML8\u000f^3n!\t\u0011v+D\u0001T\u0015\t!V+A\u0003bGR|'OC\u0001W\u0003\u0011\t7n[1\n\u0005a\u001b&aC!di>\u00148+_:uK6$\"A\u0017/\u0015\u0005\u0011[\u0006\"\u0002)\t\u0001\b\t\u0006\"\u0002&\t\u0001\u0004a\u0015a\u00017pOV\tq\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u00069An\\4hS:<'B\u000133\u0003\u0011)H/\u001b7\n\u0005\u0019\f'A\u0002'pO\u001e,'/\u0001\u0003m_\u001e\u0004\u0013!B3Dib$X#\u00016\u0011\u0005-tW\"\u00017\u000b\u00055\\\u0014AC2p]\u000e,(O]3oi&\u0011q\u000e\u001c\u0002\u0011\u000bb,7-\u001e;j_:\u001cuN\u001c;fqR\fa!Z\"uqR\u0004\u0013a\u00013jeV\t1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006\u0011\u0011n\u001c\u0006\u0002q\u0006!!.\u0019<b\u0013\tQXO\u0001\u0003GS2,\u0017\u0001\u00023je\u0002\n1\"\u001b8ji&\fG.\u001b>fIV\ta\u0010\u0005\u0002;\u007f&\u0019\u0011\u0011A\u001e\u0003\u000f\t{w\u000e\\3b]\u0006\tR\u000f\u001d3bi\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0015\t\u0005\u001d\u0011q\u0003\t\u0007\u0003\u0013\ti!!\u0005\u000e\u0005\u0005-!B\u00013<\u0013\u0011\ty!a\u0003\u0003\u0007Q\u0013\u0018\u0010E\u0002H\u0003'I1!!\u0006/\u0005=1En\\<Ue\u0006t7/Y2uS>t\u0007bBA\r!\u0001\u0007\u00111D\u0001\u0002KB\u0019q)!\b\n\u0007\u0005}aF\u0001\u000bGY><HK]1og\u0006\u001cG/[8o\u000bZ,g\u000e^\u0001\u0010M&tG\r\u0016:b]N\f7\r^5p]R!\u0011QEA\u0019!\u0015Y\u0017qEA\u0016\u0013\r\tI\u0003\u001c\u0002\u0007\rV$XO]3\u0011\u000bi\ni#!\u0005\n\u0007\u0005=2H\u0001\u0004PaRLwN\u001c\u0005\b\u0003g\t\u0002\u0019AA\u001b\u0003\r!\u0018\u000e\u001a\t\u0005\u0003o\t)E\u0004\u0003\u0002:\u0005\u0005\u0003cAA\u001ew5\u0011\u0011Q\b\u0006\u0004\u0003\u007f!\u0014A\u0002\u001fs_>$h(C\u0002\u0002Dm\na\u0001\u0015:fI\u00164\u0017\u0002BA$\u0003\u0013\u0012aa\u0015;sS:<'bAA\"w\u0005\t\"/Z7pm\u0016$&/\u00198tC\u000e$\u0018n\u001c8\u0015\t\u0005=\u0013Q\u000b\t\u0004u\u0005E\u0013bAA*w\t!QK\\5u\u0011\u001d\t\u0019D\u0005a\u0001\u0003k\tqa^5uQ\u0006cG\u000e\u0006\u0003\u0002\\\u0005\r\u0004#B6\u0002(\u0005u\u0003c\u0001\u001e\u0002`%\u0019\u0011\u0011M\u001e\u0003\u0007%sG\u000fC\u0004\u0002fM\u0001\r!a\u001a\u0002\u0003\u0019\u0004bAOA5\u0003#q\u0018bAA6w\tIa)\u001e8di&|g.M\u0001\bG2,\u0017M\\+q)\u0011\tY&!\u001d\t\u000f\u0005MD\u00031\u0001\u0002v\u000511\u000f^1uKN\u0004RAOA<\u0003wJ1!!\u001f<\u0005)a$/\u001a9fCR,GM\u0010\t\u0004\u000f\u0006u\u0014bAA@]\t!b\t\\8x)J\fgn]1di&|gn\u0015;bi\u0016\f\u0001BZ5mK:\fW.Z\u000b\u0003\u0003\u000b\u0003rAOA5\u0003#\t)$A\u0005gS2,g.Y7fA\u0005)1\u000f^8sKR1\u0011qAAG\u0003#Cq!a$\u0018\u0001\u0004\tY#A\u0002pY\u0012Dq!a%\u0018\u0001\u0004\t\t\"A\u0004dQ\u0006tw-\u001a3\u0002/1|\u0017\rZ#ySN$\u0018N\\4Ue\u0006t7/Y2uS>tG\u0003BA\u0004\u00033Ca!!\u001a\u0019\u0001\u0004\u0019\u0018a\u00047pC\u0012$&/\u00198tC\u000e$\u0018n\u001c8\u0015\t\u0005}\u0015\u0011\u0015\t\u0007\u0003\u0013\ti!a\u000b\t\r\u0005\u0015\u0014\u00041\u0001t\u0003!aw.\u00193GS2,G\u0003BAT\u0003S\u0003b!!\u0003\u0002\u000e\u0005U\u0002BBA35\u0001\u00071/\u0001\nnCB$\u0015N]3di>\u0014\u0018p\u0015;sK\u0006lG\u0003BAX\u0003\u0007\u0004Ra[A\u0014\u0003c\u0003b!a-\u0002>\u0006Ea\u0002BA[\u0003ssA!a\u000f\u00028&\tA(C\u0002\u0002<n\nq\u0001]1dW\u0006<W-\u0003\u0003\u0002@\u0006\u0005'aA*fc*\u0019\u00111X\u001e\t\u000f\u0005\u00157\u00041\u0001\u0002H\u0006IA-\u001b:TiJ,\u0017-\u001c\t\u0004\u0003\u0013\u001cS\"\u0001\u0003\u0003/\u0019KG\u000e^3sK\u0012$\u0015N]3di>\u0014\u0018p\u0015;sK\u0006l7CA\u0012:!\u0019Q\u0014\u0011NAi}B!\u00111[Ao\u001b\t\t)N\u0003\u0003\u0002X\u0006e\u0017\u0001\u00024jY\u0016T1!a7x\u0003\rq\u0017n\\\u0005\u0005\u0003?\f)N\u0001\u0003QCRDG\u0003BAd\u0003GDq!!\u001a&\u0001\u0004\ty-\u0001\u0004tiJ,\u0017-\\\u000b\u0003\u0003S\u0004b!a5\u0002l\u0006E\u0017\u0002BAw\u0003+\u0014q\u0002R5sK\u000e$xN]=TiJ,\u0017-\\\u0001\bgR\u0014X-Y7!\u0003\u001d)g\u000e\u001e:jKN,\"!!>\u0011\u0011\u0005]\u0018q`Ai\u0005\u0007i!!!?\u000b\t\u0005m\u0018Q`\u0001\tg\u000e\fG.\u00193tY*\u0019\u0011Q]+\n\t\t\u0005\u0011\u0011 \u0002\u0007'>,(oY3\u0011\t\t\u0015!qA\u0007\u0002+&\u0019!\u0011B+\u0003\u000f9{G/V:fI\u0006AQM\u001c;sS\u0016\u001c\b%A\u0003dY>\u001cX\r\u0006\u0002\u0002P\u0005aR.\u00199ESJ,7\r^8ssN#(/Z1n/&$\bNR5mi\u0016\u0014H\u0003\u0002B\u000b\u00057!B!a,\u0003\u0018!9!\u0011\u0004\u000fA\u0002\u0005\u001d\u0014AB:fY\u0016\u001cG\u000fC\u0004\u0002Fr\u0001\r!a2\u0002']LG\u000f\u001b#je\u0016\u001cGo\u001c:z'R\u0014X-Y7\u0015\t\t\u0005\"Q\u0005\u000b\u0005\u00037\u0012\u0019\u0003C\u0004\u0002fu\u0001\r!a4\t\u000f\u0005\u0015W\u00041\u0001\u0002H\u00069b)\u001b7uKJ,G\rR5sK\u000e$xN]=TiJ,\u0017-\u001c\t\u0004\u0003\u0013|2CA\u0010:)\t\u0011I#A\u0005uS\u0012\u001cFO]3b[R!\u0011q\u0019B\u001a\u0011\u001d\t\u0019$\ta\u0001\u0003k\tAc\u001d;bi\u0016$\u0015N]3di>\u0014\u0018p\u0015;sK\u0006lG\u0003BAd\u0005sAq!a\u001d#\u0001\u0004\t)\bC\u0003Q\u0007\u0001\u000f\u0011\u000bC\u0003r\u0007\u0001\u00071\u000f")
public class FileFlowTransactionManager
implements FlowTransactionManager {
    private boolean initialized;
    private volatile FileFlowTransactionManager$FilteredDirectoryStream$ FilteredDirectoryStream$module;
    private final FlowTransactionManagerConfig config;
    private final ActorSystem system;
    private final Logger blended$streams$transaction$internal$FileFlowTransactionManager$$log;
    private final ExecutionContext eCtxt;
    private final File blended$streams$transaction$internal$FileFlowTransactionManager$$dir;
    private final Function1<FlowTransaction, String> filename;
    private volatile boolean bitmap$0;

    public static FileFlowTransactionManager apply(File file, ActorSystem actorSystem) {
        return FileFlowTransactionManager$.MODULE$.apply(file, actorSystem);
    }

    @Override
    public Future<Object> clearTransactions() {
        return FlowTransactionManager.clearTransactions$(this);
    }

    @Override
    public Future<Object> withCompleted(Function1<FlowTransaction, BoxedUnit> f) {
        return FlowTransactionManager.withCompleted$(this, f);
    }

    @Override
    public Future<Object> withFailed(Function1<FlowTransaction, BoxedUnit> f) {
        return FlowTransactionManager.withFailed$(this, f);
    }

    @Override
    public Future<Object> withOpen(Function1<FlowTransaction, BoxedUnit> f) {
        return FlowTransactionManager.withOpen$(this, f);
    }

    @Override
    public Future<Object> withTransactions(Function1<FlowTransaction, Object> select, Function1<FlowTransaction, BoxedUnit> f) {
        return FlowTransactionManager.withTransactions$(this, select, f);
    }

    @Override
    public Future<Object> cleanUp() {
        return FlowTransactionManager.cleanUp$(this);
    }

    private FileFlowTransactionManager$FilteredDirectoryStream$ FilteredDirectoryStream() {
        if (this.FilteredDirectoryStream$module == null) {
            this.FilteredDirectoryStream$lzycompute$1();
        }
        return this.FilteredDirectoryStream$module;
    }

    @Override
    public FlowTransactionManagerConfig config() {
        return this.config;
    }

    public Logger blended$streams$transaction$internal$FileFlowTransactionManager$$log() {
        return this.blended$streams$transaction$internal$FileFlowTransactionManager$$log;
    }

    private ExecutionContext eCtxt() {
        return this.eCtxt;
    }

    public File blended$streams$transaction$internal$FileFlowTransactionManager$$dir() {
        return this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir;
    }

    private boolean initialized$lzycompute() {
        FileFlowTransactionManager fileFlowTransactionManager = this;
        synchronized (fileFlowTransactionManager) {
            if (!this.bitmap$0) {
                if (!this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().exists()) {
                    if (!this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().mkdirs()) {
                        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(29).append("Unable to create directory [").append(this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().getAbsolutePath()).append("]").toString());
                    } else {
                        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().info((Function0 & Serializable)() -> new StringBuilder(48).append("Created directory [").append(this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().getAbsolutePath()).append("] to persist FlowTransactions").toString());
                    }
                }
                this.initialized = this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().exists() && this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().canRead() && this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().canWrite() && this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().isDirectory();
                this.bitmap$0 = true;
            }
        }
        return this.initialized;
    }

    private boolean initialized() {
        return !this.bitmap$0 ? this.initialized$lzycompute() : this.initialized;
    }

    @Override
    public Try<FlowTransaction> updateTransaction(FlowTransactionEvent e) {
        Future fut = this.findTransaction(e.transactionId()).map((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2;
            Option option = x0$1;
            if (None$.MODULE$.equals(option)) {
                Date now = new Date();
                this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().trace((Function0 & Serializable)() -> new StringBuilder(26).append("Storing new transaction [").append(e.transactionId()).append("]").toString());
                String x$1 = e.transactionId();
                Date x$2 = now;
                Date x$3 = now;
                Map<String, MsgProperty> x$4 = e.properties();
                boolean x$5 = true;
                Map<String, List<WorklistState>> x$6 = FlowTransaction$.MODULE$.apply$default$6();
                FlowTransactionState x$7 = FlowTransaction$.MODULE$.apply$default$7();
                FlowTransaction newT = new FlowTransaction(x$1, x$2, x$3, true, x$4, x$6, x$7);
                FlowTransactionState flowTransactionState = e.state();
                FlowTransactionStateStarted$ flowTransactionStateStarted$ = FlowTransactionStateStarted$.MODULE$;
                tuple2 = !(flowTransactionState != null ? !flowTransactionState.equals(flowTransactionStateStarted$) : flowTransactionStateStarted$ != null) ? new Tuple2((Object)None$.MODULE$, (Object)newT) : new Tuple2((Object)None$.MODULE$, (Object)newT.updateTransaction(e));
            } else if (option instanceof Some) {
                Some some = (Some)option;
                FlowTransaction t = (FlowTransaction)some.value();
                this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().trace((Function0 & Serializable)() -> new StringBuilder(23).append("Updating transaction [").append(e.transactionId()).append("]").toString());
                FlowTransaction qual$1 = t.updateTransaction(e);
                boolean x$8 = false;
                String x$9 = qual$1.copy$default$1();
                Date x$10 = qual$1.copy$default$2();
                Date x$11 = qual$1.copy$default$3();
                Map<String, MsgProperty> x$12 = qual$1.copy$default$5();
                Map<String, List<WorklistState>> x$13 = qual$1.copy$default$6();
                FlowTransactionState x$14 = qual$1.copy$default$7();
                tuple2 = new Tuple2((Object)new Some((Object)t), (Object)qual$1.copy(x$9, x$10, x$11, false, x$12, x$13, x$14));
            } else {
                throw new MatchError((Object)option);
            }
            return tuple2;
        }, this.eCtxt()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Option old = (Option)tuple2._1();
            FlowTransaction updated = (FlowTransaction)tuple2._2();
            Try<FlowTransaction> try_ = this.store((Option<FlowTransaction>)old, updated);
            return try_;
        }, this.eCtxt());
        return (Try)Await$.MODULE$.result((Awaitable)fut, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(3)).seconds());
    }

    @Override
    public Future<Option<FlowTransaction>> findTransaction(String tid) {
        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().trace((Function0 & Serializable)() -> new StringBuilder(29).append("Trying to find transaction [").append(tid).append("]").toString());
        return this.mapDirectoryStream(this.FilteredDirectoryStream().tidStream(tid)).map((Function1 & Serializable)x$1 -> x$1.headOption(), this.eCtxt());
    }

    @Override
    public void removeTransaction(String tid) {
        this.withDirectoryStream(this.FilteredDirectoryStream().tidStream(tid), (Function1<Path, Object>)(Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$removeTransaction$1(this, p)));
    }

    @Override
    public Future<Object> withAll(Function1<FlowTransaction, Object> f) {
        return this.withDirectoryStream(new FilteredDirectoryStream(this, (Function1<Path, Object>)(Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$withAll$1(x$2))), (Function1<Path, Object>)(Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$withAll$2(this, f, p)));
    }

    @Override
    public Future<Object> cleanUp(Seq<FlowTransactionState> states) {
        return this.withDirectoryStream(this.FilteredDirectoryStream().stateDirectoryStream(states), (Function1<Path, Object>)(Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$cleanUp$1(this, p)));
    }

    private Function1<FlowTransaction, String> filename() {
        return this.filename;
    }

    private Try<FlowTransaction> store(Option<FlowTransaction> old, FlowTransaction changed) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            FlowTransaction flowTransaction;
            String json = Pickle$.MODULE$.intoString((Object)changed, Pickle$.MODULE$.intoString$default$2(), PrickleProtocol$.MODULE$.transPickler(), (PConfig)PConfig$.MODULE$.Default());
            File newFile = new File(this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir(), (String)this.filename().apply((Object)changed));
            old.foreach((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$store$2(this, t)));
            None$ os = None$.MODULE$;
            None$ writer = None$.MODULE$;
            try {
                try {
                    os = new Some((Object)new FileOutputStream(newFile));
                    writer = new Some((Object)new BufferedWriter(new PrintWriter((OutputStream)os.get())));
                    writer.foreach((Function1 & Serializable)w -> {
                        w.write(json);
                        return BoxedUnit.UNIT;
                    });
                    flowTransaction = changed;
                }
                catch (Throwable throwable) {
                    Option option;
                    Throwable throwable2 = throwable;
                    if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        Throwable e = (Throwable)option.get();
                        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(35).append("Error writing transaction file [").append(newFile.getAbsolutePath()).append("][").append(e.getMessage()).append("]").toString());
                        throw e;
                    }
                    throw throwable;
                }
            }
            finally {
                writer.foreach((Function1 & Serializable)w -> {
                    FileFlowTransactionManager.$anonfun$store$5(this, newFile, w);
                    return BoxedUnit.UNIT;
                });
                os.foreach((Function1 & Serializable)s -> {
                    FileFlowTransactionManager.$anonfun$store$7(this, newFile, s);
                    return BoxedUnit.UNIT;
                });
            }
            return flowTransaction;
        });
    }

    private Try<FlowTransaction> loadExistingTransaction(File f) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            FlowTransaction ft;
            Option option;
            boolean bl = false;
            Success success = null;
            Try<Option<FlowTransaction>> try_ = this.loadTransaction(f);
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                throw t;
            }
            if (try_ instanceof Success) {
                bl = true;
                success = (Success)try_;
                Option option2 = (Option)success.value();
                if (None$.MODULE$.equals(option2)) {
                    throw new Exception(new StringBuilder(28).append("FlowTransaction [").append(f.getName()).append("] not found").toString());
                }
            }
            if (!bl || !((option = (Option)success.value()) instanceof Some)) {
                throw new MatchError(try_);
            }
            Some some = (Some)option;
            FlowTransaction flowTransaction = ft = (FlowTransaction)some.value();
            return flowTransaction;
        });
    }

    private Try<Option<FlowTransaction>> loadTransaction(File f) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            None$ none$;
            if (f.exists()) {
                String json = (String)this.loadFile(f).get();
                UnpickledCurry qual$1 = Unpickle$.MODULE$.apply(PrickleProtocol$.MODULE$.transUnpickler());
                String x$1 = json;
                scala.collection.mutable.Map x$2 = qual$1.fromString$default$2();
                FlowTransaction t = (FlowTransaction)qual$1.fromString(x$1, x$2, (PConfig)PConfig$.MODULE$.Default()).get();
                none$ = new Some((Object)t);
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    private Try<String> loadFile(File f) {
        Success success;
        BufferedSource src = scala.io.Source$.MODULE$.fromFile(f, "UTF-8");
        try {
            try {
                success = new Success((Object)src.getLines().mkString("\n"));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    throw throwable;
                }
                Throwable t = (Throwable)option.get();
                this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(51).append("Exception encountered accessing transaction file [").append(f.getAbsolutePath()).append("]").toString());
                Failure failure = new Failure(t);
                success = failure;
            }
        }
        catch (Throwable throwable) {
            block11: {
                try {
                    src.close();
                }
                catch (Throwable throwable3) {
                    Option option;
                    Throwable throwable4 = throwable3;
                    if (throwable4 != null && !(option = NonFatal$.MODULE$.unapply(throwable4)).isEmpty()) {
                        Throwable t = (Throwable)option.get();
                        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(24).append("Error closing file [").append(f.getAbsolutePath()).append("]:[").append(t.getMessage()).append("]").toString());
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block11;
                    }
                    throw throwable3;
                }
            }
            throw throwable;
        }
        Success success2 = success;
        try {
            src.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable5 = throwable;
            if (throwable5 != null && !(option = NonFatal$.MODULE$.unapply(throwable5)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(24).append("Error closing file [").append(f.getAbsolutePath()).append("]:[").append(t.getMessage()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
        return success2;
    }

    private Future<Seq<FlowTransaction>> mapDirectoryStream(FilteredDirectoryStream dirStream) {
        return this.mapDirectoryStreamWithFilter(dirStream, (Function1<FlowTransaction, Object>)(Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)FileFlowTransactionManager.$anonfun$mapDirectoryStream$1(x$3)));
    }

    /*
     * WARNING - void declaration
     */
    private Future<Seq<FlowTransaction>> mapDirectoryStreamWithFilter(FilteredDirectoryStream dirStream, Function1<FlowTransaction, Object> select) {
        void var3_3;
        Future transactions = (Future)((Source)dirStream.entries().map((Function1 & Serializable)p -> this.loadExistingTransaction(p.toFile())).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isSuccess())).map((Function1 & Serializable)x$5 -> (FlowTransaction)x$5.get()).filter(select)).runWith((Graph)Sink$.MODULE$.seq(), Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system));
        transactions.onComplete((Function1 & Serializable)x$6 -> {
            dirStream.close();
            return BoxedUnit.UNIT;
        }, this.eCtxt());
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private Future<Object> withDirectoryStream(FilteredDirectoryStream dirStream, Function1<Path, Object> f) {
        void var3_3;
        Future count = dirStream.entries().via((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable)p -> BoxesRunTime.boxToInteger((int)FileFlowTransactionManager.$anonfun$withDirectoryStream$1(f, p)))).runFold((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable)(c, v) -> c + v, Materializer$.MODULE$.matFromSystem((ClassicActorSystemProvider)this.system));
        count.onComplete((Function1 & Serializable)x$7 -> {
            dirStream.close();
            return BoxedUnit.UNIT;
        }, this.eCtxt());
        return var3_3;
    }

    private final void FilteredDirectoryStream$lzycompute$1() {
        FileFlowTransactionManager fileFlowTransactionManager = this;
        synchronized (fileFlowTransactionManager) {
            if (this.FilteredDirectoryStream$module == null) {
                this.FilteredDirectoryStream$module = new FileFlowTransactionManager$FilteredDirectoryStream$(this);
            }
        }
    }

    public static final /* synthetic */ boolean $anonfun$removeTransaction$1(FileFlowTransactionManager $this, Path p) {
        $this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().trace((Function0 & Serializable)() -> new StringBuilder(16).append("Removing file [").append(p.toFile().getAbsolutePath()).append("]").toString());
        return p.toFile().delete();
    }

    public static final /* synthetic */ boolean $anonfun$withAll$1(Path x$2) {
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$withAll$2(FileFlowTransactionManager $this, Function1 f$1, Path p) {
        return BoxesRunTime.unboxToBoolean((Object)$this.loadExistingTransaction(p.toFile()).map(f$1).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false));
    }

    public static final /* synthetic */ boolean $anonfun$cleanUp$1(FileFlowTransactionManager $this, Path p) {
        boolean bl;
        String[] n = p.toFile().getName().split("\\.");
        if (n.length == 3) {
            boolean doDelete = BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
                FlowTransactionState state = (FlowTransactionState)FlowTransactionState$.MODULE$.apply(n[2]).get();
                FlowTransactionState flowTransactionState = state;
                FiniteDuration finiteDuration = FlowTransactionStateFailed$.MODULE$.equals(flowTransactionState) ? $this.config().retainFailed() : (FlowTransactionStateCompleted$.MODULE$.equals(flowTransactionState) ? $this.config().retainCompleted() : $this.config().retainStale());
                FiniteDuration retain = finiteDuration;
                return System.currentTimeMillis() - StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(n[1])) >= retain.toMillis();
            }).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> true));
            if (doDelete) {
                $this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().trace((Function0 & Serializable)() -> new StringBuilder(19).append("Cleaning up file [").append(p.toFile()).append("]").toString());
                bl = p.toFile().delete();
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$store$2(FileFlowTransactionManager $this, FlowTransaction t) {
        return new File($this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir(), (String)$this.filename().apply((Object)t)).delete();
    }

    public static final /* synthetic */ void $anonfun$store$5(FileFlowTransactionManager $this, File newFile$1, BufferedWriter w) {
        try {
            w.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(23).append("Error closing file [").append(newFile$1.getAbsolutePath()).append("][").append(e.getMessage()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ void $anonfun$store$7(FileFlowTransactionManager $this, File newFile$1, OutputStream s) {
        try {
            s.close();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                $this.blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(23).append("Error closing file [").append(newFile$1.getAbsolutePath()).append("][").append(e.getMessage()).append("]").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public static final /* synthetic */ boolean $anonfun$mapDirectoryStream$1(FlowTransaction x$3) {
        return true;
    }

    public static final /* synthetic */ int $anonfun$withDirectoryStream$1(Function1 f$5, Path p) {
        return BoxesRunTime.unboxToBoolean((Object)f$5.apply((Object)p)) ? 1 : 0;
    }

    public FileFlowTransactionManager(FlowTransactionManagerConfig config, ActorSystem system) {
        this.config = config;
        this.system = system;
        FlowTransactionManager.$init$(this);
        this.blended$streams$transaction$internal$FileFlowTransactionManager$$log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileFlowTransactionManager.class));
        this.eCtxt = system.dispatcher();
        this.blended$streams$transaction$internal$FileFlowTransactionManager$$dir = config.dir();
        Predef$.MODULE$.require(this.initialized());
        this.filename = (Function1 & Serializable)t -> new StringBuilder(2).append(t.tid()).append(".").append(t.lastUpdate().getTime()).append(".").append(t.state()).toString();
    }

    private class FilteredDirectoryStream {
        public final Function1<Path, Object> blended$streams$transaction$internal$FileFlowTransactionManager$FilteredDirectoryStream$$f;
        private final DirectoryStream<Path> stream;
        private final Source<Path, NotUsed> entries;
        public final /* synthetic */ FileFlowTransactionManager $outer;

        private DirectoryStream<Path> stream() {
            return this.stream;
        }

        public Source<Path, NotUsed> entries() {
            return this.entries;
        }

        public void close() {
            try {
                this.stream().close();
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    this.blended$streams$transaction$internal$FileFlowTransactionManager$FilteredDirectoryStream$$$outer().blended$streams$transaction$internal$FileFlowTransactionManager$$log().warn((Function0 & Serializable)() -> new StringBuilder(58).append("Error closing directory stream in transaction cleanup : [").append(t.getMessage()).append("]").toString());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }

        public /* synthetic */ FileFlowTransactionManager blended$streams$transaction$internal$FileFlowTransactionManager$FilteredDirectoryStream$$$outer() {
            return this.$outer;
        }

        public FilteredDirectoryStream(FileFlowTransactionManager $outer, Function1<Path, Object> f) {
            this.blended$streams$transaction$internal$FileFlowTransactionManager$FilteredDirectoryStream$$f = f;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            DirectoryStream.Filter<Path> tidFilter = new DirectoryStream.Filter<Path>(this){
                private final /* synthetic */ FilteredDirectoryStream $outer;

                public boolean accept(Path entry) {
                    return BoxesRunTime.unboxToBoolean((Object)this.$outer.blended$streams$transaction$internal$FileFlowTransactionManager$FilteredDirectoryStream$$f.apply((Object)entry));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            };
            this.stream = Files.newDirectoryStream($outer.blended$streams$transaction$internal$FileFlowTransactionManager$$dir().toPath(), (DirectoryStream.Filter<? super Path>)tidFilter);
            this.entries = Source$.MODULE$.fromIterator((Function0 & Serializable)() -> CollectionConverters$.MODULE$.IteratorHasAsScala(this.stream().iterator()).asScala());
        }
    }
}

