/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.streams.FlowHeaderConfig;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDestinationResolver;
import blended.streams.jms.JmsEnvelopeHeader;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsSendParameter;
import blended.streams.jms.JmsSettings;
import blended.streams.message.BinaryFlowMessage$;
import blended.streams.message.FlowEnvelope;
import blended.streams.message.FlowMessage;
import blended.streams.message.FlowMessage$;
import blended.streams.message.MsgProperty;
import blended.streams.message.MsgProperty$;
import blended.streams.message.TextFlowMessage;
import blended.util.RichTry$;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.TextMessage;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.MapOps;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try;
import scala.util.Try$;

public final class JmsFlowSupport$
implements JmsEnvelopeHeader {
    public static final JmsFlowSupport$ MODULE$ = new JmsFlowSupport$();
    private static final Function1<FlowHeaderConfig, Function1<JmsSettings, Function1<Message, Try<FlowMessage>>>> jms2flowMessage;
    private static final Function3<JmsProducerSettings, Session, FlowEnvelope, Try<JmsSendParameter>> envelope2jms;
    private static Function1<String, String> jmsHeaderPrefix;
    private static Function1<String, String> srcVendorHeader;
    private static Function1<String, String> srcProviderHeader;
    private static Function1<String, String> srcDestHeader;
    private static Function1<String, String> destHeader;
    private static Function1<String, String> corrIdHeader;
    private static Function1<String, String> priorityHeader;
    private static Function1<String, String> expireHeader;
    private static Function1<String, String> deliveryModeHeader;
    private static Function1<String, String> replyToHeader;
    private static Function1<String, String> timestampHeader;
    private static Function1<String, String> typeHeader;
    private static Function1<String, String> msgIdHeader;
    private static Function1<String, String> redeliveryHeader;
    private static String replyToQueueName;

    static {
        JmsEnvelopeHeader.$init$(MODULE$);
        jms2flowMessage = (Function1 & Serializable)headerConfig -> (Function1 & Serializable)settings -> (Function1 & Serializable)msg -> Try$.MODULE$.apply((Function0 & Serializable)() -> {
            FlowMessage flowMessage;
            String string;
            String string2;
            String prefix = headerConfig.prefix();
            String dest = JmsDestination$.MODULE$.asString((JmsDestination)JmsDestination$.MODULE$.create(msg.getJMSDestination()).get());
            String delMode = new JmsDeliveryMode(msg.getJMSDeliveryMode()).asString();
            Option option = Option$.MODULE$.apply((Object)msg.getStringProperty((String)MODULE$.srcVendorHeader().apply((Object)prefix)));
            if (None$.MODULE$.equals(option)) {
                string2 = settings.connectionFactory().vendor();
            } else if (option instanceof Some) {
                String s2;
                Some some = (Some)option;
                string2 = s2 = (String)some.value();
            } else {
                throw new MatchError((Object)option);
            }
            String srcVendor = string2;
            Option option2 = Option$.MODULE$.apply((Object)msg.getStringProperty((String)MODULE$.srcProviderHeader().apply((Object)prefix)));
            if (None$.MODULE$.equals(option2)) {
                string = settings.connectionFactory().provider();
            } else if (option2 instanceof Some) {
                String s3;
                Some some = (Some)option2;
                string = s3 = (String)some.value();
            } else {
                throw new MatchError((Object)option2);
            }
            String srcProvider = string;
            Seq jmsHeader = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.srcVendorHeader().apply((Object)prefix)), (Object)srcVendor), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.srcProviderHeader().apply((Object)prefix)), (Object)srcProvider), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.srcDestHeader().apply((Object)prefix)), (Object)dest), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.priorityHeader().apply((Object)prefix)), (Object)BoxesRunTime.boxToInteger((int)msg.getJMSPriority())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.deliveryModeHeader().apply((Object)prefix)), (Object)delMode), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.timestampHeader().apply((Object)prefix)), (Object)BoxesRunTime.boxToLong((long)msg.getJMSTimestamp())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.typeHeader().apply((Object)prefix)), (Object)msg.getJMSType()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.msgIdHeader().apply((Object)prefix)), (Object)msg.getJMSMessageID()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.redeliveryHeader().apply((Object)prefix)), (Object)BoxesRunTime.boxToBoolean((boolean)msg.getJMSRedelivered()))}));
            Map headers = (Map)RichTry$.MODULE$.toRichTry(FlowMessage$.MODULE$.props((Seq<Tuple2<String, Object>>)jmsHeader)).unwrap();
            long l = msg.getJMSExpiration();
            Map map = 0L == l ? Predef$.MODULE$.Map().empty() : (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.expireHeader().apply((Object)prefix)), RichTry$.MODULE$.toRichTry(MsgProperty$.MODULE$.apply(BoxesRunTime.boxToLong((long)l))).unwrap())}));
            Map expireHeaderMap = map;
            Map corrIdMap = (Map)Option$.MODULE$.apply((Object)msg.getJMSCorrelationID()).map((Function1 & Serializable)s -> (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.corrIdHeader().apply((Object)prefix)), RichTry$.MODULE$.toRichTry(MsgProperty$.MODULE$.apply(s)).unwrap()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"JMSCorrelationID"), RichTry$.MODULE$.toRichTry(MsgProperty$.MODULE$.apply(s)).unwrap())}))).getOrElse((Function0 & Serializable)() -> Predef$.MODULE$.Map().empty());
            Map props = CollectionConverters$.MODULE$.EnumerationHasAsScala(msg.getPropertyNames()).asScala().map((Function1 & Serializable)name -> {
                String propName = settings.keyFormatStrategy().handleReceivedKey(name.toString());
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)propName), RichTry$.MODULE$.toRichTry(MsgProperty$.MODULE$.apply(msg.getObjectProperty(name.toString()))).unwrap());
            }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map replyToMap = Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)msg.getJMSReplyTo()).map((Function1 & Serializable)d -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(MODULE$.replyToHeader().apply((Object)prefix)), RichTry$.MODULE$.toRichTry(MsgProperty$.MODULE$.apply(((JmsDestination)RichTry$.MODULE$.toRichTry(JmsDestination$.MODULE$.create(d)).unwrap()).asString())).unwrap()))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            Map props2 = (Map)((MapOps)((MapOps)((MapOps)props.$plus$plus((IterableOnce)headers)).$plus$plus((IterableOnce)expireHeaderMap)).$plus$plus((IterableOnce)corrIdMap)).$plus$plus((IterableOnce)replyToMap);
            Message message = msg;
            if (message instanceof TextMessage) {
                TextMessage textMessage = (TextMessage)message;
                flowMessage = new TextFlowMessage(textMessage.getText(), (Map<String, MsgProperty>)props2);
            } else if (message instanceof BytesMessage) {
                BytesMessage bytesMessage = (BytesMessage)message;
                byte[] content = new byte[(int)bytesMessage.getBodyLength()];
                bytesMessage.readBytes(content);
                flowMessage = BinaryFlowMessage$.MODULE$.apply(content, (Map<String, MsgProperty>)props2);
            } else {
                flowMessage = FlowMessage$.MODULE$.apply((Map<String, MsgProperty>)props2);
            }
            FlowMessage flowMessage2 = flowMessage;
            return flowMessage2;
        });
        envelope2jms = (Function3 & Serializable)(settings, session, flowEnv) -> Try$.MODULE$.apply((Function0 & Serializable)() -> (JmsSendParameter)RichTry$.MODULE$.toRichTry(((JmsDestinationResolver)settings.destinationResolver().apply(settings)).sendParameter((Session)session, (FlowEnvelope)flowEnv)).unwrap());
    }

    @Override
    public Function1<String, String> jmsHeaderPrefix() {
        return jmsHeaderPrefix;
    }

    @Override
    public Function1<String, String> srcVendorHeader() {
        return srcVendorHeader;
    }

    @Override
    public Function1<String, String> srcProviderHeader() {
        return srcProviderHeader;
    }

    @Override
    public Function1<String, String> srcDestHeader() {
        return srcDestHeader;
    }

    @Override
    public Function1<String, String> destHeader() {
        return destHeader;
    }

    @Override
    public Function1<String, String> corrIdHeader() {
        return corrIdHeader;
    }

    @Override
    public Function1<String, String> priorityHeader() {
        return priorityHeader;
    }

    @Override
    public Function1<String, String> expireHeader() {
        return expireHeader;
    }

    @Override
    public Function1<String, String> deliveryModeHeader() {
        return deliveryModeHeader;
    }

    @Override
    public Function1<String, String> replyToHeader() {
        return replyToHeader;
    }

    @Override
    public Function1<String, String> timestampHeader() {
        return timestampHeader;
    }

    @Override
    public Function1<String, String> typeHeader() {
        return typeHeader;
    }

    @Override
    public Function1<String, String> msgIdHeader() {
        return msgIdHeader;
    }

    @Override
    public Function1<String, String> redeliveryHeader() {
        return redeliveryHeader;
    }

    @Override
    public String replyToQueueName() {
        return replyToQueueName;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$jmsHeaderPrefix_$eq(Function1<String, String> x$1) {
        jmsHeaderPrefix = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcVendorHeader_$eq(Function1<String, String> x$1) {
        srcVendorHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcProviderHeader_$eq(Function1<String, String> x$1) {
        srcProviderHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$srcDestHeader_$eq(Function1<String, String> x$1) {
        srcDestHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$destHeader_$eq(Function1<String, String> x$1) {
        destHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$corrIdHeader_$eq(Function1<String, String> x$1) {
        corrIdHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$priorityHeader_$eq(Function1<String, String> x$1) {
        priorityHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$expireHeader_$eq(Function1<String, String> x$1) {
        expireHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$deliveryModeHeader_$eq(Function1<String, String> x$1) {
        deliveryModeHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToHeader_$eq(Function1<String, String> x$1) {
        replyToHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$timestampHeader_$eq(Function1<String, String> x$1) {
        timestampHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$typeHeader_$eq(Function1<String, String> x$1) {
        typeHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$msgIdHeader_$eq(Function1<String, String> x$1) {
        msgIdHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$redeliveryHeader_$eq(Function1<String, String> x$1) {
        redeliveryHeader = x$1;
    }

    @Override
    public void blended$streams$jms$JmsEnvelopeHeader$_setter_$replyToQueueName_$eq(String x$1) {
        replyToQueueName = x$1;
    }

    public Function1<FlowHeaderConfig, Function1<JmsSettings, Function1<Message, Try<FlowMessage>>>> jms2flowMessage() {
        return jms2flowMessage;
    }

    public Function3<JmsProducerSettings, Session, FlowEnvelope, Try<JmsSendParameter>> envelope2jms() {
        return envelope2jms;
    }

    private JmsFlowSupport$() {
    }
}

