/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.jms;

import akka.actor.ActorSystem;
import blended.jms.utils.JmsSession;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.jms.Connection;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005}b\u0001\u0002\n\u0014\u0001iA\u0001\"\t\u0001\u0003\u0002\u0003\u0006IA\t\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AQ\u0007\u0001B\u0001B\u0003%a\u0007C\u0003:\u0001\u0011\u0005!\bC\u0004A\u0001\t\u0007I\u0011B!\t\r)\u0003\u0001\u0015!\u0003C\u0011\u0015Y\u0005\u0001\"\u0001M\u0011\u0015y\u0006\u0001\"\u0001M\u0011\u0015\u0001\u0007\u0001\"\u0001M\u0011\u0015\t\u0007\u0001\"\u0001c\u0011\u001di\u0007A1A\u0005\n9Daa\u001e\u0001!\u0002\u0013y\u0007\"\u0002=\u0001\t\u0003I\bBB@\u0001\t\u0003\t\t\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016!9\u00111\b\u0001\u0005\u0002\u0005u\"!\u0005&ngN+7o]5p]6\u000bg.Y4fe*\u0011A#F\u0001\u0004U6\u001c(B\u0001\f\u0018\u0003\u001d\u0019HO]3b[NT\u0011\u0001G\u0001\bE2,g\u000eZ3e\u0007\u0001\u0019\"\u0001A\u000e\u0011\u0005qyR\"A\u000f\u000b\u0003y\tQa]2bY\u0006L!\u0001I\u000f\u0003\r\u0005s\u0017PU3g\u0003\u0011q\u0017-\\3\u0011\u0005\rRcB\u0001\u0013)!\t)S$D\u0001'\u0015\t9\u0013$\u0001\u0004=e>|GOP\u0005\u0003Su\ta\u0001\u0015:fI\u00164\u0017BA\u0016-\u0005\u0019\u0019FO]5oO*\u0011\u0011&H\u0001\u0005G>tg\u000e\u0005\u00020g5\t\u0001G\u0003\u0002\u0015c)\t!'A\u0003kCZ\f\u00070\u0003\u00025a\tQ1i\u001c8oK\u000e$\u0018n\u001c8\u0002\u00175\f\u0007pU3tg&|gn\u001d\t\u00039]J!\u0001O\u000f\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0005wurt\b\u0005\u0002=\u00015\t1\u0003C\u0003\"\t\u0001\u0007!\u0005C\u0003.\t\u0001\u0007a\u0006C\u00036\t\u0001\u0007a'A\u0002m_\u001e,\u0012A\u0011\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bq\u0001\\8hO&twM\u0003\u0002H/\u0005!Q\u000f^5m\u0013\tIEI\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\u0007p]N+7o]5p]>\u0003XM\\\u000b\u0002\u001bB!AD\u0014)X\u0013\tyUDA\u0005Gk:\u001cG/[8ocA\u0011\u0011+V\u0007\u0002%*\u00111\u000bV\u0001\u0006kRLGn\u001d\u0006\u0003)]I!A\u0016*\u0003\u0015)k7oU3tg&|g\u000eE\u0002Y5rk\u0011!\u0017\u0006\u0003\u000fvI!aW-\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u001d;&\u0011a,\b\u0002\u0005+:LG/\u0001\ncK\u001a|'/Z*fgNLwN\\\"m_N,\u0017!E1gi\u0016\u00148+Z:tS>t7\t\\8tK\u00069qN\\#se>\u0014X#A2\u0011\tqqE\r\u0018\t\u0003K*t!A\u001a5\u000f\u0005\u0015:\u0017\"\u0001\u0010\n\u0005%l\u0012a\u00029bG.\fw-Z\u0005\u0003W2\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005%l\u0012\u0001C:fgNLwN\\:\u0016\u0003=\u0004B\u0001];#!6\t\u0011O\u0003\u0002sg\u00069Q.\u001e;bE2,'B\u0001;\u001e\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003mF\u00141!T1q\u0003%\u0019Xm]:j_:\u001c\b%\u0001\u0004jg>\u0003XM\u001c\u000b\u0003uv\u0004\"\u0001H>\n\u0005ql\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006}6\u0001\rAI\u0001\u0003S\u0012\f!bZ3u'\u0016\u001c8/[8o)\u0011\t\u0019!a\u0003\u0011\taS\u0016Q\u0001\t\u00059\u0005\u001d\u0001+C\u0002\u0002\nu\u0011aa\u00149uS>t\u0007\"\u0002@\u000f\u0001\u0004\u0011\u0013\u0001D2m_N,7+Z:tS>tGcA,\u0002\u0012!)ap\u0004a\u0001E\u0005\t2\r\\8tKN+7o]5p]\u0006\u001b\u0018P\\2\u0015\t\u0005]\u0011\u0011\b\u000b\u0005\u00033\t)\u0003E\u0003\u0002\u001c\u0005\u0005B,\u0004\u0002\u0002\u001e)\u0019\u0011qD\u000f\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0003\u0002$\u0005u!A\u0002$viV\u0014X\rC\u0004\u0002(A\u0001\r!!\u000b\u0002\rML8\u000f^3n!\u0011\tY#!\u000e\u000e\u0005\u00055\"\u0002BA\u0018\u0003c\tQ!Y2u_JT!!a\r\u0002\t\u0005\\7.Y\u0005\u0005\u0003o\tiCA\u0006BGR|'oU=ti\u0016l\u0007\"\u0002@\u0011\u0001\u0004\u0011\u0013\u0001C2m_N,\u0017\t\u001c7\u0015\u0003]\u0003")
public class JmsSessionManager {
    private final String name;
    private final Connection conn;
    private final int maxSessions;
    private final Logger log;
    private final Map<String, JmsSession> sessions;

    private Logger log() {
        return this.log;
    }

    public Function1<JmsSession, Try<BoxedUnit>> onSessionOpen() {
        return (Function1 & Serializable)x$1 -> new Success((Object)BoxedUnit.UNIT);
    }

    public Function1<JmsSession, Try<BoxedUnit>> beforeSessionClose() {
        return (Function1 & Serializable)x$2 -> new Success((Object)BoxedUnit.UNIT);
    }

    public Function1<JmsSession, Try<BoxedUnit>> afterSessionClose() {
        return (Function1 & Serializable)x$3 -> new Success((Object)BoxedUnit.UNIT);
    }

    public Function1<Throwable, BoxedUnit> onError() {
        return (Function1 & Serializable)x$4 -> {
            JmsSessionManager.$anonfun$onError$1(x$4);
            return BoxedUnit.UNIT;
        };
    }

    private Map<String, JmsSession> sessions() {
        return this.sessions;
    }

    public boolean isOpen(String id) {
        return this.sessions().contains((Object)id);
    }

    public Try<Option<JmsSession>> getSession(String id) {
        Success success;
        Option option = this.sessions().get((Object)id);
        if (option instanceof Some) {
            Some some = (Some)option;
            JmsSession s = (JmsSession)some.value();
            this.log().trace((Function0 & Serializable)() -> new StringBuilder(45).append("Reusing existing session for session [").append(id).append("] in [").append($this.name).append("]").toString());
            success = new Success((Object)new Some((Object)s));
        } else if (None$.MODULE$.equals(option)) {
            Success success2;
            if (this.sessions().size() < this.maxSessions) {
                try {
                    this.log().debug((Function0 & Serializable)() -> new StringBuilder(25).append("Creating session [").append(id).append("] in [").append($this.name).append("]").toString());
                    JmsSession s = new JmsSession(this.conn.createSession(false, 2), id);
                    this.sessions().put((Object)s.sessionId(), (Object)s);
                    ((Try)this.onSessionOpen().apply((Object)s)).get();
                    success2 = new Success((Object)new Some((Object)s));
                }
                catch (Throwable throwable) {
                    Option option2;
                    Throwable throwable2 = throwable;
                    if (throwable2 == null || (option2 = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                        throw throwable;
                    }
                    Throwable t = (Throwable)option2.get();
                    this.log().error((Function0 & Serializable)() -> new StringBuilder(35).append("Failed to create session in [").append($this.name).append("] : [").append(t.getMessage()).append("]").toString());
                    Failure failure = new Failure(t);
                    success2 = failure;
                }
            } else {
                this.log().debug((Function0 & Serializable)() -> new StringBuilder(49).append("No free session slot available in [").append($this.name).append("] for [").append(id).append("] : [").append($this.maxSessions).append("].").toString());
                success2 = new Success((Object)None$.MODULE$);
            }
            success = success2;
        } else {
            throw new MatchError((Object)option);
        }
        return success;
    }

    public Try<BoxedUnit> closeSession(String id) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> this.sessions().remove((Object)id).map((Function1 & Serializable)sess -> {
            Object object;
            this.log().debug((Function0 & Serializable)() -> new StringBuilder(18).append("Closing session [").append(sess.sessionId()).append("]").toString());
            this.beforeSessionClose().apply(sess);
            Try try_ = sess.closeSession();
            if (try_ instanceof Success) {
                object = this.afterSessionClose().apply(sess);
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable t = failure.exception();
                object = this.onError().apply((Object)t);
            } else {
                throw new MatchError((Object)try_);
            }
            return object;
        }).getOrElse((Function0 & Serializable)() -> new Success((Object)BoxedUnit.UNIT)));
    }

    public Future<BoxedUnit> closeSessionAsync(String id, ActorSystem system) {
        return (Future)this.sessions().remove((Object)id).map((Function1 & Serializable)x$5 -> x$5.closeSessionAsync(system)).getOrElse((Function0 & Serializable)() -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {}, (ExecutionContext)system.dispatcher()));
    }

    public Try<BoxedUnit> closeAll() {
        this.log().trace((Function0 & Serializable)() -> new StringBuilder(26).append("Closing [").append(this.sessions().size()).append("] sessions for [").append($this.name).append("]").toString());
        return (Try)((IterableOnceOps)this.sessions().values().map((Function1 & Serializable)sess -> this.closeSession(sess.sessionId()))).find((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isFailure())).getOrElse((Function0 & Serializable)() -> new Success((Object)BoxedUnit.UNIT));
    }

    public static final /* synthetic */ void $anonfun$onError$1(Throwable x$4) {
    }

    public JmsSessionManager(String name, Connection conn, int maxSessions) {
        this.name = name;
        this.conn = conn;
        this.maxSessions = maxSessions;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(JmsSessionManager.class));
        this.sessions = (Map)Map$.MODULE$.empty();
    }
}

