/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.testsupport;

import akka.util.ByteString;
import akka.util.ByteString$;
import blended.streams.message.FlowMessage;
import blended.streams.message.FlowMessage$;
import blended.streams.message.MsgProperty;
import blended.streams.message.MsgProperty$;
import blended.util.FileHelper;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.xml.bind.DatatypeConverter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001B\u0006\r\u0001MA\u0001B\u0007\u0001\u0003\u0002\u0003\u0006Ia\u0007\u0005\u0006M\u0001!\ta\n\u0005\bW\u0001\u0011\r\u0011\"\u0003-\u0011\u0019)\u0004\u0001)A\u0005[!9a\u0007\u0001b\u0001\n\u00139\u0004B\u0002\"\u0001A\u0003%\u0001\bC\u0003D\u0001\u0011\u0005A\tC\u0003V\u0001\u0011%a\u000bC\u0003c\u0001\u0011%1\rC\u0003u\u0001\u0011%QOA\u000bTiJ,\u0017-\\:NKN\u001c\u0018mZ3GC\u000e$xN]=\u000b\u00055q\u0011a\u0003;fgR\u001cX\u000f\u001d9peRT!a\u0004\t\u0002\u000fM$(/Z1ng*\t\u0011#A\u0004cY\u0016tG-\u001a3\u0004\u0001M\u0011\u0001\u0001\u0006\t\u0003+ai\u0011A\u0006\u0006\u0002/\u0005)1oY1mC&\u0011\u0011D\u0006\u0002\u0007\u0003:L(+\u001a4\u0002\u0011\u0019LG.\u001a(b[\u0016\u0004\"\u0001H\u0012\u000f\u0005u\t\u0003C\u0001\u0010\u0017\u001b\u0005y\"B\u0001\u0011\u0013\u0003\u0019a$o\\8u}%\u0011!EF\u0001\u0007!J,G-\u001a4\n\u0005\u0011*#AB*ue&twM\u0003\u0002#-\u00051A(\u001b8jiz\"\"\u0001\u000b\u0016\u0011\u0005%\u0002Q\"\u0001\u0007\t\u000bi\u0011\u0001\u0019A\u000e\u0002\u00071|w-F\u0001.!\tq3'D\u00010\u0015\t\u0001\u0014'A\u0004m_\u001e<\u0017N\\4\u000b\u0005I\u0002\u0012\u0001B;uS2L!\u0001N\u0018\u0003\r1{wmZ3s\u0003\u0011awn\u001a\u0011\u0002\u0007\u0011\u0014g-F\u00019!\tI\u0004)D\u0001;\u0015\tYD(A\u0004qCJ\u001cXM]:\u000b\u0005ur\u0014a\u0001=nY*\tq(A\u0003kCZ\f\u00070\u0003\u0002Bu\t1Bi\\2v[\u0016tGOQ;jY\u0012,'OR1di>\u0014\u00180\u0001\u0003eE\u001a\u0004\u0013!D2sK\u0006$X-T3tg\u0006<W\r\u0006\u0002F!B\u0019a\t\u0013&\u000e\u0003\u001dS!A\r\f\n\u0005%;%a\u0001+ssB\u00111JT\u0007\u0002\u0019*\u0011QJD\u0001\b[\u0016\u001c8/Y4f\u0013\tyEJA\u0006GY><X*Z:tC\u001e,\u0007\"B)\b\u0001\u0004\u0011\u0016A\u00022j]\u0006\u0014\u0018\u0010\u0005\u0002\u0016'&\u0011AK\u0006\u0002\b\u0005>|G.Z1o\u0003=\u0011X-\u00193NKN\u001c\u0018mZ3GS2,G#A,\u0011\u0007\u0019C\u0005\f\u0005\u0002ZA6\t!L\u0003\u0002\\9\u0006\u0019Am\\7\u000b\u0005us\u0016aA<4G*\tq,A\u0002pe\u001eL!!\u0019.\u0003\u0011\u0011{7-^7f]R\f!B]3bI\"+\u0017\rZ3s)\t!'\u000fE\u0002G\u0011\u0016\u0004\"AZ8\u000f\u0005\u001dlgB\u00015m\u001d\tI7N\u0004\u0002\u001fU&\t\u0011#\u0003\u0002\u0010!%\u0011QJD\u0005\u0003]2\u000b1B\u00127po6+7o]1hK&\u0011\u0001/\u001d\u0002\u0011\r2|w/T3tg\u0006<W\r\u0015:paNT!A\u001c'\t\u000bML\u0001\u0019\u0001-\u0002\u0007\u0011|7-\u0001\u0005sK\u0006$'i\u001c3z)\u00151\u0018QCA\f!\r1\u0005j\u001e\t\u0004+aT\u0018BA=\u0017\u0005\u0019y\u0005\u000f^5p]B110!\u0001\u0002\bmq!\u0001 @\u000f\u0005yi\u0018\"A\f\n\u0005}4\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\t)A\u0001\u0004FSRDWM\u001d\u0006\u0003\u007fZ\u0001B!!\u0003\u0002\u00125\u0011\u00111\u0002\u0006\u0004e\u00055!BAA\b\u0003\u0011\t7n[1\n\t\u0005M\u00111\u0002\u0002\u000b\u0005f$Xm\u0015;sS:<\u0007\"B:\u000b\u0001\u0004A\u0006\"B)\u000b\u0001\u0004\u0011\u0006")
public class StreamsMessageFactory {
    private final String fileName;
    private final Logger log;
    private final DocumentBuilderFactory dbf;

    private Logger log() {
        return this.log;
    }

    private DocumentBuilderFactory dbf() {
        return this.dbf;
    }

    public Try<FlowMessage> createMessage(boolean binary) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Creating message from file [").append($this.fileName).append("]").toString());
            Document doc = (Document)this.readMessageFile().get();
            Map header = (Map)this.readHeader(doc).get();
            boolean bl = false;
            Some some = null;
            Option option = (Option)this.readBody(doc, binary).get();
            if (None$.MODULE$.equals(option)) {
                return FlowMessage$.MODULE$.apply(header);
            }
            if (option instanceof Some) {
                bl = true;
                some = (Some)option;
                Either either = (Either)some.value();
                if (either instanceof Left) {
                    Left left = (Left)either;
                    ByteString bs = (ByteString)left.value();
                    return FlowMessage$.MODULE$.apply(bs, header);
                }
            }
            if (!bl) throw new MatchError((Object)option);
            Either either = (Either)some.value();
            if (!(either instanceof Right)) throw new MatchError((Object)option);
            Right right = (Right)either;
            String t = (String)right.value();
            return FlowMessage$.MODULE$.apply(t, header);
        });
    }

    private Try<Document> readMessageFile() {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            Document document;
            byte[] content = FileHelper.readFile((String)$this.fileName);
            try (ByteArrayInputStream is = new ByteArrayInputStream(content);){
                Document doc;
                DocumentBuilder dBuilder = this.dbf().newDocumentBuilder();
                document = doc = dBuilder.parse(is);
            }
            return document;
        });
    }

    private Try<Map<String, MsgProperty>> readHeader(Document doc) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            NodeList headerList = doc.getElementsByTagName("headerProperty");
            Seq headers = (Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), headerList.getLength() - 1).map((Function1 & Serializable & scala.Serializable)i -> StreamsMessageFactory.$anonfun$readHeader$2(headerList, BoxesRunTime.unboxToInt((Object)i)), IndexedSeq$.MODULE$.canBuildFrom());
            return ((TraversableOnce)headers.map((Function1 & Serializable & scala.Serializable)elem -> {
                String propType = elem.getAttribute("type");
                String name = elem.getAttribute("name");
                String value = elem.getAttribute("value");
                Class<?> clazz = Class.forName(propType);
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Object obj = constructor.newInstance(value);
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)name), MsgProperty$.MODULE$.lift(obj).get());
            }, Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        });
    }

    private Try<Option<Either<ByteString, String>>> readBody(Document doc, boolean binary) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            None$ none$;
            NodeList textElements = doc.getElementsByTagName("text");
            if (textElements.getLength() > 0) {
                String base64 = ((Element)textElements.item(0)).getTextContent();
                byte[] decoded = DatatypeConverter.parseBase64Binary((String)base64);
                if (binary) {
                    this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Read message body as byte Array of length[").append(decoded.length).append("]").toString());
                    none$ = new Some((Object)package$.MODULE$.Left().apply((Object)ByteString$.MODULE$.apply(decoded)));
                } else {
                    String text = new String(decoded, "UTF-8");
                    this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Read message body as String of length[").append(text.length()).append("]").toString());
                    none$ = new Some((Object)package$.MODULE$.Right().apply((Object)text));
                }
            } else {
                none$ = None$.MODULE$;
            }
            return none$;
        });
    }

    public static final /* synthetic */ Element $anonfun$readHeader$2(NodeList headerList$1, int i) {
        return (Element)headerList$1.item(i);
    }

    public StreamsMessageFactory(String fileName) {
        this.fileName = fileName;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(StreamsMessageFactory.class));
        this.dbf = DocumentBuilderFactory.newInstance();
    }
}

