/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.dispatcher.internal.builder;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Source;
import blended.container.context.api.ContainerIdentifierService;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.BridgeProviderRegistry;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.persistence.PersistenceService;
import blended.streams.StreamController;
import blended.streams.StreamController$;
import blended.streams.StreamControllerConfig;
import blended.streams.StreamControllerConfig$;
import blended.streams.dispatcher.internal.ResourceTypeRouterConfig;
import blended.streams.dispatcher.internal.builder.DispatcherBuilder;
import blended.streams.dispatcher.internal.builder.DispatcherBuilderSupport;
import blended.streams.dispatcher.internal.builder.DispatcherDestinationResolver;
import blended.streams.dispatcher.internal.builder.TransactionOutbound;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JMSConsumerSettings;
import blended.streams.jms.JMSConsumerSettings$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.message.FlowEnvelope;
import blended.streams.processor.Collector;
import blended.streams.transaction.FlowHeaderConfig;
import blended.streams.transaction.FlowTransactionEvent;
import blended.streams.transaction.FlowTransactionEvent$;
import blended.streams.transaction.FlowTransactionManager$;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005}g\u0001\u0002\u000e\u001c\u0001\u0019B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\tw\u0001\u0011\t\u0011)A\u0005y!A!\t\u0001B\u0001B\u0003%1\t\u0003\u0005H\u0001\t\u0005\t\u0015!\u0003I\u0011!\u0011\u0006A!A!\u0002\u0013\u0019\u0006\u0002C-\u0001\u0005\u0003\u0005\u000b\u0011\u0002.\t\u0011y\u0003!\u0011!Q\u0001\f}C\u0001b\u001a\u0001\u0003\u0002\u0003\u0006Y\u0001\u001b\u0005\u0006]\u0002!\ta\u001c\u0005\bu\u0002\u0011\r\u0011\"\u0003|\u0011\u001d\t)\u0003\u0001Q\u0001\nqD\u0011\"a\n\u0001\u0001\u0004%I!!\u000b\t\u0013\u0005E\u0002\u00011A\u0005\n\u0005M\u0002\u0002CA \u0001\u0001\u0006K!a\u000b\t\u0013\u0005\u0005\u0003\u00011A\u0005\n\u0005%\u0002\"CA\"\u0001\u0001\u0007I\u0011BA#\u0011!\tI\u0005\u0001Q!\n\u0005-\u0002\u0002CA&\u0001\u0011\u00051$!\u0014\t\u0011\u0005=\u0004\u0001\"\u0001\u001c\u0003cB\u0001\"!%\u0001\t\u0003Y\u00121\u0013\u0005\n9\u0001\u0011\r\u0011\"\u0001\u001c\u0003KC\u0001\"!,\u0001A\u0003%\u0011q\u0015\u0005\b\u0003_\u0003A\u0011AAY\u0011\u001d\tI\u000e\u0001C\u0001\u00037Dq!!8\u0001\t\u0003\tYN\u0001\nSk:t\u0017M\u00197f\t&\u001c\b/\u0019;dQ\u0016\u0014(B\u0001\u000f\u001e\u0003\u001d\u0011W/\u001b7eKJT!AH\u0010\u0002\u0011%tG/\u001a:oC2T!\u0001I\u0011\u0002\u0015\u0011L7\u000f]1uG\",'O\u0003\u0002#G\u000591\u000f\u001e:fC6\u001c(\"\u0001\u0013\u0002\u000f\tdWM\u001c3fI\u000e\u00011c\u0001\u0001([A\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u0011\u0002\u0007)l7/\u0003\u00023_\t\u0001\"*\\:TiJ,\u0017-\\*vaB|'\u000f^\u0001\te\u0016<\u0017n\u001d;ssB\u0011Q'O\u0007\u0002m)\u0011q\u0007O\u0001\u0007EJLGmZ3\u000b\u0005A\u001a\u0013B\u0001\u001e7\u0005Y\u0011%/\u001b3hKB\u0013xN^5eKJ\u0014VmZ5tiJL\u0018AA2g!\ti\u0004)D\u0001?\u0015\ty\u0004(A\u0003vi&d7/\u0003\u0002B}\tA\u0012\nZ!xCJ,7i\u001c8oK\u000e$\u0018n\u001c8GC\u000e$xN]=\u0002\u0005\t\u001c\bC\u0001#F\u001b\u0005Y\u0012B\u0001$\u001c\u0005a!\u0015n\u001d9bi\u000eDWM\u001d\"vS2$WM]*vaB|'\u000f^\u0001\u0006S\u0012\u001cfo\u0019\t\u0003\u0013Bk\u0011A\u0013\u0006\u0003\u00172\u000b1!\u00199j\u0015\tie*A\u0004d_:$X\r\u001f;\u000b\u0005=\u001b\u0013!C2p]R\f\u0017N\\3s\u0013\t\t&J\u0001\u000eD_:$\u0018-\u001b8fe&#WM\u001c;jM&,'oU3sm&\u001cW-\u0001\u0003q'Z\u001c\u0007C\u0001+X\u001b\u0005)&B\u0001,$\u0003-\u0001XM]:jgR,gnY3\n\u0005a+&A\u0005)feNL7\u000f^3oG\u0016\u001cVM\u001d<jG\u0016\f\u0011B]8vi\u0016\u00148IZ4\u0011\u0005mcV\"A\u000f\n\u0005uk\"\u0001\u0007*fg>,(oY3UsB,'k\\;uKJ\u001cuN\u001c4jO\u000611/_:uK6\u0004\"\u0001Y3\u000e\u0003\u0005T!AY2\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003\u0011\fA!Y6lC&\u0011a-\u0019\u0002\f\u0003\u000e$xN]*zgR,W.\u0001\u0007nCR,'/[1mSj,'\u000f\u0005\u0002jY6\t!N\u0003\u0002lG\u000611\u000f\u001e:fC6L!!\u001c6\u0003\u00195\u000bG/\u001a:jC2L'0\u001a:\u0002\rqJg.\u001b;?)\u001d\u0001H/\u001e<xqf$2!\u001d:t!\t!\u0005\u0001C\u0003_\u0013\u0001\u000fq\fC\u0003h\u0013\u0001\u000f\u0001\u000eC\u00034\u0013\u0001\u0007A\u0007C\u0003<\u0013\u0001\u0007A\bC\u0003C\u0013\u0001\u00071\tC\u0003H\u0013\u0001\u0007\u0001\nC\u0003S\u0013\u0001\u00071\u000bC\u0003Z\u0013\u0001\u0007!,\u0001\nti\u0006\u0014H/\u001a3ESN\u0004\u0018\r^2iKJ\u001cX#\u0001?\u0011\u000fu\f)!!\u0003\u0002 5\taPC\u0002\u0000\u0003\u0003\tq!\\;uC\ndWMC\u0002\u0002\u0004%\n!bY8mY\u0016\u001cG/[8o\u0013\r\t9A \u0002\u0004\u001b\u0006\u0004\b\u0003BA\u0006\u00033qA!!\u0004\u0002\u0016A\u0019\u0011qB\u0015\u000e\u0005\u0005E!bAA\nK\u00051AH]8pizJ1!a\u0006*\u0003\u0019\u0001&/\u001a3fM&!\u00111DA\u000f\u0005\u0019\u0019FO]5oO*\u0019\u0011qC\u0015\u0011\u0007\u0001\f\t#C\u0002\u0002$\u0005\u0014\u0001\"Q2u_J\u0014VMZ\u0001\u0014gR\f'\u000f^3e\t&\u001c\b/\u0019;dQ\u0016\u00148\u000fI\u0001\tiJ\fgn]'heV\u0011\u00111\u0006\t\u0006Q\u00055\u0012qD\u0005\u0004\u0003_I#AB(qi&|g.\u0001\u0007ue\u0006t7/T4s?\u0012*\u0017\u000f\u0006\u0003\u00026\u0005m\u0002c\u0001\u0015\u00028%\u0019\u0011\u0011H\u0015\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{i\u0011\u0011!a\u0001\u0003W\t1\u0001\u001f\u00132\u0003%!(/\u00198t\u001b\u001e\u0014\b%A\u0006ue\u0006t7o\u0015;sK\u0006l\u0017a\u0004;sC:\u001c8\u000b\u001e:fC6|F%Z9\u0015\t\u0005U\u0012q\t\u0005\n\u0003{\u0001\u0012\u0011!a\u0001\u0003W\tA\u0002\u001e:b]N\u001cFO]3b[\u0002\na\u0002Z5ta\u0006$8\r[3s'\u0016tG\r\u0006\u0002\u0002PAQ\u0011\u0011KA,\u00037\nY&a\u001a\u000e\u0005\u0005M#bAA+U\u0006A1oY1mC\u0012\u001cH.\u0003\u0003\u0002Z\u0005M#\u0001\u0002$m_^\u0004B!!\u0018\u0002d5\u0011\u0011q\f\u0006\u0004\u0003C\n\u0013aB7fgN\fw-Z\u0005\u0005\u0003K\nyF\u0001\u0007GY><XI\u001c<fY>\u0004X\r\u0005\u0003\u0002j\u0005-T\"A2\n\u0007\u000554MA\u0004O_R,6/\u001a3\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\*f]\u0012$\"!a\u001d\u0015\r\u0005U\u0014QRAH!\u001dI\u0017qOA>\u0003OJ1!!\u001fk\u0005\u00159%/\u00199i!\u001dI\u0017QPAA\u00037J1!a k\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0003\u0002\u0004\u0006%UBAAC\u0015\r\t9)I\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002\f\u0006\u0015%\u0001\u0006$m_^$&/\u00198tC\u000e$\u0018n\u001c8Fm\u0016tG\u000fC\u0003_'\u0001\u000fq\fC\u0003h'\u0001\u000f\u0001.A\tue\u0006t7/Y2uS>t7\u000b\u001e:fC6$B!!&\u0002\"B1\u0011qSAO\u0003?i!!!'\u000b\u0007\u0005m\u0015&\u0001\u0003vi&d\u0017\u0002BAP\u00033\u00131\u0001\u0016:z\u0011\u001d\t\u0019\u000b\u0006a\u0001\u0003?\tA\u0001^'heV\u0011\u0011q\u0015\t\u0004\t\u0006%\u0016bAAV7\t\tB)[:qCR\u001c\u0007.\u001a:Ck&dG-\u001a:\u0002\u0011\t,\u0018\u000e\u001c3fe\u0002\nAB\u0019:jI\u001e,7k\\;sG\u0016$\u0002\"a-\u0002:\u0006\r\u0017q\u0019\t\t\u0003#\n),a\u0017\u0002h%!\u0011qWA*\u0005\u0019\u0019v.\u001e:dK\"9\u00111X\fA\u0002\u0005u\u0016\u0001E5oi\u0016\u0014h.\u00197Qe>4\u0018\u000eZ3s!\r)\u0014qX\u0005\u0004\u0003\u00034$\u0001\u0006\"sS\u0012<W\r\u0015:pm&$WM]\"p]\u001aLw\rC\u0004\u0002F^\u0001\r!!0\u0002\u0011A\u0014xN^5eKJDq!!3\u0018\u0001\u0004\tY-\u0001\u0004m_\u001e<WM\u001d\t\u0005\u0003\u001b\f).\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003\u001dawnZ4j]\u001eT1!a'$\u0013\u0011\t9.a4\u0003\r1{wmZ3s\u0003\u0015\u0019H/\u0019:u)\t\t)$\u0001\u0003ti>\u0004\b")
public class RunnableDispatcher
implements JmsStreamSupport {
    private final BridgeProviderRegistry registry;
    private final IdAwareConnectionFactory cf;
    private final DispatcherBuilderSupport bs;
    private final PersistenceService pSvc;
    private final ResourceTypeRouterConfig routerCfg;
    private final ActorSystem system;
    private final Materializer materializer;
    private final Map<String, ActorRef> startedDispatchers;
    private Option<ActorRef> transMgr;
    private Option<ActorRef> transStream;
    private final DispatcherBuilder builder;

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, Logger log, Seq<FlowEnvelope> msgs, ActorSystem system, Materializer materializer, ExecutionContext ectxt) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (Logger)log, msgs, (ActorSystem)system, (Materializer)materializer, (ExecutionContext)ectxt);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, Logger log, Integer listener, Option<String> selector, FiniteDuration timeout, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (Logger)log, (Integer)listener, selector, (FiniteDuration)timeout, (ActorSystem)system, (Materializer)materializer);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system, (Materializer)materializer);
    }

    public boolean jmsProducer$default$3() {
        return JmsStreamSupport.jmsProducer$default$3$((JmsStreamSupport)this);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JMSConsumerSettings settings, FlowHeaderConfig headerConfig, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, (FlowHeaderConfig)headerConfig, (ActorSystem)system);
    }

    public Source<FlowEnvelope, NotUsed> restartableConsumer(String name, JMSConsumerSettings settings, FlowHeaderConfig headerConfig, ActorSystem system) {
        return JmsStreamSupport.restartableConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, (FlowHeaderConfig)headerConfig, (ActorSystem)system);
    }

    private Map<String, ActorRef> startedDispatchers() {
        return this.startedDispatchers;
    }

    private Option<ActorRef> transMgr() {
        return this.transMgr;
    }

    private void transMgr_$eq(Option<ActorRef> x$1) {
        this.transMgr = x$1;
    }

    private Option<ActorRef> transStream() {
        return this.transStream;
    }

    private void transStream_$eq(Option<ActorRef> x$1) {
        this.transStream = x$1;
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> dispatcherSend() {
        Logger x$1 = this.bs.streamLogger();
        IdAwareConnectionFactory x$2 = this.cf;
        Function1 & Serializable & scala.Serializable x$3 = (Function1 & Serializable & scala.Serializable)s -> new DispatcherDestinationResolver((JmsProducerSettings)s, $this.registry, $this.bs);
        FiniteDuration x$4 = JmsProducerSettings$.MODULE$.apply$default$3();
        Option x$5 = JmsProducerSettings$.MODULE$.apply$default$4();
        int x$6 = JmsProducerSettings$.MODULE$.apply$default$5();
        int x$7 = JmsProducerSettings$.MODULE$.apply$default$7();
        JmsDeliveryMode x$8 = JmsProducerSettings$.MODULE$.apply$default$8();
        Option x$9 = JmsProducerSettings$.MODULE$.apply$default$9();
        Function0 x$10 = JmsProducerSettings$.MODULE$.apply$default$10();
        FiniteDuration x$11 = JmsProducerSettings$.MODULE$.apply$default$11();
        JmsProducerSettings sendProducerSettings = new JmsProducerSettings(x$1, x$2, x$4, x$5, x$6, (Function1)x$3, x$7, x$8, x$9, x$10, x$11);
        String x$12 = "dispatcherSend";
        boolean x$13 = false;
        JmsProducerSettings x$14 = sendProducerSettings;
        return this.jmsProducer(x$12, x$14, x$13, this.system, this.materializer);
    }

    public Graph<FlowShape<FlowTransactionEvent, FlowEnvelope>, NotUsed> transactionSend(ActorSystem system, Materializer materializer) {
        return GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            BridgeProviderConfig internal = (BridgeProviderConfig)$this.registry.internalProvider().get();
            FlowShape transform = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable & scala.Serializable)t -> {
                FlowEnvelope qual$1 = (FlowEnvelope)((Function1)FlowTransactionEvent$.MODULE$.event2envelope().apply((Object)$this.bs.headerConfig())).apply(t);
                String x$1 = $this.bs.headerConfig().headerTrackSource();
                String x$2 = $this.bs.streamLogger().name();
                boolean x$3 = qual$1.withHeader$default$3();
                return (FlowEnvelope)qual$1.withHeader(x$1, (Object)x$2, x$3).get();
            }));
            Logger x$4 = $this.bs.streamLogger();
            IdAwareConnectionFactory x$5 = $this.cf;
            Some x$6 = new Some((Object)internal.transactions());
            JmsDeliveryMode x$7 = JmsDeliveryMode$.MODULE$.Persistent();
            int x$8 = 4;
            None$ x$9 = None$.MODULE$;
            FiniteDuration x$10 = JmsProducerSettings$.MODULE$.apply$default$3();
            int x$11 = JmsProducerSettings$.MODULE$.apply$default$5();
            Function1 x$12 = JmsProducerSettings$.MODULE$.apply$default$6();
            Function0 x$13 = JmsProducerSettings$.MODULE$.apply$default$10();
            FiniteDuration x$14 = JmsProducerSettings$.MODULE$.apply$default$11();
            JmsProducerSettings transactionSendSettings = new JmsProducerSettings(x$4, x$5, x$10, (Option)x$6, x$11, x$12, x$8, x$7, (Option)x$9, x$13, x$14);
            FlowShape producer = (FlowShape)b.add(this.jmsProducer("transactionSend", transactionSendSettings, false, system, materializer));
            GraphDSL.Implicits$.MODULE$.flow2flow(transform, b).$tilde$greater(producer, b);
            return new FlowShape(transform.in(), producer.out());
        });
    }

    public Try<ActorRef> transactionStream(ActorRef tMgr) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            DispatcherBuilderSupport builderSupport = $this.bs;
            FlowHeaderConfig x$1 = $this.bs.headerConfig();
            ActorRef x$2 = tMgr;
            IdAwareConnectionFactory x$3 = $this.cf;
            ResourceTypeRouterConfig x$4 = $this.routerCfg;
            Logger x$5 = Logger$.MODULE$.apply(new StringBuilder(13).append($this.bs.headerConfig().prefix()).append(".transactions").toString());
            return new TransactionOutbound(x$1, x$2, x$4, x$3, x$5, $this.system, builderSupport).build();
        });
    }

    public DispatcherBuilder builder() {
        return this.builder;
    }

    public Source<FlowEnvelope, NotUsed> bridgeSource(BridgeProviderConfig internalProvider, BridgeProviderConfig provider, Logger logger) {
        Source source;
        Some some;
        Logger x$1 = this.bs.streamLogger();
        IdAwareConnectionFactory x$2 = this.cf;
        int x$3 = 3;
        AcknowledgeMode x$4 = AcknowledgeMode$.MODULE$.ClientAcknowledge();
        if (provider.internal()) {
            some = new Some((Object)provider.inbound());
        } else {
            String dest = new StringBuilder(2).append(internalProvider.inbound().name()).append(".").append(provider.vendor()).append(".").append(provider.provider()).toString();
            some = new Some(JmsDestination$.MODULE$.create(dest).get());
        }
        Some x$5 = some;
        FiniteDuration x$6 = JMSConsumerSettings$.MODULE$.apply$default$3();
        int x$7 = JMSConsumerSettings$.MODULE$.apply$default$7();
        Option x$8 = JMSConsumerSettings$.MODULE$.apply$default$8();
        FiniteDuration x$9 = JMSConsumerSettings$.MODULE$.apply$default$9();
        Option x$10 = JMSConsumerSettings$.MODULE$.apply$default$10();
        FiniteDuration x$11 = JMSConsumerSettings$.MODULE$.apply$default$11();
        JMSConsumerSettings settings = new JMSConsumerSettings(x$1, x$2, x$6, (Option)x$5, x$3, x$4, x$7, x$8, x$9, x$10, x$11);
        Source source2 = this.jmsConsumer(((JmsDestination)settings.jmsDestination().get()).asString(), settings, this.bs.headerConfig(), this.system);
        if (provider.internal()) {
            Flow startTransaction = new TransactionWiretap(this.cf, provider.transactions(), this.bs.headerConfig(), true, "internalDispatcher", this.bs.streamLogger(), this.system, this.materializer).flow();
            source = source2.via((Graph)startTransaction);
        } else {
            source = source2;
        }
        return source;
    }

    public void start() {
        try {
            BridgeProviderConfig internalProvider = (BridgeProviderConfig)this.registry.internalProvider().get();
            this.transMgr_$eq((Option<ActorRef>)new Some((Object)this.system.actorOf(FlowTransactionManager$.MODULE$.props(this.pSvc))));
            this.transStream_$eq((Option<ActorRef>)new Some(this.transactionStream((ActorRef)this.transMgr().get()).get()));
            Flow dispatcher = Flow$.MODULE$.fromGraph(this.builder().dispatcher());
            this.registry.allProvider().foreach((Function1 & Serializable & scala.Serializable)provider -> {
                Logger dispLogger = Logger$.MODULE$.apply(new StringBuilder(2).append($this.bs.streamLogger().name()).append(".").append(provider.vendor()).append(".").append(provider.provider()).toString());
                Source source = this.bridgeSource(internalProvider, (BridgeProviderConfig)provider, dispLogger).via((Graph)dispatcher);
                StreamControllerConfig qual$1 = (StreamControllerConfig)StreamControllerConfig$.MODULE$.fromConfig($this.routerCfg.rawConfig()).get();
                String x$1 = dispLogger.name();
                Source x$2 = source.via(this.transactionSend($this.system, $this.materializer));
                FiniteDuration x$3 = qual$1.copy$default$3();
                FiniteDuration x$4 = qual$1.copy$default$4();
                boolean x$5 = qual$1.copy$default$5();
                boolean x$6 = qual$1.copy$default$6();
                double x$7 = qual$1.copy$default$7();
                StreamControllerConfig streamCfg = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6, x$7);
                ActorRef actor = $this.system.actorOf(StreamController$.MODULE$.props(streamCfg, $this.system, $this.materializer));
                $this.bs.streamLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Started dispatcher flow for provider [").append(provider.id()).append("]").toString());
                return this.startedDispatchers().put((Object)provider.id(), (Object)actor);
            });
        }
        catch (Throwable t) {
            this.bs.streamLogger().error(t, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Failed to start dispatcher [").append(t.getMessage()).append("]").toString());
        }
    }

    public void stop() {
        this.transMgr().foreach((Function1 & Serializable & scala.Serializable)actor -> {
            this.system.stop(actor);
            return BoxedUnit.UNIT;
        });
        this.transStream().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            RunnableDispatcher.$anonfun$stop$2(x$1);
            return BoxedUnit.UNIT;
        });
        this.startedDispatchers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RunnableDispatcher.$anonfun$stop$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.startedDispatchers().clear();
    }

    public static final /* synthetic */ void $anonfun$stop$2(ActorRef x$1) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$1);
        StreamController.Stop$ x$12 = StreamController.Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$12);
        qual$1.$bang((Object)x$12, x$2);
    }

    public static final /* synthetic */ void $anonfun$stop$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ActorRef d = (ActorRef)tuple2._2();
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(d);
        StreamController.Stop$ x$3 = StreamController.Stop$.MODULE$;
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RunnableDispatcher(BridgeProviderRegistry registry, IdAwareConnectionFactory cf, DispatcherBuilderSupport bs, ContainerIdentifierService idSvc, PersistenceService pSvc, ResourceTypeRouterConfig routerCfg, ActorSystem system, Materializer materializer) {
        this.registry = registry;
        this.cf = cf;
        this.bs = bs;
        this.pSvc = pSvc;
        this.routerCfg = routerCfg;
        this.system = system;
        this.materializer = materializer;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        this.startedDispatchers = Map$.MODULE$.empty();
        this.transMgr = None$.MODULE$;
        this.transStream = None$.MODULE$;
        this.builder = new DispatcherBuilder(idSvc, routerCfg, this.dispatcherSend(), bs);
    }
}

