/*
 * Decompiled with CFR 0.152.
 */
package blended.streams.dispatcher.internal.builder;

import akka.NotUsed;
import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.ScalaActorRef;
import akka.actor.package$;
import akka.stream.FlowShape;
import akka.stream.Graph;
import akka.stream.KillSwitch;
import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import akka.stream.scaladsl.GraphDSL;
import akka.stream.scaladsl.GraphDSL$;
import akka.stream.scaladsl.Source;
import blended.container.context.api.ContainerIdentifierService;
import blended.jms.bridge.BridgeProviderConfig;
import blended.jms.bridge.BridgeProviderRegistry;
import blended.jms.utils.IdAwareConnectionFactory;
import blended.jms.utils.JmsDestination;
import blended.jms.utils.JmsDestination$;
import blended.persistence.PersistenceService;
import blended.streams.StreamController;
import blended.streams.StreamController$;
import blended.streams.StreamControllerConfig;
import blended.streams.StreamControllerConfig$;
import blended.streams.dispatcher.internal.ResourceTypeRouterConfig;
import blended.streams.dispatcher.internal.builder.DispatcherBuilder;
import blended.streams.dispatcher.internal.builder.DispatcherBuilderSupport;
import blended.streams.dispatcher.internal.builder.DispatcherDestinationResolver;
import blended.streams.dispatcher.internal.builder.TransactionOutbound;
import blended.streams.jms.AcknowledgeMode;
import blended.streams.jms.AcknowledgeMode$;
import blended.streams.jms.JMSConsumerSettings;
import blended.streams.jms.JMSConsumerSettings$;
import blended.streams.jms.JmsDeliveryMode;
import blended.streams.jms.JmsDeliveryMode$;
import blended.streams.jms.JmsProducerSettings;
import blended.streams.jms.JmsProducerSettings$;
import blended.streams.jms.JmsStreamSupport;
import blended.streams.message.FlowEnvelope;
import blended.streams.processor.Collector;
import blended.streams.transaction.FlowHeaderConfig;
import blended.streams.transaction.FlowTransactionEvent;
import blended.streams.transaction.FlowTransactionEvent$;
import blended.streams.transaction.FlowTransactionManager$;
import blended.streams.transaction.TransactionDestinationResolver;
import blended.streams.transaction.TransactionWiretap;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001\u0002\u000f\u001e\u0001!B\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IA\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011!!\u0006A!A!\u0002\u0013)\u0006\u0002C.\u0001\u0005\u0003\u0005\u000b\u0011\u0002/\t\u0011\u0001\u0004!\u0011!Q\u0001\f\u0005D\u0001\"\u001b\u0001\u0003\u0002\u0003\u0006YA\u001b\u0005\u0006a\u0002!\t!\u001d\u0005\by\u0002\u0011\r\u0011\"\u0003~\u0011\u001d\tI\u0003\u0001Q\u0001\nyD\u0011\"a\u000b\u0001\u0001\u0004%I!!\f\t\u0013\u0005U\u0002\u00011A\u0005\n\u0005]\u0002\u0002CA\"\u0001\u0001\u0006K!a\f\t\u0013\u0005\u0015\u0003\u00011A\u0005\n\u00055\u0002\"CA$\u0001\u0001\u0007I\u0011BA%\u0011!\ti\u0005\u0001Q!\n\u0005=\u0002\u0002\u0003\u0011\u0001\u0005\u0004%I!a\u0014\t\u0011\u0005]\u0003\u0001)A\u0005\u0003#B\u0001\"!\u0017\u0001\t\u0003i\u00121\f\u0005\t\u0003{\u0002A\u0011A\u000f\u0002\u0000!A\u0011q\u0014\u0001\u0005\u0002u\t\t\u000bC\u0005\u001f\u0001\t\u0007I\u0011A\u000f\u00024\"A\u00111\u0018\u0001!\u0002\u0013\t)\fC\u0004\u0002>\u0002!\t!a0\t\u000f\u0005\u0005\b\u0001\"\u0001\u0002d\"9\u0011Q\u001d\u0001\u0005\u0002\u0005\r(A\u0005*v]:\f'\r\\3ESN\u0004\u0018\r^2iKJT!AH\u0010\u0002\u000f\t,\u0018\u000e\u001c3fe*\u0011\u0001%I\u0001\tS:$XM\u001d8bY*\u0011!eI\u0001\u000bI&\u001c\b/\u0019;dQ\u0016\u0014(B\u0001\u0013&\u0003\u001d\u0019HO]3b[NT\u0011AJ\u0001\bE2,g\u000eZ3e\u0007\u0001\u00192\u0001A\u00150!\tQS&D\u0001,\u0015\u0005a\u0013!B:dC2\f\u0017B\u0001\u0018,\u0005\u0019\te.\u001f*fMB\u0011\u0001gM\u0007\u0002c)\u0011!gI\u0001\u0004U6\u001c\u0018B\u0001\u001b2\u0005AQUn]*ue\u0016\fWnU;qa>\u0014H/\u0001\u0005sK\u001eL7\u000f\u001e:z!\t94(D\u00019\u0015\tI$(\u0001\u0004ce&$w-\u001a\u0006\u0003e\u0015J!\u0001\u0010\u001d\u0003-\t\u0013\u0018\u000eZ4f!J|g/\u001b3feJ+w-[:uef\f!a\u00194\u0011\u0005}\u0012U\"\u0001!\u000b\u0005\u0005S\u0014!B;uS2\u001c\u0018BA\"A\u0005aIE-Q<be\u0016\u001cuN\u001c8fGRLwN\u001c$bGR|'/_\u0001\u0003EN\u0004\"AR$\u000e\u0003uI!\u0001S\u000f\u00031\u0011K7\u000f]1uG\",'OQ;jY\u0012,'oU;qa>\u0014H/A\u0003jIN38\r\u0005\u0002L%6\tAJ\u0003\u0002N\u001d\u0006\u0019\u0011\r]5\u000b\u0005=\u0003\u0016aB2p]R,\u0007\u0010\u001e\u0006\u0003#\u0016\n\u0011bY8oi\u0006Lg.\u001a:\n\u0005Mc%AG\"p]R\f\u0017N\\3s\u0013\u0012,g\u000e^5gS\u0016\u00148+\u001a:wS\u000e,\u0017\u0001\u00029Tm\u000e\u0004\"AV-\u000e\u0003]S!\u0001W\u0013\u0002\u0017A,'o]5ti\u0016t7-Z\u0005\u00035^\u0013!\u0003U3sg&\u001cH/\u001a8dKN+'O^5dK\u0006I!o\\;uKJ\u001cem\u001a\t\u0003;zk\u0011aH\u0005\u0003?~\u0011\u0001DU3t_V\u00148-\u001a+za\u0016\u0014v.\u001e;fe\u000e{gNZ5h\u0003\u0019\u0019\u0018p\u001d;f[B\u0011!mZ\u0007\u0002G*\u0011A-Z\u0001\u0006C\u000e$xN\u001d\u0006\u0002M\u0006!\u0011m[6b\u0013\tA7MA\u0006BGR|'oU=ti\u0016l\u0017\u0001D7bi\u0016\u0014\u0018.\u00197ju\u0016\u0014\bCA6o\u001b\u0005a'BA7f\u0003\u0019\u0019HO]3b[&\u0011q\u000e\u001c\u0002\r\u001b\u0006$XM]5bY&TXM]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fI4x\u000f_={wR\u00191\u000f^;\u0011\u0005\u0019\u0003\u0001\"\u00021\n\u0001\b\t\u0007\"B5\n\u0001\bQ\u0007\"B\u001b\n\u0001\u00041\u0004\"B\u001f\n\u0001\u0004q\u0004\"\u0002#\n\u0001\u0004)\u0005\"B%\n\u0001\u0004Q\u0005\"\u0002+\n\u0001\u0004)\u0006\"B.\n\u0001\u0004a\u0016AE:uCJ$X\r\u001a#jgB\fGo\u00195feN,\u0012A \t\b\u007f\u0006%\u0011QBA\u0012\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u000fY\u0013AC2pY2,7\r^5p]&!\u00111BA\u0001\u0005\ri\u0015\r\u001d\t\u0005\u0003\u001f\tiB\u0004\u0003\u0002\u0012\u0005e\u0001cAA\nW5\u0011\u0011Q\u0003\u0006\u0004\u0003/9\u0013A\u0002\u001fs_>$h(C\u0002\u0002\u001c-\na\u0001\u0015:fI\u00164\u0017\u0002BA\u0010\u0003C\u0011aa\u0015;sS:<'bAA\u000eWA\u0019!-!\n\n\u0007\u0005\u001d2M\u0001\u0005BGR|'OU3g\u0003M\u0019H/\u0019:uK\u0012$\u0015n\u001d9bi\u000eDWM]:!\u0003!!(/\u00198t\u001b\u001e\u0014XCAA\u0018!\u0015Q\u0013\u0011GA\u0012\u0013\r\t\u0019d\u000b\u0002\u0007\u001fB$\u0018n\u001c8\u0002\u0019Q\u0014\u0018M\\:NOJ|F%Z9\u0015\t\u0005e\u0012q\b\t\u0004U\u0005m\u0012bAA\u001fW\t!QK\\5u\u0011%\t\t%DA\u0001\u0002\u0004\ty#A\u0002yIE\n\u0011\u0002\u001e:b]NluM\u001d\u0011\u0002\u0017Q\u0014\u0018M\\:TiJ,\u0017-\\\u0001\u0010iJ\fgn]*ue\u0016\fWn\u0018\u0013fcR!\u0011\u0011HA&\u0011%\t\t\u0005EA\u0001\u0002\u0004\ty#\u0001\u0007ue\u0006t7o\u0015;sK\u0006l\u0007%\u0006\u0002\u0002RA\u0019q'a\u0015\n\u0007\u0005U\u0003H\u0001\u000bCe&$w-\u001a)s_ZLG-\u001a:D_:4\u0017nZ\u0001\nS:$XM\u001d8bY\u0002\na\u0002Z5ta\u0006$8\r[3s'\u0016tG\r\u0006\u0002\u0002^AQ\u0011qLA3\u0003S\nI'!\u001e\u000e\u0005\u0005\u0005$bAA2Y\u0006A1oY1mC\u0012\u001cH.\u0003\u0003\u0002h\u0005\u0005$\u0001\u0002$m_^\u0004B!a\u001b\u0002r5\u0011\u0011Q\u000e\u0006\u0004\u0003_\u001a\u0013aB7fgN\fw-Z\u0005\u0005\u0003g\niG\u0001\u0007GY><XI\u001c<fY>\u0004X\r\u0005\u0003\u0002x\u0005eT\"A3\n\u0007\u0005mTMA\u0004O_R,6/\u001a3\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\*f]\u0012$\"!!!\u0015\r\u0005\r\u00151TAO!\u001dY\u0017QQAE\u0003kJ1!a\"m\u0005\u00159%/\u00199i!\u001dY\u00171RAH\u0003SJ1!!$m\u0005%1En\\<TQ\u0006\u0004X\r\u0005\u0003\u0002\u0012\u0006]UBAAJ\u0015\r\t)jI\u0001\fiJ\fgn]1di&|g.\u0003\u0003\u0002\u001a\u0006M%\u0001\u0006$m_^$&/\u00198tC\u000e$\u0018n\u001c8Fm\u0016tG\u000fC\u0003a+\u0001\u000f\u0011\rC\u0003j+\u0001\u000f!.A\tue\u0006t7/Y2uS>t7\u000b\u001e:fC6$B!a)\u00020B1\u0011QUAV\u0003Gi!!a*\u000b\u0007\u0005%6&\u0001\u0003vi&d\u0017\u0002BAW\u0003O\u00131\u0001\u0016:z\u0011\u001d\t\tL\u0006a\u0001\u0003G\tA\u0001^'heV\u0011\u0011Q\u0017\t\u0004\r\u0006]\u0016bAA];\t\tB)[:qCR\u001c\u0007.\u001a:Ck&dG-\u001a:\u0002\u0011\t,\u0018\u000e\u001c3fe\u0002\nAB\u0019:jI\u001e,7k\\;sG\u0016$\u0002\"!1\u0002H\u0006-\u0017q\u001a\t\t\u0003?\n\u0019-!\u001b\u0002v%!\u0011QYA1\u0005\u0019\u0019v.\u001e:dK\"9\u0011\u0011Z\rA\u0002\u0005E\u0013\u0001E5oi\u0016\u0014h.\u00197Qe>4\u0018\u000eZ3s\u0011\u001d\ti-\u0007a\u0001\u0003#\n\u0001\u0002\u001d:pm&$WM\u001d\u0005\b\u0003#L\u0002\u0019AAj\u0003\u0019awnZ4feB!\u0011Q[Ao\u001b\t\t9N\u0003\u0003\u0002Z\u0006m\u0017a\u00027pO\u001eLgn\u001a\u0006\u0004\u0003S+\u0013\u0002BAp\u0003/\u0014a\u0001T8hO\u0016\u0014\u0018!B:uCJ$HCAA\u001d\u0003\u0011\u0019Ho\u001c9")
public class RunnableDispatcher
implements JmsStreamSupport {
    private final BridgeProviderRegistry registry;
    private final IdAwareConnectionFactory cf;
    private final DispatcherBuilderSupport bs;
    private final PersistenceService pSvc;
    private final ResourceTypeRouterConfig routerCfg;
    private final ActorSystem system;
    private final Materializer materializer;
    private final Map<String, ActorRef> startedDispatchers;
    private Option<ActorRef> transMgr;
    private Option<ActorRef> transStream;
    private final BridgeProviderConfig internal;
    private final DispatcherBuilder builder;

    public Try<KillSwitch> processMessages(Flow<FlowEnvelope, FlowEnvelope, ?> processFlow, Seq<FlowEnvelope> msgs, ActorSystem system) {
        return JmsStreamSupport.processMessages$((JmsStreamSupport)this, processFlow, msgs, (ActorSystem)system);
    }

    public Try<KillSwitch> sendMessages(JmsProducerSettings producerSettings, Logger log, Seq<FlowEnvelope> msgs, ActorSystem system, Materializer materializer, ExecutionContext ectxt) {
        return JmsStreamSupport.sendMessages$((JmsStreamSupport)this, (JmsProducerSettings)producerSettings, (Logger)log, msgs, (ActorSystem)system, (Materializer)materializer, (ExecutionContext)ectxt);
    }

    public Collector<FlowEnvelope> receiveMessages(FlowHeaderConfig headerCfg, IdAwareConnectionFactory cf, JmsDestination dest, Logger log, Integer listener, Option<FiniteDuration> minMessageDelay, Option<String> selector, FiniteDuration timeout, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.receiveMessages$((JmsStreamSupport)this, (FlowHeaderConfig)headerCfg, (IdAwareConnectionFactory)cf, (JmsDestination)dest, (Logger)log, (Integer)listener, minMessageDelay, selector, (FiniteDuration)timeout, (ActorSystem)system, (Materializer)materializer);
    }

    public Integer receiveMessages$default$5() {
        return JmsStreamSupport.receiveMessages$default$5$((JmsStreamSupport)this);
    }

    public Option<FiniteDuration> receiveMessages$default$6() {
        return JmsStreamSupport.receiveMessages$default$6$((JmsStreamSupport)this);
    }

    public Option<String> receiveMessages$default$7() {
        return JmsStreamSupport.receiveMessages$default$7$((JmsStreamSupport)this);
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> jmsProducer(String name, JmsProducerSettings settings, boolean autoAck, ActorSystem system, Materializer materializer) {
        return JmsStreamSupport.jmsProducer$((JmsStreamSupport)this, (String)name, (JmsProducerSettings)settings, (boolean)autoAck, (ActorSystem)system, (Materializer)materializer);
    }

    public boolean jmsProducer$default$3() {
        return JmsStreamSupport.jmsProducer$default$3$((JmsStreamSupport)this);
    }

    public Source<FlowEnvelope, NotUsed> jmsConsumer(String name, JMSConsumerSettings settings, Option<FiniteDuration> minMessageDelay, ActorSystem system) {
        return JmsStreamSupport.jmsConsumer$((JmsStreamSupport)this, (String)name, (JMSConsumerSettings)settings, minMessageDelay, (ActorSystem)system);
    }

    private Map<String, ActorRef> startedDispatchers() {
        return this.startedDispatchers;
    }

    private Option<ActorRef> transMgr() {
        return this.transMgr;
    }

    private void transMgr_$eq(Option<ActorRef> x$1) {
        this.transMgr = x$1;
    }

    private Option<ActorRef> transStream() {
        return this.transStream;
    }

    private void transStream_$eq(Option<ActorRef> x$1) {
        this.transStream = x$1;
    }

    private BridgeProviderConfig internal() {
        return this.internal;
    }

    public Flow<FlowEnvelope, FlowEnvelope, NotUsed> dispatcherSend() {
        Logger x$1 = this.bs.streamLogger();
        IdAwareConnectionFactory x$2 = this.cf;
        FlowHeaderConfig x$3 = this.bs.headerConfig();
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)s -> new DispatcherDestinationResolver((JmsProducerSettings)s, $this.registry, $this.bs);
        FiniteDuration x$5 = JmsProducerSettings$.MODULE$.apply$default$4();
        Option x$6 = JmsProducerSettings$.MODULE$.apply$default$5();
        int x$7 = JmsProducerSettings$.MODULE$.apply$default$6();
        int x$8 = JmsProducerSettings$.MODULE$.apply$default$8();
        JmsDeliveryMode x$9 = JmsProducerSettings$.MODULE$.apply$default$9();
        Option x$10 = JmsProducerSettings$.MODULE$.apply$default$10();
        Function0 x$11 = JmsProducerSettings$.MODULE$.apply$default$11();
        FiniteDuration x$12 = JmsProducerSettings$.MODULE$.apply$default$12();
        boolean x$13 = JmsProducerSettings$.MODULE$.apply$default$13();
        JmsProducerSettings sendProducerSettings = new JmsProducerSettings(x$1, x$3, x$2, x$5, x$6, x$7, (Function1)x$4, x$8, x$9, x$10, x$11, x$12, x$13);
        String x$14 = "dispatcherSend";
        boolean x$15 = false;
        JmsProducerSettings x$16 = sendProducerSettings;
        return this.jmsProducer(x$14, x$16, x$15, this.system, this.materializer);
    }

    public Graph<FlowShape<FlowTransactionEvent, FlowEnvelope>, NotUsed> transactionSend(ActorSystem system, Materializer materializer) {
        return GraphDSL$.MODULE$.create((Function1 & Serializable & scala.Serializable)b -> {
            FlowShape transform = (FlowShape)b.add((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable & scala.Serializable)t -> {
                FlowEnvelope qual$1 = (FlowEnvelope)((Function1)FlowTransactionEvent$.MODULE$.event2envelope().apply((Object)$this.bs.headerConfig())).apply(t);
                String x$1 = $this.bs.headerConfig().headerTrackSource();
                String x$2 = $this.bs.streamLogger().name();
                boolean x$3 = qual$1.withHeader$default$3();
                return (FlowEnvelope)qual$1.withHeader(x$1, (Object)x$2, x$3).get();
            }));
            Logger x$4 = $this.bs.streamLogger();
            FlowHeaderConfig x$5 = $this.bs.headerConfig();
            IdAwareConnectionFactory x$6 = $this.cf;
            Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)s -> new TransactionDestinationResolver(s, JmsDestination$.MODULE$.asString(this.internal().transactions()));
            None$ x$8 = None$.MODULE$;
            JmsDeliveryMode x$9 = JmsDeliveryMode$.MODULE$.Persistent();
            int x$10 = 4;
            None$ x$11 = None$.MODULE$;
            FiniteDuration x$12 = JmsProducerSettings$.MODULE$.apply$default$4();
            int x$13 = JmsProducerSettings$.MODULE$.apply$default$6();
            Function0 x$14 = JmsProducerSettings$.MODULE$.apply$default$11();
            FiniteDuration x$15 = JmsProducerSettings$.MODULE$.apply$default$12();
            boolean x$16 = JmsProducerSettings$.MODULE$.apply$default$13();
            JmsProducerSettings transactionSendSettings = new JmsProducerSettings(x$4, x$5, x$6, x$12, (Option)x$8, x$13, (Function1)x$7, x$10, x$9, (Option)x$11, x$14, x$15, x$16);
            FlowShape producer = (FlowShape)b.add(this.jmsProducer("transactionSend", transactionSendSettings, false, system, materializer));
            GraphDSL.Implicits$.MODULE$.flow2flow(transform, b).$tilde$greater(producer, b);
            return new FlowShape(transform.in(), producer.out());
        });
    }

    public Try<ActorRef> transactionStream(ActorRef tMgr) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            DispatcherBuilderSupport builderSupport = $this.bs;
            FlowHeaderConfig x$1 = $this.bs.headerConfig();
            ActorRef x$2 = tMgr;
            IdAwareConnectionFactory x$3 = $this.cf;
            ResourceTypeRouterConfig x$4 = $this.routerCfg;
            Logger x$5 = Logger$.MODULE$.apply(new StringBuilder(13).append($this.bs.headerConfig().prefix()).append(".transactions").toString());
            return new TransactionOutbound(x$1, x$2, x$4, x$3, x$5, $this.system, builderSupport).build();
        });
    }

    public DispatcherBuilder builder() {
        return this.builder;
    }

    public Source<FlowEnvelope, NotUsed> bridgeSource(BridgeProviderConfig internalProvider, BridgeProviderConfig provider, Logger logger) {
        Source source;
        Some some;
        Logger x$1 = this.bs.streamLogger();
        FlowHeaderConfig x$2 = this.bs.headerConfig();
        IdAwareConnectionFactory x$3 = this.cf;
        int x$4 = 3;
        AcknowledgeMode x$5 = AcknowledgeMode$.MODULE$.ClientAcknowledge();
        if (provider.internal()) {
            some = new Some((Object)provider.inbound());
        } else {
            String dest = new StringBuilder(2).append(internalProvider.inbound().name()).append(".").append(provider.vendor()).append(".").append(provider.provider()).toString();
            some = new Some(JmsDestination$.MODULE$.create(dest).get());
        }
        Some x$6 = some;
        FiniteDuration x$7 = JMSConsumerSettings$.MODULE$.apply$default$4();
        FiniteDuration x$8 = JMSConsumerSettings$.MODULE$.apply$default$7();
        FiniteDuration x$9 = JMSConsumerSettings$.MODULE$.apply$default$8();
        int x$10 = JMSConsumerSettings$.MODULE$.apply$default$10();
        Option x$11 = JMSConsumerSettings$.MODULE$.apply$default$11();
        FiniteDuration x$12 = JMSConsumerSettings$.MODULE$.apply$default$12();
        Option x$13 = JMSConsumerSettings$.MODULE$.apply$default$13();
        FiniteDuration x$14 = JMSConsumerSettings$.MODULE$.apply$default$14();
        JMSConsumerSettings settings = new JMSConsumerSettings(x$1, x$2, x$3, x$7, (Option)x$6, x$4, x$8, x$9, x$5, x$10, x$11, x$12, x$13, x$14);
        Source source2 = this.jmsConsumer(((JmsDestination)settings.jmsDestination().get()).asString(), settings, (Option<FiniteDuration>)None$.MODULE$, this.system);
        if (provider.internal()) {
            Source source3;
            Option option = Option$.MODULE$.apply((Object)System.getProperty("blended.streams.transactionShard"));
            if (None$.MODULE$.equals(option)) {
                source3 = source2;
            } else if (option instanceof Some) {
                Some some2 = (Some)option;
                String shard = (String)some2.value();
                source3 = source2.via((Graph)Flow$.MODULE$.fromFunction((Function1 & Serializable & scala.Serializable)env -> (FlowEnvelope)env.withHeader($this.bs.headerConfig().headerTransShard(), (Object)shard, false).get()));
            } else {
                throw new MatchError((Object)option);
            }
            Source setShard = source3;
            Flow startTransaction = new TransactionWiretap(this.cf, provider.transactions(), this.bs.headerConfig(), true, "internalDispatcher", this.bs.streamLogger(), this.system, this.materializer).flow();
            source = setShard.via((Graph)startTransaction);
        } else {
            source = source2;
        }
        return source;
    }

    public void start() {
        try {
            BridgeProviderConfig internalProvider = (BridgeProviderConfig)this.registry.internalProvider().get();
            this.transMgr_$eq((Option<ActorRef>)new Some((Object)this.system.actorOf(FlowTransactionManager$.MODULE$.props(this.pSvc))));
            this.transStream_$eq((Option<ActorRef>)new Some(this.transactionStream((ActorRef)this.transMgr().get()).get()));
            Flow dispatcher = Flow$.MODULE$.fromGraph(this.builder().dispatcher());
            this.registry.allProvider().foreach((Function1 & Serializable & scala.Serializable)provider -> {
                Logger dispLogger = Logger$.MODULE$.apply(new StringBuilder(2).append($this.bs.streamLogger().name()).append(".").append(provider.vendor()).append(".").append(provider.provider()).toString());
                Source source = this.bridgeSource(internalProvider, (BridgeProviderConfig)provider, dispLogger).via((Graph)dispatcher);
                StreamControllerConfig qual$1 = (StreamControllerConfig)StreamControllerConfig$.MODULE$.fromConfig($this.routerCfg.rawConfig()).get();
                String x$1 = dispLogger.name();
                FiniteDuration x$2 = qual$1.copy$default$2();
                FiniteDuration x$3 = qual$1.copy$default$3();
                boolean x$4 = qual$1.copy$default$4();
                boolean x$5 = qual$1.copy$default$5();
                double x$6 = qual$1.copy$default$6();
                StreamControllerConfig streamCfg = qual$1.copy(x$1, x$2, x$3, x$4, x$5, x$6);
                ActorRef actor = $this.system.actorOf(StreamController$.MODULE$.props(source.via(this.transactionSend($this.system, $this.materializer)), streamCfg, $this.system, $this.materializer));
                $this.bs.streamLogger().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Started dispatcher flow for provider [").append(provider.id()).append("]").toString());
                return this.startedDispatchers().put((Object)provider.id(), (Object)actor);
            });
        }
        catch (Throwable t) {
            this.bs.streamLogger().error(t, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Failed to start dispatcher [").append(t.getMessage()).append("]").toString());
        }
    }

    public void stop() {
        this.transMgr().foreach((Function1 & Serializable & scala.Serializable)actor -> {
            this.system.stop(actor);
            return BoxedUnit.UNIT;
        });
        this.transStream().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            RunnableDispatcher.$anonfun$stop$2(x$1);
            return BoxedUnit.UNIT;
        });
        this.startedDispatchers().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            RunnableDispatcher.$anonfun$stop$3(x0$1);
            return BoxedUnit.UNIT;
        });
        this.startedDispatchers().clear();
    }

    public static final /* synthetic */ void $anonfun$stop$2(ActorRef x$1) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(x$1);
        StreamController.Stop$ x$12 = StreamController.Stop$.MODULE$;
        ActorRef x$2 = qual$1.$bang$default$2((Object)x$12);
        qual$1.$bang((Object)x$12, x$2);
    }

    public static final /* synthetic */ void $anonfun$stop$3(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        ActorRef d = (ActorRef)tuple2._2();
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(d);
        StreamController.Stop$ x$3 = StreamController.Stop$.MODULE$;
        ActorRef x$4 = qual$2.$bang$default$2((Object)x$3);
        qual$2.$bang((Object)x$3, x$4);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public RunnableDispatcher(BridgeProviderRegistry registry, IdAwareConnectionFactory cf, DispatcherBuilderSupport bs, ContainerIdentifierService idSvc, PersistenceService pSvc, ResourceTypeRouterConfig routerCfg, ActorSystem system, Materializer materializer) {
        this.registry = registry;
        this.cf = cf;
        this.bs = bs;
        this.pSvc = pSvc;
        this.routerCfg = routerCfg;
        this.system = system;
        this.materializer = materializer;
        JmsStreamSupport.$init$((JmsStreamSupport)this);
        this.startedDispatchers = Map$.MODULE$.empty();
        this.transMgr = None$.MODULE$;
        this.transStream = None$.MODULE$;
        this.internal = (BridgeProviderConfig)registry.internalProvider().get();
        this.builder = new DispatcherBuilder(idSvc, routerCfg, this.dispatcherSend(), bs);
    }
}

