/*
 * Decompiled with CFR 0.152.
 */
package blended.security;

import blended.container.context.api.ContainerContext;
import blended.security.AbstractLoginModule;
import blended.security.internal.LDAPLoginConfig;
import blended.security.internal.LDAPLoginConfig$;
import blended.security.internal.LdapSearchResult;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\u0005Mb\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAa\u0001\b\u0001!\u0002\u0013i\u0002bB\u0013\u0001\u0005\u0004%\tF\n\u0005\u0007i\u0001\u0001\u000b\u0011B\u0014\t\u0011U\u0002\u0001R1A\u0005\u0002YB\u0001\"\u0010\u0001\t\u0006\u0004&IA\u0010\u0005\u0006\u0013\u0002!\tE\u0013\u0005\u0006m\u0002!\tf\u001e\u0005\u0006w\u0002!\tf\u001e\u0005\u0006y\u0002!\tf\u001e\u0005\u0007{\u0002\u0001K\u0011\u0002@\t\u000f\u0005-\u0001\u0001\"\u0011\u0002\u000e!A\u00111\u0006\u0001!\n\u0013\tiCA\bM\t\u0006\u0003Fj\\4j]6{G-\u001e7f\u0015\t\u0001\u0012#\u0001\u0005tK\u000e,(/\u001b;z\u0015\u0005\u0011\u0012a\u00022mK:$W\rZ\u0002\u0001'\t\u0001Q\u0003\u0005\u0002\u0017/5\tq\"\u0003\u0002\u0019\u001f\t\u0019\u0012IY:ue\u0006\u001cG\u000fT8hS:lu\u000eZ;mK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u0003-\u0001\t1\u0001\\8h!\tq2%D\u0001 \u0015\t\u0001\u0013%A\u0004m_\u001e<\u0017N\\4\u000b\u0005\t\n\u0012\u0001B;uS2L!\u0001J\u0010\u0003\r1{wmZ3s\u0003)iw\u000eZ;mK:\u000bW.Z\u000b\u0002OA\u0011\u0001&\r\b\u0003S=\u0002\"AK\u0017\u000e\u0003-R!\u0001L\n\u0002\rq\u0012xn\u001c;?\u0015\u0005q\u0013!B:dC2\f\u0017B\u0001\u0019.\u0003\u0019\u0001&/\u001a3fM&\u0011!g\r\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005Aj\u0013aC7pIVdWMT1nK\u0002\nq\u0001\u001c3ba\u000e3w-F\u00018!\tA4(D\u0001:\u0015\tQt\"\u0001\u0005j]R,'O\\1m\u0013\ta\u0014HA\bM\t\u0006\u0003Fj\\4j]\u000e{gNZ5h\u0003)!\u0017N]\"p]R,\u0007\u0010^\u000b\u0002\u007fA\u0011\u0001iR\u0007\u0002\u0003*\u0011!iQ\u0001\nI&\u0014Xm\u0019;pefT!\u0001R#\u0002\r9\fW.\u001b8h\u0015\u00051\u0015!\u00026bm\u0006D\u0018B\u0001%B\u0005)!\u0015N]\"p]R,\u0007\u0010^\u0001\bI>dunZ5o)\u0005Y\u0005C\u0001'N\u001b\u0005i\u0013B\u0001(.\u0005\u001d\u0011un\u001c7fC:D3a\u0002)]!\ra\u0015kU\u0005\u0003%6\u0012a\u0001\u001e5s_^\u001c\bC\u0001+[\u001b\u0005)&B\u0001,X\u0003\u0015awnZ5o\u0015\tA\u0016,\u0001\u0003bkRD'B\u0001\tF\u0013\tYVK\u0001\bM_\u001eLg.\u0012=dKB$\u0018n\u001c82\ty9S,^\u0019\u0006Gy\u000b\u0007OY\u000b\u0003M}#Q\u0001Y\nC\u0002\u0015\u0014\u0011\u0001V\u0005\u0003E\u000e\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$B\u00013.\u0003\u0019!\bN]8xgF\u0011a-\u001b\t\u0003\u0019\u001eL!\u0001[\u0017\u0003\u000f9{G\u000f[5oOB\u0011!.\u001c\b\u0003\u0019.L!\u0001\\\u0017\u0002\u000fA\f7m[1hK&\u0011an\u001c\u0002\n)\"\u0014xn^1cY\u0016T!\u0001\\\u00172\u000b\r\n(o\u001d3\u000f\u00051\u0013\u0018B\u00013.c\u0011\u0011C*\f;\u0003\u000bM\u001c\u0017\r\\12\u0005\u0019\u001a\u0016A\u00039pgR\u001cu.\\7jiR\t\u0001\u0010\u0005\u0002Ms&\u0011!0\f\u0002\u0005+:LG/A\u0005q_N$\u0018IY8si\u0006Q\u0001o\\:u\u0019><w.\u001e;\u0002\u0019Y\fG.\u001b3bi\u0016,6/\u001a:\u0015\u0003\u001dBCa\u0003)\u0002\u0002E2adJA\u0002\u0003\u0013\tda\t0b\u0003\u000b\u0011\u0017GB\u0012re\u0006\u001dA-\r\u0003#\u00196\"\u0018G\u0001\u0014T\u0003%9W\r^$s_V\u00048\u000f\u0006\u0003\u0002\u0010\u0005m\u0001#BA\t\u0003/9cbAA\nW:\u0019!&!\u0006\n\u00039J1!!\u0007p\u0005\u0011a\u0015n\u001d;\t\r\u0005uA\u00021\u0001(\u0003\u0019iW-\u001c2fe\"\"A\u0002UA\u0011c\u0019qr%a\t\u0002*E21EX1\u0002&\t\fdaI9s\u0003O!\u0017\u0007\u0002\u0012M[Q\f$AJ*\u0002#\u0011|'KR\"3eU\"TI\\2pI&tw\rF\u0002(\u0003_Aa!!\r\u000e\u0001\u00049\u0013aC5oaV$8\u000b\u001e:j]\u001e\u0004")
public class LDAPLoginModule
extends AbstractLoginModule {
    private LDAPLoginConfig ldapCfg;
    private DirContext dirContext;
    private final Logger log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(LDAPLoginModule.class));
    private final String moduleName;
    private volatile byte bitmap$0;

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    private LDAPLoginConfig ldapCfg$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Option<ContainerContext> option = this.ctCtxt();
                if (!(option instanceof Some)) {
                    if (None$.MODULE$.equals(option)) {
                        throw new Exception(new StringBuilder(59).append("LDAP Login module must be configured with an instance of [").append(ContainerContext.class).append("]").toString());
                    }
                    throw new MatchError(option);
                }
                Some some = (Some)option;
                ContainerContext s = (ContainerContext)some.value();
                LDAPLoginConfig lDAPLoginConfig = LDAPLoginConfig$.MODULE$.fromConfig(this.loginConfig(), s);
                this.ldapCfg = lDAPLoginConfig;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ldapCfg;
    }

    public LDAPLoginConfig ldapCfg() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ldapCfg$lzycompute() : this.ldapCfg;
    }

    private DirContext dirContext$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dirContext = this.liftedTree1$1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dirContext;
    }

    private DirContext dirContext() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dirContext$lzycompute() : this.dirContext;
    }

    @Override
    public boolean doLogin() throws LoginException {
        try {
            this.dirContext();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.log.error(t, this.log.error$default$2(), (Function0 & Serializable)() -> t.getMessage());
                throw new LoginException(t.getMessage());
            }
            throw throwable;
        }
        this.log.debug((Function0 & Serializable)() -> new StringBuilder(48).append("Successfully connected to LDAP server [").append(this.ldapCfg().url()).append("] user [").append(this.ldapCfg().systemUser()).append("]").toString());
        this.loggedInUser_$eq((Option<String>)new Some((Object)this.validateUser()));
        return true;
    }

    @Override
    public void postCommit() {
        this.dirContext().close();
    }

    @Override
    public void postAbort() {
        this.dirContext().close();
    }

    @Override
    public void postLogout() {
        this.dirContext().close();
    }

    private String validateUser() throws LoginException {
        String string;
        try {
            try {
                SearchResult head;
                Tuple2<String, String> tuple2 = this.extractCredentials();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String user = (String)tuple2._1();
                String pwd = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)user, (Object)pwd);
                Tuple2 tuple23 = tuple22;
                String user2 = (String)tuple23._1();
                String pwd2 = (String)tuple23._2();
                SearchControls constraint = new SearchControls();
                constraint.setSearchScope(2);
                MessageFormat userSearchFormat = new MessageFormat(new StringBuilder(6).append("(").append(this.ldapCfg().userAttribute()).append("={0})").toString());
                String filter = userSearchFormat.format(new String[]{this.doRFC2254Encoding(user2)});
                NamingEnumeration<SearchResult> r = this.dirContext().search(this.ldapCfg().userBase(), filter, constraint);
                List<SearchResult> list = new LdapSearchResult(r).result();
                if (Nil$.MODULE$.equals(list)) {
                    throw new LoginException(new StringBuilder(26).append("User [").append(user2).append("] not found in LDAP.").toString());
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    head = (SearchResult)colon2.head();
                    List tail = colon2.next$access$1();
                    if (tail.nonEmpty()) {
                        this.log.warn((Function0 & Serializable)() -> new StringBuilder(64).append("Search for user [").append(user2).append("] returned [").append(1 + tail.length()).append("] records, using first record only.").toString());
                    }
                } else {
                    throw new MatchError(list);
                }
                String name = head.getNameInNamespace();
                this.dirContext().addToEnvironment("java.naming.security.principal", name);
                this.dirContext().addToEnvironment("java.naming.security.credentials", pwd2);
                this.dirContext().getAttributes(name, (String[])((Object[])new String[]{this.ldapCfg().userAttribute()}));
                this.log.info((Function0 & Serializable)() -> new StringBuilder(39).append("User [").append(user2).append("] authenticated with LDAP name [").append(name).append("]").toString());
                String string2 = name;
                string = string2;
            }
            catch (Throwable t) {
                this.log.error(t, this.log.error$default$2(), (Function0 & Serializable)() -> t.getMessage());
                throw new LoginException(t.getMessage());
            }
        }
        finally {
            Object object;
            Option<String> option = this.ldapCfg().systemUser();
            if (None$.MODULE$.equals(option)) {
                object = this.dirContext().removeFromEnvironment("java.naming.security.principal");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String u = (String)some.value();
                object = this.dirContext().addToEnvironment("java.naming.security.principal", u);
            } else {
                throw new MatchError(option);
            }
            Option<String> option2 = this.ldapCfg().systemPassword();
            if (None$.MODULE$.equals(option2)) {
                this.dirContext().removeFromEnvironment("java.naming.security.credentials");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                String p = (String)some.value();
                this.dirContext().addToEnvironment("java.naming.security.credentials", p);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
        }
        return string;
    }

    @Override
    public List<String> getGroups(String member) throws LoginException {
        SearchControls constraint = new SearchControls();
        constraint.setSearchScope(2);
        MessageFormat groupSearchFormat = new MessageFormat(this.ldapCfg().groupSearch());
        String filter = groupSearchFormat.format(new String[]{this.doRFC2254Encoding(member)});
        NamingEnumeration<SearchResult> r = this.dirContext().search(this.ldapCfg().groupBase(), filter, constraint);
        return new LdapSearchResult(r).result().map((Function1 & Serializable)sr -> sr.getAttributes().get(this.ldapCfg().groupAttribute()).get().toString());
    }

    private String doRFC2254Encoding(String inputString) {
        String string = inputString;
        switch (string == null ? 0 : string.hashCode()) {
            default: 
        }
        String string2 = string.isEmpty() ? "" : (string.startsWith("\\") ? new StringBuilder(3).append("\\5c").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("*") ? new StringBuilder(3).append("\\2a").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("(") ? new StringBuilder(3).append("\\28").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith(")") ? new StringBuilder(3).append("\\29").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("\u0000") ? new StringBuilder(3).append("\\00").append(this.doRFC2254Encoding(string.substring(1))).toString() : new StringBuilder(0).append(string.substring(0, 1)).append(this.doRFC2254Encoding(string.substring(1))).toString())))));
        return string2;
    }

    private final DirContext liftedTree1$1() {
        InitialDirContext initialDirContext;
        try {
            Map env = (Map)Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.factory.initial"), (Object)LdapCtxFactory.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.provider.url"), (Object)this.ldapCfg().url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.authentication"), (Object)"simple")}));
            env.$plus$plus$eq((IterableOnce)this.ldapCfg().systemUser().map((Function1 & Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.principal"), u)));
            env.$plus$plus$eq((IterableOnce)this.ldapCfg().systemPassword().map((Function1 & Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.credentials"), u)));
            initialDirContext = new InitialDirContext(new Hashtable(CollectionConverters$.MODULE$.MutableMapHasAsJava(env).asJava()));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable t = (Throwable)option.get();
                this.log.error(t, this.log.error$default$2(), (Function0 & Serializable)() -> t.getMessage());
                throw new LoginException(t.getMessage());
            }
            throw throwable;
        }
        return initialDirContext;
    }

    public LDAPLoginModule() {
        this.moduleName = "ldap";
    }
}

