/*
 * Decompiled with CFR 0.152.
 */
package blended.security;

import blended.security.AbstractLoginModule;
import blended.security.internal.LDAPLoginConfig;
import blended.security.internal.LDAPLoginConfig$;
import blended.security.internal.LdapSearchResult;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001B\u0001\u0003\u0001\u001d\u0011q\u0002\u0014#B!2{w-\u001b8N_\u0012,H.\u001a\u0006\u0003\u0007\u0011\t\u0001b]3dkJLG/\u001f\u0006\u0002\u000b\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u0001!\u0001\"!\u0003\u0006\u000e\u0003\tI!a\u0003\u0002\u0003'\u0005\u00137\u000f\u001e:bGRdunZ5o\u001b>$W\u000f\\3\t\u000b5\u0001A\u0011\u0001\b\u0002\rqJg.\u001b;?)\u0005y\u0001CA\u0005\u0001\u0011\u0019\t\u0002\u0001)A\u0005%\u0005\u0019An\\4\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012a\u00027pO\u001eLgn\u001a\u0006\u0003/\u0011\tA!\u001e;jY&\u0011\u0011\u0004\u0006\u0002\u0007\u0019><w-\u001a:\t\u000fm\u0001!\u0019!C)9\u0005QQn\u001c3vY\u0016t\u0015-\\3\u0016\u0003u\u0001\"AH\u0014\u000f\u0005})\u0003C\u0001\u0011$\u001b\u0005\t#B\u0001\u0012\u0007\u0003\u0019a$o\\8u})\tA%A\u0003tG\u0006d\u0017-\u0003\u0002'G\u00051\u0001K]3eK\u001aL!\u0001K\u0015\u0003\rM#(/\u001b8h\u0015\t13\u0005\u0003\u0004,\u0001\u0001\u0006I!H\u0001\f[>$W\u000f\\3OC6,\u0007\u0005\u0003\u0005.\u0001!\u0015\r\u0011\"\u0001/\u0003\u001daG-\u00199DM\u001e,\u0012a\f\t\u0003aMj\u0011!\r\u0006\u0003e\t\t\u0001\"\u001b8uKJt\u0017\r\\\u0005\u0003iE\u0012q\u0002\u0014#B!2{w-\u001b8D_:4\u0017n\u001a\u0005\tm\u0001A)\u0019)C\u0005o\u0005QA-\u001b:D_:$X\r\u001f;\u0016\u0003a\u00022!O\u001e>\u001b\u0005Q$BA\f$\u0013\ta$HA\u0002Uef\u0004\"AP#\u000e\u0003}R!\u0001Q!\u0002\u0013\u0011L'/Z2u_JL(B\u0001\"D\u0003\u0019q\u0017-\\5oO*\tA)A\u0003kCZ\f\u00070\u0003\u0002G\u007f\tQA)\u001b:D_:$X\r\u001f;\t\u000b!\u0003A\u0011I%\u0002\u000f\u0011|Gj\\4j]R\t!\n\u0005\u0002L\u00196\t1%\u0003\u0002NG\t9!i\\8mK\u0006t\u0007fA$P7B\u00191\n\u0015*\n\u0005E\u001b#A\u0002;ie><8\u000f\u0005\u0002T36\tAK\u0003\u0002V-\u0006)An\\4j]*\u0011q\u000bW\u0001\u0005CV$\bN\u0003\u0002\u0004\u0007&\u0011!\f\u0016\u0002\u000f\u0019><\u0017N\\#yG\u0016\u0004H/[8oc\u0011qR\u0004\u0018;2\u000b\rj\u0006m\\1\u0016\u0005qqF!B0\u0007\u0005\u0004!'!\u0001+\n\u0005\u0005\u0014\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002dG\u00051A\u000f\u001b:poN\f\"!\u001a5\u0011\u0005-3\u0017BA4$\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u001b7\u000f\u0005-S\u0017BA6$\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001c8\u0003\u0013QC'o\\<bE2,'BA6$c\u0015\u0019\u0003/\u001d:d\u001d\tY\u0015/\u0003\u0002dGE\"!eS\u0012t\u0005\u0015\u00198-\u00197bc\t1#\u000bC\u0003w\u0001\u0011Es/\u0001\u0006q_N$8i\\7nSR$\u0012\u0001\u001f\t\u0003\u0017fL!A_\u0012\u0003\tUs\u0017\u000e\u001e\u0005\u0006y\u0002!\tf^\u0001\na>\u001cH/\u00112peRDQA \u0001\u0005R]\f!\u0002]8ti2{wm\\;u\u0011!\t\t\u0001\u0001Q\u0005\n\u0005\r\u0011\u0001\u0004<bY&$\u0017\r^3Vg\u0016\u0014H#A\u000f)\t}|\u0015qA\u0019\u0007=u\tI!a\u00042\r\rj\u0006-a\u0003bc\u0019\u0019\u0003/]A\u0007GF\"!eS\u0012tc\t1#\u000bC\u0004\u0002\u0014\u0001!\t%!\u0006\u0002\u0013\u001d,Go\u0012:pkB\u001cH\u0003BA\f\u0003G\u0001R!!\u0007\u0002 uq1!a\u0007k\u001d\r\u0001\u0013QD\u0005\u0002I%\u0019\u0011\u0011\u00058\u0003\t1K7\u000f\u001e\u0005\b\u0003K\t\t\u00021\u0001\u001e\u0003\u0019iW-\u001c2fe\"*\u0011\u0011C(\u0002*E2a$HA\u0016\u0003c\tdaI/a\u0003[\t\u0017GB\u0012qc\u0006=2-\r\u0003#\u0017\u000e\u001a\u0018G\u0001\u0014S\u0011!\t)\u0004\u0001Q\u0005\n\u0005]\u0012!\u00053p%\u001a\u001b%GM\u001b5\u000b:\u001cw\u000eZ5oOR\u0019Q$!\u000f\t\u000f\u0005m\u00121\u0007a\u0001;\u0005Y\u0011N\u001c9viN#(/\u001b8h\u0001")
public class LDAPLoginModule
extends AbstractLoginModule {
    private LDAPLoginConfig ldapCfg;
    private Try<DirContext> dirContext;
    private final Logger log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(LDAPLoginModule.class));
    private final String moduleName;
    private volatile byte bitmap$0;

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    private LDAPLoginConfig ldapCfg$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ldapCfg = LDAPLoginConfig$.MODULE$.fromConfig(this.loginConfig());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ldapCfg;
    }

    public LDAPLoginConfig ldapCfg() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ldapCfg$lzycompute() : this.ldapCfg;
    }

    private Try<DirContext> dirContext$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dirContext = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    InitialDirContext initialDirContext;
                    try {
                        scala.collection.mutable.Map env = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.factory.initial"), (Object)LdapCtxFactory.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.provider.url"), (Object)this.ldapCfg().url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.authentication"), (Object)"simple")}));
                        env.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(this.ldapCfg().systemUser().map((Function1 & Serializable & scala.Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.principal"), u))));
                        env.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(this.ldapCfg().systemPassword().map((Function1 & Serializable & scala.Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.credentials"), u))));
                        initialDirContext = new InitialDirContext(new Hashtable((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(env).asJava()));
                    }
                    catch (Throwable t) {
                        $this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
                        throw new LoginException(t.getMessage());
                    }
                    return initialDirContext;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dirContext;
    }

    private Try<DirContext> dirContext() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dirContext$lzycompute() : this.dirContext;
    }

    @Override
    public boolean doLogin() throws LoginException {
        try {
            this.dirContext().get();
        }
        catch (Throwable t) {
            this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
            throw new LoginException(t.getMessage());
        }
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Successfully connected to LDAP server [").append(this.ldapCfg().url()).append("] user [").append(this.ldapCfg().systemUser()).append("]").toString());
        this.loggedInUser_$eq((Option<String>)new Some((Object)this.validateUser()));
        return true;
    }

    @Override
    public void postCommit() {
        ((Context)this.dirContext().get()).close();
    }

    @Override
    public void postAbort() {
        ((Context)this.dirContext().get()).close();
    }

    @Override
    public void postLogout() {
        ((Context)this.dirContext().get()).close();
    }

    private String validateUser() throws LoginException {
        String string;
        try {
            try {
                SearchResult head;
                Tuple2<String, String> tuple2 = this.extractCredentials();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String user = (String)tuple2._1();
                String pwd = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)user, (Object)pwd);
                Tuple2 tuple23 = tuple22;
                String user2 = (String)tuple23._1();
                String pwd2 = (String)tuple23._2();
                SearchControls constraint = new SearchControls();
                constraint.setSearchScope(2);
                MessageFormat userSearchFormat = new MessageFormat(this.ldapCfg().userSearch());
                String filter = userSearchFormat.format(new String[]{this.doRFC2254Encoding(user2)});
                NamingEnumeration<SearchResult> r = ((DirContext)this.dirContext().get()).search(this.ldapCfg().userBase(), filter, constraint);
                List<SearchResult> list = new LdapSearchResult(r).result();
                if (Nil$.MODULE$.equals(list)) {
                    throw new LoginException(new StringBuilder(26).append("User [").append(user2).append("] not found in LDAP.").toString());
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    head = (SearchResult)colon2.head();
                    List tail = colon2.tl$access$1();
                    if (tail.length() > 0) {
                        this.log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Search for user [").append(user2).append("] returned [").append(1 + tail.length()).append("] records, using first record only.").toString());
                    }
                } else {
                    throw new MatchError(list);
                }
                String name = head.getNameInNamespace();
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.principal", name);
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.credentials", pwd2);
                ((DirContext)this.dirContext().get()).getAttributes("", null);
                this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("User [").append(user2).append("] authenticated with LDAP name [").append(name).append("]").toString());
                String string2 = name;
                string = string2;
            }
            catch (Throwable t) {
                this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
                throw new LoginException(t.getMessage());
            }
        }
        finally {
            Object object;
            Option<String> option = this.ldapCfg().systemUser();
            if (None$.MODULE$.equals(option)) {
                object = ((Context)this.dirContext().get()).removeFromEnvironment("java.naming.security.principal");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String u = (String)some.value();
                object = ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.principal", u);
            } else {
                throw new MatchError(option);
            }
            Option<String> option2 = this.ldapCfg().systemPassword();
            if (None$.MODULE$.equals(option2)) {
                ((Context)this.dirContext().get()).removeFromEnvironment("java.naming.security.credentials");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                String p = (String)some.value();
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.credentials", p);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
        }
        return string;
    }

    @Override
    public List<String> getGroups(String member) throws LoginException {
        SearchControls constraint = new SearchControls();
        constraint.setSearchScope(2);
        MessageFormat groupSearchFormat = new MessageFormat(this.ldapCfg().groupSearch());
        String filter = groupSearchFormat.format(new String[]{this.doRFC2254Encoding(member)});
        NamingEnumeration<SearchResult> r = ((DirContext)this.dirContext().get()).search(this.ldapCfg().groupBase(), filter, constraint);
        return (List)new LdapSearchResult(r).result().map((Function1 & Serializable & scala.Serializable)sr -> sr.getAttributes().get(this.ldapCfg().groupAttribute()).get().toString(), List$.MODULE$.canBuildFrom());
    }

    private String doRFC2254Encoding(String inputString) {
        String string = inputString;
        String string2 = string.isEmpty() ? "" : (string.startsWith("\\") ? new StringBuilder(3).append("\\5c").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("*") ? new StringBuilder(3).append("\\2a").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("(") ? new StringBuilder(3).append("\\28").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith(")") ? new StringBuilder(3).append("\\29").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("\u0000") ? new StringBuilder(3).append("\\00").append(this.doRFC2254Encoding(string.substring(1))).toString() : new StringBuilder(0).append(string.substring(0, 1)).append(this.doRFC2254Encoding(string.substring(1))).toString())))));
        return string2;
    }

    public LDAPLoginModule() {
        this.moduleName = "ldap";
    }
}

