/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.container.context.api.ContainerIdentifierService;
import blended.security.ssl.internal.CertificateConfig;
import blended.security.ssl.internal.CertificateConfig$;
import blended.security.ssl.internal.CertificateManagerConfig;
import blended.security.ssl.internal.PasswordHasher;
import blended.security.ssl.internal.RefresherConfig;
import blended.security.ssl.internal.RefresherConfig$;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;

public final class CertificateManagerConfig$
implements Serializable {
    public static final CertificateManagerConfig$ MODULE$;

    static {
        new CertificateManagerConfig$();
    }

    public CertificateManagerConfig fromConfig(Config cfg, PasswordHasher hasher, ContainerIdentifierService idSvc) {
        String keyStore = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("keyStore", System.getProperty("javax.net.ssl.keyStore"));
        String storePass = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("storePass", System.getProperty("javax.net.ssl.keyStorePassword"));
        String keyPass = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("keyPass", System.getProperty("javax.net.ssl.keyPassword"));
        List certConfigs = ((TraversableOnce)Implicits$.MODULE$.RichDefaultConfig(cfg).getConfigMap("certificates", (Map<String, Config>)Predef$.MODULE$.Map().empty()).map((Function1)new Serializable(idSvc){
            public static final long serialVersionUID = 0L;
            private final ContainerIdentifierService idSvc$1;

            public final CertificateConfig apply(Tuple2<String, Config> x0$1) {
                Tuple2<String, Config> tuple2 = x0$1;
                if (tuple2 != null) {
                    String k = (String)tuple2._1();
                    Config v = (Config)tuple2._2();
                    CertificateConfig certificateConfig = CertificateConfig$.MODULE$.fromConfig(k, v, this.idSvc$1);
                    return certificateConfig;
                }
                throw new MatchError(tuple2);
            }
            {
                this.idSvc$1 = idSvc$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toList();
        Option refresherConfig = Implicits$.MODULE$.RichOptionConfig(cfg).getConfigOption("refresher").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final RefresherConfig apply(Config c) {
                return (RefresherConfig)RefresherConfig$.MODULE$.fromConfig(c).get();
            }
        });
        return new CertificateManagerConfig(keyStore, hasher.password(storePass), hasher.password(keyPass), (List<CertificateConfig>)certConfigs, (Option<RefresherConfig>)refresherConfig);
    }

    public CertificateManagerConfig apply(String keyStore, String storePass, String keyPass, List<CertificateConfig> certConfigs, Option<RefresherConfig> refresherConfig) {
        return new CertificateManagerConfig(keyStore, storePass, keyPass, certConfigs, refresherConfig);
    }

    public Option<Tuple5<String, String, String, List<CertificateConfig>, Option<RefresherConfig>>> unapply(CertificateManagerConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)x$0.keyStore(), (Object)x$0.storePass(), (Object)x$0.keyPass(), x$0.certConfigs(), x$0.refresherConfig()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private CertificateManagerConfig$() {
        MODULE$ = this;
    }
}

