/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl;

import blended.container.context.api.ContainerIdentifierService;
import blended.security.ssl.CommonNameProvider;
import blended.security.ssl.SelfSignedConfig;
import blended.security.ssl.internal.ConfigCommonNameProvider;
import blended.util.config.Implicits$;
import com.typesafe.config.Config;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple4;
import scala.runtime.BoxesRunTime;

public final class SelfSignedConfig$
implements Serializable {
    public static final SelfSignedConfig$ MODULE$;
    private final String sigAlgPath;
    private final String validDaysPath;

    static {
        new SelfSignedConfig$();
    }

    public String sigAlgPath() {
        return this.sigAlgPath;
    }

    public String validDaysPath() {
        return this.validDaysPath;
    }

    public SelfSignedConfig fromConfig(Config cfg, ContainerIdentifierService idSvc) {
        int keyStrength = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("keyStrength", 2048);
        String signatureAlgorithm = Implicits$.MODULE$.RichDefaultConfig(cfg).getString("signatureAlgorithm", "SHA256withRSA");
        int validDays = Implicits$.MODULE$.RichDefaultConfig(cfg).getInt("validDays", 1);
        return new SelfSignedConfig(new ConfigCommonNameProvider(cfg, idSvc), keyStrength, signatureAlgorithm, validDays);
    }

    public SelfSignedConfig apply(CommonNameProvider commonNameProvider, int keyStrength, String sigAlg, int validDays) {
        return new SelfSignedConfig(commonNameProvider, keyStrength, sigAlg, validDays);
    }

    public Option<Tuple4<CommonNameProvider, Object, String, Object>> unapply(SelfSignedConfig x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple4((Object)x$0.commonNameProvider(), (Object)BoxesRunTime.boxToInteger((int)x$0.keyStrength()), (Object)x$0.sigAlg(), (Object)BoxesRunTime.boxToInteger((int)x$0.validDays())));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private SelfSignedConfig$() {
        MODULE$ = this;
        this.sigAlgPath = "signatureAlgorithm";
        this.validDaysPath = "validDays";
    }
}

