/*
 * Decompiled with CFR 0.152.
 */
package blended.security.ssl.internal;

import blended.security.ssl.CertificateProvider;
import blended.security.ssl.ServerCertificate;
import blended.security.ssl.ServerCertificate$;
import blended.security.ssl.X509CertificateInfo;
import blended.security.ssl.X509CertificateInfo$;
import blended.security.ssl.internal.CertControllerConfig;
import blended.security.ssl.internal.CertificateController$;
import blended.security.ssl.internal.ServerKeyStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\t)2)\u001a:uS\u001aL7-\u0019;f\u0007>tGO]8mY\u0016\u0014(BA\u0002\u0005\u0003!Ig\u000e^3s]\u0006d'BA\u0003\u0007\u0003\r\u00198\u000f\u001c\u0006\u0003\u000f!\t\u0001b]3dkJLG/\u001f\u0006\u0002\u0013\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u00011\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007\u0002C\n\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000b\u0002\u0007\r4w\r\u0005\u0002\u0016-5\t!!\u0003\u0002\u0018\u0005\t!2)\u001a:u\u0007>tGO]8mY\u0016\u00148i\u001c8gS\u001eD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\taJ|g/\u001b3feB\u00111\u0004H\u0007\u0002\t%\u0011Q\u0004\u0002\u0002\u0014\u0007\u0016\u0014H/\u001b4jG\u0006$X\r\u0015:pm&$WM\u001d\u0005\u0006?\u0001!\t\u0001I\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0005\u00123\u0005\u0005\u0002\u0016\u0001!)1C\ba\u0001)!)\u0011D\ba\u00015!1Q\u0005\u0001Q\u0001\n\u0019\n1\u0001\\8h!\t9C&D\u0001)\u0015\tI#&A\u0003m_\u001e$4OC\u0001,\u0003\ry'oZ\u0005\u0003[!\u0012a\u0001T8hO\u0016\u0014\b\u0002C\u0018\u0001\u0011\u000b\u0007K\u0011\u0002\u0019\u0002\u0011-,\u0017p\u0015;pe\u0016,\u0012!\r\t\u0003eYj\u0011a\r\u0006\u0003\u000fQR\u0011!N\u0001\u0005U\u00064\u0018-\u0003\u00028g\tA1*Z=Ti>\u0014X\r\u0003\u0005:\u0001!\u0005\t\u0015)\u00032\u0003%YW-_*u_J,\u0007\u0005\u0003\u0004<\u0001\u0001\u0006I\u0001P\u0001\r[&dG.[:QKJ$\u0015-\u001f\t\u0003\u001buJ!A\u0010\b\u0003\t1{gn\u001a\u0005\u0006\u0001\u0002!\t!Q\u0001\u0011G\",7m[\"feRLg-[2bi\u0016$\u0012A\u0011\t\u0004\u0007\u001aCU\"\u0001#\u000b\u0005\u0015s\u0011\u0001B;uS2L!a\u0012#\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002\u0016\u0013&\u0011!J\u0001\u0002\u000f'\u0016\u0014h/\u001a:LKf\u001cFo\u001c:f\u0011\u0015a\u0005\u0001\"\u0001N\u00039\u0019XM\u001d<fe.+\u0017p\u0015;pe\u0016$\u0012!\r\u0005\u0007\u001f\u0002\u0001K\u0011\u0002)\u00021\u0015DHO]1diN+'O^3s\u0007\u0016\u0014H/\u001b4jG\u0006$X\r\u0006\u0002R1B\u00191I\u0012*\u0011\u00075\u0019V+\u0003\u0002U\u001d\t1q\n\u001d;j_:\u0004\"a\u0007,\n\u0005]#!!E*feZ,'oQ3si&4\u0017nY1uK\")\u0011L\u0014a\u0001c\u0005\u00111n\u001d\u0005\u00077\u0002\u0001K\u0011\u0002/\u00023\rDWmY6B]\u0012,\u0006\u000fZ1uK\u000e+'\u000f^5gS\u000e\fG/\u001a\u000b\u0003\u0005vCQ!\u0017.A\u0002EBaa\u0018\u0001!\n\u0013\u0001\u0017AD;qI\u0006$XmS3zgR|'/\u001a\u000b\u0004\u0005\u0006\u0014\u0007\"B-_\u0001\u0004\t\u0004\"B2_\u0001\u0004\u0011\u0016\u0001D3ySN$\u0018N\\4DKJ$\bBB3\u0001A\u0013%a-\u0001\u0007j]&$8*Z=Ti>\u0014X\rF\u0001h!\r\u0019e)\r")
public class CertificateController {
    public final CertControllerConfig blended$security$ssl$internal$CertificateController$$cfg;
    public final CertificateProvider blended$security$ssl$internal$CertificateController$$provider;
    public final Logger blended$security$ssl$internal$CertificateController$$log;
    private KeyStore keyStore;
    private final long millisPerDay;
    private volatile boolean bitmap$0;

    private KeyStore keyStore$lzycompute() {
        CertificateController certificateController = this;
        synchronized (certificateController) {
            if (!this.bitmap$0) {
                this.keyStore = (KeyStore)this.initKeyStore().get();
                this.bitmap$0 = true;
            }
            return this.keyStore;
        }
    }

    private KeyStore keyStore() {
        return this.bitmap$0 ? this.keyStore : this.keyStore$lzycompute();
    }

    public Try<ServerKeyStore> checkCertificate() {
        if (this.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
            this.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Checking Server Certificate for key store [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$security$ssl$internal$CertificateController$$cfg.keyStore()})));
        }
        return this.checkAndUpdateCertificate(this.keyStore());
    }

    public KeyStore serverKeyStore() {
        return this.keyStore();
    }

    private Try<Option<ServerCertificate>> extractServerCertificate(KeyStore ks) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, ks){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CertificateController $outer;
            public final KeyStore ks$2;

            public final Option<ServerCertificate> apply() {
                return Option$.MODULE$.apply((Object)this.ks$2.getCertificateChain(this.$outer.blended$security$ssl$internal$CertificateController$$cfg.alias())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$extractServerCertificate$1 $outer;

                    public final ServerCertificate apply(Certificate[] chain) {
                        Certificate e = this.$outer.ks$2.getCertificate(this.$outer.blended$security$ssl$internal$CertificateController$$anonfun$$$outer().blended$security$ssl$internal$CertificateController$$cfg.alias());
                        PrivateKey key = (PrivateKey)this.$outer.ks$2.getKey(this.$outer.blended$security$ssl$internal$CertificateController$$anonfun$$$outer().blended$security$ssl$internal$CertificateController$$cfg.alias(), this.$outer.blended$security$ssl$internal$CertificateController$$anonfun$$$outer().blended$security$ssl$internal$CertificateController$$cfg.keyPass());
                        KeyPair keypair = new KeyPair(e.getPublicKey(), key);
                        return (ServerCertificate)ServerCertificate$.MODULE$.create(keypair, (List<Certificate>)Predef$.MODULE$.refArrayOps((Object[])chain).toList()).get();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ CertificateController blended$security$ssl$internal$CertificateController$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ks$2 = ks$2;
            }
        });
    }

    private Try<ServerKeyStore> checkAndUpdateCertificate(KeyStore ks) {
        Option option;
        block10: {
            Success success;
            block9: {
                Option existingCert;
                block8: {
                    Success success2;
                    existingCert = (Option)this.extractServerCertificate(ks).recoverWith((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ CertificateController $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                            A1 A1 = x1;
                            Object object = this.$outer.blended$security$ssl$internal$CertificateController$$cfg.overwriteForFailure() ? new Success((Object)None$.MODULE$) : function1.apply(x1);
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x1) {
                            Throwable throwable = x1;
                            boolean bl = this.$outer.blended$security$ssl$internal$CertificateController$$cfg.overwriteForFailure();
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }).get();
                    option = existingCert;
                    if (!(option instanceof Some)) break block8;
                    Some some = (Some)option;
                    ServerCertificate serverCertificate = (ServerCertificate)some.x();
                    X509CertificateInfo certInfo = X509CertificateInfo$.MODULE$.apply((X509Certificate)serverCertificate.chain().head());
                    long remaining = certInfo.notAfter().getTime() - System.currentTimeMillis();
                    if (remaining <= (long)this.blended$security$ssl$internal$CertificateController$$cfg.minValidDays() * this.millisPerDay) {
                        if (this.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
                            this.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate [", "] is about to expire in [", "] days...refreshing certificate."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$security$ssl$internal$CertificateController$$cfg.alias(), BoxesRunTime.boxToDouble((double)((double)remaining / (double)this.millisPerDay))})));
                        }
                        success2 = this.updateKeystore(ks, (Option<ServerCertificate>)existingCert).recoverWith((PartialFunction)new Serializable(this, ks, serverCertificate){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ CertificateController $outer;
                            private final KeyStore ks$1;
                            private final ServerCertificate serverCertificate$1;

                            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                Object object;
                                A1 A1 = x2;
                                if (A1 != null) {
                                    A1 A12 = A1;
                                    this.$outer.blended$security$ssl$internal$CertificateController$$log.debug("Could not refresh the keystore, returning the old one", A12);
                                    object = new Success((Object)new ServerKeyStore(this.ks$1, this.serverCertificate$1));
                                } else {
                                    object = function1.apply(x2);
                                }
                                return (B1)object;
                            }

                            public final boolean isDefinedAt(Throwable x2) {
                                Throwable throwable = x2;
                                boolean bl = throwable != null;
                                return bl;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                this.ks$1 = ks$1;
                                this.serverCertificate$1 = serverCertificate$1;
                            }
                        });
                    } else {
                        if (this.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
                            this.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Server certificate [", "] is still vaild."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$security$ssl$internal$CertificateController$$cfg.alias()})));
                        }
                        success2 = new Success((Object)new ServerKeyStore(ks, serverCertificate));
                    }
                    success = success2;
                    break block9;
                }
                if (!None$.MODULE$.equals(option)) break block10;
                if (this.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
                    this.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Certificate with alias [", "] does not yet exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.blended$security$ssl$internal$CertificateController$$cfg.alias()})));
                }
                success = this.updateKeystore(ks, (Option<ServerCertificate>)existingCert);
            }
            return success;
        }
        throw new MatchError((Object)option);
    }

    private Try<ServerKeyStore> updateKeystore(KeyStore ks, Option<ServerCertificate> existingCert) {
        return Try$.MODULE$.apply((Function0)new Serializable(this, ks, existingCert){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CertificateController $outer;
            private final KeyStore ks$3;
            private final Option existingCert$1;

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final ServerKeyStore apply() {
                FileOutputStream fos;
                ServerCertificate cert;
                block4: {
                    Try<ServerCertificate> newCert;
                    this.$outer.blended$security$ssl$internal$CertificateController$$log.info("Aquiring new certificate from certificate provider ...");
                    Try<ServerCertificate> try_ = newCert = this.$outer.blended$security$ssl$internal$CertificateController$$provider.refreshCertificate((Option<ServerCertificate>)this.existingCert$1);
                    if (try_ instanceof Failure) {
                        Failure failure = (Failure)try_;
                        Throwable e = failure.exception();
                        this.$outer.blended$security$ssl$internal$CertificateController$$log.error("Could not update keystore", e);
                        throw e;
                    }
                    if (!(try_ instanceof Success)) throw new MatchError(try_);
                    Success success = (Success)try_;
                    cert = (ServerCertificate)success.value();
                    X509CertificateInfo info = X509CertificateInfo$.MODULE$.apply((X509Certificate)cert.chain().head());
                    if (this.$outer.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
                        this.$outer.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully obtained certificate from certificate provider [", "] : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$security$ssl$internal$CertificateController$$provider, info})));
                    }
                    this.ks$3.setKeyEntry(this.$outer.blended$security$ssl$internal$CertificateController$$cfg.alias(), cert.keyPair().getPrivate(), this.$outer.blended$security$ssl$internal$CertificateController$$cfg.keyPass(), (Certificate[])cert.chain().toArray(ClassTag$.MODULE$.apply(Certificate.class)));
                    fos = new FileOutputStream(this.$outer.blended$security$ssl$internal$CertificateController$$cfg.keyStore());
                    try {
                        this.ks$3.store(fos, this.$outer.blended$security$ssl$internal$CertificateController$$cfg.storePass());
                        if (!this.$outer.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) break block4;
                        this.$outer.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Successfully written modified key store to [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.blended$security$ssl$internal$CertificateController$$cfg.keyStore()})));
                    }
                    catch (Throwable throwable) {
                        void var9_8;
                        var9_8.close();
                        throw throwable;
                    }
                }
                fos.close();
                return new ServerKeyStore(this.ks$3, cert);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.ks$3 = ks$3;
                this.existingCert$1 = existingCert$1;
            }
        });
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Try<KeyStore> initKeyStore() {
        this.blended$security$ssl$internal$CertificateController$$log.debug("Initializing key store for server certificate ...");
        KeyStore ks = KeyStore.getInstance("PKCS12");
        File f = new File(this.blended$security$ssl$internal$CertificateController$$cfg.keyStore());
        if (f.exists()) {
            FileInputStream fis = new FileInputStream(f);
            try {
                ks.load(fis, this.blended$security$ssl$internal$CertificateController$$cfg.storePass());
            }
            catch (Throwable throwable) {
                void var3_3;
                var3_3.close();
                throw throwable;
            }
            fis.close();
            return new Success((Object)ks);
        }
        if (this.blended$security$ssl$internal$CertificateController$$log.isInfoEnabled()) {
            this.blended$security$ssl$internal$CertificateController$$log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating empty key store  ..."})).s((Seq)Nil$.MODULE$));
        }
        ks.load(null, this.blended$security$ssl$internal$CertificateController$$cfg.storePass());
        return new Success((Object)ks);
    }

    public CertificateController(CertControllerConfig cfg, CertificateProvider provider) {
        this.blended$security$ssl$internal$CertificateController$$cfg = cfg;
        this.blended$security$ssl$internal$CertificateController$$provider = provider;
        this.blended$security$ssl$internal$CertificateController$$log = LoggerFactory.getLogger(CertificateController.class);
        this.millisPerDay = new package.DurationInt(package$.MODULE$.DurationInt(1)).day().toMillis();
    }
}

