/*
 * Decompiled with CFR 0.152.
 */
package blended.security.scep.internal;

import blended.security.scep.internal.ScepConfig;
import blended.security.ssl.CertificateHolder;
import blended.security.ssl.CertificateHolder$;
import blended.security.ssl.CertificateProvider;
import blended.security.ssl.CertificateRequestBuilder;
import blended.security.ssl.CommonNameProvider;
import blended.security.ssl.MemoryKeystore;
import blended.security.ssl.SelfSignedCertificateProvider;
import blended.security.ssl.SelfSignedConfig;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertStore;
import java.security.cert.X509Certificate;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.jscep.client.Client;
import org.jscep.client.DefaultCallbackHandler;
import org.jscep.client.EnrollmentResponse;
import org.jscep.client.verification.CertificateVerifier;
import org.jscep.client.verification.OptimisticCertificateVerifier;
import org.jscep.transaction.FailInfo;
import org.jscep.transport.response.Capabilities;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001B\u0006\r\u0001UA\u0001\"\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\u0006U\u0001!\ta\u000b\u0005\t]\u0001A)\u0019)C\u0005_!A\u0001\b\u0001ECB\u0013%\u0011\b\u0003\u0005E\u0001!\u0015\r\u0015\"\u0003F\u0011\u0015q\u0005\u0001\"\u0011P\u0011\u0015Y\u0006\u0001\"\u0011]\u0011\u0019I\u0007\u0001)C\u0005U\")A\u000e\u0001C\u0005[\"A\u0011q\u0001\u0001!\n\u0013\tIAA\fTG\u0016\u00048)\u001a:uS\u001aL7-\u0019;f!J|g/\u001b3fe*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\u0005g\u000e,\u0007O\u0003\u0002\u0012%\u0005A1/Z2ve&$\u0018PC\u0001\u0014\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0003\u0001-q\u0011\u0003CA\f\u001b\u001b\u0005A\"\"A\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005mA\"AB!osJ+g\r\u0005\u0002\u001eA5\taD\u0003\u0002 !\u0005\u00191o\u001d7\n\u0005\u0005r\"!G\"feRLg-[2bi\u0016\u0014V-];fgR\u0014U/\u001b7eKJ\u0004\"!H\u0012\n\u0005\u0011r\"aE\"feRLg-[2bi\u0016\u0004&o\u001c<jI\u0016\u0014\u0018aA2gOB\u0011q\u0005K\u0007\u0002\u0019%\u0011\u0011\u0006\u0004\u0002\u000b'\u000e,\u0007oQ8oM&<\u0017A\u0002\u001fj]&$h\b\u0006\u0002-[A\u0011q\u0005\u0001\u0005\u0006K\t\u0001\rAJ\u0001\u0004Y><W#\u0001\u0019\u0011\u0005E2T\"\u0001\u001a\u000b\u0005M\"\u0014a\u00027pO\u001eLgn\u001a\u0006\u0003kI\tA!\u001e;jY&\u0011qG\r\u0002\u0007\u0019><w-\u001a:\u0002\u0015M\u001cW\r]\"mS\u0016tG/F\u0001;!\tY$)D\u0001=\u0015\tid(\u0001\u0004dY&,g\u000e\u001e\u0006\u0003\u007f\u0001\u000bQA[:dKBT\u0011!Q\u0001\u0004_J<\u0017BA\"=\u0005\u0019\u0019E.[3oi\u0006!1-\u00199t+\u00051\u0005CA$M\u001b\u0005A%BA%K\u0003!\u0011Xm\u001d9p]N,'BA&?\u0003%!(/\u00198ta>\u0014H/\u0003\u0002N\u0011\na1)\u00199bE&d\u0017\u000e^5fg\u0006\u0001\"o\\8u\u0007\u0016\u0014H/\u001b4jG\u0006$Xm\u001d\u000b\u0002!B\u0019\u0011kU+\u000e\u0003IS!!\u000e\r\n\u0005Q\u0013&a\u0001+ssB\u0019qC\u0016-\n\u0005]C\"AB(qi&|g\u000e\u0005\u0002\u001e3&\u0011!L\b\u0002\u000f\u001b\u0016lwN]=LKf\u001cHo\u001c:f\u0003I\u0011XM\u001a:fg\"\u001cUM\u001d;jM&\u001c\u0017\r^3\u0015\u0007u\u000bG\rE\u0002R'z\u0003\"!H0\n\u0005\u0001t\"!E\"feRLg-[2bi\u0016Du\u000e\u001c3fe\")!m\u0002a\u0001G\u0006AQ\r_5ti&tw\rE\u0002\u0018-zCQ!Z\u0004A\u0002\u0019\f!b\u00198Qe>4\u0018\u000eZ3s!\tir-\u0003\u0002i=\t\u00112i\\7n_:t\u0015-\\3Qe>4\u0018\u000eZ3s\u0003U\u0019X\r\u001c4TS\u001etW\rZ\"feRLg-[2bi\u0016$\"!X6\t\u000b\u0015D\u0001\u0019\u00014\u0002\u000f\u0011,X\u000e]\"teR\u0011a.\u001f\t\u0003_Zt!\u0001\u001d;\u0011\u0005EDR\"\u0001:\u000b\u0005M$\u0012A\u0002\u001fs_>$h(\u0003\u0002v1\u00051\u0001K]3eK\u001aL!a\u001e=\u0003\rM#(/\u001b8h\u0015\t)\b\u0004C\u0003{\u0013\u0001\u000710A\u0002dgJ\u00042\u0001`A\u0002\u001b\u0005i(B\u0001@\u0000\u0003\u0011\u00018nY:\u000b\u0007\u0005\u0005\u0001)\u0001\u0007c_Vt7-_2bgRdW-C\u0002\u0002\u0006u\u0014!\u0004U&D'F\u00024)\u001a:uS\u001aL7-\u0019;j_:\u0014V-];fgR\fa!\u001a8s_2dG#B/\u0002\f\u0005=\u0001BBA\u0007\u0015\u0001\u00071-\u0001\u0004j]\u000e+'\u000f\u001e\u0005\u0006K*\u0001\rA\u001a")
public class ScepCertificateProvider
implements CertificateRequestBuilder,
CertificateProvider {
    private Logger log;
    private Client scepClient;
    private Capabilities caps;
    private final ScepConfig cfg;
    private Logger blended$security$ssl$CertificateRequestBuilder$$log;
    private int blended$security$ssl$CertificateRequestBuilder$$defaultValidDays;
    private volatile byte bitmap$0;

    public Try<X509v3CertificateBuilder> hostCertificateRequest(CommonNameProvider cnProvider, KeyPair keyPair, BigInteger serial, int validDays, Option<CertificateHolder> issuedBy) {
        return CertificateRequestBuilder.hostCertificateRequest$((CertificateRequestBuilder)this, (CommonNameProvider)cnProvider, (KeyPair)keyPair, (BigInteger)serial, (int)validDays, issuedBy);
    }

    public BigInteger hostCertificateRequest$default$3() {
        return CertificateRequestBuilder.hostCertificateRequest$default$3$((CertificateRequestBuilder)this);
    }

    public int hostCertificateRequest$default$4() {
        return CertificateRequestBuilder.hostCertificateRequest$default$4$((CertificateRequestBuilder)this);
    }

    public Option<CertificateHolder> hostCertificateRequest$default$5() {
        return CertificateRequestBuilder.hostCertificateRequest$default$5$((CertificateRequestBuilder)this);
    }

    public Logger blended$security$ssl$CertificateRequestBuilder$$log() {
        return this.blended$security$ssl$CertificateRequestBuilder$$log;
    }

    public int blended$security$ssl$CertificateRequestBuilder$$defaultValidDays() {
        return this.blended$security$ssl$CertificateRequestBuilder$$defaultValidDays;
    }

    public final void blended$security$ssl$CertificateRequestBuilder$_setter_$blended$security$ssl$CertificateRequestBuilder$$log_$eq(Logger x$1) {
        this.blended$security$ssl$CertificateRequestBuilder$$log = x$1;
    }

    public final void blended$security$ssl$CertificateRequestBuilder$_setter_$blended$security$ssl$CertificateRequestBuilder$$defaultValidDays_$eq(int x$1) {
        this.blended$security$ssl$CertificateRequestBuilder$$defaultValidDays = x$1;
    }

    private Logger log$lzycompute() {
        ScepCertificateProvider scepCertificateProvider = this;
        synchronized (scepCertificateProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ScepCertificateProvider.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.log;
    }

    private Logger log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    private Client scepClient$lzycompute() {
        ScepCertificateProvider scepCertificateProvider = this;
        synchronized (scepCertificateProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                OptimisticCertificateVerifier verifier = new OptimisticCertificateVerifier();
                DefaultCallbackHandler handler = new DefaultCallbackHandler((CertificateVerifier)verifier);
                this.scepClient = new Client(new URL(this.cfg.url()), (CallbackHandler)handler);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.scepClient;
    }

    private Client scepClient() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.scepClient$lzycompute() : this.scepClient;
    }

    private Capabilities caps$lzycompute() {
        ScepCertificateProvider scepCertificateProvider = this;
        synchronized (scepCertificateProvider) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                Capabilities capabilities;
                Option<String> option = this.cfg.profile();
                if (None$.MODULE$.equals(option)) {
                    capabilities = this.scepClient().getCaCapabilities();
                } else if (option instanceof Some) {
                    Some some = (Some)option;
                    String p = (String)some.value();
                    capabilities = this.scepClient().getCaCapabilities(p);
                } else {
                    throw new MatchError(option);
                }
                this.caps = capabilities;
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.caps;
    }

    private Capabilities caps() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.caps$lzycompute() : this.caps;
    }

    public Try<Option<MemoryKeystore>> rootCertificates() {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            List certs = CollectionConverters$.MODULE$.CollectionHasAsScala(this.scepClient().getCaCertificate().getCertificates(null)).asScala().toList();
            MemoryKeystore ms = new MemoryKeystore((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"ca"), CertificateHolder$.MODULE$.create(certs).get())})));
            return new Some((Object)ms);
        });
    }

    public Try<CertificateHolder> refreshCertificate(Option<CertificateHolder> existing, CommonNameProvider cnProvider) {
        Try<CertificateHolder> try_;
        this.log().info((Function0 & Serializable)() -> new StringBuilder(57).append("Trying to refresh the server certificate via SCEP from [").append($this.cfg.url()).append("]").toString());
        Option<CertificateHolder> option = existing;
        if (None$.MODULE$.equals(option)) {
            this.log().info((Function0 & Serializable)() -> "Obtaining initial server certificate from SCEP server.");
            try_ = this.enroll((Option<CertificateHolder>)None$.MODULE$, cnProvider);
        } else if (option instanceof Some) {
            Some some = (Some)option;
            CertificateHolder c = (CertificateHolder)some.value();
            this.log().info((Function0 & Serializable)() -> "Refreshing certificate previously obtained from SCEP server.");
            try_ = this.enroll((Option<CertificateHolder>)new Some((Object)c), cnProvider);
        } else {
            throw new MatchError(option);
        }
        return try_;
    }

    private Try<CertificateHolder> selfSignedCertificate(CommonNameProvider cnProvider) {
        SelfSignedConfig selfSignedConfig = new SelfSignedConfig(cnProvider, this.cfg.keyLength(), this.caps().getStrongestSignatureAlgorithm(), 1);
        return new SelfSignedCertificateProvider(selfSignedConfig).refreshCertificate((Option)None$.MODULE$, cnProvider);
    }

    private String dumpCsr(PKCS10CertificationRequest csr) {
        StringWriter str = new StringWriter();
        JcaPEMWriter pemWriter = new JcaPEMWriter((Writer)str);
        pemWriter.writeObject((Object)csr);
        pemWriter.close();
        str.close();
        return str.toString();
    }

    private Try<CertificateHolder> enroll(Option<CertificateHolder> inCert, CommonNameProvider cnProvider) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            BoxedUnit boxedUnit;
            CertificateHolder certificateHolder;
            Option option = inCert;
            if (None$.MODULE$.equals(option)) {
                CertificateHolder selfSigned;
                this.log().info((Function0 & Serializable)() -> new StringBuilder(54).append("Requesting initial certificate from SCEP server at [").append($this.cfg.url()).append("].").toString());
                certificateHolder = selfSigned = (CertificateHolder)this.selfSignedCertificate(cnProvider).get();
            } else if (option instanceof Some) {
                Some some = (Some)option;
                CertificateHolder c = (CertificateHolder)some.value();
                this.log().info((Function0 & Serializable)() -> new StringBuilder(46).append("Refreshing certificate from SCEP server at [").append($this.cfg.url()).append("].").toString());
                certificateHolder = c;
            } else {
                throw new MatchError((Object)option);
            }
            CertificateHolder reqCert = certificateHolder;
            PrivateKey privKey = (PrivateKey)reqCert.privateKey().get();
            JcaPKCS10CertificationRequestBuilder csrBuilder = new JcaPKCS10CertificationRequestBuilder(new X500Principal((String)cnProvider.commonName().get()), reqCert.publicKey());
            csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_challengePassword, (ASN1Encodable)new DERPrintableString($this.cfg.scepChallenge()));
            if (((IterableOnceOps)cnProvider.alternativeNames().get()).nonEmpty()) {
                GeneralName[] altNames = (GeneralName[])((List)cnProvider.alternativeNames().get()).map((Function1 & Serializable)n -> {
                    this.log().info((Function0 & Serializable)() -> new StringBuilder(59).append("Adding alternative dns name [").append((String)n).append("] to SCEP certificate request.").toString());
                    return new GeneralName(2, n);
                }).toArray(ClassTag$.MODULE$.apply(GeneralName.class));
                GeneralNames names = new GeneralNames(altNames);
                ExtensionsGenerator extGen = new ExtensionsGenerator();
                extGen.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)names);
                boxedUnit = csrBuilder.addAttribute(PKCSObjectIdentifiers.pkcs_9_at_extensionRequest, (ASN1Encodable)extGen.generate());
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            JcaContentSignerBuilder csrSignerBuilder = new JcaContentSignerBuilder($this.cfg.csrSignAlgorithm());
            ContentSigner csrSigner = csrSignerBuilder.build(privKey);
            PKCS10CertificationRequest csr = csrBuilder.build(csrSigner);
            this.log().debug((Function0 & Serializable)() -> new StringBuilder(5).append("csr: ").append(this.dumpCsr(csr)).toString());
            EnrollmentResponse response = this.scepClient().enrol((X509Certificate)reqCert.chain().head(), privKey, csr);
            while (response.isPending()) {
                this.log().info((Function0 & Serializable)() -> new StringBuilder(32).append("Waiting for PKI response from [").append($this.cfg.url()).append("]").toString());
                Thread.sleep(1000L);
            }
            if (response.isFailure()) {
                FailInfo info = response.getFailInfo();
                this.log().error((Function0 & Serializable)() -> new StringBuilder(35).append("Certificate provisioning failed: [").append(info).append("]").toString());
                throw package$.MODULE$.error(info.toString());
            }
            CertStore store = response.getCertStore();
            List certs = CollectionConverters$.MODULE$.CollectionHasAsScala(store.getCertificates(null)).asScala().toList();
            this.log().info((Function0 & Serializable)() -> new StringBuilder(34).append("Retrieved [").append(certs.length()).append("] certificates from [").append($this.cfg.url()).append("].").toString());
            return (CertificateHolder)CertificateHolder$.MODULE$.create(reqCert.publicKey(), (Option)new Some((Object)privKey), certs).get();
        });
    }

    public ScepCertificateProvider(ScepConfig cfg) {
        this.cfg = cfg;
        CertificateRequestBuilder.$init$((CertificateRequestBuilder)this);
        CertificateProvider.$init$((CertificateProvider)this);
        Statics.releaseFence();
    }
}

