/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.ws.internal;

import akka.actor.ActorSystem;
import akka.http.scaladsl.marshalling.Marshaller$;
import akka.http.scaladsl.marshalling.ToResponseMarshallable$;
import akka.http.scaladsl.model.StatusCodes$;
import akka.http.scaladsl.model.ws.Message;
import akka.http.scaladsl.model.ws.TextMessage;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.Directive$;
import akka.http.scaladsl.server.Directives$;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.StandardRoute;
import akka.http.scaladsl.server.directives.ParameterDirectives;
import akka.http.scaladsl.server.util.ApplyConverter$;
import akka.http.scaladsl.unmarshalling.Unmarshaller$;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Flow$;
import blended.mgmt.ws.internal.Dispatcher;
import blended.mgmt.ws.internal.Dispatcher$;
import blended.mgmt.ws.internal.DispatcherEvent;
import blended.mgmt.ws.internal.NewData;
import blended.mgmt.ws.internal.ReceivedMessage;
import blended.security.login.api.Token;
import blended.security.login.api.TokenStore;
import blended.updater.config.ContainerInfo;
import blended.updater.config.json.PrickleProtocol$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import prickle.Pickle$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0006\r\u0001UA\u0001\u0002\b\u0001\u0003\u0002\u0003\u0006I!\b\u0005\tK\u0001\u0011\t\u0011)A\u0005M!)\u0001\u0007\u0001C\u0001c!1a\u0007\u0001Q\u0001\n]Baa\u0010\u0001!\u0002\u0017\u0001\u0005B\u0002$\u0001A\u0003%q\tC\u0003K\u0001\u0011\u00051\n\u0003\u0005e\u0001!\u0015\r\u0015\"\u0003L\u0011\u0019)\u0007\u0001)C\u0005M\")Q\u0010\u0001C\u0001}\n\u0019RjZ7u/\u0016\u00147k\\2lKR\u001cVM\u001d<fe*\u0011QBD\u0001\tS:$XM\u001d8bY*\u0011q\u0002E\u0001\u0003oNT!!\u0005\n\u0002\t5<W\u000e\u001e\u0006\u0002'\u00059!\r\\3oI\u0016$7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\u000e\u000e\u0003aQ\u0011!G\u0001\u0006g\u000e\fG.Y\u0005\u00037a\u0011a!\u00118z%\u00164\u0017AB:zgR,W\u000e\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u0005)\u0011m\u0019;pe*\t!%\u0001\u0003bW.\f\u0017B\u0001\u0013 \u0005-\t5\r^8s'f\u001cH/Z7\u0002\u000bM$xN]3\u0011\u0005\u001drS\"\u0001\u0015\u000b\u0005%R\u0013aA1qS*\u00111\u0006L\u0001\u0006Y><\u0017N\u001c\u0006\u0003[I\t\u0001b]3dkJLG/_\u0005\u0003_!\u0012!\u0002V8lK:\u001cFo\u001c:f\u0003\u0019a\u0014N\\5u}Q\u0019!\u0007N\u001b\u0011\u0005M\u0002Q\"\u0001\u0007\t\u000bq\u0019\u0001\u0019A\u000f\t\u000b\u0015\u001a\u0001\u0019\u0001\u0014\u0002\u00071|w\r\u0005\u00029{5\t\u0011H\u0003\u0002;w\u00059An\\4hS:<'B\u0001\u001f\u0013\u0003\u0011)H/\u001b7\n\u0005yJ$A\u0002'pO\u001e,'/A\u0003f\u0007RDH\u000f\u0005\u0002B\t6\t!I\u0003\u0002D1\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005\u0015\u0013%\u0001G#yK\u000e,H/[8o\u0007>tG/\u001a=u\u000bb,7-\u001e;pe\u0006QA-[:qCR\u001c\u0007.\u001a:\u0011\u0005MB\u0015BA%\r\u0005)!\u0015n\u001d9bi\u000eDWM]\u0001\u0006e>,H/Z\u000b\u0002\u0019B\u0011Q*\u0019\b\u0003\u001dzs!aT.\u000f\u0005ACfBA)W\u001d\t\u0011V+D\u0001T\u0015\t!F#\u0001\u0004=e>|GOP\u0005\u0002E%\u0011q+I\u0001\u0005QR$\b/\u0003\u0002Z5\u0006A1oY1mC\u0012\u001cHN\u0003\u0002XC%\u0011A,X\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0005eS\u0016BA0a\u0003\u001d\u0001\u0018mY6bO\u0016T!\u0001X/\n\u0005\t\u001c'!\u0002*pkR,'BA0a\u0003%\u0011x.\u001e;f\u00136\u0004H.\u0001\beSN\u0004\u0018\r^2iKJ4En\\<\u0015\u0005\u001dD\b#\u00025m]:,X\"A5\u000b\u0005eS'BA6\"\u0003\u0019\u0019HO]3b[&\u0011Q.\u001b\u0002\u0005\r2|w\u000f\u0005\u0002pg6\t\u0001O\u0003\u0002\u0010c*\u0011!/X\u0001\u0006[>$W\r\\\u0005\u0003iB\u0014q!T3tg\u0006<W\r\u0005\u0002\u0018m&\u0011q\u000f\u0007\u0002\u0004\u0003:L\b\"B=\n\u0001\u0004Q\u0018\u0001B5oM>\u0004\"aJ>\n\u0005qD#!\u0002+pW\u0016t\u0017\u0001\u0005:fa>\u0014H/\u0012:s_J\u001ch\t\\8x+\ry\u0018qA\u000b\u0003\u0003\u0003\u0001r\u0001\u001b7\u0002\u0004\u0005\rQ\u000f\u0005\u0003\u0002\u0006\u0005\u001dA\u0002\u0001\u0003\b\u0003\u0013Q!\u0019AA\u0006\u0005\u0005!\u0016cAA\u0007kB\u0019q#a\u0004\n\u0007\u0005E\u0001DA\u0004O_RD\u0017N\\4")
public class MgmtWebSocketServer {
    private Function1<RequestContext, Future<RouteResult>> routeImpl;
    private final TokenStore store;
    private final Logger log;
    private final ExecutionContextExecutor eCtxt;
    private final Dispatcher dispatcher;
    private volatile boolean bitmap$0;

    public Function1<RequestContext, Future<RouteResult>> route() {
        return this.routeImpl();
    }

    private Function1<RequestContext, Future<RouteResult>> routeImpl$lzycompute() {
        MgmtWebSocketServer mgmtWebSocketServer = this;
        synchronized (mgmtWebSocketServer) {
            if (!this.bitmap$0) {
                this.routeImpl = (Function1)Directive$.MODULE$.addByNameNullaryApply(Directives$.MODULE$.pathSingleSlash()).apply((Function0 & Serializable & scala.Serializable)() -> {
                    $this.log.info((Function0 & Serializable & scala.Serializable)() -> "Received Web Socket upgrade request");
                    return (Function1)Directive$.MODULE$.addDirectiveApply((Directive)Directives$.MODULE$.parameter(ParameterDirectives.ParamMagnet$.MODULE$.apply((Object)"token", ParameterDirectives.ParamDef$.MODULE$.forString(Unmarshaller$.MODULE$.identityUnmarshaller()))), ApplyConverter$.MODULE$.hac1()).apply((Function1 & Serializable & scala.Serializable)token -> {
                        StandardRoute standardRoute;
                        $this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Evaluating token [").append((String)token).append("]").toString());
                        Try try_ = $this.store.verifyToken(token);
                        if (try_ instanceof Failure) {
                            Failure failure = (Failure)try_;
                            Throwable e = failure.exception();
                            $this.log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Could not verify token [").append((String)token).append("] : [").append(e.getMessage()).append("]").toString());
                            standardRoute = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.Unauthorized(), Marshaller$.MODULE$.fromStatusCode()));
                        } else if (try_ instanceof Success) {
                            StandardRoute standardRoute2;
                            Success success = (Success)try_;
                            Token token2 = (Token)success.value();
                            $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Starting Web Socket message handler ... [").append(token2.id()).append("]").toString());
                            Option option = $this.store.getToken(token2.id());
                            if (None$.MODULE$.equals(option)) {
                                standardRoute2 = Directives$.MODULE$.complete((Function0 & Serializable & scala.Serializable)() -> ToResponseMarshallable$.MODULE$.apply((Object)StatusCodes$.MODULE$.BadRequest(), Marshaller$.MODULE$.fromStatusCode()));
                            } else if (option instanceof Some) {
                                Some some = (Some)option;
                                Token info = (Token)some.value();
                                standardRoute2 = Directives$.MODULE$.handleWebSocketMessages(this.dispatcherFlow(info));
                            } else {
                                throw new MatchError((Object)option);
                            }
                            standardRoute = standardRoute2;
                        } else {
                            throw new MatchError((Object)try_);
                        }
                        return standardRoute;
                    });
                });
                this.bitmap$0 = true;
            }
        }
        return this.routeImpl;
    }

    private Function1<RequestContext, Future<RouteResult>> routeImpl() {
        return !this.bitmap$0 ? this.routeImpl$lzycompute() : this.routeImpl;
    }

    private Flow<Message, Message, Object> dispatcherFlow(Token info) {
        return ((Flow)((Flow)Flow$.MODULE$.apply().collect((PartialFunction)new scala.Serializable(null){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Message, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof TextMessage.Strict) {
                    TextMessage.Strict strict = (TextMessage.Strict)A1;
                    String msg = strict.text();
                    object = msg;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Message x1) {
                Message message = x1;
                boolean bl = message instanceof TextMessage.Strict;
                return bl;
            }
        })).via(this.dispatcher.newClient(info)).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            TextMessage.Strict strict;
            DispatcherEvent dispatcherEvent = x0$1;
            if (dispatcherEvent instanceof ReceivedMessage) {
                ReceivedMessage receivedMessage = (ReceivedMessage)dispatcherEvent;
                String m = receivedMessage.msg();
                strict = new TextMessage.Strict(m);
            } else if (dispatcherEvent instanceof NewData) {
                TextMessage.Strict strict2;
                NewData newData = (NewData)dispatcherEvent;
                Object data = newData.data();
                Object object = data;
                if (object instanceof ContainerInfo) {
                    ContainerInfo containerInfo = (ContainerInfo)object;
                    String json = Pickle$.MODULE$.intoString((Object)containerInfo, Pickle$.MODULE$.intoString$default$2(), PrickleProtocol$.MODULE$.containerInfoPickler(), PrickleProtocol$.MODULE$.prickleConfig());
                    strict2 = new TextMessage.Strict(json);
                } else if (object instanceof String) {
                    String string = (String)object;
                    strict2 = new TextMessage.Strict(string);
                } else {
                    strict2 = new TextMessage.Strict("");
                }
                strict = strict2;
            } else {
                strict = new TextMessage.Strict(dispatcherEvent.toString());
            }
            return strict;
        })).via(this.reportErrorsFlow());
    }

    public <T> Flow<T, T, Object> reportErrorsFlow() {
        return (Flow)Flow$.MODULE$.apply().watchTermination((Function2 & Serializable & scala.Serializable)(x$1, f) -> {
            f.onComplete((Function1 & Serializable & scala.Serializable)x0$1 -> {
                MgmtWebSocketServer.$anonfun$reportErrorsFlow$2(x0$1);
                return BoxedUnit.UNIT;
            }, (ExecutionContext)this.eCtxt);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$reportErrorsFlow$2(Try x0$1) {
        Try try_ = x0$1;
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable cause = failure.exception();
            Predef$.MODULE$.println((Object)new StringBuilder(22).append("WS stream failed with ").append(cause).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public MgmtWebSocketServer(ActorSystem system, TokenStore store) {
        this.store = store;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(MgmtWebSocketServer.class));
        this.eCtxt = system.dispatcher();
        this.dispatcher = Dispatcher$.MODULE$.create(system);
    }
}

