/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.service.jmx.internal;

import blended.mgmt.service.jmx.internal.ServiceJmxConfig;
import blended.mgmt.service.jmx.internal.ServiceTypeTemplate;
import blended.mgmt.service.jmx.internal.SingleServiceConfig;
import blended.updater.config.ServiceInfo;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.Serializable;
import javax.management.Attribute;
import javax.management.MBeanServer;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.JavaConverters$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.Iterable$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001=4AAC\u0006\u0001-!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0011\u0015Y\u0003\u0001\"\u0001-\u0011\u001d\u0001\u0004A1A\u0005\nEBaA\u000f\u0001!\u0002\u0013\u0011\u0004\"B\u001e\u0001\t\u0003a\u0004\"\u0002&\u0001\t\u0003Y\u0005\"B0\u0001\t\u0003\u0001\u0007\"\u00027\u0001\t\u0003i'AE*feZL7-\u001a&nq\u0006s\u0017\r\\=tKJT!\u0001D\u0007\u0002\u0011%tG/\u001a:oC2T!AD\b\u0002\u0007)l\u0007P\u0003\u0002\u0011#\u000591/\u001a:wS\u000e,'B\u0001\n\u0014\u0003\u0011iw-\u001c;\u000b\u0003Q\tqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0005\u00019\u0002C\u0001\r\u001c\u001b\u0005I\"\"\u0001\u000e\u0002\u000bM\u001c\u0017\r\\1\n\u0005qI\"AB!osJ+g-\u0001\u0004tKJ4XM\u001d\t\u0003?\u0011j\u0011\u0001\t\u0006\u0003C\t\n!\"\\1oC\u001e,W.\u001a8u\u0015\u0005\u0019\u0013!\u00026bm\u0006D\u0018BA\u0013!\u0005-i%)Z1o'\u0016\u0014h/\u001a:\u0002\r\r|gNZ5h!\tA\u0013&D\u0001\f\u0013\tQ3B\u0001\tTKJ4\u0018nY3K[b\u001cuN\u001c4jO\u00061A(\u001b8jiz\"2!\f\u00180!\tA\u0003\u0001C\u0003\u001e\u0007\u0001\u0007a\u0004C\u0003'\u0007\u0001\u0007q%A\u0002m_\u001e,\u0012A\r\t\u0003gaj\u0011\u0001\u000e\u0006\u0003kY\nq\u0001\\8hO&twM\u0003\u00028'\u0005!Q\u000f^5m\u0013\tIDG\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%\u0001\u0007de\u0016\fG/\u001a$jYR,'\u000fF\u0002>\u0001\u0016\u0003\"a\b \n\u0005}\u0002#AC(cU\u0016\u001cGOT1nK\")\u0011I\u0002a\u0001\u0005\u0006I1O^2D_:4\u0017n\u001a\t\u0003Q\rK!\u0001R\u0006\u0003'MKgn\u001a7f'\u0016\u0014h/[2f\u0007>tg-[4\t\u000b\u00193\u0001\u0019A$\u0002\u0011Q,W\u000e\u001d7bi\u0016\u0004\"\u0001\u000b%\n\u0005%[!aE*feZL7-\u001a+za\u0016$V-\u001c9mCR,\u0017!C5ogR\fgnY3t)\tae\fE\u0002N+bs!AT*\u000f\u0005=\u0013V\"\u0001)\u000b\u0005E+\u0012A\u0002\u001fs_>$h(C\u0001\u001b\u0013\t!\u0016$A\u0004qC\u000e\\\u0017mZ3\n\u0005Y;&\u0001\u0002'jgRT!\u0001V\r\u0011\u000baI6LQ$\n\u0005iK\"A\u0002+va2,7\u0007\u0005\u0002 9&\u0011Q\f\t\u0002\u000f\u001f\nTWm\u0019;J]N$\u0018M\\2f\u0011\u0015\tu\u00011\u0001C\u0003-\u0019XM\u001d<jG\u0016LeNZ8\u0015\t\u0005D'n\u001b\t\u0003E\u001al\u0011a\u0019\u0006\u0003M\u0011T!!Z\n\u0002\u000fU\u0004H-\u0019;fe&\u0011qm\u0019\u0002\f'\u0016\u0014h/[2f\u0013:4w\u000eC\u0003j\u0011\u0001\u00071,\u0001\u0005j]N$\u0018M\\2f\u0011\u0015\t\u0005\u00021\u0001C\u0011\u00151\u0005\u00021\u0001H\u0003\u001d\tg.\u00197zg\u0016$\u0012A\u001c\t\u0004\u001bV\u000b\u0007")
public class ServiceJmxAnalyser {
    private final MBeanServer server;
    private final ServiceJmxConfig config;
    private final Logger log;

    private Logger log() {
        return this.log;
    }

    public ObjectName createFilter(SingleServiceConfig svcConfig, ServiceTypeTemplate template) {
        String templateAttrs = (String)template.query().foldLeft((Object)"", (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2;
            String s;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$1, x1$1);
                    if (tuple22 == null) break block2;
                    s = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(2).append(s).append(k).append("=").append(v).append(",").toString();
            return string;
        });
        String attr = (String)svcConfig.query().foldLeft((Object)templateAttrs, (Function2 & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2 tuple2;
            String s;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = new Tuple2(x0$2, x1$2);
                    if (tuple22 == null) break block2;
                    s = (String)tuple22._1();
                    tuple2 = (Tuple2)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError((Object)tuple22);
            }
            String k = (String)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(2).append(s).append(k).append("=").append(v).append(",").toString();
            return string;
        });
        return new ObjectName(new StringBuilder(2).append(template.domain()).append(":").append(attr).append("*").toString());
    }

    public List<Tuple3<ObjectInstance, SingleServiceConfig, ServiceTypeTemplate>> instances(SingleServiceConfig svcConfig) {
        List list;
        Option option = this.config.templates().get((Object)svcConfig.svcType());
        if (None$.MODULE$.equals(option)) {
            this.log().warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("No Servicetype Template for service ").append(svcConfig.name()).append(" found").toString());
            list = List$.MODULE$.empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            ServiceTypeTemplate template = (ServiceTypeTemplate)some.value();
            list = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(this.server.queryMBeans(this.createFilter(svcConfig, template), null)).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$1 -> new Tuple3(x$1, (Object)svcConfig, (Object)template), List$.MODULE$.canBuildFrom());
        } else {
            throw new MatchError((Object)option);
        }
        return list;
    }

    public ServiceInfo serviceInfo(ObjectInstance instance, SingleServiceConfig svcConfig, ServiceTypeTemplate template) {
        return new ServiceInfo(instance.getObjectName().toString(), template.name(), System.currentTimeMillis(), (long)this.config.interval() * 1000L, this.attributes$1(template, svcConfig, instance));
    }

    public List<ServiceInfo> analyse() {
        long start = System.currentTimeMillis();
        List objectInstances = (List)((TraversableOnce)this.config.services().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SingleServiceConfig svcConfig = (SingleServiceConfig)tuple2._2();
            List<Tuple3<ObjectInstance, SingleServiceConfig, ServiceTypeTemplate>> list = this.instances(svcConfig);
            return list;
        }, Iterable$.MODULE$.canBuildFrom())).toList().flatten((Function1)Predef$.MODULE$.$conforms());
        List result = (List)objectInstances.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            ObjectInstance i = (ObjectInstance)tuple3._1();
            SingleServiceConfig s = (SingleServiceConfig)tuple3._2();
            ServiceTypeTemplate t = (ServiceTypeTemplate)tuple3._3();
            ServiceInfo serviceInfo = this.serviceInfo(i, s, t);
            return serviceInfo;
        }, List$.MODULE$.canBuildFrom());
        long end = System.currentTimeMillis();
        this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Analysed ").append(result.size()).append(" Service Infos in ").append(end - start).append("ms").toString());
        return result;
    }

    private static final List transformOne$1(List name, Object value) {
        .colon.colon colon2;
        Object object = value;
        if (object instanceof CompositeDataSupport) {
            CompositeDataSupport data = (CompositeDataSupport)object;
            colon2 = (List)((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(data.getCompositeType().keySet()).asScala()).map((Function1 & Serializable & scala.Serializable)k -> {
                List list;
                Object object = data.get((String)k);
                if (object instanceof CompositeData) {
                    List list2 = name;
                    list = ServiceJmxAnalyser.transformOne$1(new .colon.colon(k, (List)Nil$.MODULE$).$colon$colon$colon(list2), object);
                } else {
                    list = new .colon.colon((Object)new Tuple2((Object)new StringBuilder(1).append(name.mkString(".")).append(".").append((String)k).toString(), (Object)object.toString()), (List)Nil$.MODULE$);
                }
                return list;
            }, Set$.MODULE$.canBuildFrom())).toList().flatten((Function1)Predef$.MODULE$.$conforms());
        } else {
            colon2 = new .colon.colon((Object)new Tuple2((Object)name.mkString("."), (Object)object.toString()), (List)Nil$.MODULE$);
        }
        return colon2;
    }

    private static final List transformAll$1(List name, List attrs) {
        List list;
        List list2 = attrs;
        if (list2 instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list2;
            Attribute head = (Attribute)colon2.head();
            List tail = colon2.tl$access$1();
            List list3 = name;
            List newName = new .colon.colon((Object)head.getName(), (List)Nil$.MODULE$).$colon$colon$colon(list3);
            List list4 = ServiceJmxAnalyser.transformOne$1(newName, head.getValue());
            list = ServiceJmxAnalyser.transformAll$1(name, tail).$colon$colon$colon(list4);
        } else if (Nil$.MODULE$.equals(list2)) {
            list = List$.MODULE$.empty();
        } else {
            throw new MatchError((Object)list2);
        }
        return list;
    }

    private final Map attributes$1(ServiceTypeTemplate template$2, SingleServiceConfig svcConfig$2, ObjectInstance instance$1) {
        List attrNames = (List)template$2.attributes().$plus$plus(svcConfig$2.attributes(), List$.MODULE$.canBuildFrom());
        List attrList = (List)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter((java.util.List)this.server.getAttributes(instance$1.getObjectName(), (String[])attrNames.toArray(ClassTag$.MODULE$.apply(String.class)))).asScala()).toList().map((Function1 & Serializable & scala.Serializable)x$5 -> (Attribute)x$5, List$.MODULE$.canBuildFrom());
        return ServiceJmxAnalyser.transformAll$1(List$.MODULE$.empty(), attrList).toMap(Predef$.MODULE$.$conforms());
    }

    public ServiceJmxAnalyser(MBeanServer server, ServiceJmxConfig config) {
        this.server = server;
        this.config = config;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(ServiceJmxAnalyser.class));
    }
}

