/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.rest.internal;

import akka.event.EventStream;
import akka.http.scaladsl.marshalling.Marshaller;
import akka.http.scaladsl.model.HttpEntity;
import akka.http.scaladsl.model.MediaType;
import akka.http.scaladsl.model.RequestEntity;
import akka.http.scaladsl.model.headers.HttpChallenge;
import akka.http.scaladsl.server.Directive;
import akka.http.scaladsl.server.RequestContext;
import akka.http.scaladsl.server.RouteResult;
import akka.http.scaladsl.server.directives.AuthenticationDirective;
import akka.http.scaladsl.unmarshalling.Unmarshaller;
import blended.mgmt.repo.WritableArtifactRepo;
import blended.mgmt.rest.internal.CollectorService;
import blended.mgmt.rest.internal.RemoteContainerStatePersistor;
import blended.prickle.akka.http.PrickleSupport;
import blended.security.BlendedPermission;
import blended.security.BlendedPermissionManager;
import blended.security.akka.http.BlendedSecurityDirectives;
import blended.security.akka.http.JAASSecurityDirectives;
import blended.updater.config.ContainerInfo;
import blended.updater.config.ContainerRegistryResponseOK;
import blended.updater.config.OverlayConfig;
import blended.updater.config.OverlayRef;
import blended.updater.config.RemoteContainerState;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.UpdateAction;
import blended.updater.config.UpdateContainerInfo;
import blended.updater.remote.ContainerState;
import blended.updater.remote.RemoteUpdater;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import javax.security.auth.Subject;
import microjson.JsValue;
import prickle.PConfig;
import prickle.Pickler;
import prickle.Unpickler;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.Future;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.sys.package$;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015g\u0001B\f\u0019\u0001\u0005B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\r\u0002\u0011\t\u0011)A\u0005\u000f\"A!\n\u0001BC\u0002\u0013\u00053\n\u0003\u0005Q\u0001\t\u0005\t\u0015!\u0003M\u0011!\t\u0006A!b\u0001\n\u0003\u0012\u0006\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B*\t\u000b}\u0003A\u0011\u00011\t\u0011\u0019\u0004\u0001R1Q\u0005\n\u001dDQ\u0001\u001d\u0001\u0005BEDaA\u001d\u0001!B\u0013\u0019\bBB?\u0001A\u0003&a\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005m\u0001\u0001\"\u0001\u0002\u001e!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0002bBA\u0014\u0001\u0011\u0005\u0013\u0011\u0006\u0005\b\u0003\u0003\u0002A\u0011IA\"\u0011\u001d\tY\u0006\u0001C!\u0003;Bq!!\u001b\u0001\t\u0003\nY\u0007C\u0004\u0002x\u0001!\t%!\u001f\t\u000f\u0005u\u0004\u0001\"\u0011\u0002\u0000!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAK\u0001\u0011\u0005\u0013q\u0013\u0002\u0015\u0007>dG.Z2u_J\u001cVM\u001d<jG\u0016LU\u000e\u001d7\u000b\u0005eQ\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005ma\u0012\u0001\u0002:fgRT!!\b\u0010\u0002\t5<W\u000e\u001e\u0006\u0002?\u00059!\r\\3oI\u0016$7\u0001A\n\u0006\u0001\tBCF\u000e\t\u0003G\u0019j\u0011\u0001\n\u0006\u0002K\u0005)1oY1mC&\u0011q\u0005\n\u0002\u0007\u0003:L(+\u001a4\u0011\u0005%RS\"\u0001\r\n\u0005-B\"\u0001E\"pY2,7\r^8s'\u0016\u0014h/[2f!\tiC'D\u0001/\u0015\ty\u0003'\u0001\u0003iiR\u0004(BA\u00193\u0003\u0011\t7n[1\u000b\u0005Mr\u0012\u0001C:fGV\u0014\u0018\u000e^=\n\u0005Ur#A\u0006&B\u0003N\u001bVmY;sSRLH)\u001b:fGRLg/Z:\u0011\u0005]bT\"\u0001\u001d\u000b\u0005=J$BA\u0019;\u0015\tYd$A\u0004qe&\u001c7\u000e\\3\n\u0005uB$A\u0004)sS\u000e\\G.Z*vaB|'\u000f^\u0001\bkB$\u0017\r^3s!\t\u0001E)D\u0001B\u0015\t\u00115)\u0001\u0004sK6|G/\u001a\u0006\u0003}yI!!R!\u0003\u001bI+Wn\u001c;f+B$\u0017\r^3s\u0003u\u0011X-\\8uK\u000e{g\u000e^1j]\u0016\u00148\u000b^1uKB+'o]5ti>\u0014\bCA\u0015I\u0013\tI\u0005DA\u000fSK6|G/Z\"p]R\f\u0017N\\3s'R\fG/\u001a)feNL7\u000f^8s\u0003\riwM]\u000b\u0002\u0019B\u0011QJT\u0007\u0002e%\u0011qJ\r\u0002\u0019\u00052,g\u000eZ3e!\u0016\u0014X.[:tS>tW*\u00198bO\u0016\u0014\u0018\u0001B7he\u0002\nqA^3sg&|g.F\u0001T!\t!6L\u0004\u0002V3B\u0011a\u000bJ\u0007\u0002/*\u0011\u0001\fI\u0001\u0007yI|w\u000e\u001e \n\u0005i#\u0013A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!A\u0017\u0013\u0002\u0011Y,'o]5p]\u0002\na\u0001P5oSRtD#B1cG\u0012,\u0007CA\u0015\u0001\u0011\u0015qt\u00011\u0001@\u0011\u00151u\u00011\u0001H\u0011\u0015Qu\u00011\u0001M\u0011\u0015\tv\u00011\u0001T\u0003\rawnZ\u000b\u0002QB\u0011\u0011N\\\u0007\u0002U*\u00111\u000e\\\u0001\bY><w-\u001b8h\u0015\tig$\u0001\u0003vi&d\u0017BA8k\u0005\u0019aunZ4fe\u0006AAo\\*ue&tw\rF\u0001T\u0003-)g/\u001a8u'R\u0014X-Y7\u0011\u0007\r\"h/\u0003\u0002vI\t1q\n\u001d;j_:\u0004\"a^>\u000e\u0003aT!!\u001f>\u0002\u000b\u00154XM\u001c;\u000b\u0003EJ!\u0001 =\u0003\u0017\u00153XM\u001c;TiJ,\u0017-\\\u0001\u000eCJ$\u0018NZ1diJ+\u0007o\\:\u0011\u000bQ{8+a\u0001\n\u0007\u0005\u0005QLA\u0002NCB\u0004B!!\u0002\u0002\f5\u0011\u0011q\u0001\u0006\u0004\u0003\u0013a\u0012\u0001\u0002:fa>LA!!\u0004\u0002\b\t!rK]5uC\ndW-\u0011:uS\u001a\f7\r\u001e*fa>\fq\"\u00193e\u0003J$\u0018NZ1diJ+\u0007o\u001c\u000b\u0005\u0003'\tI\u0002E\u0002$\u0003+I1!a\u0006%\u0005\u0011)f.\u001b;\t\u000f\u0005%A\u00021\u0001\u0002\u0004\u0005\u0011\"/Z7pm\u0016\f%\u000f^5gC\u000e$(+\u001a9p)\u0011\t\u0019\"a\b\t\u000f\u0005%Q\u00021\u0001\u0002\u0004\u0005q1/\u001a;Fm\u0016tGo\u0015;sK\u0006lG\u0003BA\n\u0003KAQA\u001d\bA\u0002M\fA\u0003\u001d:pG\u0016\u001c8oQ8oi\u0006Lg.\u001a:J]\u001a|G\u0003BA\u0016\u0003o\u0001B!!\f\u000245\u0011\u0011q\u0006\u0006\u0004\u0003c\u0019\u0015AB2p]\u001aLw-\u0003\u0003\u00026\u0005=\"aG\"p]R\f\u0017N\\3s%\u0016<\u0017n\u001d;ssJ+7\u000f]8og\u0016|5\nC\u0004\u0002:=\u0001\r!a\u000f\u0002\t%tgm\u001c\t\u0005\u0003[\ti$\u0003\u0003\u0002@\u0005=\"!D\"p]R\f\u0017N\\3s\u0013:4w.A\bhKR\u001cUO\u001d:f]R\u001cF/\u0019;f)\t\t)\u0005\u0005\u0004\u0002H\u0005E\u0013QK\u0007\u0003\u0003\u0013RA!a\u0013\u0002N\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u001f\"\u0013AC2pY2,7\r^5p]&!\u00111KA%\u0005\r\u0019V-\u001d\t\u0005\u0003[\t9&\u0003\u0003\u0002Z\u0005=\"\u0001\u0006*f[>$XmQ8oi\u0006Lg.\u001a:Ti\u0006$X-A\u000bsK\u001eL7\u000f^3s%VtG/[7f\u0007>tg-[4\u0015\t\u0005M\u0011q\f\u0005\b\u0003C\n\u0002\u0019AA2\u0003\t\u00118\r\u0005\u0003\u0002.\u0005\u0015\u0014\u0002BA4\u0003_\u0011QBU;oi&lWmQ8oM&<\u0017!\u0006:fO&\u001cH/\u001a:Pm\u0016\u0014H.Y=D_:4\u0017n\u001a\u000b\u0005\u0003'\ti\u0007C\u0004\u0002pI\u0001\r!!\u001d\u0002\u0005=\u001c\u0007\u0003BA\u0017\u0003gJA!!\u001e\u00020\tiqJ^3sY\u0006L8i\u001c8gS\u001e\f\u0011cZ3u%VtG/[7f\u0007>tg-[4t)\t\tY\b\u0005\u0004\u0002H\u0005E\u00131M\u0001\u0012O\u0016$xJ^3sY\u0006L8i\u001c8gS\u001e\u001cHCAAA!\u0019\t9%!\u0015\u0002r\u0005y\u0011\r\u001a3Va\u0012\fG/Z!di&|g\u000e\u0006\u0004\u0002\u0014\u0005\u001d\u00151\u0012\u0005\u0007\u0003\u0013+\u0002\u0019A*\u0002\u0017\r|g\u000e^1j]\u0016\u0014\u0018\n\u001a\u0005\b\u0003\u001b+\u0002\u0019AAH\u00031)\b\u000fZ1uK\u0006\u001bG/[8o!\u0011\ti#!%\n\t\u0005M\u0015q\u0006\u0002\r+B$\u0017\r^3BGRLwN\\\u0001\u000eS:\u001cH/\u00197m\u0005VtG\r\\3\u0015\u0015\u0005e\u00151UAT\u0003W\u000by\f\u0005\u0004\u0002\u001c\u0006}\u00151C\u0007\u0003\u0003;S!!\u001c\u0013\n\t\u0005\u0005\u0016Q\u0014\u0002\u0004)JL\bBBAS-\u0001\u00071+\u0001\u0004sKB|\u0017\n\u001a\u0005\u0007\u0003S3\u0002\u0019A*\u0002\tA\fG\u000f\u001b\u0005\b\u0003[3\u0002\u0019AAX\u0003\u00111\u0017\u000e\\3\u0011\t\u0005E\u00161X\u0007\u0003\u0003gSA!!.\u00028\u0006\u0011\u0011n\u001c\u0006\u0003\u0003s\u000bAA[1wC&!\u0011QXAZ\u0005\u00111\u0015\u000e\\3\t\u000f\u0005\u0005g\u00031\u0001\u0002D\u000691\u000f[12'Vl\u0007cA\u0012u'\u0002")
public class CollectorServiceImpl
implements CollectorService,
JAASSecurityDirectives,
PrickleSupport {
    private Logger log;
    private final RemoteUpdater updater;
    private final RemoteContainerStatePersistor remoteContainerStatePersistor;
    private final BlendedPermissionManager mgr;
    private final String version;
    private Option<EventStream> eventStream;
    private Map<String, WritableArtifactRepo> artifactRepos;
    private final Logger blended$prickle$akka$http$PrickleSupport$$log;
    private final MediaType.WithFixedCharset prickleMediaType;
    private Logger blended$security$akka$http$JAASSecurityDirectives$$log;
    private final HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge;
    private final AuthenticationDirective<Subject> authenticated;
    private final Function1<RequestContext, Future<RouteResult>> httpRoute;
    private Logger blended$mgmt$rest$internal$CollectorService$$log;
    private volatile byte bitmap$0;

    public <T> Marshaller<T, RequestEntity> toEntityMarshaller(Pickler<T> p, PConfig<JsValue> config) {
        return PrickleSupport.toEntityMarshaller$((PrickleSupport)this, p, config);
    }

    public <T> Unmarshaller<HttpEntity, T> fromEntityUnmarshaller(Unpickler<T> u, PConfig<JsValue> config) {
        return PrickleSupport.fromEntityUnmarshaller$((PrickleSupport)this, u, config);
    }

    public Directive<BoxedUnit> requirePermission(BlendedPermission permission) {
        return JAASSecurityDirectives.requirePermission$((JAASSecurityDirectives)this, (BlendedPermission)permission);
    }

    public Directive<BoxedUnit> requireGroup(String group) {
        return JAASSecurityDirectives.requireGroup$((JAASSecurityDirectives)this, (String)group);
    }

    public Directive<BoxedUnit> requirePermission(String permission) {
        return BlendedSecurityDirectives.requirePermission$((BlendedSecurityDirectives)this, (String)permission);
    }

    @Override
    public Option<OverlayRef> findMissingOverlayRef(Iterable<OverlayRef> configs) {
        return CollectorService.findMissingOverlayRef$(this, configs);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> versionRoute() {
        return CollectorService.versionRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> collectorRoute() {
        return CollectorService.collectorRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> infoRoute() {
        return CollectorService.infoRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> runtimeConfigRoute() {
        return CollectorService.runtimeConfigRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> overlayConfigRoute() {
        return CollectorService.overlayConfigRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> updateActionRoute() {
        return CollectorService.updateActionRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> rolloutProfileRoute() {
        return CollectorService.rolloutProfileRoute$(this);
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> uploadDeploymentPackRoute() {
        return CollectorService.uploadDeploymentPackRoute$(this);
    }

    @Override
    public Try<Tuple2<String, String>> processDeploymentPack(String repoId, File zipFile) {
        return CollectorService.processDeploymentPack$(this, repoId, zipFile);
    }

    @Override
    public void deleteRecursive(Seq<File> files) {
        CollectorService.deleteRecursive$(this, files);
    }

    public Logger blended$prickle$akka$http$PrickleSupport$$log() {
        return this.blended$prickle$akka$http$PrickleSupport$$log;
    }

    public MediaType.WithFixedCharset prickleMediaType() {
        return this.prickleMediaType;
    }

    public final void blended$prickle$akka$http$PrickleSupport$_setter_$blended$prickle$akka$http$PrickleSupport$$log_$eq(Logger x$1) {
        this.blended$prickle$akka$http$PrickleSupport$$log = x$1;
    }

    public void blended$prickle$akka$http$PrickleSupport$_setter_$prickleMediaType_$eq(MediaType.WithFixedCharset x$1) {
        this.prickleMediaType = x$1;
    }

    private Logger blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blended$security$akka$http$JAASSecurityDirectives$$log = JAASSecurityDirectives.blended$security$akka$http$JAASSecurityDirectives$$log$((JAASSecurityDirectives)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public Logger blended$security$akka$http$JAASSecurityDirectives$$log() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blended$security$akka$http$JAASSecurityDirectives$$log$lzycompute() : this.blended$security$akka$http$JAASSecurityDirectives$$log;
    }

    public HttpChallenge blended$security$akka$http$JAASSecurityDirectives$$challenge() {
        return this.blended$security$akka$http$JAASSecurityDirectives$$challenge;
    }

    public AuthenticationDirective<Subject> authenticated() {
        return this.authenticated;
    }

    public final void blended$security$akka$http$JAASSecurityDirectives$_setter_$blended$security$akka$http$JAASSecurityDirectives$$challenge_$eq(HttpChallenge x$1) {
        this.blended$security$akka$http$JAASSecurityDirectives$$challenge = x$1;
    }

    public void blended$security$akka$http$JAASSecurityDirectives$_setter_$authenticated_$eq(AuthenticationDirective<Subject> x$1) {
        this.authenticated = x$1;
    }

    @Override
    public Function1<RequestContext, Future<RouteResult>> httpRoute() {
        return this.httpRoute;
    }

    private Logger blended$mgmt$rest$internal$CollectorService$$log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.blended$mgmt$rest$internal$CollectorService$$log = CollectorService.blended$mgmt$rest$internal$CollectorService$$log$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.blended$mgmt$rest$internal$CollectorService$$log;
    }

    @Override
    public Logger blended$mgmt$rest$internal$CollectorService$$log() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.blended$mgmt$rest$internal$CollectorService$$log$lzycompute() : this.blended$mgmt$rest$internal$CollectorService$$log;
    }

    @Override
    public void blended$mgmt$rest$internal$CollectorService$_setter_$httpRoute_$eq(Function1<RequestContext, Future<RouteResult>> x$1) {
        this.httpRoute = x$1;
    }

    public BlendedPermissionManager mgr() {
        return this.mgr;
    }

    @Override
    public String version() {
        return this.version;
    }

    private Logger log$lzycompute() {
        CollectorServiceImpl collectorServiceImpl = this;
        synchronized (collectorServiceImpl) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(CollectorServiceImpl.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.log;
    }

    private Logger log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.log;
    }

    public String toString() {
        return new StringBuilder(55).append(this.getClass().getSimpleName()).append("(updater=").append(this.updater).append(",remoteContainerStatePersistor=").append(this.remoteContainerStatePersistor).append(",mgr=").append(this.mgr()).append(",version=").append(this.version()).append(")").toString();
    }

    public void addArtifactRepo(WritableArtifactRepo repo) {
        this.artifactRepos = this.artifactRepos.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)repo.repoId()), (Object)repo));
    }

    public void removeArtifactRepo(WritableArtifactRepo repo) {
        this.artifactRepos = this.artifactRepos.filterKeys((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)CollectorServiceImpl.$anonfun$removeArtifactRepo$1(repo, name)));
    }

    public void setEventStream(Option<EventStream> eventStream) {
        this.eventStream = eventStream;
    }

    @Override
    public ContainerRegistryResponseOK processContainerInfo(ContainerInfo info) {
        this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Processing container info: ").append(info).toString());
        this.eventStream.foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.publish((Object)new UpdateContainerInfo(info));
            return BoxedUnit.UNIT;
        });
        ContainerState updated = this.updater.updateContainerState(info);
        List actions = updated.outstandingActions();
        RemoteContainerState state = new RemoteContainerState(info, actions);
        this.remoteContainerStatePersistor.updateState(state);
        return new ContainerRegistryResponseOK(info.containerId(), actions);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public scala.collection.immutable.Seq<RemoteContainerState> getCurrentState() {
        void var1_1;
        List<RemoteContainerState> states = this.remoteContainerStatePersistor.findAll();
        this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("About to send state: ").append(states).toString());
        return var1_1;
    }

    @Override
    public void registerRuntimeConfig(RuntimeConfig rc) {
        this.updater.registerRuntimeConfig(rc);
    }

    @Override
    public void registerOverlayConfig(OverlayConfig oc) {
        this.updater.registerOverlayConfig(oc);
    }

    @Override
    public scala.collection.immutable.Seq<RuntimeConfig> getRuntimeConfigs() {
        return this.updater.getRuntimeConfigs();
    }

    @Override
    public scala.collection.immutable.Seq<OverlayConfig> getOverlayConfigs() {
        return this.updater.getOverlayConfigs();
    }

    @Override
    public void addUpdateAction(String containerId, UpdateAction updateAction) {
        this.updater.addAction(containerId, updateAction);
    }

    @Override
    public Try<BoxedUnit> installBundle(String repoId, String path, File file, Option<String> sha1Sum) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            this.log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("About to install bundle into repoId: ").append(repoId).append(" at path: ").append(path).append(", file: ").append(file).append(" with checksum: ").append(sha1Sum).toString());
            WritableArtifactRepo repo = (WritableArtifactRepo)$this.artifactRepos.getOrElse((Object)repoId, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(42).append("No artifact repository with ID ").append(repoId).append(" registered").toString()));
            try (InputStream stream = file.toURI().toURL().openStream();){
                repo.uploadFile(path, stream, sha1Sum).get();
            }
        });
    }

    public static final /* synthetic */ boolean $anonfun$removeArtifactRepo$1(WritableArtifactRepo repo$1, String name) {
        String string = name;
        String string2 = repo$1.repoId();
        return string == null ? string2 != null : !string.equals(string2);
    }

    public CollectorServiceImpl(RemoteUpdater updater, RemoteContainerStatePersistor remoteContainerStatePersistor, BlendedPermissionManager mgr, String version) {
        this.updater = updater;
        this.remoteContainerStatePersistor = remoteContainerStatePersistor;
        this.mgr = mgr;
        this.version = version;
        CollectorService.$init$(this);
        BlendedSecurityDirectives.$init$((BlendedSecurityDirectives)this);
        JAASSecurityDirectives.$init$((JAASSecurityDirectives)this);
        PrickleSupport.$init$((PrickleSupport)this);
        this.log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(8).append("This is ").append(this.toString()).toString());
        this.eventStream = None$.MODULE$;
        this.artifactRepos = (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$);
    }
}

