/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.repo.file;

import blended.mgmt.repo.WritableArtifactRepo;
import blended.mgmt.repo.file.FileArtifactRepo$;
import blended.updater.config.util.StreamCopy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uc\u0001B\u0001\u0003\u0001-\u0011\u0001CR5mK\u0006\u0013H/\u001b4bGR\u0014V\r]8\u000b\u0005\r!\u0011\u0001\u00024jY\u0016T!!\u0002\u0004\u0002\tI,\u0007o\u001c\u0006\u0003\u000f!\tA!\\4ni*\t\u0011\"A\u0004cY\u0016tG-\u001a3\u0004\u0001M!\u0001\u0001\u0004\n\u0017!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00111\u0003F\u0007\u0002\t%\u0011Q\u0003\u0002\u0002\r\u0003J$\u0018NZ1diJ+\u0007o\u001c\t\u0003']I!\u0001\u0007\u0003\u0003)]\u0013\u0018\u000e^1cY\u0016\f%\u000f^5gC\u000e$(+\u001a9p\u0011!Q\u0002A!b\u0001\n\u0003Z\u0012A\u0002:fa>LE-F\u0001\u001d!\tiBE\u0004\u0002\u001fEA\u0011qDD\u0007\u0002A)\u0011\u0011EC\u0001\u0007yI|w\u000e\u001e \n\u0005\rr\u0011A\u0002)sK\u0012,g-\u0003\u0002&M\t11\u000b\u001e:j]\u001eT!a\t\b\t\u0011!\u0002!\u0011!Q\u0001\nq\tqA]3q_&#\u0007\u0005\u0003\u0005+\u0001\t\u0005\t\u0015!\u0003,\u0003\u001d\u0011\u0017m]3ESJ\u0004\"\u0001L\u0019\u000e\u00035R!AL\u0018\u0002\u0005%|'\"\u0001\u0019\u0002\t)\fg/Y\u0005\u0003e5\u0012AAR5mK\")A\u0007\u0001C\u0001k\u00051A(\u001b8jiz\"2A\u000e\u001d:!\t9\u0004!D\u0001\u0003\u0011\u0015Q2\u00071\u0001\u001d\u0011\u0015Q3\u00071\u0001,\u0011\u0019Y\u0004\u0001)A\u0005y\u0005\u0019An\\4\u0011\u0005u\u0012U\"\u0001 \u000b\u0005}\u0002\u0015a\u00027pO\u001eLgn\u001a\u0006\u0003\u0003\"\tA!\u001e;jY&\u00111I\u0010\u0002\u0007\u0019><w-\u001a:\t\u000b\u0015\u0003A\u0011\u0001$\u0002']LG\u000f[\"iK\u000e\\W\r\u001a$jY\u0016\u0004\u0016\r\u001e5\u0016\u0005\u001d\u0003FC\u0001%_)\tI\u0015\fE\u0002K\u0019:k\u0011a\u0013\u0006\u0003\u0003:I!!T&\u0003\u0007Q\u0013\u0018\u0010\u0005\u0002P!2\u0001A!B)E\u0005\u0004\u0011&!\u0001+\u0012\u0005M3\u0006CA\u0007U\u0013\t)fBA\u0004O_RD\u0017N\\4\u0011\u000559\u0016B\u0001-\u000f\u0005\r\te.\u001f\u0005\u00065\u0012\u0003\raW\u0001\u0002MB!Q\u0002X\u0016O\u0013\tifBA\u0005Gk:\u001cG/[8oc!)q\f\u0012a\u00019\u0005!\u0001/\u0019;i\u0011\u0015\t\u0007\u0001\"\u0001c\u0003!1\u0017N\u001c3GS2,GCA2g!\riAmK\u0005\u0003K:\u0011aa\u00149uS>t\u0007\"B0a\u0001\u0004a\u0002\"\u00025\u0001\t\u0003I\u0017\u0001\u00064j]\u00124\u0015\u000e\\3TQ\u0006\f4\t[3dWN,X\u000e\u0006\u0002kWB\u0019Q\u0002\u001a\u000f\t\u000b};\u0007\u0019\u0001\u000f\t\u000b5\u0004A\u0011\t8\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\b\u0005\u0006a\u0002!\t!]\u0001\nY&\u001cHOR5mKN$\"A]>\u0011\u0007MDHD\u0004\u0002um:\u0011q$^\u0005\u0002\u001f%\u0011qOD\u0001\ba\u0006\u001c7.Y4f\u0013\tI(P\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0015\t9h\u0002C\u0003`_\u0002\u0007A\u0004C\u0003~\u0001\u0011\u0005c0\u0001\u0006va2|\u0017\r\u001a$jY\u0016$ra`A\u0004\u0003\u0013\t\u0019\u0002\u0005\u0003K\u0019\u0006\u0005\u0001cA\u0007\u0002\u0004%\u0019\u0011Q\u0001\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006?r\u0004\r\u0001\b\u0005\b\u0003\u0017a\b\u0019AA\u0007\u0003-1\u0017\u000e\\3D_:$XM\u001c;\u0011\u00071\ny!C\u0002\u0002\u00125\u00121\"\u00138qkR\u001cFO]3b[\"1\u0011Q\u0003?A\u0002)\fqa\u001d5bcM+XnB\u0004\u0002\u001a\tA\t!a\u0007\u0002!\u0019KG.Z!si&4\u0017m\u0019;SKB|\u0007cA\u001c\u0002\u001e\u00191\u0011A\u0001E\u0001\u0003?\u00192!!\b\r\u0011\u001d!\u0014Q\u0004C\u0001\u0003G!\"!a\u0007\t\u0011\u0005\u001d\u0012Q\u0004C\u0001\u0003S\tQBY=uKN$vn\u0015;sS:<Gc\u0001\u000f\u0002,!A\u0011QFA\u0013\u0001\u0004\ty#\u0001\u0004eS\u001e,7\u000f\u001e\t\u0006\u001b\u0005E\u0012QG\u0005\u0004\u0003gq!!B!se\u0006L\bcA\u0007\u00028%\u0019\u0011\u0011\b\b\u0003\t\tKH/\u001a\u0004\b\u0003{\ti\u0002AA \u0005i\t%\u000f^5gC\u000e$8i\u001c7mSNLwN\\#yG\u0016\u0004H/[8o'\u0011\tY$!\u0011\u0011\u0007M\f\u0019%C\u0002\u0002Fi\u0014\u0001CU;oi&lW-\u0012=dKB$\u0018n\u001c8\t\u0015\u0005%\u00131\bB\u0001B\u0003%A$A\u0002ng\u001eDq\u0001NA\u001e\t\u0003\ti\u0005\u0006\u0003\u0002P\u0005M\u0003\u0003BA)\u0003wi!!!\b\t\u000f\u0005%\u00131\na\u00019\u0001")
public class FileArtifactRepo
implements WritableArtifactRepo {
    private final String repoId;
    private final File baseDir;
    private final Logger log;

    public static String bytesToString(byte[] byArray) {
        return FileArtifactRepo$.MODULE$.bytesToString(byArray);
    }

    @Override
    public String repoId() {
        return this.repoId;
    }

    public <T> Try<T> withCheckedFilePath(String path, Function1<File, T> f) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            URI base = $this.baseDir.toURI().normalize();
            URI toCheck = new File($this.baseDir, path).toURI().normalize();
            if (!toCheck.getPath().startsWith(base.getPath())) {
                throw scala.sys.package$.MODULE$.error("invalid path given");
            }
            String pathToCheck = toCheck.getPath().substring(base.getPath().length());
            if (pathToCheck.startsWith("..") || pathToCheck.startsWith("/..")) {
                throw scala.sys.package$.MODULE$.error("invalid path given");
            }
            return new File(toCheck);
        }).map(f);
    }

    @Override
    public Option<File> findFile(String path) {
        return (Option)this.withCheckedFilePath(path, (Function1 & Serializable & scala.Serializable)file -> file.exists() && file.isFile() ? Option$.MODULE$.apply(file) : None$.MODULE$).getOrElse((Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
    }

    @Override
    public Option<String> findFileSha1Checksum(String path) {
        return this.findFile(path).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Option option;
            try (DigestInputStream sha1Stream = new DigestInputStream(new BufferedInputStream(new FileInputStream((File)file)), MessageDigest.getInstance("SHA"));){
                try {
                    while (sha1Stream.read() != -1) {
                    }
                    option = Option$.MODULE$.apply((Object)FileArtifactRepo$.MODULE$.bytesToString(sha1Stream.getMessageDigest().digest()));
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    Option option2 = NonFatal$.MODULE$.unapply(throwable2);
                    if (option2.isEmpty()) {
                        throw throwable;
                    }
                    None$ none$ = None$.MODULE$;
                    option = none$;
                }
            }
            return option;
        });
    }

    public String toString() {
        return new StringBuilder(18).append(this.getClass().getSimpleName()).append("(repoId=").append(this.repoId()).append(",baseDir=").append(this.baseDir).append(")").toString();
    }

    @Override
    public Iterator<String> listFiles(String path) {
        URI base = this.baseDir.toURI().normalize();
        return (Iterator)this.withCheckedFilePath(path, (Function1 & Serializable & scala.Serializable)file -> {
            Iterator iterator;
            if (!file.exists()) {
                iterator = package$.MODULE$.Iterator().empty();
            } else {
                FileSystem fs = file.toPath().getFileSystem();
                Iterator files = FileArtifactRepo.getFiles$1(file.toPath());
                URI baseFile = file.toURI();
                iterator = files.map((Function1 & Serializable & scala.Serializable)f -> baseFile.relativize(f.toUri().normalize()).getPath());
            }
            return iterator;
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.Iterator().empty());
    }

    @Override
    public Try<BoxedUnit> uploadFile(String path, InputStream fileContent, Option<String> sha1Sum) {
        return this.withCheckedFilePath(path, (Function1 & Serializable & scala.Serializable)file -> {
            FileArtifactRepo.$anonfun$uploadFile$1(this, path, fileContent, sha1Sum, file);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$listFiles$3(boolean isDir$1, Path f) {
        return !isDir$1;
    }

    private static final Iterator getFiles$1(Path dir) {
        Iterator files = (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(Files.newDirectoryStream(dir).iterator()).asScala();
        return files.flatMap((Function1 & Serializable & scala.Serializable)f2 -> {
            boolean isDir = Files.isDirectory(f2, new LinkOption[0]);
            Iterator file = package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Path[]{f2})).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileArtifactRepo.$anonfun$listFiles$3(isDir, f)));
            Iterator childs = isDir ? FileArtifactRepo.getFiles$1(f2) : package$.MODULE$.Iterator().empty();
            return file.$plus$plus((Function0 & Serializable & scala.Serializable)() -> childs);
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ void $anonfun$uploadFile$1(FileArtifactRepo $this, String path$2, InputStream fileContent$1, Option sha1Sum$1, File file) {
        if (file.exists()) {
            if (file.isFile()) {
                Option option = sha1Sum$1;
                if (None$.MODULE$.equals(option)) {
                    throw new ArtifactCollisionException(new StringBuilder(51).append("There is already an artifact installed under path: ").append(path$2).toString());
                }
                Option<String> existingSum = $this.findFileSha1Checksum(path$2);
                Option option2 = option;
                Option<String> option3 = existingSum;
                if (option2 == null ? option3 != null : !option2.equals(option3)) {
                    $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("Artifact with different checksum (existing: ").append(existingSum).append(", new: ").append(option).append(") already present: ").append(path$2).toString());
                    throw new ArtifactCollisionException(new StringBuilder(77).append("There is already an artifact with a different checksum installed under path: ").append(path$2).toString());
                }
                $this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Artifact with same checksum already present: ").append(path$2).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
            $this.log.error((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Artifact path [").append(path$2).append("] is a directory. Cannot upload").toString());
            throw new IllegalArgumentException(new StringBuilder(49).append("The given path [").append(path$2).append("] cannot be used as artifact path").toString());
        }
        Option$.MODULE$.apply((Object)file.getParentFile()).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.mkdirs()));
        try (FileOutputStream fos = new FileOutputStream(file);){
            $this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("About to save file: ").append(file).toString());
            StreamCopy$.MODULE$.copy(fileContent$1, (OutputStream)fos);
            return;
        }
    }

    public FileArtifactRepo(String repoId, File baseDir) {
        this.repoId = repoId;
        this.baseDir = baseDir;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FileArtifactRepo.class));
    }

    public static class ArtifactCollisionException
    extends RuntimeException {
        public ArtifactCollisionException(String msg) {
            super(msg);
        }
    }
}

