/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.mock.clients;

import akka.actor.ActorSystem;
import akka.actor.ActorSystem$;
import blended.container.context.api.ContainerContext;
import blended.container.context.impl.internal.AbstractContainerContextImpl;
import blended.mgmt.agent.internal.MgmtReporter;
import blended.mgmt.mock.MockObjects$;
import blended.mgmt.mock.clients.Config;
import blended.mgmt.mock.clients.ContainerActor$;
import blended.mgmt.mock.clients.MgmtMockClients$;
import blended.updater.config.ContainerInfo;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.ConfigFactory;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.util.Random;

@ScalaSignature(bytes="\u0006\u0005%4AAD\b\u00011!Aq\u0004\u0001B\u0001B\u0003%\u0001\u0005C\u0003%\u0001\u0011\u0005Q\u0005\u0003\u0004)\u0001\u0001\u0006I!\u000b\u0005\u0007c\u0001\u0001\u000b\u0011\u0002\u001a\t\r]\u0002\u0001\u0015!\u00039\u0011\u001d\u0011\u0005A1A\u0005\u0004\rCa\u0001\u0014\u0001!\u0002\u0013!\u0005\"B'\u0001\t\u0003q\u0005\"\u0002*\u0001\t\u0003qu!B*\u0010\u0011\u0003!f!\u0002\b\u0010\u0011\u0003)\u0006\"\u0002\u0013\f\t\u00031\u0006\"B,\f\t\u0003A&aD'h[RlunY6DY&,g\u000e^:\u000b\u0005A\t\u0012aB2mS\u0016tGo\u001d\u0006\u0003%M\tA!\\8dW*\u0011A#F\u0001\u0005[\u001elGOC\u0001\u0017\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u00013A\u0011!$H\u0007\u00027)\tA$A\u0003tG\u0006d\u0017-\u0003\u0002\u001f7\t1\u0011I\\=SK\u001a\faaY8oM&<\u0007CA\u0011#\u001b\u0005y\u0011BA\u0012\u0010\u0005\u0019\u0019uN\u001c4jO\u00061A(\u001b8jiz\"\"AJ\u0014\u0011\u0005\u0005\u0002\u0001\"B\u0010\u0003\u0001\u0004\u0001\u0013a\u00017pOB\u0011!fL\u0007\u0002W)\u0011A&L\u0001\bY><w-\u001b8h\u0015\tqS#\u0001\u0003vi&d\u0017B\u0001\u0019,\u0005\u0019aunZ4fe\u0006\u0019!O\u001c3\u0011\u0005M*T\"\u0001\u001b\u000b\u00059Z\u0012B\u0001\u001c5\u0005\u0019\u0011\u0016M\u001c3p[\u000611\r^\"uqR\u0004\"!\u000f!\u000e\u0003iR!a\u000f\u001f\u0002\u0007\u0005\u0004\u0018N\u0003\u0002>}\u000591m\u001c8uKb$(BA \u0016\u0003%\u0019wN\u001c;bS:,'/\u0003\u0002Bu\t\u00012i\u001c8uC&tWM]\"p]R,\u0007\u0010^\u0001\u0007gf\u001cH/Z7\u0016\u0003\u0011\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u000b\u0005\u001cGo\u001c:\u000b\u0003%\u000bA!Y6lC&\u00111J\u0012\u0002\f\u0003\u000e$xN]*zgR,W.A\u0004tsN$X-\u001c\u0011\u0002\u000bM$\u0018M\u001d;\u0015\u0003=\u0003\"A\u0007)\n\u0005E[\"\u0001B+oSR\fAa\u001d;pa\u0006yQjZ7u\u001b>\u001c7n\u00117jK:$8\u000f\u0005\u0002\"\u0017M\u00111\"\u0007\u000b\u0002)\u0006!Q.Y5o)\ty\u0015\fC\u0003[\u001b\u0001\u00071,\u0001\u0003be\u001e\u001c\bc\u0001\u000e]=&\u0011Ql\u0007\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003?\u001at!\u0001\u00193\u0011\u0005\u0005\\R\"\u00012\u000b\u0005\r<\u0012A\u0002\u001fs_>$h(\u0003\u0002f7\u00051\u0001K]3eK\u001aL!a\u001a5\u0003\rM#(/\u001b8h\u0015\t)7\u0004")
public class MgmtMockClients {
    private final Config config;
    private final Logger log;
    private final Random rnd;
    private final ContainerContext ctCtxt;
    private final ActorSystem system;

    public static void main(String[] stringArray) {
        MgmtMockClients$.MODULE$.main(stringArray);
    }

    public ActorSystem system() {
        return this.system;
    }

    public void start() {
        this.log.debug((Function0 & Serializable)() -> new StringBuilder(28).append("About to start with config: ").append($this.config).toString());
        List<ContainerInfo> containerInfos = MockObjects$.MODULE$.createContainer(Predef$.MODULE$.int2Integer(this.config.clientCount()));
        containerInfos.map((Function1 & Serializable)ci -> {
            long diff = Math.abs($this.config.updateIntervalMsecMax() - $this.config.updateIntervalMsecMin());
            long interval = Math.abs($this.rnd.nextLong()) % diff + Math.min($this.config.updateIntervalMsecMax(), $this.config.updateIntervalMsecMin());
            MgmtReporter.MgmtReporterConfig reporterConfig = new MgmtReporter.MgmtReporterConfig($this.config.url(), interval, $this.config.initialUpdateDelayMsec());
            return this.system().actorOf(ContainerActor$.MODULE$.props(reporterConfig, $this.ctCtxt), new StringBuilder(10).append("container-").append(ci.containerId()).toString());
        });
    }

    public void stop() {
        this.log.debug((Function0 & Serializable)() -> "About to stop");
        Await$.MODULE$.ready((Awaitable)this.system().terminate(), (Duration)Duration$.MODULE$.apply(10L, TimeUnit.SECONDS));
    }

    public MgmtMockClients(Config config) {
        this.config = config;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(MgmtMockClients.class));
        this.rnd = new Random();
        this.ctCtxt = new AbstractContainerContextImpl(null){
            private final String containerDirectory;
            private final String containerConfigDirectory;
            private final String containerLogDirectory;
            private final String profileDirectory;
            private final String profileConfigDirectory;
            private final String containerHostname;
            private final com.typesafe.config.Config containerConfig;

            public String containerDirectory() {
                return this.containerDirectory;
            }

            public String containerConfigDirectory() {
                return this.containerConfigDirectory;
            }

            public String containerLogDirectory() {
                return this.containerLogDirectory;
            }

            public String profileDirectory() {
                return this.profileDirectory;
            }

            public String profileConfigDirectory() {
                return this.profileConfigDirectory;
            }

            public String containerHostname() {
                return this.containerHostname;
            }

            public com.typesafe.config.Config containerConfig() {
                return this.containerConfig;
            }

            public String getContainerConfigDirectory() {
                return this.containerConfigDirectory();
            }

            public String getContainerDirectory() {
                return this.containerDirectory();
            }

            public String getContainerHostname() {
                return this.containerHostname();
            }

            public String getContainerLogDirectory() {
                return this.containerLogDirectory();
            }

            public String getProfileConfigDirectory() {
                return this.profileConfigDirectory();
            }

            public String getProfileDirectory() {
                return this.profileDirectory();
            }
            {
                this.containerDirectory = ".";
                this.containerConfigDirectory = this.containerDirectory();
                this.containerLogDirectory = this.containerDirectory();
                this.profileDirectory = this.containerDirectory();
                this.profileConfigDirectory = this.containerDirectory();
                this.containerHostname = "localhost";
                this.containerConfig = ConfigFactory.empty();
            }
        };
        this.system = ActorSystem$.MODULE$.apply("MgmtMockClients");
    }
}

