/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.base.internal;

import blended.container.context.api.ContainerContext;
import blended.mgmt.base.internal.FrameworkServiceMBean;
import blended.util.StreamCopySupport;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001!4A\u0001C\u0005\u0001%!AQ\u0004\u0001B\u0001B\u0003%a\u0004\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011\u0015\u0019\u0004\u0001\"\u00015\u0011\u0019A\u0004\u0001)A\u0005s!1\u0011\t\u0001Q\u0001\n\tCQ!\u0014\u0001\u0005B9Ca\u0001\u001a\u0001!\n\u0013)'\u0001\u0005$sC6,wo\u001c:l'\u0016\u0014h/[2f\u0015\tQ1\"\u0001\u0005j]R,'O\\1m\u0015\taQ\"\u0001\u0003cCN,'B\u0001\b\u0010\u0003\u0011iw-\u001c;\u000b\u0003A\tqA\u00197f]\u0012,Gm\u0001\u0001\u0014\u0007\u0001\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0004B]f\u0014VM\u001a\t\u00035mi\u0011!C\u0005\u00039%\u0011QC\u0012:b[\u0016<xN]6TKJ4\u0018nY3N\u0005\u0016\fg.A\u0007ck:$G.Z\"p]R,\u0007\u0010\u001e\t\u0003?\u0019j\u0011\u0001\t\u0006\u0003C\t\n\u0011B\u001a:b[\u0016<xN]6\u000b\u0005\r\"\u0013\u0001B8tO&T\u0011!J\u0001\u0004_J<\u0017BA\u0014!\u00055\u0011UO\u001c3mK\u000e{g\u000e^3yi\u0006I1\r^\"p]R,\u0007\u0010\u001e\t\u0003UEj\u0011a\u000b\u0006\u0003Y5\n1!\u00199j\u0015\tqs&A\u0004d_:$X\r\u001f;\u000b\u0005Az\u0011!C2p]R\f\u0017N\\3s\u0013\t\u00114F\u0001\tD_:$\u0018-\u001b8fe\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2!\u000e\u001c8!\tQ\u0002\u0001C\u0003\u001e\u0007\u0001\u0007a\u0004C\u0003)\u0007\u0001\u0007\u0011&A\u0002m_\u001e\u0004\"AO \u000e\u0003mR!\u0001P\u001f\u0002\u000f1|wmZ5oO*\u0011ahD\u0001\u0005kRLG.\u0003\u0002Aw\t1Aj\\4hKJ\f!B]3ti\u0006\u0014H/\u001b8h!\t\u00195*D\u0001E\u0015\t)e)\u0001\u0004bi>l\u0017n\u0019\u0006\u0003\u000f\"\u000b!bY8oGV\u0014(/\u001a8u\u0015\tq\u0014JC\u0001K\u0003\u0011Q\u0017M^1\n\u00051#%!D!u_6L7MQ8pY\u0016\fg.\u0001\tsKN$\u0018M\u001d;D_:$\u0018-\u001b8feR\u0019qJU0\u0011\u0005Q\u0001\u0016BA)\u0016\u0005\u0011)f.\u001b;\t\u000bM3\u0001\u0019\u0001+\u0002\rI,\u0017m]8o!\t)FL\u0004\u0002W5B\u0011q+F\u0007\u00021*\u0011\u0011,E\u0001\u0007yI|w\u000e\u001e \n\u0005m+\u0012A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!aW\u000b\t\u000b\u00014\u0001\u0019A1\u0002\u0011M\fg/\u001a'pON\u0004\"\u0001\u00062\n\u0005\r,\"a\u0002\"p_2,\u0017M\\\u0001\u0011GJ,\u0017\r^3M_\u001e\f%o\u00195jm\u0016$\"a\u00144\t\u000b\u001d<\u0001\u0019\u0001+\u0002\u0013QLW.Z:uC6\u0004\b")
public class FrameworkService
implements FrameworkServiceMBean {
    private final BundleContext bundleContext;
    private final ContainerContext ctContext;
    private final Logger log;
    private final AtomicBoolean restarting;

    @Override
    public void restartContainer(String reason, boolean saveLogs) {
        Config cfg = this.ctContext.getContainerConfig();
        String saveLogsPath = "blended.saveLogsOnRestart";
        try {
            Bundle frameworkBundle = this.bundleContext.getBundle(0L);
            boolean alreadyRestarting = this.restarting.getAndSet(true);
            if (!alreadyRestarting) {
                boolean saveLogsConfigured;
                String now = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n             |---------------------------------------------------------------------------------------------------------\n             | Container restart initiated : ").append(now).append("\n             | Reason                      : ").append(reason).append("\n             |---------------------------------------------------------------------------------------------------------\n        ").toString())).stripMargin();
                this.log.warn((Function0 & Serializable & scala.Serializable)() -> msg);
                boolean bl = saveLogsConfigured = cfg.hasPath(saveLogsPath) && cfg.getBoolean(saveLogsPath);
                if (saveLogs & saveLogsConfigured) {
                    this.createLogArchive(now);
                }
                frameworkBundle.update();
            } else {
                this.log.warn((Function0 & Serializable & scala.Serializable)() -> "Ignoring container restart command because framework is already restarting.");
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log.error(e, (Function0 & Serializable & scala.Serializable)() -> "Could not restart container");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void createLogArchive(String timestamp) {
        String archiveName = new StringBuilder(12).append("restart-").append(timestamp).append(".zip").toString();
        File logDir = new File(this.ctContext.getContainerLogDirectory());
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Creating log archive from directory [").append(logDir.getAbsolutePath()).append("]").toString());
        List logFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.list(new FilenameFilter(null){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isFile() && !name.startsWith("restart");
            }
        }))).toList();
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Files :[").append(logFiles).append("]").toString());
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(logDir, archiveName)));
            logFiles.foreach((Function1 & Serializable & scala.Serializable)logFile -> {
                FrameworkService.$anonfun$createLogArchive$3(out, logDir, logFile);
                return BoxedUnit.UNIT;
            });
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.log.error((Throwable)e, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Error creating log archive (").append(e.getMessage()).append(")").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$createLogArchive$3(ZipOutputStream out$1, File logDir$1, String logFile) {
        out$1.putNextEntry(new ZipEntry(logFile));
        FileInputStream in = new FileInputStream(new File(logDir$1, logFile));
        StreamCopySupport.copyStream((InputStream)in, (OutputStream)out$1);
        in.close();
        out$1.closeEntry();
    }

    public FrameworkService(BundleContext bundleContext, ContainerContext ctContext) {
        this.bundleContext = bundleContext;
        this.ctContext = ctContext;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FrameworkService.class));
        this.restarting = new AtomicBoolean(false);
    }
}

