/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.base.internal;

import blended.container.context.api.ContainerContext;
import blended.mgmt.base.internal.FrameworkServiceMBean;
import blended.util.StreamCopySupport;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001!4A!\u0001\u0002\u0001\u0017\t\u0001bI]1nK^|'o[*feZL7-\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tAAY1tK*\u0011q\u0001C\u0001\u0005[\u001elGOC\u0001\n\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005U1%/Y7fo>\u00148nU3sm&\u001cW-\u0014\"fC:D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u000eEVtG\r\\3D_:$X\r\u001f;\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00034sC6,wo\u001c:l\u0015\tib$\u0001\u0003pg\u001eL'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"5\ti!)\u001e8eY\u0016\u001cuN\u001c;fqRD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\nGR\u001cuN\u001c;fqR\u0004\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002*U\u000591m\u001c8uKb$(BA\u0016\t\u0003%\u0019wN\u001c;bS:,'/\u0003\u0002.M\t\u00012i\u001c8uC&tWM]\"p]R,\u0007\u0010\u001e\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00124\u0007\u0005\u0002\u0014\u0001!)qC\fa\u00011!)1E\fa\u0001I!1Q\u0007\u0001Q\u0001\nY\n1\u0001\\8h!\t9D(D\u00019\u0015\tI$(A\u0004m_\u001e<\u0017N\\4\u000b\u0005mB\u0011\u0001B;uS2L!!\u0010\u001d\u0003\r1{wmZ3s\u0011\u0019y\u0004\u0001)A\u0005\u0001\u0006Q!/Z:uCJ$\u0018N\\4\u0011\u0005\u0005KU\"\u0001\"\u000b\u0005\r#\u0015AB1u_6L7M\u0003\u0002F\r\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005m:%\"\u0001%\u0002\t)\fg/Y\u0005\u0003\u0015\n\u0013Q\"\u0011;p[&\u001c'i\\8mK\u0006t\u0007\"\u0002'\u0001\t\u0003j\u0015\u0001\u0005:fgR\f'\u000f^\"p]R\f\u0017N\\3s)\rq\u0015K\u0018\t\u0003\u001b=K!\u0001\u0015\b\u0003\tUs\u0017\u000e\u001e\u0005\u0006%.\u0003\raU\u0001\u0007e\u0016\f7o\u001c8\u0011\u0005Q[fBA+Z!\t1f\"D\u0001X\u0015\tA&\"\u0001\u0004=e>|GOP\u0005\u00035:\ta\u0001\u0015:fI\u00164\u0017B\u0001/^\u0005\u0019\u0019FO]5oO*\u0011!L\u0004\u0005\u0006?.\u0003\r\u0001Y\u0001\tg\u00064X\rT8hgB\u0011Q\"Y\u0005\u0003E:\u0011qAQ8pY\u0016\fg\u000e\u0003\u0004e\u0001\u0001&I!Z\u0001\u0011GJ,\u0017\r^3M_\u001e\f%o\u00195jm\u0016$\"A\u00144\t\u000b\u001d\u001c\u0007\u0019A*\u0002\u0013QLW.Z:uC6\u0004\b")
public class FrameworkService
implements FrameworkServiceMBean {
    private final BundleContext bundleContext;
    private final ContainerContext ctContext;
    private final Logger log;
    private final AtomicBoolean restarting;

    @Override
    public void restartContainer(String reason, boolean saveLogs) {
        Config cfg = this.ctContext.getContainerConfig();
        String saveLogsPath = "blended.saveLogsOnRestart";
        try {
            Bundle frameworkBundle = this.bundleContext.getBundle(0L);
            boolean alreadyRestarting = this.restarting.getAndSet(true);
            if (!alreadyRestarting) {
                boolean saveLogsConfigured;
                String now = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n             |---------------------------------------------------------------------------------------------------------\n             | Container restart initiated : ").append(now).append("\n             | Reason                      : ").append(reason).append("\n             |---------------------------------------------------------------------------------------------------------\n        ").toString())).stripMargin();
                this.log.warn((Function0 & Serializable & scala.Serializable)() -> msg);
                boolean bl = saveLogsConfigured = cfg.hasPath(saveLogsPath) && cfg.getBoolean(saveLogsPath);
                if (saveLogs & saveLogsConfigured) {
                    this.createLogArchive(now);
                }
                frameworkBundle.update();
            } else {
                this.log.warn((Function0 & Serializable & scala.Serializable)() -> "Ignoring container restart command because framework is already restarting.");
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log.error(e, (Function0 & Serializable & scala.Serializable)() -> "Could not restart container");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void createLogArchive(String timestamp) {
        String archiveName = new StringBuilder(12).append("restart-").append(timestamp).append(".zip").toString();
        File logDir = new File(this.ctContext.getContainerLogDirectory());
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(38).append("Creating log archive from directory [").append(logDir.getAbsolutePath()).append("]").toString());
        List logFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.list(new FilenameFilter(null){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isFile() && !name.startsWith("restart");
            }
        }))).toList();
        this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Files :[").append(logFiles).append("]").toString());
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(logDir, archiveName)));
            logFiles.foreach((Function1 & Serializable & scala.Serializable)logFile -> {
                FrameworkService.$anonfun$createLogArchive$3(logDir, out, logFile);
                return BoxedUnit.UNIT;
            });
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.log.error((Throwable)e, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Error creating log archive (").append(e.getMessage()).append(")").toString());
        }
    }

    public static final /* synthetic */ void $anonfun$createLogArchive$3(File logDir$1, ZipOutputStream out$1, String logFile) {
        out$1.putNextEntry(new ZipEntry(logFile));
        FileInputStream in = new FileInputStream(new File(logDir$1, logFile));
        StreamCopySupport.copyStream((InputStream)in, (OutputStream)out$1);
        in.close();
        out$1.closeEntry();
    }

    public FrameworkService(BundleContext bundleContext, ContainerContext ctContext) {
        this.bundleContext = bundleContext;
        this.ctContext = ctContext;
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(FrameworkService.class));
        this.restarting = new AtomicBoolean(false);
    }
}

