/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.base.internal;

import blended.container.context.api.ContainerContext;
import blended.mgmt.base.internal.FrameworkServiceMBean;
import blended.util.StreamCopySupport;
import com.typesafe.config.Config;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u001d4A!\u0001\u0002\u0001\u0017\t\u0001bI]1nK^|'o[*feZL7-\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tAAY1tK*\u0011q\u0001C\u0001\u0005[\u001elGOC\u0001\n\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005U1%/Y7fo>\u00148nU3sm&\u001cW-\u0014\"fC:D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u000eEVtG\r\\3D_:$X\r\u001f;\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00034sC6,wo\u001c:l\u0015\tib$\u0001\u0003pg\u001eL'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"5\ti!)\u001e8eY\u0016\u001cuN\u001c;fqRD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\nGR\u001cuN\u001c;fqR\u0004\"!\n\u0017\u000e\u0003\u0019R!a\n\u0015\u0002\u0007\u0005\u0004\u0018N\u0003\u0002*U\u000591m\u001c8uKb$(BA\u0016\t\u0003%\u0019wN\u001c;bS:,'/\u0003\u0002.M\t\u00012i\u001c8uC&tWM]\"p]R,\u0007\u0010\u001e\u0005\u0006_\u0001!\t\u0001M\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007E\u00124\u0007\u0005\u0002\u0014\u0001!)qC\fa\u00011!)1E\fa\u0001I!1Q\u0007\u0001Q\u0001\nY\n1\u0001\\8h!\t9$(D\u00019\u0015\tId$A\u0003tY\u001a$$.\u0003\u0002<q\t1Aj\\4hKJDa!\u0010\u0001!\u0002\u0013q\u0014A\u0003:fgR\f'\u000f^5oOB\u0011q\bS\u0007\u0002\u0001*\u0011\u0011IQ\u0001\u0007CR|W.[2\u000b\u0005\r#\u0015AC2p]\u000e,(O]3oi*\u0011QIR\u0001\u0005kRLGNC\u0001H\u0003\u0011Q\u0017M^1\n\u0005%\u0003%!D!u_6L7MQ8pY\u0016\fg\u000eC\u0003L\u0001\u0011\u0005C*\u0001\tsKN$\u0018M\u001d;D_:$\u0018-\u001b8feR\u0019Q\nU/\u0011\u00055q\u0015BA(\u000f\u0005\u0011)f.\u001b;\t\u000bES\u0005\u0019\u0001*\u0002\rI,\u0017m]8o!\t\u0019&L\u0004\u0002U1B\u0011QKD\u0007\u0002-*\u0011qKC\u0001\u0007yI|w\u000e\u001e \n\u0005es\u0011A\u0002)sK\u0012,g-\u0003\u0002\\9\n11\u000b\u001e:j]\u001eT!!\u0017\b\t\u000byS\u0005\u0019A0\u0002\u0011M\fg/\u001a'pON\u0004\"!\u00041\n\u0005\u0005t!a\u0002\"p_2,\u0017M\u001c\u0005\u0007G\u0002\u0001K\u0011\u00023\u0002!\r\u0014X-\u0019;f\u0019><\u0017I]2iSZ,GCA'f\u0011\u00151'\r1\u0001S\u0003%!\u0018.\\3ti\u0006l\u0007\u000f")
public class FrameworkService
implements FrameworkServiceMBean {
    private final BundleContext bundleContext;
    private final ContainerContext ctContext;
    private final Logger log;
    private final AtomicBoolean restarting;

    @Override
    public void restartContainer(String reason, boolean saveLogs) {
        Config cfg = this.ctContext.getContainerConfig();
        String saveLogsPath = "blended.saveLogsOnRestart";
        try {
            Bundle frameworkBundle = this.bundleContext.getBundle(0L);
            boolean alreadyRestarting = this.restarting.getAndSet(true);
            if (!alreadyRestarting) {
                boolean saveLogsConfigured;
                String now = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                String msg = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(341).append("\n             |---------------------------------------------------------------------------------------------------------\n             | Container restart initiated : ").append(now).append("\n             | Reason                      : ").append(reason).append("\n             |---------------------------------------------------------------------------------------------------------\n        ").toString())).stripMargin();
                this.log.warn(msg);
                boolean bl = saveLogsConfigured = cfg.hasPath(saveLogsPath) && cfg.getBoolean(saveLogsPath);
                if (saveLogs & saveLogsConfigured) {
                    this.createLogArchive(now);
                }
                frameworkBundle.update();
            } else {
                this.log.warn("Ignoring container restart command because framework is already restarting.");
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                this.log.error("Could not restart container", e);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private void createLogArchive(String timestamp) {
        String archiveName = new StringBuilder(12).append("restart-").append(timestamp).append(".zip").toString();
        File logDir = new File(this.ctContext.getContainerLogDirectory());
        this.log.info(new StringBuilder(38).append("Creating log archive from directory [").append(logDir.getAbsolutePath()).append("]").toString());
        List logFiles = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])logDir.list(new FilenameFilter(null){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isFile() && !name.startsWith("restart");
            }
        }))).toList();
        this.log.info(new StringBuilder(9).append("Files :[").append(logFiles).append("]").toString());
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(logDir, archiveName)));
            logFiles.foreach((Function1 & Serializable & scala.Serializable)logFile -> {
                FrameworkService.$anonfun$createLogArchive$1(logDir, out, logFile);
                return BoxedUnit.UNIT;
            });
            out.flush();
            out.close();
        }
        catch (Exception e) {
            this.log.error(new StringBuilder(29).append("Error creating log archive (").append(e.getMessage()).append(")").toString(), (Throwable)e);
        }
    }

    public static final /* synthetic */ void $anonfun$createLogArchive$1(File logDir$1, ZipOutputStream out$1, String logFile) {
        out$1.putNextEntry(new ZipEntry(logFile));
        FileInputStream in = new FileInputStream(new File(logDir$1, logFile));
        StreamCopySupport.copyStream((InputStream)in, (OutputStream)out$1);
        in.close();
        out$1.closeEntry();
    }

    public FrameworkService(BundleContext bundleContext, ContainerContext ctContext) {
        this.bundleContext = bundleContext;
        this.ctContext = ctContext;
        this.log = LoggerFactory.getLogger(FrameworkService.class);
        this.restarting = new AtomicBoolean(false);
    }
}

