/*
 * Decompiled with CFR 0.152.
 */
package blended.mgmt.base.internal;

import blended.container.context.ContainerContext;
import blended.mgmt.base.internal.FrameworkServiceMBean;
import blended.util.StreamCopySupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00054A!\u0001\u0002\u0001\u0017\t\u0001bI]1nK^|'o[*feZL7-\u001a\u0006\u0003\u0007\u0011\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003\u000b\u0019\tAAY1tK*\u0011q\u0001C\u0001\u0005[\u001elGOC\u0001\n\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001aE\u0002\u0001\u0019I\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005U1%/Y7fo>\u00148nU3sm&\u001cW-\u0014\"fC:D\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u000eEVtG\r\\3D_:$X\r\u001f;\u0011\u0005e\u0001S\"\u0001\u000e\u000b\u0005ma\u0012!\u00034sC6,wo\u001c:l\u0015\tib$\u0001\u0003pg\u001eL'\"A\u0010\u0002\u0007=\u0014x-\u0003\u0002\"5\ti!)\u001e8eY\u0016\u001cuN\u001c;fqRD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\nGR\u001cuN\u001c;fqR\u0004\"!\n\u0016\u000e\u0003\u0019R!a\n\u0015\u0002\u000f\r|g\u000e^3yi*\u0011\u0011\u0006C\u0001\nG>tG/Y5oKJL!a\u000b\u0014\u0003!\r{g\u000e^1j]\u0016\u00148i\u001c8uKb$\b\"B\u0017\u0001\t\u0003q\u0013A\u0002\u001fj]&$h\bF\u00020aE\u0002\"a\u0005\u0001\t\u000b]a\u0003\u0019\u0001\r\t\u000b\rb\u0003\u0019\u0001\u0013\t\rM\u0002\u0001\u0015!\u00035\u0003\rawn\u001a\t\u0003kaj\u0011A\u000e\u0006\u0003oy\tQa\u001d7gi)L!!\u000f\u001c\u0003\r1{wmZ3s\u0011\u0019Y\u0004\u0001)A\u0005y\u0005Q!/Z:uCJ$\u0018N\\4\u0011\u0005u2U\"\u0001 \u000b\u0005}\u0002\u0015AB1u_6L7M\u0003\u0002B\u0005\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005\r#\u0015\u0001B;uS2T\u0011!R\u0001\u0005U\u00064\u0018-\u0003\u0002H}\ti\u0011\t^8nS\u000e\u0014un\u001c7fC:DQ!\u0013\u0001\u0005B)\u000b\u0001C]3ti\u0006\u0014HoQ8oi\u0006Lg.\u001a:\u0015\u0007-su\u000b\u0005\u0002\u000e\u0019&\u0011QJ\u0004\u0002\u0005+:LG\u000fC\u0003P\u0011\u0002\u0007\u0001+\u0001\u0004sK\u0006\u001cxN\u001c\t\u0003#Rs!!\u0004*\n\u0005Ms\u0011A\u0002)sK\u0012,g-\u0003\u0002V-\n11\u000b\u001e:j]\u001eT!a\u0015\b\t\u000baC\u0005\u0019A-\u0002\u0011M\fg/\u001a'pON\u0004\"!\u0004.\n\u0005ms!a\u0002\"p_2,\u0017M\u001c\u0005\u0007;\u0002\u0001K\u0011\u00020\u0002!\r\u0014X-\u0019;f\u0019><\u0017I]2iSZ,GCA&`\u0011\u0015\u0001G\f1\u0001Q\u0003%!\u0018.\\3ti\u0006l\u0007\u000f")
public class FrameworkService
implements FrameworkServiceMBean {
    private final BundleContext bundleContext;
    private final ContainerContext ctContext;
    private final Logger log;
    private final AtomicBoolean restarting;

    @Override
    public void restartContainer(String reason, boolean saveLogs) {
        try {
            Bundle frameworkBundle = this.bundleContext.getBundle(0L);
            boolean alreadyRestarting = this.restarting.getAndSet(true);
            if (alreadyRestarting) {
                this.log.warn("Ignoring container restart command because framework is already restarting.");
            } else {
                String now = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
                String msg = new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\n             |---------------------------------------------------------------------------------------------------------\n             | Container restart initiated : ", "\n             | Reason                      : ", "\n             |---------------------------------------------------------------------------------------------------------\n        "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{now, reason})))).stripMargin();
                this.log.warn(msg);
                if (saveLogs) {
                    this.createLogArchive(now);
                }
                frameworkBundle.update();
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.log.error("Could not restart container", e);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void createLogArchive(String timestamp) {
        String archiveName = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"restart-", ".zip"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timestamp}));
        File logDir = new File(this.ctContext.getContainerLogDirectory());
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Creating log archive from directory [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logDir.getAbsolutePath()})));
        List logFiles = Predef$.MODULE$.refArrayOps((Object[])logDir.list(new FilenameFilter(this){

            public boolean accept(File dir, String name) {
                File f = new File(dir, name);
                return f.isFile() && !name.startsWith("restart");
            }
        })).toList();
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Files :[", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{logFiles})));
        try {
            ZipOutputStream out = new ZipOutputStream(new FileOutputStream(new File(logDir, archiveName)));
            logFiles.foreach((Function1)new Serializable(this, logDir, out){
                public static final long serialVersionUID = 0L;
                private final File logDir$1;
                private final ZipOutputStream out$1;

                public final void apply(String logFile) {
                    this.out$1.putNextEntry(new ZipEntry(logFile));
                    FileInputStream in = new FileInputStream(new File(this.logDir$1, logFile));
                    StreamCopySupport.copyStream((InputStream)in, (OutputStream)this.out$1);
                    in.close();
                    this.out$1.closeEntry();
                }
                {
                    this.logDir$1 = logDir$1;
                    this.out$1 = out$1;
                }
            });
            out.flush();
            out.close();
        }
        catch (Exception exception) {
            this.log.error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error creating log archive (", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{exception.getMessage()})), (Throwable)exception);
        }
    }

    public FrameworkService(BundleContext bundleContext, ContainerContext ctContext) {
        this.bundleContext = bundleContext;
        this.ctContext = ctContext;
        this.log = LoggerFactory.getLogger(FrameworkService.class);
        this.restarting = new AtomicBoolean(false);
    }
}

