/*
 * Decompiled with CFR 0.152.
 */
package blended.launcher.jvmrunner;

import blended.util.io.StreamCopy$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001da!B\t\u0013\u0001IA\u0002\u0002C\u0010\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\t\u0011%\u0002!\u0011!Q\u0001\n)B\u0001\"\f\u0001\u0003\u0002\u0003\u0006IA\u000b\u0005\t]\u0001\u0011\t\u0011)A\u0005_!)q\u0007\u0001C\u0001q!1q\b\u0001Q\u0001\n\u0001CaA\u0012\u0001!\u0002\u00139\u0005B\u0002&\u0001A\u0003%1\n\u0003\u0004T\u0001\u0001\u0006Ia\f\u0005\u0007)\u0002\u0001\u000b\u0011B+\t\u000ba\u0003A\u0011A-\t\u000bu\u0003A\u0011\u00020\t\u000b\u0005\u0004A\u0011A-\t\u000b\t\u0004A\u0011B2\t\u000bM\u0004A\u0011\u0002;\t\u000bi\u0004A\u0011B>\u0003\u001dI+hN\\5oOB\u0013xnY3tg*\u00111\u0003F\u0001\nUZl'/\u001e8oKJT!!\u0006\f\u0002\u00111\fWO\\2iKJT\u0011aF\u0001\bE2,g\u000eZ3e'\t\u0001\u0011\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VMZ\u0001\baJ|7-Z:t\u0007\u0001\u0001\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\t1\fgn\u001a\u0006\u0002M\u0005!!.\u0019<b\u0013\tA3EA\u0004Qe>\u001cWm]:\u0002!\u0015\u0014(o\u001c:t\u0013:$xnT;uaV$\bC\u0001\u000e,\u0013\ta3DA\u0004C_>dW-\u00198\u0002\u0017%tG/\u001a:bGRLg/Z\u0001\u0010g\",H\u000fZ8x]RKW.Z8viB\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\tIV\u0014\u0018\r^5p]*\u0011AgG\u0001\u000bG>t7-\u001e:sK:$\u0018B\u0001\u001c2\u000591\u0015N\\5uK\u0012+(/\u0019;j_:\fa\u0001P5oSRtD#B\u001d<yur\u0004C\u0001\u001e\u0001\u001b\u0005\u0011\u0002\"B\u0010\u0006\u0001\u0004\t\u0003\"B\u0015\u0006\u0001\u0004Q\u0003\"B\u0017\u0006\u0001\u0004Q\u0003\"\u0002\u0018\u0006\u0001\u0004y\u0013AA5o!\t\tE)D\u0001C\u0015\t\u0019U%\u0001\u0002j_&\u0011QI\u0011\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.A\u0002pkR\u0004\"!\u0011%\n\u0005%\u0013%\u0001D(viB,Ho\u0015;sK\u0006l\u0017a\u00017pOB\u0011A*U\u0007\u0002\u001b*\u0011ajT\u0001\bY><w-\u001b8h\u0015\t\u0001f#\u0001\u0003vi&d\u0017B\u0001*N\u0005\u0019aunZ4fe\u0006i1\u000f\\3fa&sG/\u001a:wC2\f\u0011b\\;u)\"\u0014X-\u00193\u0011\u0005\t2\u0016BA,$\u0005\u0019!\u0006N]3bI\u00069q/Y5u\r>\u0014H#\u0001.\u0011\u0005iY\u0016B\u0001/\u001c\u0005\rIe\u000e^\u0001\u0011o\u0006LG/\u00168uS2\u001cFo\u001c9qK\u0012$\"AK0\t\u000b\u0001d\u0001\u0019A\u0018\u0002\u0003Q\fAa\u001d;pa\u0006aq.\u001e;qkR$\u0006N]3bIR\u0019Q\u000bZ9\t\u000b\u0015t\u0001\u0019\u00014\u0002\t9\fW.\u001a\t\u0003O:t!\u0001\u001b7\u0011\u0005%\\R\"\u00016\u000b\u0005-\u0004\u0013A\u0002\u001fs_>$h(\u0003\u0002n7\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti7\u0004C\u0003s\u001d\u0001\u0007\u0001)\u0001\u0002jg\u0006y\u0011m]=oG\u000e{\u0007/\u001f+ie\u0016\fG\rF\u0003VkZ<\u0018\u0010C\u0003@\u001f\u0001\u0007\u0001\tC\u0003G\u001f\u0001\u0007q\tC\u0003y\u001f\u0001\u0007!&A\u0006j[6,G-[1uK2L\b\"B*\u0010\u0001\u0004y\u0013\u0001B2paf$\u0002\u0002`@\u0002\u0002\u0005\r\u0011Q\u0001\t\u00035uL!A`\u000e\u0003\tUs\u0017\u000e\u001e\u0005\u0006\u007fA\u0001\r\u0001\u0011\u0005\u0006\rB\u0001\ra\u0012\u0005\u0006qB\u0001\rA\u000b\u0005\u0006'B\u0001\ra\f")
public class RunningProcess {
    private final Process process;
    private final boolean interactive;
    private final FiniteDuration shutdownTimeout;
    private final InputStream in;
    private final OutputStream out;
    private final Logger log;
    private final FiniteDuration sleepInterval;
    private final Thread outThread;

    public int waitFor() {
        int n;
        try {
            n = this.process.waitFor();
        }
        catch (Throwable throwable) {
            try {
                this.process.getOutputStream().close();
            }
            catch (Throwable throwable2) {}
            this.outThread.interrupt();
            try {
                this.process.getErrorStream().close();
            }
            catch (Throwable throwable3) {}
            try {
                this.process.getInputStream().close();
            }
            catch (Throwable throwable4) {}
            throw throwable;
        }
        int n2 = n;
        try {
            this.process.getOutputStream().close();
        }
        catch (Throwable throwable) {}
        this.outThread.interrupt();
        try {
            this.process.getErrorStream().close();
        }
        catch (Throwable throwable) {}
        try {
            this.process.getInputStream().close();
        }
        catch (Throwable throwable) {}
        return n2;
    }

    private boolean waitUntilStopped(FiniteDuration t) {
        long now = System.currentTimeMillis();
        long end = now + t.toMillis();
        while (this.process.isAlive() && System.currentTimeMillis() <= end) {
            Thread.sleep(this.sleepInterval.toMillis());
        }
        return this.process.isAlive();
    }

    public int stop() {
        this.log.info((Function0 & Serializable)() -> "Stopping container JVM ...");
        if (this.interactive) {
            this.outThread.interrupt();
        } else {
            this.out.write("stop 0\n".getBytes());
        }
        if (this.waitUntilStopped(this.shutdownTimeout)) {
            this.log.info((Function0 & Serializable)() -> new StringBuilder(58).append("Killing container JVM after maximum shutdown timeout of [").append($this.shutdownTimeout).append("]").toString());
            this.process.destroy();
        }
        this.out.flush();
        this.out.close();
        return this.waitFor();
    }

    private Thread outputThread(String name, InputStream is) {
        return new Thread(null, name, is){
            private final InputStream is$1;
            private final String name$1;

            public void run() {
                try (BufferedReader rd = new BufferedReader(new InputStreamReader(this.is$1, "UTF-8"));){
                    ObjectRef line = ObjectRef.create((Object)rd.readLine());
                    while ((String)line.elem != null) {
                        Logger$.MODULE$.apply(new StringBuilder(27).append("blended.launcher.jvmrunner.").append(this.name$1).toString()).debug((Function0 & Serializable)() -> (String)line$1.elem);
                        line.elem = rd.readLine();
                    }
                }
            }
            {
                this.is$1 = is$1;
                this.name$1 = name$1;
                super(name$1);
                this.setDaemon(true);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$run$1(scala.runtime.ObjectRef )}, serializedLambda);
            }
        };
    }

    private Thread asyncCopyThread(InputStream in, OutputStream out, boolean immediately, FiniteDuration sleepInterval) {
        return new Thread(this, in, out, immediately, sleepInterval){
            private final /* synthetic */ RunningProcess $outer;
            private final InputStream in$1;
            private final OutputStream out$1;
            private final boolean immediately$1;
            private final FiniteDuration sleepInterval$1;

            public void run() {
                try {
                    this.$outer.blended$launcher$jvmrunner$RunningProcess$$copy(this.in$1, this.out$1, this.immediately$1, this.sleepInterval$1);
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.out$1.flush();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.in$1 = in$1;
                this.out$1 = out$1;
                this.immediately$1 = immediately$1;
                this.sleepInterval$1 = sleepInterval$1;
                super("StreamCopyThread");
                this.setDaemon(true);
            }
        };
    }

    public void blended$launcher$jvmrunner$RunningProcess$$copy(InputStream in, OutputStream out, boolean immediately, FiniteDuration sleepInterval) {
        if (immediately) {
            while (true) {
                if (in.available() > 0) {
                    int n = in.read();
                    switch (n) {
                        case -1: {
                            break;
                        }
                        default: {
                            out.write(n);
                            out.flush();
                            break;
                        }
                    }
                    continue;
                }
                Thread.sleep(sleepInterval.toMillis());
            }
        }
        StreamCopy$.MODULE$.copy(in, out);
    }

    public RunningProcess(Process process, boolean errorsIntoOutput, boolean interactive, FiniteDuration shutdownTimeout) {
        this.process = process;
        this.interactive = interactive;
        this.shutdownTimeout = shutdownTimeout;
        this.in = System.in;
        this.out = process.getOutputStream();
        this.log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(RunningProcess.class));
        this.sleepInterval = new package.DurationInt(package$.MODULE$.DurationInt(50)).millis();
        this.outThread = this.asyncCopyThread(this.in, this.out, true, this.sleepInterval);
        if (interactive) {
            this.log.info((Function0 & Serializable)() -> "Starting console read thread ...");
            this.outThread.start();
        } else {
            this.log.info((Function0 & Serializable)() -> "Container is started without console read thread ...");
        }
        this.outputThread("stdErr", process.getErrorStream()).start();
        this.outputThread("stdOut", process.getInputStream()).start();
    }
}

