/*
 * Decompiled with CFR 0.152.
 */
package blended.launcher;

import blended.launcher.Cmdline;
import blended.launcher.Launcher;
import blended.launcher.Launcher$Configs$;
import blended.launcher.LauncherException;
import blended.launcher.LauncherException$;
import blended.launcher.config.LauncherConfig;
import blended.launcher.config.LauncherConfig$;
import blended.updater.config.ConfigConverter$;
import blended.updater.config.LocalProfile;
import blended.updater.config.Profile;
import blended.updater.config.ProfileCompanion$;
import blended.updater.config.ProfileLookup;
import blended.updater.config.ProfileLookup$;
import blended.updater.config.ResolvedProfile;
import blended.updater.config.SystemPropertyResolver$;
import blended.util.arm.ARM$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.CmdlineParserException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Seq$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Launcher$ {
    public static final Launcher$ MODULE$;
    private static Logger blended$launcher$Launcher$$log;
    private static String blendedHomeDir;
    private static String containerConfigDirectory;
    private static final String containerIdFile;
    private static final String extraStartBundle;
    private static final List<String> extraStartBundles;
    private static volatile byte bitmap$0;

    static {
        List list;
        MODULE$ = new Launcher$();
        containerIdFile = "blended.container.context.id";
        extraStartBundle = "blended.laucher.startbundles";
        Option option = Option$.MODULE$.apply((Object)System.getProperty(MODULE$.extraStartBundle()));
        if (None$.MODULE$.equals(option)) {
            list = List$.MODULE$.empty();
        } else if (option instanceof Some) {
            Some some = (Some)option;
            String s = (String)some.value();
            list = Predef$.MODULE$.wrapRefArray((Object[])s.split(",")).toList();
        } else {
            throw new MatchError((Object)option);
        }
        extraStartBundles = list;
    }

    private Logger log$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                blended$launcher$Launcher$$log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Launcher$.class));
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return blended$launcher$Launcher$$log;
    }

    public Logger blended$launcher$Launcher$$log() {
        return (byte)(bitmap$0 & 1) == 0 ? this.log$lzycompute() : blended$launcher$Launcher$$log;
    }

    private String blendedHomeDir$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                blendedHomeDir = (String)Option$.MODULE$.apply((Object)System.getProperty("blended.home")).getOrElse((Function0 & Serializable)() -> ".");
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return blendedHomeDir;
    }

    private String blendedHomeDir() {
        return (byte)(bitmap$0 & 2) == 0 ? this.blendedHomeDir$lzycompute() : blendedHomeDir;
    }

    private String containerConfigDirectory$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(bitmap$0 & 4) == 0) {
                containerConfigDirectory = new StringBuilder(4).append(this.blendedHomeDir()).append("/etc").toString();
                bitmap$0 = (byte)(bitmap$0 | 4);
            }
        }
        return containerConfigDirectory;
    }

    private String containerConfigDirectory() {
        return (byte)(bitmap$0 & 4) == 0 ? this.containerConfigDirectory$lzycompute() : containerConfigDirectory;
    }

    private String containerIdFile() {
        return containerIdFile;
    }

    private String extraStartBundle() {
        return extraStartBundle;
    }

    public List<String> extraStartBundles() {
        return extraStartBundles;
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (LauncherException t) {
            this.blended$launcher$Launcher$$log().debug((Throwable)t, this.blended$launcher$Launcher$$log().debug$default$2(), (Function0 & Serializable)() -> new StringBuilder(67).append("Caught a LauncherException. Exiting with error code: ").append(t.errorCode()).append(" and message: ").append(t.getMessage()).toString());
            if (!t.getMessage().isEmpty()) {
                Console$.MODULE$.err().println(String.valueOf(t.getMessage()));
            }
            throw package$.MODULE$.exit(t.errorCode());
        }
        catch (Throwable t) {
            this.blended$launcher$Launcher$$log().error(t, this.blended$launcher$Launcher$$log().error$default$2(), (Function0 & Serializable)() -> "Caught an exception. Exiting with error code: 1");
            Console$.MODULE$.err().println(new StringBuilder(7).append("Error: ").append(t.getMessage()).toString());
            throw package$.MODULE$.exit(1);
        }
        throw package$.MODULE$.exit(0);
    }

    private void reportError(String msg) {
        this.blended$launcher$Launcher$$log().error((Function0 & Serializable)() -> msg);
        Console$.MODULE$.err().println(msg);
        throw package$.MODULE$.error(msg);
    }

    private Try<Cmdline> parseArgs(String[] args) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            void var1_1;
            Cmdline cmdline = new Cmdline();
            CmdlineParser cp = new CmdlineParser(new Object[]{cmdline});
            try {
                cp.parse(args);
            }
            catch (CmdlineParserException e) {
                MODULE$.reportError(new StringBuilder(30).append(e.getMessage()).append("\nRun launcher --help for help.").toString());
            }
            if (cmdline.help()) {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                PrintStream os = new PrintStream(bos);
                cp.usage(new PrintStream(os));
                throw new LauncherException(bos.toString(), (Option<Throwable>)None$.MODULE$, 0);
            }
            return var1_1;
        });
    }

    private Try<String> containerId(File f, boolean createContainerID, boolean onlyIfMissing) {
        Object object;
        boolean generateId;
        File idFile = new File(this.containerConfigDirectory(), this.containerIdFile());
        if (idFile.exists() && idFile.isDirectory()) {
            String msg = new StringBuilder(37).append("The file [").append(idFile.getAbsoluteFile()).append("] exists and is a directory").toString();
            this.blended$launcher$Launcher$$log().error((Function0 & Serializable)() -> msg);
            Console$.MODULE$.err().println(msg);
            throw package$.MODULE$.error(msg);
        }
        boolean bl = generateId = createContainerID && (!onlyIfMissing || !idFile.exists());
        if (generateId && idFile.exists() && !idFile.canWrite()) {
            this.reportError(new StringBuilder(36).append("Container Id File [").append(idFile.getAbsolutePath()).append("] is not writable").toString());
        }
        Object object2 = generateId && idFile.exists() ? BoxesRunTime.boxToBoolean((boolean)idFile.delete()) : BoxedUnit.UNIT;
        if (generateId) {
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> "Creating new container id");
            Predef.ArrayCharSequence uuid = Predef$.MODULE$.ArrayCharSequence(UUID.randomUUID().toString().toCharArray());
            object = Files.write(idFile.toPath(), (Iterable<? extends CharSequence>)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)Seq$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CharSequence[]{uuid}))).asJava(), new OpenOption[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            java.util.List<String> lines = Files.readAllLines(Paths.get(idFile.getAbsolutePath(), new String[0]));
            if (lines.isEmpty()) {
                throw package$.MODULE$.error("Empty container ID file");
            }
            return lines.get(0);
        });
    }

    private Launcher createAndPrepareLaunch(Launcher.Configs configs, boolean createContainerId, boolean onlyIfMissing) {
        scala.collection.immutable.Seq seq;
        Launcher launcher = new Launcher(configs.launcherConfig());
        Option<LocalProfile> option = configs.profileConfig();
        if (option instanceof Some) {
            Some some = (Some)option;
            LocalProfile localConfig = (LocalProfile)some.value();
            String propNames = (String)localConfig.resolvedProfile().profile().properties().getOrElse((Object)Profile.Properties$.MODULE$.PROFILE_PROPERTY_KEYS(), (Function0 & Serializable)() -> "");
            System.setProperty(Profile.Properties$.MODULE$.PROFILE_PROPERTY_KEYS(), propNames);
            seq = (scala.collection.immutable.Seq)localConfig.validate(false, true).get();
        } else if (None$.MODULE$.equals(option)) {
            seq = launcher.validate();
        } else {
            throw new MatchError(option);
        }
        scala.collection.immutable.Seq errors = seq;
        if (errors.nonEmpty()) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Could not start the OSGi Framework. Details:\n").append(errors.mkString("\n")).toString());
        }
        Try<String> try_ = this.containerId(new File(this.containerConfigDirectory(), this.containerIdFile()), createContainerId, onlyIfMissing);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            String msg = "Launcher is unable to determine the container id.";
            Option<LocalProfile> option2 = configs.profileConfig();
            if (option2 instanceof Some) {
                this.blended$launcher$Launcher$$log().error(e, this.blended$launcher$Launcher$$log().error$default$2(), (Function0 & Serializable)() -> msg);
                Console$.MODULE$.err().println(msg);
                throw package$.MODULE$.error(msg);
            }
            if (!None$.MODULE$.equals(option2)) {
                throw new MatchError(option2);
            }
            this.blended$launcher$Launcher$$log().warn(e, this.blended$launcher$Launcher$$log().warn$default$2(), (Function0 & Serializable)() -> msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String id = (String)success.value();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(18).append("ContainerId is [").append(id).append("] ").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
        return launcher;
    }

    public void run(String[] args) {
        Cmdline cmdline = (Cmdline)this.parseArgs(args).get();
        boolean handleFrameworkRestart = cmdline.handleFrameworkRestart();
        boolean firstStart = true;
        int retVal = 0;
        do {
            BoxedUnit boxedUnit;
            Launcher.Configs configs;
            try {
                configs = this.readConfigs(cmdline);
            }
            catch (Throwable e) {
                this.blended$launcher$Launcher$$log().error(e, this.blended$launcher$Launcher$$log().error$default$2(), (Function0 & Serializable)() -> "Could not read configs");
                throw e;
            }
            Launcher.Configs configs2 = configs;
            this.blended$launcher$Launcher$$log().debug((Function0 & Serializable)() -> new StringBuilder(9).append("Configs: ").append(configs2).toString());
            Option<File> option = cmdline.writeSystemProperties();
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                File propFile = (File)some.value();
                this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> "Running with --write-system-properties. About to generate properties file and exit");
                Properties fileProps = new Properties();
                configs2.launcherConfig().systemProperties().foreach((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = fileProps.setProperty(k, v);
                    return object;
                });
                try {
                    ARM$.MODULE$.using((AutoCloseable)new FileOutputStream(propFile), (Function1 & Serializable)stream -> {
                        Launcher$.$anonfun$run$5(fileProps, propFile, stream);
                        return BoxedUnit.UNIT;
                    });
                    retVal = 0;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    this.blended$launcher$Launcher$$log().error(e, this.blended$launcher$Launcher$$log().error$default$2(), (Function0 & Serializable)() -> new StringBuilder(40).append("Could not write system properties file: ").append(propFile).toString());
                    retVal = 1;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                boolean createContainerId = firstStart && (cmdline.resetContainerId() || cmdline.initContainerId());
                Launcher launcher = this.createAndPrepareLaunch(configs2, createContainerId, cmdline.initContainerId());
                retVal = launcher.run(cmdline);
                firstStart = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(option);
        } while (handleFrameworkRestart && retVal == 2);
        if (retVal != 0) {
            String x$1 = "";
            int x$2 = retVal;
            Option<Throwable> x$3 = LauncherException$.MODULE$.$lessinit$greater$default$2();
            throw new LauncherException("", x$3, x$2);
        }
    }

    public Launcher.Configs readConfigs(Cmdline cmdline) {
        Launcher.Configs configs;
        Option<String> option = cmdline.configFile();
        if (option instanceof Some) {
            Some some = (Some)option;
            String configFile = (String)some.value();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(28).append("About to read configFile: [").append(configFile).append("]").toString());
            Config config = ConfigFactory.parseFile((File)new File(configFile), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            configs = new Launcher.Configs(LauncherConfig$.MODULE$.read(config), Launcher$Configs$.MODULE$.apply$default$2());
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple2;
            String string;
            Option profileLookup = cmdline.profileLookup().map((Function1 & Serializable)pl2 -> {
                MODULE$.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(37).append("About to read profile lookup file: [").append((String)pl2).append("]").toString());
                Config c = ConfigFactory.parseFile((File)new File((String)pl2), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
                return (ProfileLookup)ProfileLookup$.MODULE$.read(c).map((Function1 & Serializable)pl -> {
                    File x$1 = pl.profileBaseDir().getAbsoluteFile();
                    String x$2 = pl.copy$default$1();
                    String x$3 = pl.copy$default$2();
                    return pl.copy(x$2, x$3, x$1);
                }).get();
            });
            Option option2 = profileLookup;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                ProfileLookup pl3 = (ProfileLookup)some.value();
                string = pl3.materializedDir().getPath();
            } else if (None$.MODULE$.equals(option2)) {
                String profile;
                Option<String> option3 = cmdline.profileDir();
                if (!(option3 instanceof Some)) {
                    if (None$.MODULE$.equals(option3)) {
                        throw package$.MODULE$.error("Either a config file or a profile dir or file or a profile lookup path must be given");
                    }
                    throw new MatchError(option3);
                }
                Some some = (Some)option3;
                String string2 = profile = (String)some.value();
                string = string2;
            } else {
                throw new MatchError((Object)option2);
            }
            String profile = string;
            Tuple2 tuple22 = tuple2 = new File(profile).isDirectory() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile), (Object)new File(profile, "profile.conf")) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)new File(profile).getParent()).getOrElse((Function0 & Serializable)() -> ".")), (Object)new File(profile));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String profileDir = (String)tuple2._1();
            File profileFile = (File)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)profileDir, (Object)profileFile);
            Tuple2 tuple24 = tuple23;
            String profileDir2 = (String)tuple24._1();
            File profileFile2 = (File)tuple24._2();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(28).append("Using profile directory : [").append(profileDir2).append("]").toString());
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(28).append("Using profile file      : [").append(profileFile2.getAbsolutePath()).append("]").toString());
            Config config = ConfigFactory.parseFile((File)profileFile2, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            File featureDir = new File(profileDir2, "features");
            Object object = !featureDir.exists() ? BoxesRunTime.boxToBoolean((boolean)featureDir.mkdirs()) : BoxedUnit.UNIT;
            ResolvedProfile runtimeConfig = new ResolvedProfile((Profile)ProfileCompanion$.MODULE$.read(config).get());
            LauncherConfig launchConfig = (LauncherConfig)ConfigConverter$.MODULE$.runtimeConfigToLauncherConfig(runtimeConfig, profileDir2).get();
            ObjectRef brandingProps = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Profile.Properties$.MODULE$.PROFILE_DIR()), (Object)profileDir2)}))));
            profileLookup.foreach((Function1 & Serializable)pl -> {
                brandingProps.elem = (Map)((Map)brandingProps.elem).$plus$plus((IterableOnce)Map$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Profile.Properties$.MODULE$.PROFILE_LOOKUP_FILE()), (Object)new File((String)cmdline.profileLookup().get()).getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Profile.Properties$.MODULE$.PROFILES_BASE_DIR()), (Object)pl.profileBaseDir().getAbsolutePath())})));
                return BoxedUnit.UNIT;
            });
            Map x$4 = (Map)launchConfig.branding().$plus$plus((IterableOnce)((Map)brandingProps.elem));
            Map x$5 = SystemPropertyResolver$.MODULE$.resolve((Map)launchConfig.systemProperties().$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blended.container.home"), (Object)profileDir2)));
            String x$6 = launchConfig.copy$default$1();
            Map x$7 = launchConfig.copy$default$3();
            int x$8 = launchConfig.copy$default$4();
            int x$9 = launchConfig.copy$default$5();
            scala.collection.immutable.Seq x$10 = launchConfig.copy$default$6();
            configs = new Launcher.Configs(launchConfig.copy(x$6, x$5, x$7, x$8, x$9, x$10, x$4), (Option<LocalProfile>)new Some((Object)new LocalProfile(runtimeConfig, new File(profileDir2))));
        } else {
            throw new MatchError(option);
        }
        return configs;
    }

    public Launcher apply(File configFile) {
        return new Launcher(LauncherConfig$.MODULE$.read(configFile));
    }

    public static final /* synthetic */ void $anonfun$run$5(Properties fileProps$1, File propFile$1, FileOutputStream stream) {
        fileProps$1.store(stream, "Generated by Launcher");
        MODULE$.blended$launcher$Launcher$$log().info((Function0 & Serializable)() -> new StringBuilder(30).append("Wrote system properties file: ").append(propFile$1).toString());
    }

    private Launcher$() {
    }
}

