/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import blended.util.ResourceResolver;
import blended.util.StreamCopySupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;

public class FileHelper {
    public static void writeFile(File file, byte[] byArray) throws Exception {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        StreamCopySupport.copyStream(byteArrayInputStream, fileOutputStream);
        FileHelper.safeClose(byteArrayInputStream);
        FileHelper.safeClose(fileOutputStream);
    }

    public static byte[] readStream(InputStream inputStream) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        StreamCopySupport.copyStream(inputStream, byteArrayOutputStream);
        FileHelper.safeClose(inputStream);
        FileHelper.safeClose(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readFile(String string) throws Exception {
        InputStream inputStream = ResourceResolver.openFile(string);
        return FileHelper.readStream(inputStream);
    }

    public static boolean renameFile(File file, File file2) {
        if (!file.exists() || file2.exists()) {
            return false;
        }
        file.renameTo(file2);
        return file2.exists() && !file.exists();
    }

    private static void safeClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void safeClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

