/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns;

import akka.actor.ExtendedActorSystem;
import akka.annotation.InternalApi;
import akka.io.dns.DnsSettings$;
import akka.util.JavaDurationConverters$;
import akka.util.JavaDurationConverters$JavaDurationOps$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValueType;
import java.io.Serializable;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.package$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ScalaSignature;
import scala.runtime.Nothing$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\u0005}a!\u0002\n\u0014\u0005MI\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\t\u0011!\u0002!\u0011!Q\u0001\n%BQa\r\u0001\u0005\u0002QBq!\u000f\u0001C\u0002\u0013\u0005!\b\u0003\u0004P\u0001\u0001\u0006Ia\u000f\u0005\b!\u0002\u0011\r\u0011\"\u0001R\u0011\u0019Q\u0006\u0001)A\u0005%\")1\f\u0001C\u00019\u001e)qm\u0005E\u0001Q\u001a)!c\u0005E\u0001S\")1G\u0003C\u0001U\"91N\u0003b\u0001\n\u001ba\u0007BB8\u000bA\u00035Q\u000eC\u0004q\u0015\t\u0007I\u0011B9\t\riT\u0001\u0015!\u0003s\u0011\u0019Y(\u0002\"\u0001\u0018y\"A\u0011\u0011\u0003\u0006\u0005\u0002]\t\u0019BA\u0006E]N\u001cV\r\u001e;j]\u001e\u001c(B\u0001\u000b\u0016\u0003\r!gn\u001d\u0006\u0003-]\t!![8\u000b\u0003a\tA!Y6lCN\u0011\u0001A\u0007\t\u00037yi\u0011\u0001\b\u0006\u0002;\u0005)1oY1mC&\u0011q\u0004\b\u0002\u0007\u0003:L(+\u001a4\u0002\rML8\u000f^3n\u0007\u0001\u0001\"a\t\u0014\u000e\u0003\u0011R!!J\f\u0002\u000b\u0005\u001cGo\u001c:\n\u0005\u001d\"#aE#yi\u0016tG-\u001a3BGR|'oU=ti\u0016l\u0017!A2\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013AB2p]\u001aLwM\u0003\u0002/_\u0005AA/\u001f9fg\u00064WMC\u00011\u0003\r\u0019w.\\\u0005\u0003e-\u0012aaQ8oM&<\u0017A\u0002\u001fj]&$h\bF\u00026oa\u0002\"A\u000e\u0001\u000e\u0003MAQ\u0001I\u0002A\u0002\tBQ\u0001K\u0002A\u0002%\n1BT1nKN+'O^3sgV\t1\bE\u0002=\t\u001es!!\u0010\"\u000f\u0005y\nU\"A \u000b\u0005\u0001\u000b\u0013A\u0002\u001fs_>$h(C\u0001\u001e\u0013\t\u0019E$A\u0004qC\u000e\\\u0017mZ3\n\u0005\u00153%\u0001\u0002'jgRT!a\u0011\u000f\u0011\u0005!kU\"A%\u000b\u0005)[\u0015a\u00018fi*\tA*\u0001\u0003kCZ\f\u0017B\u0001(J\u0005EIe.\u001a;T_\u000e\\W\r^!eIJ,7o]\u0001\r\u001d\u0006lWmU3sm\u0016\u00148\u000fI\u0001\u000f%\u0016\u001cx\u000e\u001c<f)&lWm\\;u+\u0005\u0011\u0006CA*Y\u001b\u0005!&BA+W\u0003!!WO]1uS>t'BA,\u001d\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u00033R\u0013aBR5oSR,G)\u001e:bi&|g.A\bSKN|GN^3US6,w.\u001e;!\u0003\u001d2\u0017-\u001b7V]\u0006\u0014G.\u001a+p\t\u0016$XM]7j]\u0016$UMZ1vYRt\u0015-\\3tKJ4XM]:\u0016\u0003u\u0003\"a\u00070\n\u0005}c\"a\u0002(pi\"Lgn\u001a\u0015\u0003\u0001\u0005\u0004\"AY3\u000e\u0003\rT!\u0001Z\f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002gG\nY\u0011J\u001c;fe:\fG.\u00119j\u0003-!en]*fiRLgnZ:\u0011\u0005YR1C\u0001\u0006\u001b)\u0005A\u0017a\u0004#og\u001a\u000bG\u000e\u001c2bG.\u0004vN\u001d;\u0016\u00035|\u0011A\\\u000f\u0002k\u0005\u0001BI\\:GC2d'-Y2l!>\u0014H\u000fI\u0001\u0012S:,GoU8dW\u0016$\u0018\t\u001a3sKN\u001cX#\u0001:\u0011\u0005MDX\"\u0001;\u000b\u0005U4\u0018\u0001C7bi\u000eD\u0017N\\4\u000b\u0005]d\u0012\u0001B;uS2L!!\u001f;\u0003\u000bI+w-\u001a=\u0002%%tW\r^*pG.,G/\u00113ee\u0016\u001c8\u000fI\u0001\u0017a\u0006\u00148/\u001a(b[\u0016\u001cXM\u001d<fe\u0006#GM]3tgR\u0011q) \u0005\u0006}B\u0001\ra`\u0001\u0004gR\u0014\b\u0003BA\u0001\u0003\u0013qA!a\u0001\u0002\u0006A\u0011a\bH\u0005\u0004\u0003\u000fa\u0012A\u0002)sK\u0012,g-\u0003\u0003\u0002\f\u00055!AB*ue&twMC\u0002\u0002\bqA#\u0001E1\u0002+\u001d,G\u000fR3gCVdGOT1nKN+'O^3sgR!\u0011QCA\u000f!\u0015\t9\"!\u0007<\u001b\u00051\u0018bAA\u000em\n\u0019AK]=\t\u000b\u0001\n\u0002\u0019\u0001\u0012")
public final class DnsSettings {
    private final List<InetSocketAddress> NameServers;
    private final FiniteDuration ResolveTimeout;

    public List<InetSocketAddress> NameServers() {
        return this.NameServers;
    }

    public FiniteDuration ResolveTimeout() {
        return this.ResolveTimeout;
    }

    public Nothing$ failUnableToDetermineDefaultNameservers() {
        throw new IllegalStateException("Unable to obtain default nameservers from JNDI or via reflection. Please set `akka.io.dns.async-dns.nameservers` explicitly in order to be able to resolve domain names. ");
    }

    public DnsSettings(ExtendedActorSystem system, Config c) {
        List list;
        ConfigValueType configValueType = c.getValue("nameservers").valueType();
        if (ConfigValueType.STRING.equals(configValueType)) {
            List list2;
            String string = c.getString("nameservers");
            if ("default".equals(string)) {
                List osAddresses = (List)DnsSettings$.MODULE$.getDefaultNameServers(system).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.failUnableToDetermineDefaultNameservers());
                if (osAddresses.isEmpty()) {
                    throw this.failUnableToDetermineDefaultNameservers();
                }
                list2 = osAddresses;
            } else {
                InetSocketAddress inetSocketAddress = DnsSettings$.MODULE$.parseNameserverAddress(string);
                list2 = Nil$.MODULE$.$colon$colon((Object)inetSocketAddress);
            }
            list = list2;
        } else if (ConfigValueType.LIST.equals(configValueType)) {
            IndexedSeq userAddresses = (IndexedSeq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(c.getStringList("nameservers")).asScala()).map((Function1 & Serializable & scala.Serializable)str -> DnsSettings$.MODULE$.parseNameserverAddress((String)str), package$.MODULE$.breakOut(Predef$.MODULE$.fallbackStringCanBuildFrom()));
            Predef$.MODULE$.require(userAddresses.nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> "nameservers can not be empty");
            list = userAddresses.toList();
        } else {
            throw new IllegalArgumentException("Invalid type for nameservers. Must be a string or string list");
        }
        this.NameServers = list;
        this.ResolveTimeout = JavaDurationConverters$JavaDurationOps$.MODULE$.asScala$extension(JavaDurationConverters$.MODULE$.JavaDurationOps(c.getDuration("resolve-timeout")));
    }
}

