/*
 * Decompiled with CFR 0.152.
 */
package blended.util;

import blended.util.ResourceResolver;
import java.io.InputStream;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class XMLSupport {
    private final String location;
    private final ClassLoader loader;
    private Document document = null;
    private static final XPathFactory XPATH_FACTORY = XPathFactory.newInstance();
    private static final DocumentBuilderFactory DOC_BUILDER_FACTORY = DocumentBuilderFactory.newInstance();

    public XMLSupport(String string) {
        this(string, XMLSupport.class.getClassLoader());
    }

    public XMLSupport(String string, ClassLoader classLoader) {
        this.loader = classLoader;
        this.location = string;
    }

    public Document getDocument() throws Exception {
        if (this.document == null) {
            DocumentBuilder documentBuilder = DOC_BUILDER_FACTORY.newDocumentBuilder();
            InputStream inputStream = ResourceResolver.openFile(this.location, this.loader);
            if (inputStream == null) {
                throw new Exception("Location [" + this.location + "] couldn't be resolved.");
            }
            this.document = documentBuilder.parse(new InputSource(inputStream));
            try {
                inputStream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.document;
    }

    public String applyXPath(String string) throws Exception {
        final Element element = this.getDocument().getDocumentElement();
        try {
            XPath xPath = XPATH_FACTORY.newXPath();
            if (element.getNamespaceURI() != null) {
                xPath.setNamespaceContext(new NamespaceContext(){

                    @Override
                    public String getNamespaceURI(String string) {
                        return element.getNamespaceURI();
                    }

                    @Override
                    public String getPrefix(String string) {
                        throw new UnsupportedOperationException();
                    }

                    public Iterator getPrefixes(String string) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            XPathExpression xPathExpression = xPath.compile(string);
            return xPathExpression.evaluate(element);
        }
        catch (Exception exception) {
            String string2 = "Error evaluating XPath [" + string + "] on element [" + element.getTagName() + "].";
            throw new Exception(string2, exception);
        }
    }

    public void validate(String string) throws Exception {
        StreamSource streamSource = new StreamSource(ResourceResolver.openFile(string));
        StreamSource streamSource2 = new StreamSource(ResourceResolver.openFile(this.location));
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = schemaFactory.newSchema(streamSource);
        Validator validator = schema.newValidator();
        validator.validate(streamSource2);
    }

    static {
        DOC_BUILDER_FACTORY.setXIncludeAware(true);
        DOC_BUILDER_FACTORY.setNamespaceAware(true);
    }
}

