/*
 * Decompiled with CFR 0.152.
 */
package blended.security;

import blended.security.AbstractLoginModule;
import blended.security.internal.LDAPLoginConfig;
import blended.security.internal.LDAPLoginConfig$;
import blended.security.internal.LdapSearchResult;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.sun.jndi.ldap.LdapCtxFactory;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Map;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.security.auth.login.LoginException;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u0005ub\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAa\u0001\b\u0001!\u0002\u0013i\u0002bB\u0013\u0001\u0005\u0004%\tF\n\u0005\u0007i\u0001\u0001\u000b\u0011B\u0014\t\u0011U\u0002\u0001R1A\u0005\u0002YB\u0001\"\u0010\u0001\t\u0006\u0004&IA\u0010\u0005\u0006\u001d\u0002!\te\u0014\u0005\u0006w\u0002!\t\u0006 \u0005\u0007\u0003\u0003\u0001A\u0011\u000b?\t\r\u0005\r\u0001\u0001\"\u0015}\u0011!\t)\u0001\u0001Q\u0005\n\u0005\u001d\u0001bBA\u000b\u0001\u0011\u0005\u0013q\u0003\u0005\t\u0003k\u0001\u0001\u0015\"\u0003\u00028\tyA\nR!Q\u0019><\u0017N\\'pIVdWM\u0003\u0002\u0011#\u0005A1/Z2ve&$\u0018PC\u0001\u0013\u0003\u001d\u0011G.\u001a8eK\u0012\u001c\u0001a\u0005\u0002\u0001+A\u0011acF\u0007\u0002\u001f%\u0011\u0001d\u0004\u0002\u0014\u0003\n\u001cHO]1di2{w-\u001b8N_\u0012,H.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003m\u0001\"A\u0006\u0001\u0002\u00071|w\r\u0005\u0002\u001fG5\tqD\u0003\u0002!C\u00059An\\4hS:<'B\u0001\u0012\u0012\u0003\u0011)H/\u001b7\n\u0005\u0011z\"A\u0002'pO\u001e,'/\u0001\u0006n_\u0012,H.\u001a(b[\u0016,\u0012a\n\t\u0003QEr!!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00051\u001a\u0012A\u0002\u001fs_>$hHC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001T&\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019.\u0003-iw\u000eZ;mK:\u000bW.\u001a\u0011\u0002\u000f1$\u0017\r]\"gOV\tq\u0007\u0005\u00029w5\t\u0011H\u0003\u0002;\u001f\u0005A\u0011N\u001c;fe:\fG.\u0003\u0002=s\tyA\nR!Q\u0019><\u0017N\\\"p]\u001aLw-\u0001\u0006eSJ\u001cuN\u001c;fqR,\u0012a\u0010\t\u0004\u0001\n#U\"A!\u000b\u0005\tj\u0013BA\"B\u0005\r!&/\u001f\t\u0003\u000b2k\u0011A\u0012\u0006\u0003\u000f\"\u000b\u0011\u0002Z5sK\u000e$xN]=\u000b\u0005%S\u0015A\u00028b[&twMC\u0001L\u0003\u0015Q\u0017M^1y\u0013\tieI\u0001\u0006ESJ\u001cuN\u001c;fqR\fq\u0001Z8M_\u001eLg\u000eF\u0001Q!\t\t&+D\u0001.\u0013\t\u0019VFA\u0004C_>dW-\u00198)\u0007\u001d)\u0016\rE\u0002R-bK!aV\u0017\u0003\rQD'o\\<t!\tIv,D\u0001[\u0015\tYF,A\u0003m_\u001eLgN\u0003\u0002^=\u0006!\u0011-\u001e;i\u0015\t\u0001\"*\u0003\u0002a5\nqAj\\4j]\u0016C8-\u001a9uS>t\u0017\u0007\u0002\u0010(Ej\fTaI2gk\u001e,\"A\n3\u0005\u000b\u0015\u001c\"\u0019\u00016\u0003\u0003QK!a\u001a5\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132\u0015\tIW&\u0001\u0004uQJ|wo]\t\u0003W:\u0004\"!\u00157\n\u00055l#a\u0002(pi\"Lgn\u001a\t\u0003_Jt!!\u00159\n\u0005El\u0013a\u00029bG.\fw-Z\u0005\u0003gR\u0014\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0005El\u0013'B\u0012wobLgBA)x\u0013\tIW&\r\u0003##6J(!B:dC2\f\u0017G\u0001\u0014Y\u0003)\u0001xn\u001d;D_6l\u0017\u000e\u001e\u000b\u0002{B\u0011\u0011K`\u0005\u0003\u007f6\u0012A!\u00168ji\u0006I\u0001o\\:u\u0003\n|'\u000f^\u0001\u000ba>\u001cH\u000fT8h_V$\u0018\u0001\u0004<bY&$\u0017\r^3Vg\u0016\u0014H#A\u0014)\t-)\u00161B\u0019\u0007=\u001d\ni!a\u00052\r\r\u001ag-a\u0004hc\u0019\u0019co^A\tSF\"!%U\u0017zc\t1\u0003,A\u0005hKR<%o\\;qgR!\u0011\u0011DA\u0013!\u0015\tY\"!\t(\u001d\r\ti\u0002\u001d\b\u0004U\u0005}\u0011\"\u0001\u0018\n\u0007\u0005\rBO\u0001\u0003MSN$\bBBA\u0014\u0019\u0001\u0007q%\u0001\u0004nK6\u0014WM\u001d\u0015\u0005\u0019U\u000bY#\r\u0004\u001fO\u00055\u00121G\u0019\u0007G\r4\u0017qF42\r\r2x/!\rjc\u0011\u0011\u0013+L=2\u0005\u0019B\u0016!\u00053p%\u001a\u001b%GM\u001b5\u000b:\u001cw\u000eZ5oOR\u0019q%!\u000f\t\r\u0005mR\u00021\u0001(\u0003-Ig\u000e];u'R\u0014\u0018N\\4")
public class LDAPLoginModule
extends AbstractLoginModule {
    private LDAPLoginConfig ldapCfg;
    private Try<DirContext> dirContext;
    private final Logger log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(LDAPLoginModule.class));
    private final String moduleName;
    private volatile byte bitmap$0;

    @Override
    public String moduleName() {
        return this.moduleName;
    }

    private LDAPLoginConfig ldapCfg$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.ldapCfg = LDAPLoginConfig$.MODULE$.fromConfig(this.loginConfig());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.ldapCfg;
    }

    public LDAPLoginConfig ldapCfg() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.ldapCfg$lzycompute() : this.ldapCfg;
    }

    private Try<DirContext> dirContext$lzycompute() {
        LDAPLoginModule lDAPLoginModule = this;
        synchronized (lDAPLoginModule) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.dirContext = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                    InitialDirContext initialDirContext;
                    try {
                        scala.collection.mutable.Map env = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.factory.initial"), (Object)LdapCtxFactory.class.getName()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.provider.url"), (Object)this.ldapCfg().url()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.authentication"), (Object)"simple")}));
                        env.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(this.ldapCfg().systemUser().map((Function1 & Serializable & scala.Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.principal"), u))));
                        env.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(this.ldapCfg().systemPassword().map((Function1 & Serializable & scala.Serializable)u -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"java.naming.security.credentials"), u))));
                        initialDirContext = new InitialDirContext(new Hashtable((Map)JavaConverters$.MODULE$.mutableMapAsJavaMapConverter(env).asJava()));
                    }
                    catch (Throwable t) {
                        $this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
                        throw new LoginException(t.getMessage());
                    }
                    return initialDirContext;
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.dirContext;
    }

    private Try<DirContext> dirContext() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.dirContext$lzycompute() : this.dirContext;
    }

    @Override
    public boolean doLogin() throws LoginException {
        try {
            this.dirContext().get();
        }
        catch (Throwable t) {
            this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
            throw new LoginException(t.getMessage());
        }
        this.log.debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(48).append("Successfully connected to LDAP server [").append(this.ldapCfg().url()).append("] user [").append(this.ldapCfg().systemUser()).append("]").toString());
        this.loggedInUser_$eq((Option<String>)new Some((Object)this.validateUser()));
        return true;
    }

    @Override
    public void postCommit() {
        ((Context)this.dirContext().get()).close();
    }

    @Override
    public void postAbort() {
        ((Context)this.dirContext().get()).close();
    }

    @Override
    public void postLogout() {
        ((Context)this.dirContext().get()).close();
    }

    private String validateUser() throws LoginException {
        String string;
        try {
            try {
                SearchResult head;
                Tuple2<String, String> tuple2 = this.extractCredentials();
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                String user = (String)tuple2._1();
                String pwd = (String)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)user, (Object)pwd);
                Tuple2 tuple23 = tuple22;
                String user2 = (String)tuple23._1();
                String pwd2 = (String)tuple23._2();
                SearchControls constraint = new SearchControls();
                constraint.setSearchScope(2);
                MessageFormat userSearchFormat = new MessageFormat(this.ldapCfg().userSearch());
                String filter = userSearchFormat.format(new String[]{this.doRFC2254Encoding(user2)});
                NamingEnumeration<SearchResult> r = ((DirContext)this.dirContext().get()).search(this.ldapCfg().userBase(), filter, constraint);
                List<SearchResult> list = new LdapSearchResult(r).result();
                if (Nil$.MODULE$.equals(list)) {
                    throw new LoginException(new StringBuilder(26).append("User [").append(user2).append("] not found in LDAP.").toString());
                }
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    head = (SearchResult)colon2.head();
                    List tail = colon2.tl$access$1();
                    if (tail.length() > 0) {
                        this.log.warn((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Search for user [").append(user2).append("] returned [").append(1 + tail.length()).append("] records, using first record only.").toString());
                    }
                } else {
                    throw new MatchError(list);
                }
                String name = head.getNameInNamespace();
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.principal", name);
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.credentials", pwd2);
                ((DirContext)this.dirContext().get()).getAttributes("", null);
                this.log.info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("User [").append(user2).append("] authenticated with LDAP name [").append(name).append("]").toString());
                String string2 = name;
                string = string2;
            }
            catch (Throwable t) {
                this.log.error(t, (Function0 & Serializable & scala.Serializable)() -> t.getMessage());
                throw new LoginException(t.getMessage());
            }
        }
        finally {
            Object object;
            Option<String> option = this.ldapCfg().systemUser();
            if (None$.MODULE$.equals(option)) {
                object = ((Context)this.dirContext().get()).removeFromEnvironment("java.naming.security.principal");
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String u = (String)some.value();
                object = ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.principal", u);
            } else {
                throw new MatchError(option);
            }
            Option<String> option2 = this.ldapCfg().systemPassword();
            if (None$.MODULE$.equals(option2)) {
                ((Context)this.dirContext().get()).removeFromEnvironment("java.naming.security.credentials");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (option2 instanceof Some) {
                Some some = (Some)option2;
                String p = (String)some.value();
                ((Context)this.dirContext().get()).addToEnvironment("java.naming.security.credentials", p);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError(option2);
            }
        }
        return string;
    }

    @Override
    public List<String> getGroups(String member) throws LoginException {
        SearchControls constraint = new SearchControls();
        constraint.setSearchScope(2);
        MessageFormat groupSearchFormat = new MessageFormat(this.ldapCfg().groupSearch());
        String filter = groupSearchFormat.format(new String[]{this.doRFC2254Encoding(member)});
        NamingEnumeration<SearchResult> r = ((DirContext)this.dirContext().get()).search(this.ldapCfg().groupBase(), filter, constraint);
        return (List)new LdapSearchResult(r).result().map((Function1 & Serializable & scala.Serializable)sr -> sr.getAttributes().get(this.ldapCfg().groupAttribute()).get().toString(), List$.MODULE$.canBuildFrom());
    }

    private String doRFC2254Encoding(String inputString) {
        String string = inputString;
        String string2 = string.isEmpty() ? "" : (string.startsWith("\\") ? new StringBuilder(3).append("\\5c").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("*") ? new StringBuilder(3).append("\\2a").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("(") ? new StringBuilder(3).append("\\28").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith(")") ? new StringBuilder(3).append("\\29").append(this.doRFC2254Encoding(string.substring(1))).toString() : (string.startsWith("\u0000") ? new StringBuilder(3).append("\\00").append(this.doRFC2254Encoding(string.substring(1))).toString() : new StringBuilder(0).append(string.substring(0, 1)).append(this.doRFC2254Encoding(string.substring(1))).toString())))));
        return string2;
    }

    public LDAPLoginModule() {
        this.moduleName = "ldap";
    }
}

