/*
 * Decompiled with CFR 0.152.
 */
package akka.io.dns.internal;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorRefFactory;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.annotation.InternalApi;
import akka.event.LoggingAdapter;
import akka.io.dns.AAAARecord;
import akka.io.dns.ARecord;
import akka.io.dns.CachePolicy;
import akka.io.dns.CachePolicy$Ttl$;
import akka.io.dns.CachePolicy$Ttl$TtlIsOrdered$;
import akka.io.dns.DnsProtocol;
import akka.io.dns.DnsProtocol$Resolved$;
import akka.io.dns.DnsProtocol$Srv$;
import akka.io.dns.DnsSettings;
import akka.io.dns.ResourceRecord;
import akka.io.dns.internal.AsyncDnsCache;
import akka.io.dns.internal.AsyncDnsResolver$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv4Type$;
import akka.io.dns.internal.AsyncDnsResolver$Ipv6Type$;
import akka.io.dns.internal.AsyncDnsResolver$SrvType$;
import akka.io.dns.internal.DnsClient;
import akka.pattern.AskableActorRef$;
import akka.util.Helpers$;
import akka.util.Timeout;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Try$;
import scala.util.control.NonFatal$;

@InternalApi
@ScalaSignature(bytes="\u0006\u0001\r\u001dc!B+W\u0005is\u0006\u0002\u00038\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u0011Q\u0004!\u0011!Q\u0001\nUD\u0001\"\u001f\u0001\u0003\u0002\u0003\u0006IA\u001f\u0005\b\u0003c\u0001A\u0011AA\u001a\u0011%\ti\u0004\u0001b\u0001\n\u0007\ty\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA!\u0011%\ty\u0005\u0001b\u0001\n\u0007\t\t\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA*\u0011%\t\t\u0007\u0001b\u0001\n\u0003\t\u0019\u0007\u0003\u0005\u0002f\u0001\u0001\u000b\u0011BA\u0001\u0011%\t9\u0007\u0001a\u0001\n\u0013\tI\u0007C\u0005\u0002r\u0001\u0001\r\u0011\"\u0003\u0002t!A\u0011q\u0010\u0001!B\u0013\tY\u0007C\u0004\u0002\u0002\u0002!I!a!\t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005\u001d\u0005\u0002CAE\u0001\u0001\u0006I!!\u000b\t\u000f\u0005-\u0005\u0001\"\u0011\u0002\u000e\"9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBAo\u0001\u0011%\u0011q\u001c\u0005\b\u0003/\u0003A\u0011\u0002B\u0002\u000f!\u0011IB\u0016E\u00015\nmaaB+W\u0011\u0003Q&Q\u0004\u0005\b\u0003c1B\u0011\u0001B\u0010\u0011%\u0011\tC\u0006b\u0001\n\u0013\u0011\u0019\u0003\u0003\u0005\u00034Y\u0001\u000b\u0011\u0002B\u0013\u0011%\u0011)D\u0006b\u0001\n\u0013\u0011\u0019\u0003\u0003\u0005\u00038Y\u0001\u000b\u0011\u0002B\u0013\u0011\u001d\u0011ID\u0006C\u0005\u0005wA\u0011B!\u0012\u0017\u0005\u0004%IAa\u0012\t\u0011\t%c\u0003)A\u0005\u0003C4\u0011Ba\u0013\u0017!\u0003\r\nC!\u0014\b\u000f\tUg\u0003#\"\u0003h\u00199!\u0011\u000b\f\t\u0006\nM\u0003bBA\u0019C\u0011\u0005!Q\r\u0005\n\u0005S\n\u0013\u0011!C!\u0005WB\u0011Ba\u001e\"\u0003\u0003%\tA!\u001f\t\u0013\t\u0005\u0015%!A\u0005\u0002\t\r\u0005\"\u0003BGC\u0005\u0005I\u0011\tBH\u0011%\u0011i*IA\u0001\n\u0003\u0011y\nC\u0005\u0003$\u0006\n\t\u0011\"\u0011\u0003&\"I!qU\u0011\u0002\u0002\u0013\u0005#\u0011\u0016\u0005\n\u0005W\u000b\u0013\u0011!C\u0005\u0005[;qAa6\u0017\u0011\u000b\u0013YLB\u0004\u00036ZA)Ia.\t\u000f\u0005EB\u0006\"\u0001\u0003:\"I!\u0011\u000e\u0017\u0002\u0002\u0013\u0005#1\u000e\u0005\n\u0005ob\u0013\u0011!C\u0001\u0005sB\u0011B!!-\u0003\u0003%\tA!0\t\u0013\t5E&!A\u0005B\t=\u0005\"\u0003BOY\u0005\u0005I\u0011\u0001Ba\u0011%\u0011\u0019\u000bLA\u0001\n\u0003\u0012)\u000bC\u0005\u0003(2\n\t\u0011\"\u0011\u0003*\"I!1\u0016\u0017\u0002\u0002\u0013%!QV\u0004\b\u000534\u0002R\u0011Bf\r\u001d\u0011)M\u0006EC\u0005\u000fDq!!\r8\t\u0003\u0011I\rC\u0005\u0003j]\n\t\u0011\"\u0011\u0003l!I!qO\u001c\u0002\u0002\u0013\u0005!\u0011\u0010\u0005\n\u0005\u0003;\u0014\u0011!C\u0001\u0005\u001bD\u0011B!$8\u0003\u0003%\tEa$\t\u0013\tuu'!A\u0005\u0002\tE\u0007\"\u0003BRo\u0005\u0005I\u0011\tBS\u0011%\u00119kNA\u0001\n\u0003\u0012I\u000bC\u0005\u0003,^\n\t\u0011\"\u0003\u0003.\u001a1!1\u001c\fA\u0005;D!B!:B\u0005+\u0007I\u0011\u0001Bt\u0011)\u0011I/\u0011B\tB\u0003%\u00111\u0017\u0005\b\u0003c\tE\u0011\u0001Bv\u0011%\u0011\t0QA\u0001\n\u0003\u0011\u0019\u0010C\u0005\u0003x\u0006\u000b\n\u0011\"\u0001\u0003z\"I!\u0011N!\u0002\u0002\u0013\u0005#1\u000e\u0005\n\u0005o\n\u0015\u0011!C\u0001\u0005sB\u0011B!!B\u0003\u0003%\ta!\u0004\t\u0013\t5\u0015)!A\u0005B\t=\u0005\"\u0003BO\u0003\u0006\u0005I\u0011AB\t\u0011%\u0011\u0019+QA\u0001\n\u0003\u0012)\u000bC\u0005\u0004\u0016\u0005\u000b\t\u0011\"\u0011\u0004\u0018\u001dI11\u0004\f\u0002\u0002#\u00051Q\u0004\u0004\n\u000574\u0012\u0011!E\u0001\u0007?Aq!!\rP\t\u0003\u0019i\u0003C\u0005\u0003(>\u000b\t\u0011\"\u0012\u0003*\"I1qF(\u0002\u0002\u0013\u00055\u0011\u0007\u0005\n\u0007ky\u0015\u0011!CA\u0007oA\u0011Ba+P\u0003\u0003%IA!,\u0003!\u0005\u001b\u0018P\\2E]N\u0014Vm]8mm\u0016\u0014(BA,Y\u0003!Ig\u000e^3s]\u0006d'BA-[\u0003\r!gn\u001d\u0006\u00037r\u000b!![8\u000b\u0003u\u000bA!Y6lCN!\u0001aX3l!\t\u00017-D\u0001b\u0015\u0005\u0011\u0017!B:dC2\f\u0017B\u00013b\u0005\u0019\te.\u001f*fMB\u0011a-[\u0007\u0002O*\u0011\u0001\u000eX\u0001\u0006C\u000e$xN]\u0005\u0003U\u001e\u0014Q!Q2u_J\u0004\"A\u001a7\n\u00055<'\u0001D!di>\u0014Hj\\4hS:<\u0017\u0001C:fiRLgnZ:\u0004\u0001A\u0011\u0011O]\u0007\u00021&\u00111\u000f\u0017\u0002\f\t:\u001c8+\u001a;uS:<7/A\u0003dC\u000eDW\r\u0005\u0002wo6\ta+\u0003\u0002y-\ni\u0011i]=oG\u0012s7oQ1dQ\u0016\fQb\u00197jK:$h)Y2u_JL\bc\u00021|{\u0006\u0005\u0011\u0011F\u0005\u0003y\u0006\u0014\u0011BR;oGRLwN\u001c\u001a\u0011\u0005\u0019t\u0018BA@h\u0005=\t5\r^8s%\u00164g)Y2u_JL\bCBA\u0002\u0003'\tIB\u0004\u0003\u0002\u0006\u0005=a\u0002BA\u0004\u0003\u001bi!!!\u0003\u000b\u0007\u0005-q.\u0001\u0004=e>|GOP\u0005\u0002E&\u0019\u0011\u0011C1\u0002\u000fA\f7m[1hK&!\u0011QCA\f\u0005\u0011a\u0015n\u001d;\u000b\u0007\u0005E\u0011\r\u0005\u0003\u0002\u001c\u0005\u0015RBAA\u000f\u0015\u0011\ty\"!\t\u0002\u00079,GO\u0003\u0002\u0002$\u0005!!.\u0019<b\u0013\u0011\t9#!\b\u0003#%sW\r^*pG.,G/\u00113ee\u0016\u001c8\u000f\u0005\u0004\u0002\u0004\u0005M\u00111\u0006\t\u0004M\u00065\u0012bAA\u0018O\nA\u0011i\u0019;peJ+g-\u0001\u0004=S:LGO\u0010\u000b\t\u0003k\t9$!\u000f\u0002<A\u0011a\u000f\u0001\u0005\u0006]\u0012\u0001\r\u0001\u001d\u0005\u0006i\u0012\u0001\r!\u001e\u0005\u0006s\u0012\u0001\rA_\u0001\u0003K\u000e,\"!!\u0011\u0011\t\u0005\r\u0013\u0011J\u0007\u0003\u0003\u000bR1!a\u0012b\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u0017\n)E\u0001\rFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0016CXmY;u_J\f1!Z2!\u0003\u001d!\u0018.\\3pkR,\"!a\u0015\u0011\t\u0005U\u00131L\u0007\u0003\u0003/R1!!\u0017]\u0003\u0011)H/\u001b7\n\t\u0005u\u0013q\u000b\u0002\b)&lWm\\;u\u0003!!\u0018.\\3pkR\u0004\u0013a\u00038b[\u0016\u001cVM\u001d<feN,\"!!\u0001\u0002\u00199\fW.Z*feZ,'o\u001d\u0011\u0002\u0013I,\u0017/^3ti&#WCAA6!\r\u0001\u0017QN\u0005\u0004\u0003_\n'!B*i_J$\u0018!\u0004:fcV,7\u000f^%e?\u0012*\u0017\u000f\u0006\u0003\u0002v\u0005m\u0004c\u00011\u0002x%\u0019\u0011\u0011P1\u0003\tUs\u0017\u000e\u001e\u0005\n\u0003{b\u0011\u0011!a\u0001\u0003W\n1\u0001\u001f\u00132\u0003)\u0011X-];fgRLE\rI\u0001\u0007]\u0016DH/\u00133\u0015\u0005\u0005-\u0014!\u0003:fg>dg/\u001a:t+\t\tI#\u0001\u0006sKN|GN^3sg\u0002\nqA]3dK&4X-\u0006\u0002\u0002\u0010B!\u0011\u0011SAJ\u001b\u0005\u0001\u0011bAAKS\n9!+Z2fSZ,\u0017a\u0002:fg>dg/\u001a\u000b\t\u00037\u000by+a1\u0002\\B1\u00111IAO\u0003CKA!a(\u0002F\t1a)\u001e;ve\u0016\u0004B!a)\u0002*:\u0019\u0011/!*\n\u0007\u0005\u001d\u0006,A\u0006E]N\u0004&o\u001c;pG>d\u0017\u0002BAV\u0003[\u0013\u0001BU3t_24X\r\u001a\u0006\u0004\u0003OC\u0006bBAY%\u0001\u0007\u00111W\u0001\u0005]\u0006lW\r\u0005\u0003\u00026\u0006uf\u0002BA\\\u0003s\u00032!a\u0002b\u0013\r\tY,Y\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0016\u0011\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005m\u0016\rC\u0004\u0002FJ\u0001\r!a2\u0002\u0017I,\u0017/^3tiRK\b/\u001a\t\u0005\u0003\u0013\f9N\u0004\u0003\u0002L\u0006\u0015f\u0002BAg\u0003+tA!a4\u0002T:!\u0011qAAi\u0013\u0005i\u0016BA.]\u0013\tI&,\u0003\u0003\u0002Z\u00065&a\u0003*fcV,7\u000f\u001e+za\u0016Dq!!\"\u0013\u0001\u0004\tI#\u0001\u0007tK:$\u0017+^3ti&|g\u000e\u0006\u0004\u0002b\u0006U\u0018\u0011 \t\u0007\u0003\u0007\ni*a9\u0011\t\u0005\u0015\u0018q\u001e\b\u0005\u0003O\fYO\u0004\u0003\u0002L\u0006%\u0018BA,Y\u0013\r\tiOV\u0001\n\t:\u001c8\t\\5f]RLA!!=\u0002t\n1\u0011I\\:xKJT1!!<W\u0011\u001d\t9p\u0005a\u0001\u0003W\t\u0001B]3t_24XM\u001d\u0005\b\u0003w\u001c\u0002\u0019AA\u007f\u0003\u001diWm]:bO\u0016\u0004B!!:\u0002\u0000&!!\u0011AAz\u0005-!en])vKN$\u0018n\u001c8\u0015\u0011\u0005m%Q\u0001B\u0004\u0005\u0013Aq!!-\u0015\u0001\u0004\t\u0019\fC\u0004\u0002FR\u0001\r!a2\t\u000f\u0005]H\u00031\u0001\u0002,!\u001a\u0001A!\u0004\u0011\t\t=!QC\u0007\u0003\u0005#Q1Aa\u0005]\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005/\u0011\tBA\u0006J]R,'O\\1m\u0003BL\u0017\u0001E!ts:\u001cGI\\:SKN|GN^3s!\t1hc\u0005\u0002\u0017?R\u0011!1D\u0001\fSB4H'\u00113ee\u0016\u001c8/\u0006\u0002\u0003&A!!q\u0005B\u0018\u001b\t\u0011IC\u0003\u0003\u0003,\t5\u0012\u0001C7bi\u000eD\u0017N\\4\u000b\u0007\u0005e\u0013-\u0003\u0003\u00032\t%\"!\u0002*fO\u0016D\u0018\u0001D5qmR\nE\r\u001a:fgN\u0004\u0013aC5qmZ\nE\r\u001a:fgN\fA\"\u001b9wm\u0005#GM]3tg\u0002\nQ\"[:J]\u0016$\u0018\t\u001a3sKN\u001cH\u0003\u0002B\u001f\u0005\u0007\u00022\u0001\u0019B \u0013\r\u0011\t%\u0019\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\f\ba\u0001\u0003g\u000bQ!R7qif,\"!!9\u0002\r\u0015k\u0007\u000f^=!\u0005%\tV/\u001a:z)f\u0004Xm\u0005\u0002 ?&\"q$\t\u00178\u0005!I\u0005O\u001e\u001bUsB,7\u0003C\u0011`\u0005+\u0012IFa\u0018\u0011\u0007\t]s$D\u0001\u0017!\r\u0001'1L\u0005\u0004\u0005;\n'a\u0002)s_\u0012,8\r\u001e\t\u0004A\n\u0005\u0014b\u0001B2C\na1+\u001a:jC2L'0\u00192mKR\u0011!q\r\t\u0004\u0005/\n\u0013!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0003nA!!q\u000eB;\u001b\t\u0011\tH\u0003\u0003\u0003t\u0005\u0005\u0012\u0001\u00027b]\u001eLA!a0\u0003r\u0005a\u0001O]8ek\u000e$\u0018I]5usV\u0011!1\u0010\t\u0004A\nu\u0014b\u0001B@C\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!Q\u0011BF!\r\u0001'qQ\u0005\u0004\u0005\u0013\u000b'aA!os\"I\u0011QP\u0013\u0002\u0002\u0003\u0007!1P\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!\u0011\u0013\t\u0007\u0005'\u0013IJ!\"\u000e\u0005\tU%b\u0001BLC\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tm%Q\u0013\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003>\t\u0005\u0006\"CA?O\u0005\u0005\t\u0019\u0001BC\u0003!A\u0017m\u001d5D_\u0012,GC\u0001B>\u0003!!xn\u0015;sS:<GC\u0001B7\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t=\u0006\u0003\u0002B8\u0005cKAAa-\u0003r\t1qJ\u00196fGR\u0014\u0001\"\u00139wmQK\b/Z\n\tY}\u0013)F!\u0017\u0003`Q\u0011!1\u0018\t\u0004\u0005/bC\u0003\u0002BC\u0005\u007fC\u0011\"! 1\u0003\u0003\u0005\rAa\u001f\u0015\t\tu\"1\u0019\u0005\n\u0003{\u0012\u0014\u0011!a\u0001\u0005\u000b\u0013qa\u0015:w)f\u0004Xm\u0005\u00058?\nU#\u0011\fB0)\t\u0011Y\rE\u0002\u0003X]\"BA!\"\u0003P\"I\u0011QP\u001e\u0002\u0002\u0003\u0007!1\u0010\u000b\u0005\u0005{\u0011\u0019\u000eC\u0005\u0002~u\n\t\u00111\u0001\u0003\u0006\u0006A\u0011\n\u001d<5)f\u0004X-\u0001\u0005JaZ4D+\u001f9f\u0003\u001d\u0019&O\u001e+za\u0016\u0014aCU3t_24XMR1jY\u0016$W\t_2faRLwN\\\n\b\u0003\n}'\u0011\fB0!\u0011\t\u0019A!9\n\t\t\r\u0018q\u0003\u0002\n\u000bb\u001cW\r\u001d;j_:\f1!\\:h+\t\t\u0019,\u0001\u0003ng\u001e\u0004C\u0003\u0002Bw\u0005_\u00042Aa\u0016B\u0011\u001d\u0011)\u000f\u0012a\u0001\u0003g\u000bAaY8qsR!!Q\u001eB{\u0011%\u0011)/\u0012I\u0001\u0002\u0004\t\u0019,\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\tm(\u0006BAZ\u0005{\\#Aa@\u0011\t\r\u00051\u0011B\u0007\u0003\u0007\u0007QAa!\u0002\u0004\b\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005'\t\u0017\u0002BB\u0006\u0007\u0007\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f)\u0011\u0011)ia\u0004\t\u0013\u0005u\u0014*!AA\u0002\tmD\u0003\u0002B\u001f\u0007'A\u0011\"! L\u0003\u0003\u0005\rA!\"\u0002\r\u0015\fX/\u00197t)\u0011\u0011id!\u0007\t\u0013\u0005uT*!AA\u0002\t\u0015\u0015A\u0006*fg>dg/\u001a$bS2,G-\u0012=dKB$\u0018n\u001c8\u0011\u0007\t]sjE\u0003P\u0007C\u0011y\u0006\u0005\u0005\u0004$\r%\u00121\u0017Bw\u001b\t\u0019)CC\u0002\u0004(\u0005\fqA];oi&lW-\u0003\u0003\u0004,\r\u0015\"!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u00111QD\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0005[\u001c\u0019\u0004C\u0004\u0003fJ\u0003\r!a-\u0002\u000fUt\u0017\r\u001d9msR!1\u0011HB !\u0015\u000171HAZ\u0013\r\u0019i$\u0019\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\r\u00053+!AA\u0002\t5\u0018a\u0001=%a!\u001aaC!\u0004)\u0007U\u0011i\u0001")
public final class AsyncDnsResolver
implements Actor,
ActorLogging {
    private final AsyncDnsCache cache;
    private final ExecutionContextExecutor ec;
    private final Timeout timeout;
    private final List<InetSocketAddress> nameServers;
    private short requestId;
    private final List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    @Override
    public LoggingAdapter log() {
        return ActorLogging.log$(this);
    }

    @Override
    public final ActorRef sender() {
        return Actor.sender$(this);
    }

    @Override
    @InternalApi
    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.aroundReceive$(this, receive2, msg);
    }

    @Override
    @InternalApi
    public void aroundPreStart() {
        Actor.aroundPreStart$(this);
    }

    @Override
    @InternalApi
    public void aroundPostStop() {
        Actor.aroundPostStop$(this);
    }

    @Override
    @InternalApi
    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.aroundPreRestart$(this, reason, message);
    }

    @Override
    @InternalApi
    public void aroundPostRestart(Throwable reason) {
        Actor.aroundPostRestart$(this, reason);
    }

    @Override
    public SupervisorStrategy supervisorStrategy() {
        return Actor.supervisorStrategy$(this);
    }

    @Override
    public void preStart() throws Exception {
        Actor.preStart$(this);
    }

    @Override
    public void postStop() throws Exception {
        Actor.postStop$(this);
    }

    @Override
    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.preRestart$(this, reason, message);
    }

    @Override
    public void postRestart(Throwable reason) throws Exception {
        Actor.postRestart$(this, reason);
    }

    @Override
    public void unhandled(Object message) {
        Actor.unhandled$(this, message);
    }

    @Override
    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    @Override
    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    @Override
    public ActorContext context() {
        return this.context;
    }

    @Override
    public final ActorRef self() {
        return this.self;
    }

    @Override
    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    @Override
    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public ExecutionContextExecutor ec() {
        return this.ec;
    }

    public Timeout timeout() {
        return this.timeout;
    }

    public List<InetSocketAddress> nameServers() {
        return this.nameServers;
    }

    private short requestId() {
        return this.requestId;
    }

    private void requestId_$eq(short x$1) {
        this.requestId = x$1;
    }

    private short nextId() {
        this.requestId_$eq((short)(this.requestId() + 1));
        return this.requestId();
    }

    public List<ActorRef> akka$io$dns$internal$AsyncDnsResolver$$resolvers() {
        return this.akka$io$dns$internal$AsyncDnsResolver$$resolvers;
    }

    @Override
    public PartialFunction<Object, BoxedUnit> receive() {
        return new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof DnsProtocol.Resolve) {
                    DnsProtocol.Resolve resolve2 = (DnsProtocol.Resolve)A1;
                    String name = resolve2.name();
                    DnsProtocol.RequestType mode = resolve2.requestType();
                    akka.pattern.package$.MODULE$.pipe(this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(name, mode, this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolvers()), (ExecutionContext)this.$outer.ec()).pipeTo(this.$outer.sender(), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                Object object = x1;
                boolean bl = object instanceof DnsProtocol.Resolve;
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public Future<DnsProtocol.Resolved> akka$io$dns$internal$AsyncDnsResolver$$resolve(String name, DnsProtocol.RequestType requestType, List<ActorRef> resolvers) {
        Future future;
        if (AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$isInetAddress(name)) {
            future = Future$.MODULE$.fromTry(Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                ARecord record;
                ResourceRecord resourceRecord;
                InetAddress address = InetAddress.getByName(name);
                InetAddress inetAddress = address;
                if (inetAddress instanceof Inet4Address) {
                    resourceRecord = new ARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), address);
                } else if (inetAddress instanceof Inet6Address) {
                    Inet6Address inet6Address = (Inet6Address)inetAddress;
                    resourceRecord = new AAAARecord(name, CachePolicy$Ttl$.MODULE$.effectivelyForever(), inet6Address);
                } else {
                    throw new MatchError((Object)inetAddress);
                }
                ARecord aRecord = record = resourceRecord;
                return DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)Nil$.MODULE$.$colon$colon((Object)aRecord));
            }));
        } else {
            Future future2;
            List<ActorRef> list = resolvers;
            if (Nil$.MODULE$.equals(list)) {
                future2 = Future$.MODULE$.failed((Throwable)new ResolveFailedException(new StringBuilder(39).append("Timed out resolving ").append(name).append(" with nameservers: ").append(this.nameServers()).toString()));
            } else if (list instanceof .colon.colon) {
                .colon.colon colon2 = (.colon.colon)list;
                ActorRef head = (ActorRef)colon2.head();
                List tail = colon2.tl$access$1();
                future2 = this.resolve(name, requestType, head).recoverWith((PartialFunction)new scala.Serializable(this, name, requestType, tail){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ AsyncDnsResolver $outer;
                    private final String name$1;
                    private final DnsProtocol.RequestType requestType$1;
                    private final List tail$1;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        Future<DnsProtocol.Resolved> future;
                        A1 A1 = x1;
                        Option option = NonFatal$.MODULE$.unapply(A1);
                        if (!option.isEmpty()) {
                            Throwable t = (Throwable)option.get();
                            this.$outer.log().error(t, "Resolve failed. Trying next name server");
                            future = this.$outer.akka$io$dns$internal$AsyncDnsResolver$$resolve(this.name$1, this.requestType$1, (List<ActorRef>)this.tail$1);
                        } else {
                            future = function1.apply(x1);
                        }
                        return (B1)future;
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        Option option = NonFatal$.MODULE$.unapply(throwable);
                        boolean bl = !option.isEmpty();
                        return bl;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.name$1 = name$1;
                        this.requestType$1 = requestType$1;
                        this.tail$1 = tail$1;
                    }
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(list);
            }
            future = future2;
        }
        return future;
    }

    /*
     * WARNING - void declaration
     */
    private Future<DnsClient.Answer> sendQuestion(ActorRef resolver, DnsClient.DnsQuestion message) {
        void var3_3;
        Future result = AskableActorRef$.MODULE$.$qmark$extension1(akka.pattern.package$.MODULE$.ask(resolver), message, this.timeout(), this.self()).mapTo(ClassTag$.MODULE$.apply(DnsClient.Answer.class));
        result.onFailure((PartialFunction)new scala.Serializable(this, resolver, message){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AsyncDnsResolver $outer;
            private final ActorRef resolver$1;
            private final DnsClient.DnsQuestion message$1;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    package$.MODULE$.actorRef2Scala(this.resolver$1).$bang(new DnsClient.DropRequest(this.message$1.id()), this.$outer.self());
                    object = BoxedUnit.UNIT;
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.resolver$1 = resolver$1;
                this.message$1 = message$1;
            }
        }, (ExecutionContext)this.ec());
        return var3_3;
    }

    private Future<DnsProtocol.Resolved> resolve(String name, DnsProtocol.RequestType requestType, ActorRef resolver) {
        Future future;
        this.log().debug("Attempting to resolve {} with {}", name, resolver);
        String caseFoldedName = Helpers$.MODULE$.toRootLowerCase(name);
        DnsProtocol.RequestType requestType2 = requestType;
        if (requestType2 instanceof DnsProtocol.Ip) {
            Future future2;
            Future ipv4Recs;
            Future future3;
            DnsProtocol.Ip ip = (DnsProtocol.Ip)requestType2;
            boolean ipv4 = ip.ipv4();
            boolean ipv6 = ip.ipv6();
            if (ipv4) {
                Future future4;
                Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r = (DnsClient.Answer)some.value();
                    this.log().debug("Ipv4 cached {}", r);
                    future4 = Future$.MODULE$.successful((Object)r);
                } else if (None$.MODULE$.equals(option)) {
                    future4 = this.sendQuestion(resolver, new DnsClient.Question4(this.nextId(), caseFoldedName));
                } else {
                    throw new MatchError(option);
                }
                future3 = future4;
            } else {
                future3 = ipv4Recs = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            if (ipv6) {
                Future future5;
                Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$));
                if (option instanceof Some) {
                    Some some = (Some)option;
                    DnsClient.Answer r = (DnsClient.Answer)some.value();
                    this.log().debug("Ipv6 cached {}", r);
                    future5 = Future$.MODULE$.successful((Object)r);
                } else if (None$.MODULE$.equals(option)) {
                    future5 = this.sendQuestion(resolver, new DnsClient.Question6(this.nextId(), caseFoldedName));
                } else {
                    throw new MatchError(option);
                }
                future2 = future5;
            } else {
                future2 = AsyncDnsResolver$.MODULE$.akka$io$dns$internal$AsyncDnsResolver$$Empty();
            }
            Future ipv6Recs = future2;
            future = ipv4Recs.flatMap((Function1 & Serializable & scala.Serializable)ipv4Records -> {
                block0: {
                    if (!ipv4Records.rrs().nonEmpty()) break block0;
                    CachePolicy.Ttl minTtl4 = (CachePolicy.Ttl)((TraversableOnce)ipv4Records.rrs().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.ttl(), Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                    $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv4Type$.MODULE$), (DnsClient.Answer)ipv4Records, minTtl4);
                }
                return ipv6Recs.map((Function1 & Serializable & scala.Serializable)ipv6Records -> {
                    block0: {
                        if (!ipv6Records.rrs().nonEmpty()) break block0;
                        CachePolicy.Ttl minTtl6 = (CachePolicy.Ttl)((TraversableOnce)ipv6Records.rrs().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.ttl(), Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                        $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$Ipv6Type$.MODULE$), (DnsClient.Answer)ipv6Records, minTtl6);
                    }
                    return (Seq)ipv4Records.rrs().$plus$plus(ipv6Records.rrs(), Seq$.MODULE$.canBuildFrom());
                }, (ExecutionContext)this.ec()).map((Function1 & Serializable & scala.Serializable)recs -> DnsProtocol$Resolved$.MODULE$.apply(name, (Seq<ResourceRecord>)recs), (ExecutionContext)this.ec());
            }, (ExecutionContext)this.ec());
        } else if (DnsProtocol$Srv$.MODULE$.equals(requestType2)) {
            Future future6;
            Option<DnsClient.Answer> option = this.cache.get((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$SrvType$.MODULE$));
            if (option instanceof Some) {
                Some some = (Some)option;
                DnsClient.Answer r = (DnsClient.Answer)some.value();
                future6 = Future$.MODULE$.successful((Object)new DnsProtocol.Resolved(name, r.rrs(), r.additionalRecs()));
            } else if (None$.MODULE$.equals(option)) {
                future6 = this.sendQuestion(resolver, new DnsClient.SrvQuestion(this.nextId(), caseFoldedName)).map((Function1 & Serializable & scala.Serializable)answer -> {
                    if (answer.rrs().nonEmpty()) {
                        CachePolicy.Ttl minTtl = (CachePolicy.Ttl)((TraversableOnce)answer.rrs().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.ttl(), Seq$.MODULE$.canBuildFrom())).min((Ordering)CachePolicy$Ttl$TtlIsOrdered$.MODULE$);
                        $this.cache.put((Tuple2<String, QueryType>)new Tuple2((Object)name, (Object)AsyncDnsResolver$SrvType$.MODULE$), (DnsClient.Answer)answer, minTtl);
                    }
                    return new DnsProtocol.Resolved(name, answer.rrs(), answer.additionalRecs());
                }, (ExecutionContext)this.ec());
            } else {
                throw new MatchError(option);
            }
            future = future6;
        } else {
            throw new MatchError((Object)requestType2);
        }
        return future;
    }

    public AsyncDnsResolver(DnsSettings settings, AsyncDnsCache cache, Function2<ActorRefFactory, List<InetSocketAddress>, List<ActorRef>> clientFactory) {
        this.cache = cache;
        Actor.$init$(this);
        ActorLogging.$init$(this);
        this.ec = this.context().dispatcher();
        this.timeout = new Timeout(settings.ResolveTimeout());
        this.nameServers = settings.NameServers();
        this.log().debug("Using name servers [{}]", this.nameServers());
        this.requestId = 0;
        this.akka$io$dns$internal$AsyncDnsResolver$$resolvers = (List)clientFactory.apply((Object)this.context(), this.nameServers());
    }

    public static interface QueryType {
    }

    public static class ResolveFailedException
    extends Exception
    implements Product,
    scala.Serializable {
        private final String msg;

        public String msg() {
            return this.msg;
        }

        public ResolveFailedException copy(String msg) {
            return new ResolveFailedException(msg);
        }

        public String copy$default$1() {
            return this.msg();
        }

        public String productPrefix() {
            return "ResolveFailedException";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return this.msg();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ResolveFailedException;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ResolveFailedException)) return false;
            boolean bl = true;
            if (!bl) return false;
            ResolveFailedException resolveFailedException = (ResolveFailedException)x$1;
            String string = this.msg();
            String string2 = resolveFailedException.msg();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!resolveFailedException.canEqual(this)) return false;
            return true;
        }

        public ResolveFailedException(String msg) {
            this.msg = msg;
            super(msg);
            Product.$init$((Product)this);
        }
    }
}

