/*
 * Decompiled with CFR 0.152.
 */
package blended.launcher;

import blended.launcher.Cmdline;
import blended.launcher.Launcher;
import blended.launcher.Launcher$Configs$;
import blended.launcher.LauncherException;
import blended.launcher.LauncherException$;
import blended.launcher.config.LauncherConfig;
import blended.launcher.config.LauncherConfig$;
import blended.launcher.internal.ARM$;
import blended.updater.config.ConfigConverter$;
import blended.updater.config.LocalOverlays;
import blended.updater.config.LocalOverlays$;
import blended.updater.config.LocalRuntimeConfig;
import blended.updater.config.ProfileLookup;
import blended.updater.config.ProfileLookup$;
import blended.updater.config.ResolvedRuntimeConfig;
import blended.updater.config.RuntimeConfig;
import blended.updater.config.RuntimeConfigCompanion$;
import blended.updater.config.SystemPropertyResolver$;
import blended.util.logging.Logger;
import blended.util.logging.Logger$;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import de.tototec.cmdoption.CmdlineParser;
import de.tototec.cmdoption.CmdlineParserException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.UUID;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.sys.package$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class Launcher$ {
    public static Launcher$ MODULE$;
    private Logger blended$launcher$Launcher$$log;
    private String blendedHomeDir;
    private String containerConfigDirectory;
    private String containerIdFile;
    private volatile byte bitmap$0;

    static {
        new Launcher$();
    }

    private Logger log$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.blended$launcher$Launcher$$log = Logger$.MODULE$.apply(ClassTag$.MODULE$.apply(Launcher$.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.blended$launcher$Launcher$$log;
    }

    public Logger blended$launcher$Launcher$$log() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.log$lzycompute() : this.blended$launcher$Launcher$$log;
    }

    private String blendedHomeDir$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.blendedHomeDir = (String)Option$.MODULE$.apply((Object)System.getProperty("blended.home")).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".");
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.blendedHomeDir;
    }

    private String blendedHomeDir() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.blendedHomeDir$lzycompute() : this.blendedHomeDir;
    }

    private String containerConfigDirectory$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.containerConfigDirectory = new StringBuilder(4).append(this.blendedHomeDir()).append("/etc").toString();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.containerConfigDirectory;
    }

    private String containerConfigDirectory() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.containerConfigDirectory$lzycompute() : this.containerConfigDirectory;
    }

    private String containerIdFile$lzycompute() {
        Launcher$ launcher$ = this;
        synchronized (launcher$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.containerIdFile = "blended.container.context.id";
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.containerIdFile;
    }

    private String containerIdFile() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.containerIdFile$lzycompute() : this.containerIdFile;
    }

    public void main(String[] args) {
        try {
            this.run(args);
        }
        catch (LauncherException t) {
            this.blended$launcher$Launcher$$log().debug((Throwable)t, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("Caught a LauncherException. Exiting with error code: ").append(t.errorCode()).append(" and message: ").append(t.getMessage()).toString());
            if (!t.getMessage().isEmpty()) {
                Console$.MODULE$.err().println(String.valueOf(t.getMessage()));
            }
            throw package$.MODULE$.exit(t.errorCode());
        }
        catch (Throwable t) {
            this.blended$launcher$Launcher$$log().error(t, (Function0 & Serializable & scala.Serializable)() -> "Caught an exception. Exiting with error code: 1");
            Console$.MODULE$.err().println(new StringBuilder(7).append("Error: ").append(t.getMessage()).toString());
            throw package$.MODULE$.exit(1);
        }
        throw package$.MODULE$.exit(0);
    }

    private void reportError(String msg) {
        this.blended$launcher$Launcher$$log().error((Function0 & Serializable & scala.Serializable)() -> msg);
        Console$.MODULE$.err().println(msg);
        throw package$.MODULE$.error(msg);
    }

    private Try<Cmdline> parseArgs(String[] args) {
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            void var1_1;
            Cmdline cmdline = new Cmdline();
            CmdlineParser cp = new CmdlineParser(new Object[]{cmdline});
            try {
                cp.parse(args);
            }
            catch (CmdlineParserException e) {
                MODULE$.reportError(new StringBuilder(30).append(e.getMessage()).append("\nRun launcher --help for help.").toString());
            }
            if (cmdline.help()) {
                StringBuilder sb = new StringBuilder();
                cp.usage(sb);
                throw new LauncherException(sb.toString(), null, 0);
            }
            return var1_1;
        });
    }

    private Try<String> containerId(File f, boolean createContainerID, boolean onlyIfMissing) {
        Object object;
        boolean generateId;
        File idFile = new File(this.containerConfigDirectory(), this.containerIdFile());
        if (idFile.exists() && idFile.isDirectory()) {
            String msg = new StringBuilder(37).append("The file [").append(idFile.getAbsoluteFile()).append("] exists and is a directory").toString();
            this.blended$launcher$Launcher$$log().error((Function0 & Serializable & scala.Serializable)() -> msg);
            Console$.MODULE$.err().println(msg);
            throw package$.MODULE$.error(msg);
        }
        boolean bl = generateId = createContainerID && (!onlyIfMissing || !idFile.exists());
        if (generateId && idFile.exists() && !idFile.canWrite()) {
            this.reportError(new StringBuilder(36).append("Container Id File [").append(idFile.getAbsolutePath()).append("] is not writable").toString());
        }
        Object object2 = generateId && idFile.exists() ? BoxesRunTime.boxToBoolean((boolean)idFile.delete()) : BoxedUnit.UNIT;
        if (generateId) {
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> "Creating new container id");
            Predef.ArrayCharSequence uuid = Predef$.MODULE$.ArrayCharSequence(UUID.randomUUID().toString().toCharArray());
            object = Files.write(idFile.toPath(), (Iterable<? extends CharSequence>)((Iterable)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CharSequence[]{uuid}))).asJava()), new OpenOption[0]);
        } else {
            object = BoxedUnit.UNIT;
        }
        return Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            java.util.List<String> lines = Files.readAllLines(Paths.get(idFile.getAbsolutePath(), new String[0]));
            if (lines.isEmpty()) {
                throw package$.MODULE$.error("Empty container ID file");
            }
            return lines.get(0);
        });
    }

    private Launcher createAndPrepareLaunch(Launcher.Configs configs, boolean createContainerId, boolean onlyIfMissing) {
        Seq seq;
        Launcher launcher = new Launcher(configs.launcherConfig());
        Option<LocalRuntimeConfig> option = configs.profileConfig();
        if (option instanceof Some) {
            Some some = (Some)option;
            LocalRuntimeConfig localConfig = (LocalRuntimeConfig)some.value();
            String propNames = (String)localConfig.resolvedRuntimeConfig().runtimeConfig().properties().getOrElse((Object)RuntimeConfig.Properties$.MODULE$.PROFILE_PROPERTY_KEYS(), (Function0 & Serializable & scala.Serializable)() -> "");
            System.setProperty(RuntimeConfig.Properties$.MODULE$.PROFILE_PROPERTY_KEYS(), propNames);
            seq = localConfig.validate(false, true);
        } else if (None$.MODULE$.equals(option)) {
            seq = launcher.validate();
        } else {
            throw new MatchError(option);
        }
        Seq errors = seq;
        if (!errors.isEmpty()) {
            throw package$.MODULE$.error(new StringBuilder(45).append("Could not start the OSGi Framework. Details:\n").append(errors.mkString("\n")).toString());
        }
        Try<String> try_ = this.containerId(new File(this.containerConfigDirectory(), this.containerIdFile()), createContainerId, onlyIfMissing);
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e = failure.exception();
            String msg = "Launcher is unable to determine the container id.";
            Option<LocalRuntimeConfig> option2 = configs.profileConfig();
            if (option2 instanceof Some) {
                this.blended$launcher$Launcher$$log().error(e, (Function0 & Serializable & scala.Serializable)() -> msg);
                Console$.MODULE$.err().println(msg);
                throw package$.MODULE$.error(msg);
            }
            if (!None$.MODULE$.equals(option2)) {
                throw new MatchError(option2);
            }
            this.blended$launcher$Launcher$$log().warn(e, (Function0 & Serializable & scala.Serializable)() -> msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
        } else if (try_ instanceof Success) {
            Success success = (Success)try_;
            String id = (String)success.value();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("ContainerId is [").append(id).append("] ").toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
        return launcher;
    }

    public void run(String[] args) {
        Cmdline cmdline = (Cmdline)this.parseArgs(args).get();
        boolean handleFrameworkRestart = cmdline.handleFrameworkRestart();
        boolean firstStart = true;
        int retVal = 0;
        do {
            BoxedUnit boxedUnit;
            Launcher.Configs configs;
            try {
                configs = this.readConfigs(cmdline);
            }
            catch (Throwable e) {
                this.blended$launcher$Launcher$$log().error(e, (Function0 & Serializable & scala.Serializable)() -> "Could not read configs");
                throw e;
            }
            Launcher.Configs configs2 = configs;
            this.blended$launcher$Launcher$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(9).append("Configs: ").append(configs2).toString());
            Option<File> option = cmdline.writeSystemProperties();
            if (option instanceof Some) {
                BoxedUnit boxedUnit2;
                Some some = (Some)option;
                File propFile = (File)some.value();
                this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> "Running with --write-system-properties. About to generate properties file and exit");
                Properties fileProps = new Properties();
                configs2.launcherConfig().systemProperties().foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    String k = (String)tuple2._1();
                    String v = (String)tuple2._2();
                    Object object = fileProps.setProperty(k, v);
                    return object;
                });
                try {
                    ARM$.MODULE$.using(new FileOutputStream(propFile), (Function1 & Serializable & scala.Serializable)stream -> {
                        Launcher$.$anonfun$run$5(fileProps, propFile, stream);
                        return BoxedUnit.UNIT;
                    });
                    retVal = 0;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                catch (Throwable e) {
                    this.blended$launcher$Launcher$$log().error(e, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Could not write system properties file: ").append(propFile).toString());
                    retVal = 1;
                    boxedUnit2 = BoxedUnit.UNIT;
                }
                boxedUnit = boxedUnit2;
                continue;
            }
            if (None$.MODULE$.equals(option)) {
                boolean createContainerId = firstStart && (cmdline.resetContainerId() || cmdline.initContainerId());
                Launcher launcher = this.createAndPrepareLaunch(configs2, createContainerId, cmdline.initContainerId());
                retVal = launcher.run(cmdline);
                firstStart = false;
                boxedUnit = BoxedUnit.UNIT;
                continue;
            }
            throw new MatchError(option);
        } while (handleFrameworkRestart && retVal == 2);
        if (retVal != 0) {
            String x$1 = "";
            int x$2 = retVal;
            Throwable x$3 = LauncherException$.MODULE$.$lessinit$greater$default$2();
            throw new LauncherException(x$1, x$3, x$2);
        }
    }

    public Launcher.Configs readConfigs(Cmdline cmdline) {
        Launcher.Configs configs;
        Option<String> option = cmdline.configFile();
        if (option instanceof Some) {
            Some some = (Some)option;
            String configFile = (String)some.value();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("About to read configFile: [").append(configFile).append("]").toString());
            Config config = ConfigFactory.parseFile((File)new File(configFile), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            configs = new Launcher.Configs(LauncherConfig$.MODULE$.read(config), Launcher$Configs$.MODULE$.apply$default$2());
        } else if (None$.MODULE$.equals(option)) {
            Tuple2 tuple2;
            String string;
            Option profileLookup = cmdline.profileLookup().map((Function1 & Serializable & scala.Serializable)pl2 -> {
                MODULE$.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("About to read profile lookup file: [").append((String)pl2).append("]").toString());
                Config c = ConfigFactory.parseFile((File)new File((String)pl2), (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
                return (ProfileLookup)ProfileLookup$.MODULE$.read(c).map((Function1 & Serializable & scala.Serializable)pl -> {
                    File x$1 = pl.profileBaseDir().getAbsoluteFile();
                    String x$2 = pl.copy$default$1();
                    String x$3 = pl.copy$default$2();
                    Set x$4 = pl.copy$default$4();
                    return pl.copy(x$2, x$3, x$1, x$4);
                }).get();
            });
            Option option2 = profileLookup;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                ProfileLookup pl3 = (ProfileLookup)some.value();
                string = pl3.materializedDir().getPath();
            } else if (None$.MODULE$.equals(option2)) {
                String profile;
                Option<String> option3 = cmdline.profileDir();
                if (!(option3 instanceof Some)) {
                    if (None$.MODULE$.equals(option3)) {
                        throw package$.MODULE$.error("Either a config file or a profile dir or file or a profile lookup path must be given");
                    }
                    throw new MatchError(option3);
                }
                Some some = (Some)option3;
                String string2 = profile = (String)some.value();
                string = string2;
            } else {
                throw new MatchError((Object)option2);
            }
            String profile = string;
            Tuple2 tuple22 = tuple2 = new File(profile).isDirectory() ? Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)profile), (Object)new File(profile, "profile.conf")) : Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(Option$.MODULE$.apply((Object)new File(profile).getParent()).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".")), (Object)new File(profile));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String profileDir = (String)tuple2._1();
            File profileFile = (File)tuple2._2();
            Tuple2 tuple23 = new Tuple2((Object)profileDir, (Object)profileFile);
            Tuple2 tuple24 = tuple23;
            String profileDir2 = (String)tuple24._1();
            File profileFile2 = (File)tuple24._2();
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Using profile directory : [").append(profileDir2).append("]").toString());
            this.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Using profile file      : [").append(profileFile2.getAbsolutePath()).append("]").toString());
            Config config = ConfigFactory.parseFile((File)profileFile2, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)).resolve();
            ResolvedRuntimeConfig runtimeConfig = new ResolvedRuntimeConfig((RuntimeConfig)RuntimeConfigCompanion$.MODULE$.read(config).get());
            LauncherConfig launchConfig = ConfigConverter$.MODULE$.runtimeConfigToLauncherConfig(runtimeConfig, profileDir2);
            ObjectRef brandingProps = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RuntimeConfig.Properties$.MODULE$.PROFILE_DIR()), (Object)profileDir2)}))));
            ObjectRef overlayProps = ObjectRef.create((Object)((Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$)));
            profileLookup.foreach((Function1 & Serializable & scala.Serializable)pl -> {
                Launcher$.$anonfun$readConfigs$8(brandingProps, cmdline, profileDir2, overlayProps, pl);
                return BoxedUnit.UNIT;
            });
            Map x$5 = launchConfig.branding().$plus$plus((GenTraversableOnce)((Map)brandingProps.elem));
            Map x$6 = SystemPropertyResolver$.MODULE$.resolve(launchConfig.systemProperties().$plus$plus((GenTraversableOnce)((Map)overlayProps.elem)).$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"blended.container.home"), (Object)profileDir2)));
            String x$7 = launchConfig.copy$default$1();
            Map x$8 = launchConfig.copy$default$3();
            int x$9 = launchConfig.copy$default$4();
            int x$10 = launchConfig.copy$default$5();
            Seq x$11 = launchConfig.copy$default$6();
            configs = new Launcher.Configs(launchConfig.copy(x$7, x$6, x$8, x$9, x$10, x$11, x$5), (Option<LocalRuntimeConfig>)new Some((Object)new LocalRuntimeConfig(runtimeConfig, new File(profileDir2))));
        } else {
            throw new MatchError(option);
        }
        return configs;
    }

    public Launcher apply(File configFile) {
        return new Launcher(LauncherConfig$.MODULE$.read(configFile));
    }

    public static final /* synthetic */ void $anonfun$run$5(Properties fileProps$1, File propFile$1, FileOutputStream stream) {
        fileProps$1.store(stream, "Generated by Launcher");
        MODULE$.blended$launcher$Launcher$$log().info((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Wrote system properties file: ").append(propFile$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$readConfigs$10(ProfileLookup pl$2, LocalOverlays ko) {
        Set set = ko.overlayRefs().toSet();
        Set set2 = pl$2.overlays().toSet();
        return !(set != null ? !set.equals(set2) : set2 != null);
    }

    public static final /* synthetic */ void $anonfun$readConfigs$8(ObjectRef brandingProps$1, Cmdline cmdline$1, String profileDir$1, ObjectRef overlayProps$1, ProfileLookup pl) {
        brandingProps$1.elem = ((Map)brandingProps$1.elem).$plus$plus((GenTraversableOnce)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RuntimeConfig.Properties$.MODULE$.PROFILE_LOOKUP_FILE()), (Object)new File((String)cmdline$1.profileLookup().get()).getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RuntimeConfig.Properties$.MODULE$.PROFILES_BASE_DIR()), (Object)pl.profileBaseDir().getAbsolutePath()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)RuntimeConfig.Properties$.MODULE$.OVERLAYS()), (Object)((TraversableOnce)pl.overlays().map((Function1 & Serializable & scala.Serializable)or -> new StringBuilder(1).append(or.name()).append(":").append(or.version()).toString(), Set$.MODULE$.canBuildFrom())).mkString(","))})));
        List knownOverlays = LocalOverlays$.MODULE$.findLocalOverlays(new File(profileDir$1).getAbsoluteFile());
        Option option = knownOverlays.find((Function1 & Serializable & scala.Serializable)ko -> BoxesRunTime.boxToBoolean((boolean)Launcher$.$anonfun$readConfigs$10(pl, ko)));
        if (None$.MODULE$.equals(option)) {
            if (!pl.overlays().isEmpty()) {
                throw package$.MODULE$.error(new StringBuilder(35).append("Cannot find specified overlay set: ").append(((TraversableOnce)pl.overlays().toSeq().sorted(Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms()))).mkString(", ")).toString());
            }
            MODULE$.blended$launcher$Launcher$$log().error((Function0 & Serializable & scala.Serializable)() -> "Cannot find the empty overlay set (aka 'base.conf'). To be compatible with older version, we continue here as no real information is missing");
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            LocalOverlays localOverlays = (LocalOverlays)some.value();
            Map newOverlayProps = localOverlays.properties();
            MODULE$.blended$launcher$Launcher$$log().debug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Found overlay provided properties: ").append(newOverlayProps).toString());
            overlayProps$1.elem = ((Map)overlayProps$1.elem).$plus$plus((GenTraversableOnce)newOverlayProps);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    private Launcher$() {
        MODULE$ = this;
    }
}

